/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import org.jmol.constant.EnumAxesMode;
import org.jmol.constant.EnumCallback;
import org.jmol.constant.EnumStructure;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptVariable;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 8;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    Viewer viewer;
    Map<String, Object> saved = new Hashtable<String, Object>();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";
    String lastState = "";
    String lastShape = "";
    String lastCoordinates = "";
    private static final Map<String, ScriptFunction> staticFunctions = new Hashtable<String, ScriptFunction>();
    private Map<String, ScriptFunction> localFunctions = new Hashtable<String, ScriptFunction>();
    protected static final String unreportedProperties = (";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;debug;debugscript;defaultlatttice;defaults;diffusepercent;exportdrivers;_filecaching;_filecache;fontcaching;fontscaling;language;legacyautobonding;loglevel;logfile;loggestures;logcommands;measureStyleChime;loadformat;loadligandformat;smilesurlformat;nihresolverformat;edsurlformat;edsurlcutoff;multiprocessor;navigationmode;;perspectivedepth;phongexponent;perspectivemodel;preservestate;refreshing;repaintwaitms;rotationradius;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showunitcell;slabenabled;slab;slabrange;depth;zshade;zshadepower;specular;specularexponent;specularpercent;specularpower;stateversion;statusreporting;stereo;stereostate;vibrationperiod;unitcellcolor;visualrange;windowcentered;zerobasedxyzrasmol;zoomenabled;mousedragfactor;mousewheelfactor;scriptqueue;scriptreportinglevel;syncscript;syncmouse;syncstereo;;defaultdirectory;currentlocalpath;defaultdirectorylocal;ambient;bonds;colorrasmol;diffuse;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;navx;navy;navz;navfps;" + EnumCallback.getNameList() + ";undo;bondpicking;modelkitmode;allowgestures;allowkeystrokes;allowmultitouch;allowmodelkit" + ";").toLowerCase();

    public static String getVariableList(Map<String, ScriptVariable> map, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        Object[] objectArray = new String[map.size()];
        for (Map.Entry<String, ScriptVariable> entry : map.entrySet()) {
            String string = entry.getKey();
            ScriptVariable scriptVariable = entry.getValue();
            if (!bl && string.startsWith("site_") || bl2 && string.charAt(0) != '@') continue;
            objectArray[n2++] = string + (string.charAt(0) == '@' ? " " + scriptVariable.asString() : " = " + StateManager.varClip(string, scriptVariable.escape(), n));
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) continue;
            StateManager.appendCmd(stringBuffer, (String)objectArray[i]);
        }
        if (n2 == 0 && !bl2) {
            stringBuffer.append("# --no global user variables defined--;\n");
        }
        return stringBuffer.toString();
    }

    public static int getObjectIdFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = objectNameList.indexOf(string.toLowerCase());
        return n < 0 ? n : n / 11;
    }

    static String getObjectNameFromId(int n) {
        if (n < 0 || n >= 8) {
            return null;
        }
        return objectNameList.substring(n * 11, n * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings(GlobalSettings globalSettings) {
        return new GlobalSettings(globalSettings);
    }

    void clear(GlobalSettings globalSettings) {
        this.viewer.setShowAxes(false);
        this.viewer.setShowBbcage(false);
        this.viewer.setShowUnitCell(false);
        globalSettings.clear();
    }

    void setCrystallographicDefaults() {
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setShowAxes(true);
        this.viewer.setShowUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.viewer.setIntProperty("percentVdwAtom", 23);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.viewer.setDefaultVdw("auto");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.viewer.setDefaultVdw("Rasmol");
    }

    String listSavedStates() {
        String string = "";
        Iterator<String> iterator = this.saved.keySet().iterator();
        while (iterator.hasNext()) {
            string = string + "\n" + iterator.next();
        }
        return string;
    }

    private void deleteSavedType(String string) {
        Iterator<String> iterator = this.saved.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
            Logger.debug("deleted " + string2);
        }
    }

    void deleteSaved(String string) {
        this.saved.remove(string);
    }

    void saveSelection(String string, BitSet bitSet) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Selected_");
            return;
        }
        string = this.lastSelected = "Selected_" + string;
        this.saved.put(string, BitSetUtil.copy(bitSet));
    }

    boolean restoreSelection(String string) {
        String string2 = string.length() > 0 ? "Selected_" + string : this.lastSelected;
        BitSet bitSet = (BitSet)this.saved.get(string2);
        if (bitSet == null) {
            this.viewer.select(new BitSet(), false, null, false);
            return false;
        }
        this.viewer.select(bitSet, false, null, false);
        return true;
    }

    void saveState(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("State_");
            return;
        }
        string = this.lastState = "State_" + string;
        this.saved.put(string, this.viewer.getStateInfo());
    }

    String getSavedState(String string) {
        String string2 = string.length() > 0 ? "State_" + string : this.lastState;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveStructure(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Shape_");
            return;
        }
        string = this.lastShape = "Shape_" + string;
        this.saved.put(string, this.viewer.getStructureState());
    }

    String getSavedStructure(String string) {
        String string2 = string.length() > 0 ? "Shape_" + string : this.lastShape;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveCoordinates(String string, BitSet bitSet) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Coordinates_");
            return;
        }
        string = this.lastCoordinates = "Coordinates_" + string;
        this.saved.put(string, this.viewer.getCoordinateState(bitSet));
    }

    String getSavedCoordinates(String string) {
        String string2 = string.length() > 0 ? "Coordinates_" + string : this.lastCoordinates;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    Orientation getOrientation() {
        return new Orientation(false);
    }

    String getSavedOrientationText(String string) {
        if (string != null) {
            Orientation orientation = this.getOrientation(string);
            return orientation == null ? "" : orientation.getMoveToText(true);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : this.saved.keySet()) {
            if (!string2.startsWith("Orientation_")) continue;
            stringBuffer.append(((Orientation)this.saved.get(string2)).getMoveToText(true));
        }
        return stringBuffer.toString();
    }

    void saveOrientation(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Orientation_");
            return;
        }
        Orientation orientation = new Orientation(string.equals("default"));
        orientation.saveName = this.lastOrientation = "Orientation_" + string;
        this.saved.put(orientation.saveName, orientation);
    }

    boolean restoreOrientation(String string, float f, boolean bl) {
        Orientation orientation = this.getOrientation(string);
        if (orientation == null) {
            return false;
        }
        orientation.restore(f, bl);
        return true;
    }

    private Orientation getOrientation(String string) {
        String string2 = string.length() > 0 ? "Orientation_" + string : this.lastOrientation;
        return (Orientation)this.saved.get(string2);
    }

    void saveBonds(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Bonds_");
            return;
        }
        Connections connections = new Connections();
        connections.saveName = this.lastConnections = "Bonds_" + string;
        this.saved.put(connections.saveName, connections);
    }

    boolean restoreBonds(String string) {
        String string2 = string.length() > 0 ? "Bonds_" + string : this.lastConnections;
        Connections connections = (Connections)this.saved.get(string2);
        if (connections == null) {
            return false;
        }
        connections.restore();
        return true;
    }

    Map<String, ScriptFunction> getFunctions(boolean bl) {
        return bl ? staticFunctions : this.localFunctions;
    }

    String getFunctionCalls(String string) {
        boolean bl;
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("*");
        boolean bl2 = n >= 0;
        boolean bl3 = string.indexOf("static_") == 0;
        boolean bl4 = bl = string.equalsIgnoreCase("names") || string.equalsIgnoreCase("static_names");
        if (bl) {
            string = "";
        }
        if (bl2) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase();
        Map<String, ScriptFunction> map = this.getFunctions(bl3);
        Object[] objectArray = new String[map.size()];
        Iterator<String> iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if ((string.length() != 0 || string2.startsWith("_")) && !string2.equalsIgnoreCase(string) && (!bl2 || string2.toLowerCase().indexOf(string) != 0)) continue;
            objectArray[n2++] = string2;
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            ScriptFunction scriptFunction = map.get(objectArray[i]);
            stringBuffer.append(bl ? scriptFunction.getSignature() : scriptFunction.toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void clearFunctions() {
        staticFunctions.clear();
        this.localFunctions.clear();
    }

    private static boolean isStaticFunction(String string) {
        return string.startsWith("static_");
    }

    boolean isFunction(String string) {
        return (StateManager.isStaticFunction(string) ? staticFunctions : this.localFunctions).containsKey(string);
    }

    void addFunction(ScriptFunction scriptFunction) {
        (StateManager.isStaticFunction(scriptFunction.name) ? staticFunctions : this.localFunctions).put(scriptFunction.name, scriptFunction);
    }

    ScriptFunction getFunction(String string) {
        if (string == null) {
            return null;
        }
        ScriptFunction scriptFunction = (StateManager.isStaticFunction(string) ? staticFunctions : this.localFunctions).get(string);
        return scriptFunction == null || scriptFunction.aatoken == null ? null : scriptFunction;
    }

    protected static int getJmolVersionInt() {
        String string = JmolConstants.version;
        int n = -1;
        try {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt(string);
                return n;
            }
            n = 100000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(".")) < 0) {
                return n += 1000 * Integer.parseInt(string);
            }
            n += 1000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf("_")) >= 0) {
                string = string.substring(0, n2);
            }
            if ((n2 = string.indexOf(" ")) >= 0) {
                string = string.substring(0, n2);
            }
            n += Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void setStateInfo(Map<String, BitSet> map, int n, int n2, String string) {
        BitSet bitSet;
        if (map.containsKey(string)) {
            bitSet = map.get(string);
        } else {
            bitSet = new BitSet();
            map.put(string, bitSet);
        }
        bitSet.set(n, n2 + 1);
    }

    public static String varClip(String string, String string2, int n) {
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n) + " #...more (" + string2.length() + " bytes -- use SHOW " + string + " or MESSAGE @" + string + " to view)";
        }
        return string2;
    }

    public static String getCommands(Map<String, BitSet> map) {
        return StateManager.getCommands(map, null, "select");
    }

    public static String getCommands(Map<String, BitSet> map, Map<String, BitSet> map2) {
        return StateManager.getCommands(map, map2, "select");
    }

    public static String getCommands(Map<String, BitSet> map, Map<String, BitSet> map2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = StateManager.getCommands(map, stringBuffer, null, string);
        if (map2 != null) {
            StateManager.getCommands(map2, stringBuffer, string2, "select");
        }
        return stringBuffer.toString();
    }

    private static String getCommands(Map<String, BitSet> map, StringBuffer stringBuffer, String string, String string2) {
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, BitSet> entry : map.entrySet()) {
            String string3 = entry.getKey();
            String string4 = Escape.escape(entry.getValue());
            if (string4.length() < 5) continue;
            string4 = string2 + " " + string4;
            if (!string4.equals(string)) {
                StateManager.appendCmd(stringBuffer, string4);
            }
            string = string4;
            if (string3.indexOf("-") == 0) continue;
            StateManager.appendCmd(stringBuffer, string3);
        }
        return string;
    }

    public static void appendCmd(StringBuffer stringBuffer, String string) {
        if (string.length() == 0) {
            return;
        }
        stringBuffer.append("  ").append(string).append(";\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GlobalSettings {
        Map<String, Object> htNonbooleanParameterValues;
        Map<String, Boolean> htBooleanParameterFlags;
        Map<String, Boolean> htPropertyFlagsRemoved;
        Map<String, ScriptVariable> htUserVariables = new Hashtable<String, ScriptVariable>();
        int ambientPercent = 45;
        int diffusePercent = 84;
        boolean specular = true;
        int specularExponent = 6;
        int phongExponent = 64;
        int specularPercent = 22;
        int specularPower = 40;
        int zDepth = 0;
        int zShadePower = 3;
        int zSlab = 0;
        boolean slabByMolecule = false;
        boolean slabByAtom = false;
        boolean allowEmbeddedScripts = true;
        boolean appendNew = true;
        String appletProxy = "";
        boolean applySymmetryToBonds = false;
        String atomTypes = "";
        boolean autoBond = true;
        boolean axesOrientationRasmol = false;
        short bondRadiusMilliAngstroms = (short)150;
        float bondTolerance = 0.45f;
        String defaultDirectory = "";
        boolean defaultStructureDSSP = true;
        final Point3f ptDefaultLattice = new Point3f();
        String defaultLoadScript = "";
        String defaultLoadFilter = "";
        boolean forceAutoBond = false;
        boolean fractionalRelative = false;
        char inlineNewlineChar = (char)124;
        String loadFormat = "http://www.rcsb.org/pdb/files/%FILE.pdb.gz";
        String loadLigandFormat = "http://www.rcsb.org/pdb/files/ligand/%FILE.cif";
        String smilesUrlFormat = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        String nihResolverFormat = "http://cactus.nci.nih.gov/chemical/structure/%FILE";
        String edsUrlFormat = "http://eds.bmc.uu.se/eds/dfs/%LC13/%LCFILE/%LCFILE.omap";
        String edsUrlCutoff = "load('http://eds.bmc.uu.se/eds/dfs/%LC13/%LCFILE/%LCFILE.sfdat').lines.find('MAP_SIGMA').split(' ')[2]";
        String edsUrlOptions = "within 2.0 {*}";
        float minBondDistance = 0.4f;
        int minPixelSelRadius = 6;
        boolean pdbAddHydrogens = false;
        boolean pdbGetHeader = false;
        boolean pdbSequential = false;
        int percentVdwAtom = 23;
        int smallMoleculeMaxAtoms = 40000;
        boolean smartAromatic = true;
        boolean zeroBasedXyzRasmol = false;
        boolean legacyAutoBonding = false;
        boolean allowRotateSelected = false;
        boolean allowMoveAtoms = false;
        boolean perspectiveDepth = true;
        float visualRange = 5.0f;
        boolean solventOn = false;
        String defaultAngleLabel = "%VALUE %UNITS";
        String defaultDistanceLabel = "%VALUE %UNITS";
        String defaultTorsionLabel = "%VALUE %UNITS";
        boolean justifyMeasurements = false;
        boolean measureAllModels = false;
        int minimizationSteps = 100;
        boolean minimizationRefresh = true;
        boolean minimizationSilent = false;
        float minimizationCriterion = 0.001f;
        boolean antialiasDisplay = false;
        boolean antialiasImages = true;
        boolean imageState = true;
        boolean antialiasTranslucent = true;
        boolean displayCellParameters = true;
        boolean dotsSelectedOnly = false;
        boolean dotSurface = true;
        int dotDensity = 3;
        int dotScale = 1;
        boolean dynamicMeasurements = false;
        boolean greyscaleRendering = false;
        boolean isosurfaceKey = false;
        boolean isosurfacePropertySmoothing = true;
        int isosurfacePropertySmoothingPower = 7;
        int repaintWaitMs = 1000;
        boolean showHiddenSelectionHalos = false;
        boolean showKeyStrokes = true;
        boolean showMeasurements = true;
        boolean zoomLarge = true;
        String backgroundImageFileName;
        boolean partialDots = false;
        boolean bondModeOr = false;
        boolean hbondsBackbone = false;
        float hbondsAngleMinimum = 90.0f;
        float hbondsDistanceMaximum = 3.25f;
        boolean hbondsRasmol = true;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean showHydrogens = true;
        boolean showMultipleBonds = true;
        boolean ssbondsBackbone = false;
        float multipleBondSpacing = -1.0f;
        float multipleBondRadiusFactor = 0.0f;
        boolean cartoonBaseEdges = false;
        boolean cartoonRockets = false;
        boolean chainCaseSensitive = false;
        int hermiteLevel = 0;
        boolean highResolutionFlag = false;
        boolean rangeSelected = false;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        int ribbonAspectRatio = 16;
        boolean ribbonBorder = false;
        boolean rocketBarrels = false;
        float sheetSmoothing = 1.0f;
        boolean traceAlpha = true;
        boolean allowGestures = false;
        boolean allowModelkit = true;
        boolean allowMultiTouch = true;
        boolean allowKeyStrokes = false;
        int animationFps = 10;
        boolean autoFps = false;
        EnumAxesMode axesMode = EnumAxesMode.BOUNDBOX;
        float axesScale = 2.0f;
        float cameraDepth = 3.0f;
        String dataSeparator = "~~~";
        boolean debugScript = false;
        float defaultDrawArrowScale = 0.5f;
        String defaultLabelXYZ = "%a";
        String defaultLabelPDB = "%m%r";
        float defaultTranslucent = 0.5f;
        int delayMaximumMs = 0;
        float dipoleScale = 1.0f;
        boolean disablePopupMenu = false;
        boolean dragSelected = false;
        boolean drawHover = false;
        boolean drawPicking = false;
        boolean dsspCalcHydrogen = true;
        boolean bondPicking = false;
        boolean atomPicking = true;
        String helpPath = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
        boolean fontScaling = false;
        boolean fontCaching = true;
        int helixStep = 1;
        boolean hideNameInPopup = false;
        int hoverDelayMs = 500;
        float loadAtomDataTolerance = 0.01f;
        boolean logCommands = false;
        boolean logGestures = false;
        boolean measurementLabels = true;
        boolean messageStyleChime = false;
        boolean monitorEnergy = false;
        boolean multiProcessor = true;
        int pickingSpinRate = 10;
        String pickLabel = "";
        float pointGroupDistanceTolerance = 0.2f;
        float pointGroupLinearTolerance = 8.0f;
        boolean preserveState = true;
        String propertyColorScheme = "roygb";
        String quaternionFrame = "p";
        boolean saveProteinStructureState = true;
        float solventProbeRadius = 1.2f;
        int scriptDelay = 0;
        boolean selectAllModels = true;
        boolean statusReporting = true;
        int strandCountForStrands = 5;
        int strandCountForMeshRibbon = 7;
        int strutSpacing = 6;
        float strutLengthMaximum = 7.0f;
        float strutDefaultRadius = 0.3f;
        boolean strutsMultiple = false;
        boolean useArcBall = false;
        boolean useMinimizationThread = true;
        boolean useNumberLocalization = true;
        boolean useScriptQueue = true;
        boolean waitForMoveTo = true;
        float vectorScale = 1.0f;
        float vibrationPeriod = 1.0f;
        float vibrationScale = 1.0f;
        boolean wireframeRotation = false;
        boolean hideNavigationPoint = false;
        boolean navigationMode = false;
        boolean navigateSurface = false;
        boolean navigationPeriodic = false;
        float navigationSpeed = 5.0f;
        boolean showNavigationPointAlways = false;
        String stereoState = null;
        boolean modelKitMode = false;
        int[] objColors = new int[8];
        boolean[] objStateOn = new boolean[8];
        int[] objMad = new int[8];
        boolean ellipsoidAxes = false;
        boolean ellipsoidDots = false;
        boolean ellipsoidArcs = false;
        boolean ellipsoidFill = false;
        boolean ellipsoidBall = true;
        int ellipsoidDotCount = 200;
        float ellipsoidAxisDiameter = 0.02f;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        private String measureDistanceUnits = "nanometers";
        private Map<EnumStructure, float[]> structureList = new Hashtable<EnumStructure, float[]>();
        private boolean haveSetStructureList;

        GlobalSettings(GlobalSettings globalSettings) {
            this.structureList.put(EnumStructure.TURN, new float[]{30.0f, 90.0f, -15.0f, 95.0f});
            this.structureList.put(EnumStructure.SHEET, new float[]{-180.0f, -10.0f, 70.0f, 180.0f, -180.0f, -45.0f, -180.0f, -130.0f, 140.0f, 180.0f, 90.0f, 180.0f});
            this.structureList.put(EnumStructure.HELIX, new float[]{-160.0f, 0.0f, -100.0f, 45.0f});
            this.registerAllValues(globalSettings);
        }

        void clear() {
            Iterator<String> iterator = this.htUserVariables.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string.charAt(0) != '@' && !string.startsWith("site_")) continue;
                iterator.remove();
            }
            this.setPicked(-1);
            this.setParameterValue("_atomhovered", -1);
            this.setParameterValue("_pickinfo", "");
            this.setParameterValue("selectionhalos", false);
            this.setParameterValue("hidenotselected", false);
            this.measurementLabels = true;
            this.setParameterValue("measurementlabels", true);
            this.drawHover = false;
            this.setParameterValue("drawHover", false);
        }

        void registerAllValues(GlobalSettings globalSettings) {
            this.htNonbooleanParameterValues = new Hashtable<String, Object>();
            this.htBooleanParameterFlags = new Hashtable<String, Boolean>();
            this.htPropertyFlagsRemoved = new Hashtable<String, Boolean>();
            if (globalSettings != null) {
                this.debugScript = globalSettings.debugScript;
                this.disablePopupMenu = globalSettings.disablePopupMenu;
                this.messageStyleChime = globalSettings.messageStyleChime;
                this.defaultDirectory = globalSettings.defaultDirectory;
                this.allowGestures = globalSettings.allowGestures;
                this.allowModelkit = globalSettings.allowModelkit;
                this.allowMultiTouch = globalSettings.allowMultiTouch;
                this.allowKeyStrokes = globalSettings.allowKeyStrokes;
                this.legacyAutoBonding = globalSettings.legacyAutoBonding;
                this.useScriptQueue = globalSettings.useScriptQueue;
                this.useArcBall = globalSettings.useArcBall;
            }
            for (EnumCallback enumCallback : EnumCallback.values()) {
                this.resetParameterStringValue(enumCallback.getName(), globalSettings);
            }
            this.setParameterValue("historyLevel", 0);
            this.setParameterValue("gestureSwipeFactor", 1.0f);
            this.setParameterValue("hideNotSelected", false);
            this.setParameterValue("hoverLabel", "");
            this.setParameterValue("isKiosk", StateManager.this.viewer.isKiosk());
            this.setParameterValue("logFile", StateManager.this.viewer.getLogFile());
            this.setParameterValue("logLevel", Logger.getLogLevel());
            this.setParameterValue("mouseWheelFactor", 1.15f);
            this.setParameterValue("mouseDragFactor", 1.0f);
            this.setParameterValue("navFps", 10);
            this.setParameterValue("navigationDepth", 0);
            this.setParameterValue("navigationSlab", 0);
            this.setParameterValue("navX", 0);
            this.setParameterValue("navY", 0);
            this.setParameterValue("navZ", 0);
            this.setParameterValue("perspectiveModel", 11);
            this.setParameterValue("picking", "identify");
            this.setParameterValue("pickingStyle", "toggle");
            this.setParameterValue("refreshing", true);
            this.setParameterValue("rotationRadius", 0);
            this.setParameterValue("scaleAngstromsPerInch", 0);
            this.setParameterValue("scriptReportingLevel", 0);
            this.setParameterValue("selectionHalos", false);
            this.setParameterValue("showaxes", false);
            this.setParameterValue("showboundbox", false);
            this.setParameterValue("showfrank", false);
            this.setParameterValue("showUnitcell", false);
            this.setParameterValue("slabEnabled", false);
            this.setParameterValue("depth", 0);
            this.setParameterValue("slab", 100);
            this.setParameterValue("slabrange", 0.0f);
            this.setParameterValue("spinX", 0);
            this.setParameterValue("spinY", 30);
            this.setParameterValue("spinZ", 0);
            this.setParameterValue("spinFps", 30);
            this.setParameterValue("stereoDegrees", -5);
            this.setParameterValue("stateversion", 0);
            this.setParameterValue("windowCentered", true);
            this.setParameterValue("zoomEnabled", true);
            this.setParameterValue("zShade", false);
            this.setParameterValue("_version", StateManager.getJmolVersionInt());
            this.setParameterValue("axesWindow", true);
            this.setParameterValue("axesMolecular", false);
            this.setParameterValue("axesPosition", false);
            this.setParameterValue("axesUnitcell", false);
            this.setParameterValue("backgroundModel", 0);
            this.setParameterValue("colorRasmol", false);
            this.setParameterValue("currentLocalPath", "");
            this.setParameterValue("defaultLattice", "{0 0 0}");
            this.setParameterValue("defaultColorScheme", "Jmol");
            this.setParameterValue("defaultDirectoryLocal", "");
            this.setParameterValue("defaults", "Jmol");
            this.setParameterValue("defaultVDW", "Jmol");
            this.setParameterValue("exportDrivers", "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj");
            this.setParameterValue("propertyAtomNumberColumnCount", 0);
            this.setParameterValue("propertyAtomNumberField", 0);
            this.setParameterValue("propertyDataColumnCount", 0);
            this.setParameterValue("propertyDataField", 0);
            this.setParameterValue("undo", true);
            this.setParameterValue("allowEmbeddedScripts", this.allowEmbeddedScripts);
            this.setParameterValue("allowGestures", this.allowGestures);
            this.setParameterValue("allowKeyStrokes", this.allowKeyStrokes);
            this.setParameterValue("allowModelkit", this.allowModelkit);
            this.setParameterValue("allowMultiTouch", this.allowMultiTouch);
            this.setParameterValue("allowRotateSelected", this.allowRotateSelected);
            this.setParameterValue("allowMoveAtoms", this.allowMoveAtoms);
            this.setParameterValue("ambientPercent", this.ambientPercent);
            this.setParameterValue("animationFps", this.animationFps);
            this.setParameterValue("antialiasImages", this.antialiasImages);
            this.setParameterValue("antialiasDisplay", this.antialiasDisplay);
            this.setParameterValue("antialiasTranslucent", this.antialiasTranslucent);
            this.setParameterValue("appendNew", this.appendNew);
            this.setParameterValue("appletProxy", this.appletProxy);
            this.setParameterValue("applySymmetryToBonds", this.applySymmetryToBonds);
            this.setParameterValue("atomPicking", this.atomPicking);
            this.setParameterValue("atomTypes", this.atomTypes);
            this.setParameterValue("autoBond", this.autoBond);
            this.setParameterValue("autoFps", this.autoFps);
            this.setParameterValue("axesMode", this.axesMode.getCode());
            this.setParameterValue("axesScale", this.axesScale);
            this.setParameterValue("axesOrientationRasmol", this.axesOrientationRasmol);
            this.setParameterValue("bondModeOr", this.bondModeOr);
            this.setParameterValue("bondPicking", this.bondPicking);
            this.setParameterValue("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
            this.setParameterValue("bondTolerance", this.bondTolerance);
            this.setParameterValue("cameraDepth", this.cameraDepth);
            this.setParameterValue("cartoonBaseEdges", this.cartoonBaseEdges);
            this.setParameterValue("cartoonRockets", this.cartoonRockets);
            this.setParameterValue("chainCaseSensitive", this.chainCaseSensitive);
            this.setParameterValue("dataSeparator", this.dataSeparator);
            this.setParameterValue("debugScript", this.debugScript);
            this.setParameterValue("defaultAngleLabel", this.defaultAngleLabel);
            this.setParameterValue("defaultDrawArrowScale", this.defaultDrawArrowScale);
            this.setParameterValue("defaultDirectory", this.defaultDirectory);
            this.setParameterValue("defaultDistanceLabel", this.defaultDistanceLabel);
            this.setParameterValue("defaultLabelPDB", this.defaultLabelPDB);
            this.setParameterValue("defaultLabelXYZ", this.defaultLabelXYZ);
            this.setParameterValue("defaultLoadFilter", this.defaultLoadFilter);
            this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            this.setParameterValue("defaultStructureDSSP", this.defaultStructureDSSP);
            this.setParameterValue("defaultTorsionLabel", this.defaultTorsionLabel);
            this.setParameterValue("defaultTranslucent", this.defaultTranslucent);
            this.setParameterValue("delayMaximumMs", this.delayMaximumMs);
            this.setParameterValue("diffusePercent", this.diffusePercent);
            this.setParameterValue("dipoleScale", this.dipoleScale);
            this.setParameterValue("disablePopupMenu", this.disablePopupMenu);
            this.setParameterValue("displayCellParameters", this.displayCellParameters);
            this.setParameterValue("dotDensity", this.dotDensity);
            this.setParameterValue("dotScale", this.dotScale);
            this.setParameterValue("dotsSelectedOnly", this.dotsSelectedOnly);
            this.setParameterValue("dotSurface", this.dotSurface);
            this.setParameterValue("dragSelected", this.dragSelected);
            this.setParameterValue("drawHover", this.drawHover);
            this.setParameterValue("drawPicking", this.drawPicking);
            this.setParameterValue("dsspCalculateHydrogenAlways", this.dsspCalcHydrogen);
            this.setParameterValue("dynamicMeasurements", this.dynamicMeasurements);
            this.setParameterValue("edsUrlFormat", this.edsUrlFormat);
            this.setParameterValue("edsUrlCutoff", this.edsUrlCutoff);
            this.setParameterValue("ellipsoidArcs", this.ellipsoidArcs);
            this.setParameterValue("ellipsoidAxes", this.ellipsoidAxes);
            this.setParameterValue("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
            this.setParameterValue("ellipsoidBall", this.ellipsoidBall);
            this.setParameterValue("ellipsoidDotCount", this.ellipsoidDotCount);
            this.setParameterValue("ellipsoidDots", this.ellipsoidDots);
            this.setParameterValue("ellipsoidFill", this.ellipsoidFill);
            this.setParameterValue("fontScaling", this.fontScaling);
            this.setParameterValue("fontCaching", this.fontCaching);
            this.setParameterValue("forceAutoBond", this.forceAutoBond);
            this.setParameterValue("fractionalRelative", this.fractionalRelative);
            this.setParameterValue("greyscaleRendering", this.greyscaleRendering);
            this.setParameterValue("hbondsAngleMinimum", this.hbondsAngleMinimum);
            this.setParameterValue("hbondsDistanceMaximum", this.hbondsDistanceMaximum);
            this.setParameterValue("hbondsBackbone", this.hbondsBackbone);
            this.setParameterValue("hbondsRasmol", this.hbondsRasmol);
            this.setParameterValue("hbondsSolid", this.hbondsSolid);
            this.setParameterValue("helixStep", this.helixStep);
            this.setParameterValue("helpPath", this.helpPath);
            this.setParameterValue("hermiteLevel", this.hermiteLevel);
            this.setParameterValue("hideNameInPopup", this.hideNameInPopup);
            this.setParameterValue("hideNavigationPoint", this.hideNavigationPoint);
            this.setParameterValue("highResolution", this.highResolutionFlag);
            this.setParameterValue("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
            this.setParameterValue("imageState", this.imageState);
            this.setParameterValue("isosurfaceKey", this.isosurfaceKey);
            this.setParameterValue("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
            this.setParameterValue("isosurfacePropertySmoothingPower", this.isosurfacePropertySmoothingPower);
            this.setParameterValue("justifyMeasurements", this.justifyMeasurements);
            this.setParameterValue("legacyAutoBonding", this.legacyAutoBonding);
            this.setParameterValue("loadAtomDataTolerance", this.loadAtomDataTolerance);
            this.setParameterValue("loadFormat", this.loadFormat);
            this.setParameterValue("loadLigandFormat", this.loadLigandFormat);
            this.setParameterValue("logCommands", this.logCommands);
            this.setParameterValue("logGestures", this.logGestures);
            this.setParameterValue("measureAllModels", this.measureAllModels);
            this.setParameterValue("measurementLabels", this.measurementLabels);
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
            this.setParameterValue("messageStyleChime", this.messageStyleChime);
            this.setParameterValue("minBondDistance", this.minBondDistance);
            this.setParameterValue("minPixelSelRadius", this.minPixelSelRadius);
            this.setParameterValue("minimizationSteps", this.minimizationSteps);
            this.setParameterValue("minimizationRefresh", this.minimizationRefresh);
            this.setParameterValue("minimizationSilent", this.minimizationSilent);
            this.setParameterValue("minimizationCriterion", this.minimizationCriterion);
            this.setParameterValue("modelKitMode", this.modelKitMode);
            this.setParameterValue("monitorEnergy", this.monitorEnergy);
            this.setParameterValue("multipleBondRadiusFactor", this.multipleBondRadiusFactor);
            this.setParameterValue("multipleBondSpacing", this.multipleBondSpacing);
            this.setParameterValue("multiProcessor", this.multiProcessor && Viewer.nProcessors > 1);
            this.setParameterValue("navigationMode", this.navigationMode);
            this.setParameterValue("navigateSurface", this.navigateSurface);
            this.setParameterValue("navigationPeriodic", this.navigationPeriodic);
            this.setParameterValue("navigationSpeed", this.navigationSpeed);
            this.setParameterValue("partialDots", this.partialDots);
            this.setParameterValue("pdbAddHydrogens", this.pdbAddHydrogens);
            this.setParameterValue("pdbGetHeader", this.pdbGetHeader);
            this.setParameterValue("pdbSequential", this.pdbSequential);
            this.setParameterValue("perspectiveDepth", this.perspectiveDepth);
            this.setParameterValue("percentVdwAtom", this.percentVdwAtom);
            this.setParameterValue("phongExponent", this.phongExponent);
            this.setParameterValue("pickingSpinRate", this.pickingSpinRate);
            this.setParameterValue("pickLabel", this.pickLabel);
            this.setParameterValue("pointGroupLinearTolerance", this.pointGroupLinearTolerance);
            this.setParameterValue("pointGroupDistanceTolerance", this.pointGroupDistanceTolerance);
            this.setParameterValue("preserveState", this.preserveState);
            this.setParameterValue("propertyColorScheme", this.propertyColorScheme);
            this.setParameterValue("quaternionFrame", this.quaternionFrame);
            this.setParameterValue("rangeSelected", this.rangeSelected);
            this.setParameterValue("repaintWaitMs", this.repaintWaitMs);
            this.setParameterValue("ribbonAspectRatio", this.ribbonAspectRatio);
            this.setParameterValue("ribbonBorder", this.ribbonBorder);
            this.setParameterValue("rocketBarrels", this.rocketBarrels);
            this.setParameterValue("saveProteinStructureState", this.saveProteinStructureState);
            this.setParameterValue("scriptqueue", this.useScriptQueue);
            this.setParameterValue("selectAllModels", this.selectAllModels);
            this.setParameterValue("selectHetero", this.rasmolHeteroSetting);
            this.setParameterValue("selectHydrogen", this.rasmolHydrogenSetting);
            this.setParameterValue("sheetSmoothing", this.sheetSmoothing);
            this.setParameterValue("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
            this.setParameterValue("showHydrogens", this.showHydrogens);
            this.setParameterValue("showKeyStrokes", this.showKeyStrokes);
            this.setParameterValue("showMeasurements", this.showMeasurements);
            this.setParameterValue("showMultipleBonds", this.showMultipleBonds);
            this.setParameterValue("showNavigationPointAlways", this.showNavigationPointAlways);
            this.setParameterValue("showScript", this.scriptDelay);
            this.setParameterValue("slabByMolecule", this.slabByMolecule);
            this.setParameterValue("slabByAtom", this.slabByAtom);
            this.setParameterValue("smartAromatic", this.smartAromatic);
            this.setParameterValue("smallMoleculeMaxAtoms", this.smallMoleculeMaxAtoms);
            this.setParameterValue("smilesUrlFormat", this.smilesUrlFormat);
            this.setParameterValue("nihResolverFormat", this.nihResolverFormat);
            this.setParameterValue("solventProbe", this.solventOn);
            this.setParameterValue("solventProbeRadius", this.solventProbeRadius);
            this.setParameterValue("specular", this.specular);
            this.setParameterValue("specularExponent", this.specularExponent);
            this.setParameterValue("specularPercent", this.specularPercent);
            this.setParameterValue("specularPower", this.specularPower);
            this.setParameterValue("ssbondsBackbone", this.ssbondsBackbone);
            this.setParameterValue("statusReporting", this.statusReporting);
            this.setParameterValue("strandCount", this.strandCountForStrands);
            this.setParameterValue("strandCountForStrands", this.strandCountForStrands);
            this.setParameterValue("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
            this.setParameterValue("strutDefaultRadius", this.strutDefaultRadius);
            this.setParameterValue("strutLengthMaximum", this.strutLengthMaximum);
            this.setParameterValue("strutSpacing", this.strutSpacing);
            this.setParameterValue("strutsMultiple", this.strutsMultiple);
            this.setParameterValue("testFlag1", this.testFlag1);
            this.setParameterValue("testFlag2", this.testFlag2);
            this.setParameterValue("testFlag3", this.testFlag3);
            this.setParameterValue("testFlag4", this.testFlag4);
            this.setParameterValue("traceAlpha", this.traceAlpha);
            this.setParameterValue("useArcBall", this.useArcBall);
            this.setParameterValue("useMinimizationThread", this.useMinimizationThread);
            this.setParameterValue("useNumberLocalization", this.useNumberLocalization);
            this.setParameterValue("vectorScale", this.vectorScale);
            this.setParameterValue("vibrationPeriod", this.vibrationPeriod);
            this.setParameterValue("vibrationScale", this.vibrationScale);
            this.setParameterValue("visualRange", this.visualRange);
            this.setParameterValue("wireframeRotation", this.wireframeRotation);
            this.setParameterValue("zDepth", this.zDepth);
            this.setParameterValue("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
            this.setParameterValue("zoomLarge", this.zoomLarge);
            this.setParameterValue("zShadePower", this.zShadePower);
            this.setParameterValue("zSlab", this.zSlab);
        }

        String getLoadState(Map<String, Object> map) {
            StringBuffer stringBuffer = new StringBuffer();
            StateManager.appendCmd(stringBuffer, "set allowEmbeddedScripts false");
            if (this.allowEmbeddedScripts) {
                this.setParameterValue("allowEmbeddedScripts", true);
            }
            StateManager.appendCmd(stringBuffer, "set appendNew " + this.appendNew);
            StateManager.appendCmd(stringBuffer, "set appletProxy " + Escape.escape(this.appletProxy));
            StateManager.appendCmd(stringBuffer, "set applySymmetryToBonds " + this.applySymmetryToBonds);
            if (this.atomTypes.length() > 0) {
                StateManager.appendCmd(stringBuffer, "set atomTypes " + Escape.escape(this.atomTypes));
            }
            StateManager.appendCmd(stringBuffer, "set autoBond " + this.autoBond);
            if (this.axesOrientationRasmol) {
                StateManager.appendCmd(stringBuffer, "set axesOrientationRasmol true");
            }
            StateManager.appendCmd(stringBuffer, "set bondRadiusMilliAngstroms " + this.bondRadiusMilliAngstroms);
            StateManager.appendCmd(stringBuffer, "set bondTolerance " + this.bondTolerance);
            StateManager.appendCmd(stringBuffer, "set defaultLattice " + Escape.escape(this.ptDefaultLattice));
            StateManager.appendCmd(stringBuffer, "set defaultLoadFilter " + Escape.escape(this.defaultLoadFilter));
            StateManager.appendCmd(stringBuffer, "set defaultLoadScript \"\"");
            if (this.defaultLoadScript.length() > 0) {
                this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            }
            StateManager.appendCmd(stringBuffer, "set defaultStructureDssp " + this.defaultStructureDSSP);
            String string = StateManager.this.viewer.getDefaultVdwTypeNameOrData(Integer.MIN_VALUE, null);
            StateManager.appendCmd(stringBuffer, "set defaultVDW " + string);
            if (string.equals("User")) {
                StateManager.appendCmd(stringBuffer, StateManager.this.viewer.getDefaultVdwTypeNameOrData(Integer.MAX_VALUE, null));
            }
            StateManager.appendCmd(stringBuffer, "set forceAutoBond " + this.forceAutoBond);
            StateManager.appendCmd(stringBuffer, "#set defaultDirectory " + Escape.escape(this.defaultDirectory));
            StateManager.appendCmd(stringBuffer, "#set loadFormat " + Escape.escape(this.loadFormat));
            StateManager.appendCmd(stringBuffer, "#set loadLigandFormat " + Escape.escape(this.loadLigandFormat));
            StateManager.appendCmd(stringBuffer, "#set smilesUrlFormat " + Escape.escape(this.smilesUrlFormat));
            StateManager.appendCmd(stringBuffer, "#set nihResolverFormat " + Escape.escape(this.nihResolverFormat));
            StateManager.appendCmd(stringBuffer, "#set edsUrlFormat " + Escape.escape(this.edsUrlFormat));
            StateManager.appendCmd(stringBuffer, "#set edsUrlCutoff " + Escape.escape(this.edsUrlCutoff));
            StateManager.appendCmd(stringBuffer, "set legacyAutoBonding " + this.legacyAutoBonding);
            StateManager.appendCmd(stringBuffer, "set minBondDistance " + this.minBondDistance);
            StateManager.appendCmd(stringBuffer, "set minimizationCriterion  " + this.minimizationCriterion);
            StateManager.appendCmd(stringBuffer, "set minimizationSteps  " + this.minimizationSteps);
            StateManager.appendCmd(stringBuffer, "set pdbAddHydrogens " + (map != null && map.get("pdbNoHydrogens") == null ? this.pdbAddHydrogens : false));
            StateManager.appendCmd(stringBuffer, "set pdbGetHeader " + this.pdbGetHeader);
            StateManager.appendCmd(stringBuffer, "set pdbSequential " + this.pdbSequential);
            StateManager.appendCmd(stringBuffer, "set percentVdwAtom " + this.percentVdwAtom);
            StateManager.appendCmd(stringBuffer, "set smallMoleculeMaxAtoms " + this.smallMoleculeMaxAtoms);
            StateManager.appendCmd(stringBuffer, "set smartAromatic " + this.smartAromatic);
            if (this.zeroBasedXyzRasmol) {
                StateManager.appendCmd(stringBuffer, "set zeroBasedXyzRasmol true");
            }
            return stringBuffer.toString();
        }

        void setDefaultLattice(Point3f point3f) {
            this.ptDefaultLattice.set(point3f);
        }

        Point3f getDefaultLattice() {
            return this.ptDefaultLattice;
        }

        String getWindowState(StringBuffer stringBuffer, int n, int n2) {
            StringBuffer stringBuffer2 = new StringBuffer();
            if (stringBuffer != null) {
                stringBuffer.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
                stringBuffer2.append("\nfunction _setWindowState() {\n");
            }
            if (n != 0) {
                stringBuffer2.append("# preferredWidthHeight ").append(n).append(" ").append(n2).append(";\n");
            }
            stringBuffer2.append("# width ").append(n == 0 ? StateManager.this.viewer.getScreenWidth() : n).append(";\n# height ").append(n2 == 0 ? StateManager.this.viewer.getScreenHeight() : n2).append(";\n");
            StateManager.appendCmd(stringBuffer2, "stateVersion = " + this.getParameter("_version"));
            StateManager.appendCmd(stringBuffer2, "background " + Escape.escapeColor(this.objColors[0]));
            for (int i = 1; i < 8; ++i) {
                if (this.objColors[i] == 0) continue;
                StateManager.appendCmd(stringBuffer2, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor(this.objColors[i]) + '\"');
            }
            if (this.backgroundImageFileName != null) {
                StateManager.appendCmd(stringBuffer2, "background IMAGE /*file*/" + Escape.escape(this.backgroundImageFileName));
            }
            stringBuffer2.append(this.getSpecularState());
            StateManager.appendCmd(stringBuffer2, "statusReporting  = " + this.statusReporting);
            if (stringBuffer != null) {
                stringBuffer2.append("}\n\n");
            }
            return stringBuffer2.toString();
        }

        String getSpecularState() {
            StringBuffer stringBuffer = new StringBuffer("");
            StateManager.appendCmd(stringBuffer, "set ambientPercent " + Graphics3D.getAmbientPercent());
            StateManager.appendCmd(stringBuffer, "set diffusePercent " + Graphics3D.getDiffusePercent());
            StateManager.appendCmd(stringBuffer, "set specular " + Graphics3D.getSpecular());
            StateManager.appendCmd(stringBuffer, "set specularPercent " + Graphics3D.getSpecularPercent());
            StateManager.appendCmd(stringBuffer, "set specularPower " + Graphics3D.getSpecularPower());
            int n = Graphics3D.getSpecularExponent();
            int n2 = Graphics3D.getPhongExponent();
            if (Math.pow(2.0, n) == (double)n2) {
                StateManager.appendCmd(stringBuffer, "set specularExponent " + n);
            } else {
                StateManager.appendCmd(stringBuffer, "set phongExponent " + n2);
            }
            StateManager.appendCmd(stringBuffer, "set zShadePower " + Graphics3D.getZShadePower());
            return stringBuffer.toString();
        }

        void setMeasureDistanceUnits(String string) {
            if (string.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (string.equalsIgnoreCase("nanometers") || string.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (string.equalsIgnoreCase("picometers") || string.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else if (string.equalsIgnoreCase("bohr") || string.equalsIgnoreCase("au")) {
                this.measureDistanceUnits = "au";
            } else if (string.equalsIgnoreCase("vanderwaals") || string.equalsIgnoreCase("vdw")) {
                this.measureDistanceUnits = "vdw";
            }
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
        }

        String getMeasureDistanceUnits() {
            return this.measureDistanceUnits;
        }

        boolean isJmolVariable(String string) {
            return string.charAt(0) == '_' || this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase()) || this.htBooleanParameterFlags.containsKey(string) || unreportedProperties.indexOf(";" + string + ";") >= 0;
        }

        private void resetParameterStringValue(String string, GlobalSettings globalSettings) {
            this.setParameterValue(string, globalSettings == null ? "" : (String)globalSettings.getParameter(string));
        }

        void setParameterValue(String string, boolean bl) {
            if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htBooleanParameterFlags.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }

        void setParameterValue(String string, int n) {
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, n);
        }

        void setParameterValue(String string, float f) {
            if (Float.isNaN(f)) {
                return;
            }
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, new Float(f));
        }

        void setParameterValue(String string, String string2) {
            string = string.toLowerCase();
            if (string2 == null || this.htBooleanParameterFlags.containsKey(string)) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, string2);
        }

        void removeJmolParameter(String string) {
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                this.htBooleanParameterFlags.remove(string);
                if (!this.htPropertyFlagsRemoved.containsKey(string)) {
                    this.htPropertyFlagsRemoved.put(string, Boolean.FALSE);
                }
                return;
            }
            if (this.htNonbooleanParameterValues.containsKey(string)) {
                this.htNonbooleanParameterValues.remove(string);
            }
        }

        ScriptVariable setUserVariable(String string, ScriptVariable scriptVariable) {
            if (scriptVariable == null) {
                return null;
            }
            string = string.toLowerCase();
            this.htUserVariables.put(string, scriptVariable.setName(string).setGlobal());
            return scriptVariable;
        }

        void unsetUserVariable(String string) {
            if ((string = string.toLowerCase()).equals("all") || string.equals("variables")) {
                this.htUserVariables.clear();
                Logger.info("all user-defined variables deleted");
            } else if (this.htUserVariables.containsKey(string)) {
                Logger.info("variable " + string + " deleted");
                this.htUserVariables.remove(string);
            }
        }

        void removeUserVariable(String string) {
            this.htUserVariables.remove(string);
        }

        ScriptVariable getUserVariable(String string) {
            if (string == null) {
                return null;
            }
            string = string.toLowerCase();
            return this.htUserVariables.get(string);
        }

        String getParameterEscaped(String string, int n) {
            if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
                Object object = this.htNonbooleanParameterValues.get(string);
                return StateManager.varClip(string, Escape.escape(object), n);
            }
            if (this.htBooleanParameterFlags.containsKey(string)) {
                return this.htBooleanParameterFlags.get(string).toString();
            }
            if (this.htUserVariables.containsKey(string)) {
                return this.htUserVariables.get(string).escape();
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return "false";
            }
            return "<not defined>";
        }

        Object getParameter(String string) {
            Object object = this.getParameter(string, false);
            return object == null ? "" : object;
        }

        ScriptVariable getOrSetNewVariable(String string, boolean bl) {
            Object object;
            if (string == null || string.length() == 0) {
                string = "x";
            }
            return (object = this.getParameter(string, true)) == null && bl && string.charAt(0) != '_' ? this.setUserVariable(string, new ScriptVariable()) : ScriptVariable.getVariable(object);
        }

        Object getParameter(String string, boolean bl) {
            Object object;
            if ((string = string.toLowerCase()).equals("_memory")) {
                object = Runtime.getRuntime();
                float f = (float)((Runtime)object).totalMemory() / 1000000.0f;
                float f2 = (float)((Runtime)object).freeMemory() / 1000000.0f;
                String string2 = TextFormat.formatDecimal(f - f2, 1) + "/" + TextFormat.formatDecimal(f, 1);
                this.htNonbooleanParameterValues.put("_memory", string2);
            }
            if (this.htNonbooleanParameterValues.containsKey(string)) {
                return this.htNonbooleanParameterValues.get(string);
            }
            if (this.htBooleanParameterFlags.containsKey(string)) {
                return this.htBooleanParameterFlags.get(string);
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return Boolean.FALSE;
            }
            if (this.htUserVariables.containsKey(string)) {
                object = this.htUserVariables.get(string);
                return bl ? object : ScriptVariable.oValue((ScriptVariable)object);
            }
            return null;
        }

        String getAllSettings(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("");
            Object[] objectArray = new String[this.htBooleanParameterFlags.size() + this.htNonbooleanParameterValues.size() + this.htUserVariables.size()];
            int n = 0;
            String string2 = "_" + string;
            for (String string3 : this.htBooleanParameterFlags.keySet()) {
                if (string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
                objectArray[n++] = (string3.indexOf("_") == 0 ? string3 + " = " : "set " + string3 + " ") + this.htBooleanParameterFlags.get(string3);
            }
            for (String string3 : this.htNonbooleanParameterValues.keySet()) {
                if (string3.charAt(0) == '@' || string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
                object = this.htNonbooleanParameterValues.get(string3);
                if (object instanceof String) {
                    object = this.chop(Escape.escape((String)object));
                }
                objectArray[n++] = (string3.indexOf("_") == 0 ? string3 + " = " : "set " + string3 + " ") + object;
            }
            for (String string3 : this.htUserVariables.keySet()) {
                if (string != null && string3.indexOf(string) != 0) continue;
                object = this.htUserVariables.get(string3);
                String string4 = ((ScriptVariable)object).asString();
                objectArray[n++] = string3 + " " + (string3.startsWith("@") ? "" : "= ") + (((ScriptVariable)object).tok == 4 ? this.chop(Escape.escape(string4)) : string4);
            }
            Arrays.sort(objectArray, 0, n);
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                StateManager.appendCmd(stringBuffer, (String)objectArray[i]);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        private String chop(String string) {
            int n = string.length();
            if (n < 512) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "\"\\\n    + \"";
            int n2 = 0;
            for (int i = 72; i < n; i += 72) {
                while (string.charAt(i - 1) == '\\') {
                    ++i;
                }
                stringBuilder.append(n2 == 0 ? "" : string2).append(string.substring(n2, i));
                n2 = i;
            }
            stringBuilder.append(string2).append(string.substring(n2, n));
            return stringBuilder.toString();
        }

        String getState(StringBuffer stringBuffer) {
            boolean bl;
            Object[] objectArray = new String[this.htBooleanParameterFlags.size() + this.htNonbooleanParameterValues.size()];
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl2 = bl = stringBuffer != null;
            if (bl) {
                stringBuffer.append("  _setVariableState;\n");
                stringBuffer2.append("function _setVariableState() {\n\n");
            }
            int n = 0;
            for (String string : this.htBooleanParameterFlags.keySet()) {
                if (!this.doReportProperty(string)) continue;
                objectArray[n++] = "set " + string + " " + this.htBooleanParameterFlags.get(string);
            }
            for (String string : this.htNonbooleanParameterValues.keySet()) {
                if (!this.doReportProperty(string)) continue;
                Object object = this.htNonbooleanParameterValues.get(string);
                if (string.charAt(0) == '=') {
                    string = string.substring(1);
                } else {
                    string = string.indexOf("default") == 0 ? " set " + string : "set " + string;
                    object = Escape.escape(object);
                }
                objectArray[n++] = string + " " + object;
            }
            switch (this.axesMode) {
                case UNITCELL: {
                    objectArray[n++] = "set axes unitcell";
                    break;
                }
                case BOUNDBOX: {
                    objectArray[n++] = "set axes window";
                    break;
                }
                default: {
                    objectArray[n++] = "set axes molecular";
                }
            }
            Arrays.sort(objectArray, 0, n);
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                StateManager.appendCmd(stringBuffer2, (String)objectArray[i]);
            }
            String string = StateManager.getVariableList(this.htUserVariables, 0, false, true);
            if (string.length() > 0) {
                stringBuffer2.append("\n#user-defined atom sets; \n");
                stringBuffer2.append(string);
            }
            StateManager.this.viewer.loadShape(5);
            stringBuffer2.append(StateManager.this.viewer.getShapeProperty(5, "defaultState"));
            if (this.haveSetStructureList) {
                stringBuffer2.append("struture HELIX set " + Escape.escape(this.structureList.get((Object)EnumStructure.HELIX)));
                stringBuffer2.append("struture SHEET set " + Escape.escape(this.structureList.get((Object)EnumStructure.SHEET)));
                stringBuffer2.append("struture TURN set " + Escape.escape(this.structureList.get((Object)EnumStructure.TURN)));
            }
            if (stringBuffer != null) {
                stringBuffer2.append("\n}\n\n");
            }
            return stringBuffer2.toString();
        }

        private boolean doReportProperty(String string) {
            return string.charAt(0) != '_' && unreportedProperties.indexOf(";" + string + ";") < 0;
        }

        String getVariableList() {
            return StateManager.getVariableList(this.htUserVariables, 0, true, false);
        }

        public void setStructureList(float[] fArray, EnumStructure enumStructure) {
            this.haveSetStructureList = true;
            this.structureList.put(enumStructure, fArray);
        }

        public Map<EnumStructure, float[]> getStructureList() {
            return this.structureList;
        }

        void setPicked(int n) {
            ScriptVariable scriptVariable = null;
            if (n >= 0) {
                this.setParameterValue("_atompicked", n);
                scriptVariable = (ScriptVariable)this.getParameter("picked", true);
            }
            if (scriptVariable == null || scriptVariable.tok != 10) {
                scriptVariable = ScriptVariable.getVariable(new BitSet());
                this.setUserVariable("picked", scriptVariable);
            }
            if (n >= 0) {
                ScriptVariable.getBitSet(scriptVariable, false).set(n);
            }
        }
    }

    static class Connection {
        int atomIndex1;
        int atomIndex2;
        short mad;
        short colix;
        int order;
        float energy;
        int shapeVisibilityFlags;

        Connection(int n, int n2, short s, short s2, int n3, float f, int n4) {
            this.atomIndex1 = n;
            this.atomIndex2 = n2;
            this.mad = s;
            this.colix = s2;
            this.order = n3;
            this.energy = f;
            this.shapeVisibilityFlags = n4;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            this.bondCount = modelSet.getBondCount();
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bondArray = modelSet.getBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Bond bond = bondArray[n];
                this.connections[n] = new Connection(bond.getAtomIndex1(), bond.getAtomIndex2(), bond.getMad(), bond.getColix(), bond.order, bond.getEnergy(), bond.getShapeVisibilityFlags());
            }
        }

        void restore() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            modelSet.deleteAllBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Connection connection = this.connections[n];
                int n2 = modelSet.getAtomCount();
                if (connection.atomIndex1 >= n2 || connection.atomIndex2 >= n2) continue;
                Bond bond = modelSet.bondAtoms(modelSet.atoms[connection.atomIndex1], modelSet.atoms[connection.atomIndex2], connection.order, connection.mad, null, connection.energy, false, true);
                bond.setColix(connection.colix);
                bond.setShapeVisibilityFlags(connection.shapeVisibilityFlags);
            }
            n = this.bondCount;
            while (--n >= 0) {
                modelSet.getBondAt(n).setIndex(n);
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
        }
    }

    public class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        Point3f navCenter = new Point3f();
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        boolean windowCenteredFlag;
        boolean navigationMode;
        boolean navigateSurface;
        String moveToText;

        Orientation(boolean bl) {
            if (bl) {
                Matrix3f matrix3f = (Matrix3f)StateManager.this.viewer.getModelSetAuxiliaryInfo("defaultOrientationMatrix");
                if (matrix3f == null) {
                    this.rotationMatrix.setIdentity();
                } else {
                    this.rotationMatrix.set(matrix3f);
                }
            } else {
                StateManager.this.viewer.getRotation(this.rotationMatrix);
            }
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomSetting();
            this.center.set(StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
            this.navigationMode = StateManager.this.viewer.getNavigationMode();
            this.navigateSurface = StateManager.this.viewer.getNavigateSurface();
            this.moveToText = StateManager.this.viewer.getMoveToText(-1.0f);
            if (this.navigationMode) {
                this.xNav = StateManager.this.viewer.getNavigationOffsetPercent('X');
                this.yNav = StateManager.this.viewer.getNavigationOffsetPercent('Y');
                this.navDepth = StateManager.this.viewer.getNavigationDepthPercent();
                this.navCenter = new Point3f(StateManager.this.viewer.getNavigationCenter());
            }
        }

        public String getMoveToText(boolean bl) {
            return bl ? "  " + this.moveToText + "\n  save orientation \"" + this.saveName.substring(12) + "\";\n" : this.moveToText;
        }

        public void restore(float f, boolean bl) {
            if (!bl) {
                StateManager.this.viewer.setRotationMatrix(this.rotationMatrix);
                return;
            }
            StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            StateManager.this.viewer.setBooleanProperty("navigationMode", this.navigationMode);
            StateManager.this.viewer.setBooleanProperty("navigateSurface", this.navigateSurface);
            StateManager.this.viewer.moveTo(f, this.center, null, Float.NaN, this.rotationMatrix, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth);
        }
    }
}

