/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shapespecial.Draw;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;

public class DrawMesh
extends Mesh {
    BitSet modelFlags;
    Draw.EnumDrawType drawType = Draw.EnumDrawType.NONE;
    Draw.EnumDrawType[] drawTypes;
    Point3f[] ptCenters;
    Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    Vector3f[] axes;
    int drawVertexCount;
    int[] drawVertexCounts;
    boolean isFixed;
    boolean isVector;
    float drawArrowScale;
    boolean noHead;
    boolean isBarb;
    BitSet bsMeshesVisible = new BitSet();

    DrawMesh(String string, Graphics3D graphics3D, short s, int n) {
        super(string, graphics3D, s, n);
    }

    void setCenters() {
        if (this.ptCenters == null) {
            this.setCenter(-1);
        } else {
            int n = this.ptCenters.length;
            while (--n >= 0) {
                this.setCenter(n);
            }
        }
    }

    final void setCenter(int n) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.polygonCount;
        while (--n5 >= 0) {
            int n6;
            if (n >= 0 && n5 != n || this.polygonIndexes[n5] == null) continue;
            n2 = -1;
            int n7 = n6 = this.drawType == Draw.EnumDrawType.POLYGON ? 3 : this.polygonIndexes[n5].length;
            while (--n6 >= 0) {
                n3 = this.polygonIndexes[n5][n6];
                if (n3 == n2) continue;
                n2 = n3;
                point3f.add(this.vertices[n3]);
                ++n4;
            }
            if (n4 <= 0 || n5 != n && n5 != 0) continue;
            point3f.scale(1.0f / (float)n4);
            if (this.ptOffset == null) break;
            point3f.add(this.ptOffset);
            break;
        }
        if (n < 0) {
            this.ptCenter = point3f;
        } else {
            this.ptCenters[n] = point3f;
        }
    }

    void offset(Vector3f vector3f) {
        if (this.ptOffset == null) {
            this.ptOffset = new Point3f();
        }
        this.ptOffset.add(vector3f);
        this.setCenters();
        this.recalcAltVertices = true;
    }

    public void deleteAtoms(int n) {
        if (n >= this.polygonCount) {
            return;
        }
        --this.polygonCount;
        this.polygonIndexes = (int[][])ArrayUtil.deleteElements(this.polygonIndexes, n, 1);
        this.drawTypes = (Draw.EnumDrawType[])ArrayUtil.deleteElements(this.drawTypes, n, 1);
        this.drawVertexCounts = (int[])ArrayUtil.deleteElements(this.drawVertexCounts, n, 1);
        this.ptCenters = (Point3f[])ArrayUtil.deleteElements(this.ptCenters, n, 1);
        this.axes = (Vector3f[])ArrayUtil.deleteElements(this.axes, n, 1);
        BitSet bitSet = BitSetUtil.setBit(n);
        BitSetUtil.deleteBits(this.modelFlags, bitSet);
    }
}

