/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import org.jmol.modelset.TickInfo;
import org.jmol.shape.FontShape;
import org.jmol.util.Escape;

public abstract class FontLineShape
extends FontShape {
    TickInfo[] tickInfos = new TickInfo[4];

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("tickInfo" == string) {
            TickInfo tickInfo = (TickInfo)object;
            if (tickInfo.ticks == null) {
                if (tickInfo.type.equals(" ")) {
                    this.tickInfos[3] = null;
                    this.tickInfos[2] = null;
                    this.tickInfos[1] = null;
                    this.tickInfos[0] = null;
                } else {
                    this.tickInfos["xyz".indexOf((String)tickInfo.type) + 1] = null;
                }
                return;
            }
            this.tickInfos["xyz".indexOf((String)tickInfo.type) + 1] = tickInfo;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public String getShapeState() {
        String string = super.getShapeState();
        if (this.tickInfos == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.tickInfos[0] != null) {
            this.appendTickInfo(stringBuffer, 0);
        }
        if (this.tickInfos[1] != null) {
            this.appendTickInfo(stringBuffer, 1);
        }
        if (this.tickInfos[2] != null) {
            this.appendTickInfo(stringBuffer, 2);
        }
        if (this.tickInfos[3] != null) {
            this.appendTickInfo(stringBuffer, 3);
        }
        if (string.indexOf(" off") >= 0) {
            stringBuffer.append("  " + this.myType + " off;\n");
        }
        return stringBuffer.toString();
    }

    private void appendTickInfo(StringBuffer stringBuffer, int n) {
        stringBuffer.append("  ");
        stringBuffer.append(this.myType);
        FontLineShape.addTickInfo(stringBuffer, this.tickInfos[n], false);
        stringBuffer.append(";\n");
    }

    public static void addTickInfo(StringBuffer stringBuffer, TickInfo tickInfo, boolean bl) {
        boolean bl2;
        stringBuffer.append(" ticks ").append(tickInfo.type).append(" ").append(Escape.escape(tickInfo.ticks));
        boolean bl3 = bl2 = tickInfo.scale != null && Float.isNaN(tickInfo.scale.x);
        if (bl2) {
            stringBuffer.append(" UNITCELL");
        }
        if (tickInfo.tickLabelFormats != null) {
            stringBuffer.append(" format ").append(Escape.escape(tickInfo.tickLabelFormats, false));
        }
        if (!bl2 && tickInfo.scale != null) {
            stringBuffer.append(" scale ").append(Escape.escape(tickInfo.scale));
        }
        if (bl && !Float.isNaN(tickInfo.first) && tickInfo.first != 0.0f) {
            stringBuffer.append(" first ").append(tickInfo.first);
        }
        if (tickInfo.reference != null) {
            stringBuffer.append(" point ").append(Escape.escape(tickInfo.reference));
        }
    }
}

