/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumAxesMode;
import org.jmol.shape.Axes;
import org.jmol.shape.FontLineShapeRenderer;
import org.jmol.util.Point3fi;

public class AxesRenderer
extends FontLineShapeRenderer {
    private static final String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c", "X", "Y", "Z", null, null, null, "X", null, "Z", null, "(Y)", null};
    private final Point3f[] screens = new Point3f[6];
    private final Point3f originScreen;
    private short[] colixes;

    public AxesRenderer() {
        int n = 6;
        while (--n >= 0) {
            this.screens[n] = new Point3f();
        }
        this.originScreen = new Point3f();
        this.colixes = new short[3];
    }

    protected void initRenderer() {
        this.endcap = (byte)2;
        this.draw000 = false;
    }

    protected void render() {
        int n;
        float f;
        float f2;
        boolean bl;
        SymmetryInterface[] symmetryInterfaceArray;
        boolean bl2;
        Axes axes = (Axes)this.shape;
        int n2 = this.viewer.getObjectMad(1);
        if (n2 == 0 || !this.g3d.checkTranslucent(false)) {
            return;
        }
        boolean bl3 = bl2 = axes.axisXY.z != 0.0f;
        if (!bl2 && this.viewer.isNavigating() && this.viewer.getNavigationPeriodic()) {
            return;
        }
        EnumAxesMode enumAxesMode = this.viewer.getAxesMode();
        this.imageFontScaling = this.viewer.getImageFontScaling();
        if (this.viewer.areAxesTainted()) {
            symmetryInterfaceArray = axes.font3d;
            axes.initShape();
            if (symmetryInterfaceArray != null) {
                axes.font3d = symmetryInterfaceArray;
            }
        }
        this.font3d = this.g3d.getFont3DScaled(axes.font3d, this.imageFontScaling);
        symmetryInterfaceArray = this.modelSet.getCellInfos();
        int n3 = this.viewer.getCurrentModelIndex();
        boolean bl4 = bl = enumAxesMode == EnumAxesMode.UNITCELL;
        if (this.viewer.isJmolDataFrame(n3) || bl && n3 < 0) {
            return;
        }
        int n4 = 6;
        int n5 = 0;
        if (bl && symmetryInterfaceArray != null) {
            n4 = 3;
            n5 = 6;
        } else if (bl2) {
            n4 = 3;
            n5 = 9;
        } else if (enumAxesMode == EnumAxesMode.BOUNDBOX) {
            n4 = 6;
            int n6 = n5 = this.viewer.getAxesOrientationRasmol() ? 15 : 9;
        }
        if (axes.labels != null) {
            if (n4 != 3) {
                n4 = axes.labels.length;
            }
            n5 = -1;
        }
        boolean bl5 = this.viewer.isJmolDataFrame();
        int n7 = this.g3d.getSlab();
        int n8 = n2;
        boolean bl6 = false;
        if (bl2) {
            if (this.exportType == 1) {
                return;
            }
            if (n2 >= 20) {
                int n9 = n8 = n2 > 500 ? 5 : n2 / 100;
                if (n8 == 0) {
                    n8 = 2;
                }
            } else if (this.g3d.isAntialiased()) {
                n8 += n8;
            }
            this.g3d.setSlab(0);
            this.pt0.set(this.viewer.transformPoint(axes.axisXY));
            this.originScreen.set(this.pt0.x, this.pt0.y, this.pt0.z);
            f2 = this.viewer.getScreenDim();
            f = f2 / 10.0f * axes.scale;
            if (this.g3d.isAntialiased()) {
                f *= 2.0f;
            }
            for (n = 0; n < 3; ++n) {
                this.viewer.rotatePoint(axes.getAxisPoint(n, false), this.screens[n]);
                this.screens[n].z *= -1.0f;
                this.screens[n].scaleAdd(f, this.screens[n], this.originScreen);
            }
        } else {
            boolean bl7 = bl6 = axes.tickInfos != null;
            if (bl6) {
                if (this.atomA == null) {
                    this.atomA = new Point3fi();
                    this.atomB = new Point3fi();
                }
                this.atomA.set(axes.getOriginPoint(bl5));
            }
            this.viewer.transformPointNoClip(axes.getOriginPoint(bl5), this.originScreen);
            n8 = this.getDiameter((int)this.originScreen.z, n2);
            int n10 = n4;
            while (--n10 >= 0) {
                this.viewer.transformPointNoClip(axes.getAxisPoint(n10, bl5), this.screens[n10]);
            }
        }
        f2 = this.originScreen.x;
        f = this.originScreen.y;
        this.colixes[0] = this.viewer.getObjectColix(1);
        this.colixes[1] = this.viewer.getObjectColix(2);
        this.colixes[2] = this.viewer.getObjectColix(3);
        n = n4;
        while (--n >= 0) {
            String string;
            this.colix = this.colixes[n % 3];
            this.g3d.setColix(this.colix);
            String string2 = axes.labels == null ? axisLabels[n + n5] : (string = n < axes.labels.length ? axes.labels[n] : null);
            if (string != null && string.length() > 0) {
                this.renderLabel(string, this.screens[n].x, this.screens[n].y, this.screens[n].z, f2, f);
            }
            if (bl6) {
                this.tickInfo = axes.tickInfos[n % 3 + 1];
                if (this.tickInfo == null) {
                    this.tickInfo = axes.tickInfos[0];
                }
                this.atomB.set(axes.getAxisPoint(n, bl5));
                if (this.tickInfo != null) {
                    this.tickInfo.first = 0.0f;
                    this.tickInfo.signFactor = n % 6 >= 3 ? -1 : 1;
                }
            }
            this.renderLine(this.originScreen, this.screens[n], n8, this.pt0, this.pt1, bl6 && this.tickInfo != null);
        }
        if (n4 == 3 && !bl2) {
            this.colix = this.viewer.getColixBackgroundContrast();
            this.g3d.setColix(this.colix);
            this.renderLabel("0", this.originScreen.x, this.originScreen.y, this.originScreen.z, f2, f);
        }
        if (bl2) {
            this.g3d.setSlab(n7);
        }
    }

    private void renderLabel(String string, float f, float f2, float f3, float f4, float f5) {
        float f6;
        int n = this.font3d.getAscent();
        int n2 = this.font3d.stringWidth(string);
        float f7 = f - f4;
        float f8 = f2 - f5;
        if (f7 != 0.0f || f8 != 0.0f) {
            f6 = (float)Math.sqrt(f7 * f7 + f8 * f8);
            f7 = (float)n2 * 0.75f * f7 / f6;
            f8 = (float)n * 0.75f * f8 / f6;
            f += f7;
            f2 += f8;
        }
        f6 = f - (float)(n2 / 2);
        float f9 = f2 + (float)(n / 2);
        this.g3d.drawString(string, this.font3d, (int)f6, (int)f9, (int)f3, (int)f3);
    }
}

