/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Measure;

public class Sheet
extends ProteinStructure {
    AlphaPolymer alphaPolymer;
    Vector3f widthUnitVector;
    Vector3f heightUnitVector;

    Sheet(AlphaPolymer alphaPolymer, int n, int n2, int n3, EnumStructure enumStructure) {
        super(alphaPolymer, EnumStructure.SHEET, n, n2, n3);
        this.alphaPolymer = alphaPolymer;
        this.subtype = enumStructure;
    }

    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new Point3f();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        Point3f point3f = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst, point3f);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(point3f, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        Point3f point3f2 = new Point3f();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount, point3f2);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(point3f2, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = point3f;
        this.axisB = point3f2;
    }

    void calcSheetUnitVectors() {
        if (!(this.alphaPolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            AminoMonomer aminoMonomer = (AminoMonomer)this.alphaPolymer.monomers[this.monomerIndexFirst];
            vector3f2.sub(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
            int n = this.monomerCount;
            while (--n > this.monomerIndexFirst) {
                aminoMonomer = (AminoMonomer)this.alphaPolymer.monomers[n];
                vector3f.sub(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
                if (vector3f2.angle(vector3f) < 1.5707964f) {
                    vector3f2.add(vector3f);
                    continue;
                }
                vector3f2.sub(vector3f);
            }
            this.heightUnitVector = vector3f;
            this.heightUnitVector.cross(this.axisUnitVector, vector3f2);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vector3f2;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public Vector3f getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    public Vector3f getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

