/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.StateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model {
    ModelSet modelSet;
    public int modelIndex;
    int fileIndex;
    public int hydrogenCount;
    public boolean isPDB;
    public boolean isPdbWithMultipleBonds;
    String loadState = "";
    StringBuffer loadScript = new StringBuffer();
    boolean isModelKit;
    boolean isTrajectory;
    int trajectoryBaseIndex;
    int selectedTrajectory = -1;
    boolean hasRasmolHBonds;
    Map<String, Integer> dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    int firstAtomIndex;
    int atomCount = 0;
    final BitSet bsAtoms = new BitSet();
    final BitSet bsAtomsDeleted = new BitSet();
    private int bondCount = -1;
    int firstMoleculeIndex;
    int moleculeCount;
    public int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    int chainCount = 0;
    Chain[] chains = new Chain[8];
    int bioPolymerCount = 0;
    Polymer[] bioPolymers = new Polymer[8];
    int biosymmetryCount;
    Map<String, Object> auxiliaryInfo;
    Properties properties;
    float defaultRotationRadius;
    String defaultStructure;
    StateManager.Orientation orientation;
    boolean structureTainted;
    boolean isJmolDataFrame;

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isModelkit() {
        return this.isModelKit;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bondArray = this.modelSet.getBonds();
        this.bondCount = 0;
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            if (bondArray[n].atom1.modelIndex != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    Model(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = map;
        if (map.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)map.get("biosymmetryCount");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = string;
            this.isJmolDataFrame = true;
            map.put("jmolData", string);
            map.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
    }

    void setNAltLocs(int n) {
        this.nAltLocs = n;
    }

    void setNInsertions(int n) {
        this.nInsertions = n;
    }

    void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, char c, int n3, char c2, int n4) {
        int n5 = this.bioPolymerCount;
        while (--n5 >= 0) {
            Polymer polymer = this.bioPolymers[n5];
            polymer.addSecondaryStructure(enumStructure, string, n, n2, c, n3, c2, n4);
        }
    }

    public String getModelNumberDotted() {
        return this.modelSet.getModelNumberDotted(this.modelIndex);
    }

    public String getModelTitle() {
        return this.modelSet.getModelTitle(this.modelIndex);
    }

    String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        this.modelSet.proteinStructureTainted = true;
        this.structureTainted = true;
        if (this.bioPolymerCount == 0 || !bl4 && !bl) {
            return "";
        }
        if (bl4) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (bl && this.bioPolymers[n].getGroups()[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[n].clearStructures();
            }
        }
        if (!bl || bl5) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                this.bioPolymers[n].calculateStructures(bl5);
            }
        }
        return bl ? this.bioPolymers[0].calculateStructures(this.bioPolymers, this.bioPolymerCount, null, bl2, bl3, bl4) : "";
    }

    public boolean isStructureTainted() {
        return this.structureTainted;
    }

    void setConformation(BitSet bitSet) {
        if (this.nAltLocs > 0) {
            int n = this.bioPolymerCount;
            while (--n >= 0) {
                this.bioPolymers[n].setConformation(bitSet);
            }
        }
    }

    boolean getPdbConformation(BitSet bitSet, int n) {
        if (!this.isPDB) {
            return false;
        }
        if (this.nAltLocs > 0) {
            int n2 = this.bioPolymerCount;
            while (--n2 >= 0) {
                this.bioPolymers[n2].getConformation(bitSet, n);
            }
        }
        return true;
    }

    public Chain[] getChains() {
        return this.chains;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != '\u0000') continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCount(boolean bl) {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            int n3 = this.chains[n2].groupCount;
            while (--n3 >= 0) {
                if (this.chains[n2].groups[n3].isHetero() != bl) continue;
                ++n;
            }
        }
        return n;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bitSet);
        }
    }

    void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcSelectedMonomersCount(bitSet);
        }
    }

    void selectSeqcodeRange(int n, int n2, char c, BitSet bitSet, boolean bl) {
        int n3 = this.chainCount;
        while (--n3 >= 0) {
            if (c != '\t' && c != this.chains[n3].chainID && (bl || c != Character.toUpperCase(this.chains[n3].chainID))) continue;
            int n4 = 0;
            while (n4 >= 0) {
                n4 = this.chains[n3].selectSeqcodeRange(n4, n, n2, bitSet);
            }
        }
    }

    int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].getGroupCount();
            }
        }
        return this.groupCount;
    }

    Chain getChain(char c) {
        int n = this.chainCount;
        while (--n >= 0) {
            Chain chain = this.chains[n];
            if (chain.getChainID() != c) continue;
            return chain;
        }
        return null;
    }

    Chain getChain(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    public Polymer getBioPolymer(int n) {
        return this.bioPolymers[n];
    }

    void getDefaultLargePDBRendering(StringBuffer stringBuffer, int n) {
        BitSet bitSet = new BitSet();
        if (this.getBondCount() == 0) {
            bitSet = this.bsAtoms;
        }
        if (bitSet != this.bsAtoms) {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                this.bioPolymers[i].getRange(bitSet);
            }
        }
        if (bitSet.nextSetBit(0) < 0) {
            return;
        }
        BitSet bitSet2 = new BitSet();
        if (bitSet == this.bsAtoms) {
            bitSet2 = bitSet;
        } else {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                if (this.bioPolymers[i].getType() != 0) continue;
                this.bioPolymers[i].getRange(bitSet2);
            }
        }
        if (bitSet2.nextSetBit(0) >= 0) {
            stringBuffer.append("select ").append(Escape.escape(bitSet2)).append(";backbone only;");
        }
        if (this.atomCount <= n) {
            return;
        }
        stringBuffer.append("select ").append(Escape.escape(bitSet)).append(" & connected; wireframe only;");
        if (bitSet != this.bsAtoms) {
            bitSet2.clear();
            bitSet2.or(this.bsAtoms);
            bitSet2.andNot(bitSet);
            if (bitSet2.nextSetBit(0) >= 0) {
                stringBuffer.append("select " + Escape.escape(bitSet2) + " & !connected;stars 0.5;");
            }
        }
    }

    public boolean isAtomHidden(int n) {
        return this.modelSet.isAtomHidden(n);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    void fixIndices(int n, int n2, BitSet bitSet) {
        int n3;
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (n3 = 0; n3 < this.chainCount; ++n3) {
            this.chains[n3].fixIndices(n2, bitSet);
        }
        for (n3 = 0; n3 < this.bioPolymerCount; ++n3) {
            this.bioPolymers[n3].recalculateLeadMidpointsAndWingVectors();
        }
        BitSetUtil.deleteBits(this.bsAtoms, bitSet);
        BitSetUtil.deleteBits(this.bsAtomsDeleted, bitSet);
    }
}

