/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    protected int groupIndex;
    protected Chain chain;
    int seqcode;
    protected short groupID;
    protected boolean isProtein;
    int selectedIndex;
    public int firstAtomIndex = -1;
    public int leadAtomIndex = -1;
    public int lastAtomIndex;
    private static final int SEQUENCE_NUMBER_FLAG = 128;
    private static final int INSERTION_CODE_MASK = 127;
    private static final int SEQUENCE_NUMBER_SHIFT = 8;
    public int shapeVisibilityFlags = 0;
    private float phi = Float.NaN;
    private float psi = Float.NaN;
    private float omega = Float.NaN;
    private float straightness = Float.NaN;
    private float mu = Float.NaN;
    private float theta = Float.NaN;
    private static Map<String, Short> htGroup = new Hashtable<String, Short>();
    static String[] group3Names = new String[128];
    static short group3NameCount = 0;
    private BitSet bsAdded;

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int n) {
        this.groupIndex = n;
    }

    protected boolean calcBioParameters() {
        return false;
    }

    public boolean haveParameters() {
        return true;
    }

    public void setGroupParameter(int n, float f) {
        switch (n) {
            case 1112539143: {
                this.phi = f;
                break;
            }
            case 1112539144: {
                this.psi = f;
                break;
            }
            case 1112539142: {
                this.omega = f;
                break;
            }
            case 1112539140: {
                this.mu = f;
                break;
            }
            case 1112539147: {
                this.theta = f;
                break;
            }
            case 1112539145: {
                this.straightness = f;
            }
        }
    }

    public float getGroupParameter(int n) {
        if (!this.haveParameters()) {
            this.calcBioParameters();
        }
        switch (n) {
            case 1112539142: {
                return this.omega;
            }
            case 1112539143: {
                return this.phi;
            }
            case 1112539144: {
                return this.psi;
            }
            case 1112539140: {
                return this.mu;
            }
            case 1112539147: {
                return this.theta;
            }
            case 1112539145: {
                return this.straightness;
            }
        }
        return Float.NaN;
    }

    public Group(Chain chain, String string, int n, int n2, int n3) {
        this.chain = chain;
        this.seqcode = n;
        if (string == null) {
            string = "";
        }
        this.groupID = Group.getGroupID(string);
        this.isProtein = this.groupID >= 1 && this.groupID < 24;
        this.firstAtomIndex = n2;
        this.lastAtomIndex = n3;
    }

    public void setModelSet(ModelSet modelSet) {
        this.chain.modelSet = modelSet;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    final boolean isGroup3(String string) {
        return group3Names[this.groupID].equalsIgnoreCase(string);
    }

    public final String getGroup3() {
        return group3Names[this.groupID];
    }

    public static String getGroup3(short s) {
        return group3Names[s];
    }

    public final char getGroup1() {
        if (this.groupID >= JmolConstants.predefinedGroup1Names.length) {
            return '?';
        }
        return JmolConstants.predefinedGroup1Names[this.groupID];
    }

    public final short getGroupID() {
        return this.groupID;
    }

    public final ModelSet getModelSet() {
        return this.chain.getModelSet();
    }

    public final char getChainID() {
        return this.chain.chainID;
    }

    public int getBioPolymerLength() {
        return 0;
    }

    public int getMonomerIndex() {
        return -1;
    }

    public Object getStructure() {
        return null;
    }

    public int getStrucNo() {
        return 0;
    }

    public EnumStructure getProteinStructureType() {
        return EnumStructure.NOT;
    }

    public EnumStructure getProteinStructureSubType() {
        return this.getProteinStructureType();
    }

    public int setProteinStructureType(EnumStructure enumStructure, int n) {
        return -1;
    }

    public boolean isProtein() {
        return this.isProtein;
    }

    public boolean isNucleic() {
        return this.groupID >= 24 && this.groupID < 42;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public boolean isPurine() {
        return false;
    }

    public boolean isPyrimidine() {
        return false;
    }

    public boolean isCarbohydrate() {
        return false;
    }

    static synchronized short addGroup3Name(String string) {
        if (group3NameCount == group3Names.length) {
            group3Names = ArrayUtil.doubleLength(group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short s2 = s;
        Group.group3Names[s2] = string;
        htGroup.put(string, s2);
        return s2;
    }

    public static short getGroupID(String string) {
        if (string == null) {
            return -1;
        }
        short s = Group.lookupGroupID(string);
        return s != -1 ? s : Group.addGroup3Name(string);
    }

    public static short lookupGroupID(String string) {
        Short s;
        if (string != null && (s = htGroup.get(string)) != null) {
            return s;
        }
        return -1;
    }

    public final int getResno() {
        return this.seqcode == Integer.MIN_VALUE ? 0 : this.seqcode >> 8;
    }

    public final int getSeqcode() {
        return this.seqcode;
    }

    public final int getSeqNumber() {
        return this.seqcode >> 8;
    }

    public static final int getSequenceNumber(int n) {
        return Group.haveSequenceNumber(n) ? n >> 8 : Integer.MAX_VALUE;
    }

    public static final int getInsertionCodeValue(int n) {
        return n & 0x7F;
    }

    public static final boolean haveSequenceNumber(int n) {
        return (n & 0x80) != 0;
    }

    public final String getSeqcodeString() {
        return Group.getSeqcodeString(this.seqcode);
    }

    public static int getSeqcode(int n, char c) {
        if (n == Integer.MIN_VALUE) {
            return n;
        }
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '?' || c == '*')) {
            if (c != ' ' && c != '\u0000') {
                Logger.warn("unrecognized insertionCode:" + c);
            }
            c = '\u0000';
        }
        return (n == Integer.MAX_VALUE ? 0 : n << 8 | 0x80) + c;
    }

    public static String getSeqcodeString(int n) {
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return (n & 0x7F) == 0 ? "" + (n >> 8) : "" + (n >> 8) + '^' + (char)(n & 0x7F);
    }

    public char getInsertionCode() {
        if (this.seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(this.seqcode & 0x7F);
    }

    public static char getInsertionCode(int n) {
        if (n == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(n & 0x7F);
    }

    public boolean isAdded(int n) {
        return this.bsAdded != null && this.bsAdded.get(n);
    }

    public void addAtoms(int n) {
        if (this.bsAdded == null) {
            this.bsAdded = new BitSet();
        }
        this.bsAdded.set(n);
    }

    public int selectAtoms(BitSet bitSet) {
        bitSet.set(this.firstAtomIndex, this.lastAtomIndex + 1);
        if (this.bsAdded != null) {
            bitSet.or(this.bsAdded);
        }
        return this.lastAtomIndex;
    }

    public boolean isSelected(BitSet bitSet) {
        int n = bitSet.nextSetBit(this.firstAtomIndex);
        return n >= 0 && n <= this.lastAtomIndex || this.bsAdded != null && this.bsAdded.intersects(bitSet);
    }

    boolean isHetero() {
        return this.chain.getAtom(this.firstAtomIndex).isHetero();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    protected int scaleToScreen(int n, int n2) {
        return this.chain.modelSet.viewer.scaleToScreen(n, n2);
    }

    protected boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return this.chain.modelSet.isCursorOnTopOf(atom, n, n2, n3, atom2);
    }

    protected boolean isAtomHidden(int n) {
        return this.chain.modelSet.isAtomHidden(n);
    }

    public Model getModel() {
        return this.chain.model;
    }

    public int getModelIndex() {
        return this.chain.model.getModelIndex();
    }

    public int getSelectedMonomerCount() {
        return 0;
    }

    public int getSelectedMonomerIndex() {
        return -1;
    }

    public int getSelectedGroupIndex() {
        return this.selectedIndex;
    }

    public boolean isLeadAtom(int n) {
        return false;
    }

    public Atom getLeadAtom(Atom atom) {
        Atom atom2 = this.getLeadAtom();
        return atom2 == null ? atom : atom2;
    }

    public Atom getLeadAtom() {
        return null;
    }

    public Quaternion getQuaternion(char c) {
        return null;
    }

    public Quaternion getQuaternionFrame(Atom[] atomArray) {
        if (this.lastAtomIndex - this.firstAtomIndex < 3) {
            return null;
        }
        int n = this.firstAtomIndex;
        return Quaternion.getQuaternionFrame(atomArray[n], atomArray[++n], atomArray[++n]);
    }

    public void setProteinStructureId(int n) {
    }

    public Object getHelixData(int n, char c, int n2) {
        switch (n) {
            case 0x8100010: {
                return new Point3f();
            }
            case 1073741854: 
            case 1666189314: {
                return new Vector3f();
            }
            case 0x8100001: {
                return new Float(Float.NaN);
            }
            case 135266306: 
            case 1073742001: {
                return new String[0];
            }
        }
        return "";
    }

    public boolean isWithinStructure(EnumStructure enumStructure) {
        return false;
    }

    public String getProteinStructureTag() {
        return null;
    }

    public String getStructureId() {
        return "";
    }

    public int getBioPolymerIndexInModel() {
        return -1;
    }

    public boolean isCrossLinked(Group group) {
        return false;
    }

    public boolean getCrossLinkLeadAtomIndexes(List<Integer> list) {
        return false;
    }

    public boolean isConnectedPrevious() {
        return false;
    }

    public Atom getNitrogenAtom() {
        return null;
    }

    public Atom getCarbonylOxygenAtom() {
        return null;
    }

    public void fixIndices(int n, BitSet bitSet) {
        this.firstAtomIndex -= n;
        this.leadAtomIndex -= n;
        this.lastAtomIndex -= n;
        if (this.bsAdded != null) {
            BitSetUtil.deleteBits(this.bsAdded, bitSet);
        }
    }

    protected Map<String, Object> getGroupInfo(int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("groupIndex", n);
        hashtable.put("groupID", this.groupID);
        String string = this.getSeqcodeString();
        if (string != null) {
            hashtable.put("seqCode", string);
        }
        hashtable.put("_apt1", this.firstAtomIndex);
        hashtable.put("_apt2", this.lastAtomIndex);
        if (this.bsAdded != null) {
            hashtable.put("addedAtoms", this.bsAdded);
        }
        hashtable.put("atomInfo1", this.chain.modelSet.getAtomInfo(this.firstAtomIndex, null));
        hashtable.put("atomInfo2", this.chain.modelSet.getAtomInfo(this.lastAtomIndex, null));
        hashtable.put("visibilityFlags", this.shapeVisibilityFlags);
        return hashtable;
    }

    public void getMinZ(Atom[] atomArray, int[] nArray) {
        int n;
        nArray[0] = Integer.MAX_VALUE;
        for (n = this.firstAtomIndex; n <= this.lastAtomIndex; ++n) {
            this.checkMinZ(atomArray[n], nArray);
        }
        if (this.bsAdded != null) {
            n = this.bsAdded.nextSetBit(0);
            while (n >= 0) {
                this.checkMinZ(atomArray[n], nArray);
                n = this.bsAdded.nextSetBit(n + 1);
            }
        }
    }

    private void checkMinZ(Atom atom, int[] nArray) {
        int n = atom.screenZ - atom.screenDiameter / 2 - 2;
        if (n < nArray[0]) {
            nArray[0] = Math.max(1, n);
        }
    }

    static {
        for (int i = 0; i < JmolConstants.predefinedGroup3Names.length; ++i) {
            Group.addGroup3Name(JmolConstants.predefinedGroup3Names[i]);
        }
    }
}

