/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.util.BitSetUtil;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;
import org.jmol.viewer.JmolConstants;

public class Bond
extends JmolEdge {
    Atom atom1;
    Atom atom2;
    short mad;
    short colix;
    int shapeVisibilityFlags;
    static final int myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(1);

    public short getMad() {
        return this.mad;
    }

    public short getColix() {
        return this.colix;
    }

    public Bond(Atom atom, Atom atom2, int n, short s, short s2) {
        this.atom1 = atom;
        this.atom2 = atom2;
        this.colix = s2;
        this.setOrder(n);
        this.setMad(s);
    }

    public void setMad(short s) {
        this.mad = s;
        this.setShapeVisibility(s != 0);
    }

    public void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    void setShapeVisibility(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.shapeVisibilityFlags & myVisibilityFlag) != 0;
        if (bl2 == bl) {
            return;
        }
        this.atom1.addDisplayedBond(myVisibilityFlag, bl);
        this.atom2.addDisplayedBond(myVisibilityFlag, bl);
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= myVisibilityFlag) : (this.shapeVisibilityFlags &= ~myVisibilityFlag);
    }

    public String getIdentity() {
        return this.index + 1 + " " + this.getOrderNumberAsString() + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    public boolean isHydrogen() {
        return Bond.isHydrogen(this.order);
    }

    public static boolean isHydrogen(int n) {
        return (n & 0x7800) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x400) != 0;
    }

    boolean isPartial() {
        return (this.order & 0xE0) != 0;
    }

    boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    public void setPaletteID(byte by) {
    }

    public float getEnergy() {
        return 0.0f;
    }

    int getValence() {
        return !this.isCovalent() ? 0 : (this.isPartial() || this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, bl, f);
    }

    boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colix);
    }

    public void setOrder(int n) {
        if (this.atom1.getElementNumber() == 16 && this.atom2.getElementNumber() == 16) {
            n |= 0x100;
        }
        if (n == 512) {
            n = 515;
        }
        this.order = n | this.order & 0x20000;
    }

    public Atom getAtom1() {
        return this.atom1;
    }

    public Atom getAtom2() {
        return this.atom2;
    }

    public int getAtomIndex1() {
        return this.atom1.index;
    }

    public int getAtomIndex2() {
        return this.atom2.index;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    public int getCovalentOrder() {
        return JmolEdge.getCovalentBondOrder(this.order);
    }

    String getOrderName() {
        return JmolEdge.getBondOrderNameFromOrder(this.order);
    }

    String getOrderNumberAsString() {
        return JmolEdge.getBondOrderNumberFromOrder(this.order);
    }

    short getColix1() {
        return Graphics3D.getColixInherited(this.colix, this.atom1.colixAtom);
    }

    short getColix2() {
        return Graphics3D.getColixInherited(this.colix, this.atom2.colixAtom);
    }

    public Atom getOtherAtom(Atom atom) {
        return this.atom1 == atom ? this.atom2 : (this.atom2 == atom ? this.atom1 : null);
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean is(int n) {
        return (this.order & 0xFFFDFFFF) == n;
    }

    public JmolNode getOtherAtom(JmolNode jmolNode) {
        return this.atom1 == jmolNode ? this.atom2 : (this.atom2 == jmolNode ? this.atom1 : null);
    }

    public String toString() {
        return this.atom1 + " - " + this.atom2;
    }

    public static class BondSet
    extends BitSet {
        private int[] associatedAtoms;

        public BondSet() {
        }

        public int[] getAssociatedAtoms() {
            return this.associatedAtoms;
        }

        public BondSet(BitSet bitSet) {
            BitSetUtil.copy(bitSet, this);
        }

        public BondSet(BitSet bitSet, int[] nArray) {
            this(bitSet);
            this.associatedAtoms = nArray;
        }
    }
}

