/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Calculations {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double KCAL_TO_KJ = 4.1868;
    static final int CALC_DISTANCE = 0;
    static final int CALC_ANGLE = 1;
    static final int CALC_TORSION = 2;
    static final int CALC_OOP = 3;
    static final int CALC_VDW = 4;
    static final int CALC_ES = 5;
    static final int CALC_MAX = 6;
    ForceField ff;
    List<Object[]>[] calculations = ArrayUtil.createArrayOfArrayList(6);
    public Map<String, FFParam> ffParams;
    int atomCount;
    int bondCount;
    MinAtom[] atoms;
    MinBond[] bonds;
    int[][] angles;
    int[][] torsions;
    double[] partialCharges;
    boolean havePartialCharges;
    List<Object[]> constraints;
    boolean isPreliminary;
    boolean gradients;
    boolean silent;
    StringBuffer logData = new StringBuffer();
    boolean logging;
    boolean loggingEnabled;
    final Vector3d da = new Vector3d();
    final Vector3d db = new Vector3d();
    final Vector3d dc = new Vector3d();
    final Vector3d dd = new Vector3d();
    int ia;
    int ib;
    int ic;
    int id;
    final Vector3d v1 = new Vector3d();
    final Vector3d v2 = new Vector3d();
    final Vector3d v3 = new Vector3d();
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    public void setConstraints(List<Object[]> list) {
        this.constraints = list;
    }

    Calculations(ForceField forceField, MinAtom[] minAtomArray, MinBond[] minBondArray, int[][] nArray, int[][] nArray2, double[] dArray, List<Object[]> list) {
        this.ff = forceField;
        this.atoms = minAtomArray;
        this.bonds = minBondArray;
        this.angles = nArray;
        this.torsions = nArray2;
        this.constraints = list;
        this.atomCount = this.atoms.length;
        this.bondCount = this.bonds.length;
        if (dArray != null && dArray.length == this.atomCount) {
            int n = this.atomCount;
            while (--n >= 0) {
                if (dArray[n] == 0.0) continue;
                this.havePartialCharges = true;
                break;
            }
        }
        if (!this.havePartialCharges) {
            dArray = null;
        }
        this.partialCharges = dArray;
    }

    boolean haveParams() {
        return this.ffParams != null;
    }

    void setParams(Map<String, FFParam> map) {
        this.ffParams = map;
    }

    static FFParam getParameter(String string, Map<String, FFParam> map) {
        return map.get(string);
    }

    abstract boolean setupCalculations();

    abstract String getAtomList(String var1);

    abstract boolean setupElectrostatics();

    abstract String getDebugHeader(int var1);

    abstract String getDebugFooter(int var1, double var2);

    abstract String getUnit();

    abstract double compute(int var1, Object[] var2);

    void addForce(Vector3d vector3d, int n, double d) {
        this.atoms[n].force[0] = this.atoms[n].force[0] + vector3d.x * d;
        this.atoms[n].force[1] = this.atoms[n].force[1] + vector3d.y * d;
        this.atoms[n].force[2] = this.atoms[n].force[2] + vector3d.z * d;
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public String getLogData() {
        return this.logData.toString();
    }

    void appendLogData(String string) {
        this.logData.append(string).append("\n");
    }

    void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
        if (this.loggingEnabled) {
            this.logData = new StringBuffer();
        }
    }

    void setPreliminary(boolean bl) {
        this.isPreliminary = bl;
    }

    private double calc(int n, boolean bl) {
        int n2;
        this.logging = this.loggingEnabled && !this.silent;
        this.gradients = bl;
        List<Object[]> list = this.calculations[n];
        double d = 0.0;
        if (list == null || (n2 = list.size()) == 0) {
            return 0.0;
        }
        if (this.logging) {
            this.appendLogData(this.getDebugHeader(n));
        }
        for (int i = 0; i < n2; ++i) {
            d += this.compute(n, this.calculations[n].get(i));
        }
        if (this.logging) {
            this.appendLogData(this.getDebugFooter(n, d));
        }
        if (this.constraints != null && n <= 2) {
            d += this.constraintEnergy(n);
        }
        return d;
    }

    double energyStrBnd(boolean bl) {
        return 0.0;
    }

    double energyBond(boolean bl) {
        return this.calc(0, bl);
    }

    double energyAngle(boolean bl) {
        return this.calc(1, bl);
    }

    double energyTorsion(boolean bl) {
        return this.calc(2, bl);
    }

    double energyOOP(boolean bl) {
        return this.calc(3, bl);
    }

    double energyVDW(boolean bl) {
        return this.calc(4, bl);
    }

    double energyES(boolean bl) {
        return this.calc(5, bl);
    }

    private double constraintEnergy(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.constraints.size();
        while (--n2 >= 0) {
            Object[] objectArray = this.constraints.get(n2);
            int n3 = ((int[])objectArray[0])[0];
            if (n3 != n + 2) continue;
            int[] nArray = (int[])objectArray[1];
            double d4 = ((Float)objectArray[2]).doubleValue();
            switch (n) {
                case 2: {
                    this.id = nArray[3];
                    if (this.gradients) {
                        this.dd.set(this.atoms[this.id].coord);
                    }
                }
                case 1: {
                    this.ic = nArray[2];
                    if (this.gradients) {
                        this.dc.set(this.atoms[this.ic].coord);
                    }
                }
                case 0: {
                    this.ib = nArray[1];
                    this.ia = nArray[0];
                    if (!this.gradients) break;
                    this.db.set(this.atoms[this.ib].coord);
                    this.da.set(this.atoms[this.ia].coord);
                }
            }
            d2 = 10000.0;
            switch (n) {
                case 2: {
                    d4 *= Math.PI / 180;
                    double d5 = d = this.gradients ? Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd) : Util.getTorsionAngleRadians(this.atoms[this.ia].coord, this.atoms[this.ib].coord, this.atoms[this.ic].coord, this.atoms[this.id].coord, this.v1, this.v2, this.v3);
                    if (d < 0.0 && d4 >= 1.5707963267948966) {
                        d += Math.PI * 2;
                        break;
                    }
                    if (!(d > 0.0) || !(d4 <= -1.5707963267948966)) break;
                    d4 += Math.PI * 2;
                    break;
                }
                case 1: {
                    d4 *= Math.PI / 180;
                    d = this.gradients ? Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc) : Util.getAngleRadiansABC(this.atoms[this.ia].coord, this.atoms[this.ib].coord, this.atoms[this.ic].coord);
                    break;
                }
                case 0: {
                    d = this.gradients ? Util.restorativeForceAndDistance(this.da, this.db, this.dc) : Math.sqrt(Util.distance2(this.atoms[this.ia].coord, this.atoms[this.ib].coord));
                }
            }
            d3 += this.constrainQuadratic(d, d4, d2, n);
        }
        return d3;
    }

    private double constrainQuadratic(double d, double d2, double d3, int n) {
        if (!Util.isFinite(d)) {
            return 0.0;
        }
        double d4 = d - d2;
        if (this.gradients) {
            double d5 = 2.0 * d3 * d4;
            switch (n) {
                case 2: {
                    this.addForce(this.dd, this.id, d5);
                }
                case 1: {
                    this.addForce(this.dc, this.ic, d5);
                }
                case 0: {
                    this.addForce(this.db, this.ib, d5);
                    this.addForce(this.da, this.ia, d5);
                }
            }
        }
        return d3 * d4 * d4;
    }
}

