/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.engine.client.Executable;
import compbio.runner.conservation.AACon;
import compbio.runner.disorder.Disembl;
import compbio.runner.disorder.GlobPlot;
import compbio.runner.disorder.IUPred;
import compbio.runner.disorder.Jronn;
import compbio.runner.msa.ClustalO;
import compbio.runner.msa.ClustalW;
import compbio.runner.msa.GLprobs;
import compbio.runner.msa.MSAprobs;
import compbio.runner.msa.Mafft;
import compbio.runner.msa.Muscle;
import compbio.runner.msa.Probcons;
import compbio.runner.msa.Tcoffee;
import compbio.runner.predictors.Jpred;
import compbio.runner.structure.RNAalifold;
import compbio.ws.client.Services;
import java.io.File;

public class ServicesUtil {
    public static Services getServiceByRunner(Class<? extends Executable> clazz) {
        assert (clazz != null);
        String string = clazz.getSimpleName().toLowerCase();
        for (Services services : Services.values()) {
            if (!services.toString().toLowerCase().contains(string)) continue;
            return services;
        }
        return null;
    }

    private static Class<? extends Executable<?>> getServiceImpl(Services services) {
        switch (services) {
            case AAConWS: {
                return AACon.class;
            }
            case JpredWS: {
                return Jpred.class;
            }
            case ClustalOWS: {
                return ClustalO.class;
            }
            case ClustalWS: {
                return ClustalW.class;
            }
            case MafftWS: {
                return Mafft.class;
            }
            case MuscleWS: {
                return Muscle.class;
            }
            case TcoffeeWS: {
                return Tcoffee.class;
            }
            case ProbconsWS: {
                return Probcons.class;
            }
            case MSAprobsWS: {
                return MSAprobs.class;
            }
            case GLprobsWS: {
                return GLprobs.class;
            }
            case DisemblWS: {
                return Disembl.class;
            }
            case GlobPlotWS: {
                return GlobPlot.class;
            }
            case JronnWS: {
                return Jronn.class;
            }
            case IUPredWS: {
                return IUPred.class;
            }
            case RNAalifoldWS: {
                return RNAalifold.class;
            }
        }
        throw new RuntimeException("Unknown web service implementation class for service: " + (Object)((Object)services));
    }

    public static Class<? extends Executable<?>> getRunnerByJobDirectory(File file) {
        Services services = ServicesUtil.getServiceByRunnerName(ServicesUtil.getRunnerNameByJobDirectory(file));
        return ServicesUtil.getServiceImpl(services);
    }

    private static String getRunnerNameByJobDirectory(File file) {
        String string = file.getName().split("#")[0];
        if (string.startsWith("@")) {
            assert ("@".length() == 1);
            string = string.substring(1);
        }
        return string;
    }

    public static Services getServiceByJobDirectory(File file) {
        return ServicesUtil.getServiceByRunnerName(ServicesUtil.getRunnerNameByJobDirectory(file));
    }

    private static Services getServiceByRunnerName(String string) {
        for (Services services : Services.values()) {
            String string2 = ServicesUtil.getServiceImpl(services).getSimpleName().toLowerCase();
            if (!(string = string.trim().toLowerCase()).startsWith(string2)) continue;
            return services;
        }
        return null;
    }
}

