/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.ValueConstrain;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Parameter<T>
extends Option<T> {
    @XmlElement
    Set<String> possibleValues = new HashSet<String>();
    ValueConstrain validValue;

    private Parameter() {
    }

    public Parameter(String string, String string2) {
        super(string, string2);
    }

    public ValueConstrain getValidValue() {
        return this.validValue;
    }

    public void setValidValue(ValueConstrain valueConstrain) {
        if (valueConstrain == null) {
            throw new NullPointerException("ValueConstrain is expected!");
        }
        this.validValue = valueConstrain;
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (this.validValue != null) {
            string = string + this.validValue.toString();
        }
        if (!this.possibleValues.isEmpty()) {
            TreeSet<String> treeSet = new TreeSet<String>(this.possibleValues);
            string = string + "POSSIBLE VALUES:" + SysPrefs.newlinechar;
            for (String string2 : treeSet) {
                string = string + string2 + SysPrefs.newlinechar;
            }
        }
        return string;
    }

    @Override
    public String toCommand(String string) {
        if (string == null) {
            throw new NullPointerException("Name value separator is expected!");
        }
        return this.getOptionName() + string + this.getValue();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        Parameter parameter = null;
        if (!(object instanceof Parameter)) {
            return false;
        }
        parameter = (Parameter)object;
        if (parameter.possibleValues.size() != this.possibleValues.size()) {
            return false;
        }
        int n = 0;
        block0: for (String string : parameter.possibleValues) {
            if (Util.isEmpty(string)) continue;
            for (String string2 : this.possibleValues) {
                if (!string.equals(string2)) continue;
                ++n;
                continue block0;
            }
        }
        return n == parameter.possibleValues.size();
    }

    @Override
    public List<String> getPossibleValues() {
        return new ArrayList<String>(this.possibleValues);
    }

    public void setPossibleValues(Set<String> set) {
        this.possibleValues = new HashSet<String>(set);
    }

    public Set<String> addPossibleValues(String ... stringArray) {
        for (String string : stringArray) {
            this.possibleValues.add(string);
        }
        return this.possibleValues;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.possibleValues != null) {
            n += ((Object)this.possibleValues).hashCode();
        }
        return n;
    }

    @Override
    public void setOptionNames(Set<String> set) {
        if (set.size() != 1) {
            throw new IllegalArgumentException("Parameter must have a single option name! But given " + set.size() + " names:  " + set);
        }
        super.setOptionNames(set);
    }

    @Override
    public Set<String> addOptionNames(String ... stringArray) {
        throw new UnsupportedOperationException("Parameter must have only one optionName! If you setting the only name that use setOptionName instead");
    }

    public String getOptionName() {
        assert (this.optionNames.size() == 1);
        return (String)this.optionNames.iterator().next();
    }

    public void setOptionName(String string) {
        assert (!Util.isEmpty(string));
        this.setOptionNames(Collections.singleton(string));
    }

    String getValue() {
        if (this.possibleValues.size() == 1) {
            return this.possibleValues.iterator().next();
        }
        return this.getDefaultValue();
    }

    @Override
    void validate() throws ValidationException {
        super.validate();
        if (this.validValue == null) {
            if (this.possibleValues.isEmpty()) {
                throw new ValidationException("No possible values defined for parameter: " + this);
            }
            if (this.possibleValues.size() > 1 && Util.isEmpty(this.getDefaultValue())) {
                throw new ValidationException("Multiple possible values are defined but no default value for parameter: " + this);
            }
        } else {
            if (Util.isEmpty(this.getDefaultValue())) {
                throw new ValidationException("Default value is not defined for numeric parameter! " + this);
            }
            this.validValue.checkValue(this.getDefaultValue());
        }
    }

    boolean isValidValue(String string) {
        assert (!Util.isEmpty(string));
        return Option.valueExist(string, this.getPossibleValues());
    }

    @Override
    public void setDefaultValue(String string) throws WrongParameterException {
        if (this.validValue == null) {
            if (this.getPossibleValues().isEmpty()) {
                throw new IllegalStateException("Attempting to set default value for parameter: " + this + " Without possible values! Please define possible value first!");
            }
            if (!this.isValidValue(string)) {
                throw new WrongParameterException("Attempting to set illegal value '" + string + "' for the parameter: " + this);
            }
        } else {
            try {
                this.validValue.checkValue(string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new WrongParameterException("Attempting to set default value outside boundaries defined by the constraint: " + this.validValue + "\n For parameter: " + this);
            }
        }
        this.defaultValue = string;
    }
}

