/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.DisemblResult;
import compbio.data.sequence.DisorderMethod;
import compbio.data.sequence.FastaReader;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.GlobProtResult;
import compbio.data.sequence.IUPredResult;
import compbio.data.sequence.Program;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SequenceUtil {
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s");
    public static final Pattern DIGIT = Pattern.compile("\\d");
    public static final Pattern NONWORD = Pattern.compile("\\W");
    public static final Pattern AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern NON_AA = Pattern.compile("[^ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern AMBIGUOUS_AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYVXU]+", 2);
    public static final Pattern NUCLEOTIDE = Pattern.compile("[AGTCU]+", 2);
    public static final Pattern AMBIGUOUS_NUCLEOTIDE = Pattern.compile("[AGTCRYMKSWHBVDNU]+", 2);
    public static final Pattern NON_NUCLEOTIDE = Pattern.compile("[^AGTCU]+", 2);
    private static final String JRONN_WRONG_FORMAT_MESSAGE = "Jronn file must be in the following format:\n>sequence_name\n M\tV\tS\n0.43\t0.22\t0.65\nWhere first line is the sequence name,\nsecond line is the tab delimited sequence,\nthird line contains tab delimited disorder prediction values.\nNo lines are allowed between these three. Additionally, the number of  sequence residues must be equal to the number of the disorder values.";

    private SequenceUtil() {
    }

    public static boolean isNucleotideSequence(FastaSequence fastaSequence) {
        return SequenceUtil.isNonAmbNucleotideSequence(fastaSequence.getSequence());
    }

    public static boolean isNonAmbNucleotideSequence(String string) {
        if (DIGIT.matcher(string = SequenceUtil.cleanSequence(string)).find()) {
            return false;
        }
        if (NON_NUCLEOTIDE.matcher(string).find()) {
            return false;
        }
        Matcher matcher = NUCLEOTIDE.matcher(string);
        return matcher.find();
    }

    public static String cleanSequence(String string) {
        assert (string != null);
        Matcher matcher = WHITE_SPACE.matcher(string);
        string = matcher.replaceAll("").toUpperCase();
        return string;
    }

    public static String deepCleanSequence(String string) {
        string = SequenceUtil.cleanSequence(string);
        string = DIGIT.matcher(string).replaceAll("");
        string = NONWORD.matcher(string).replaceAll("");
        Pattern pattern = Pattern.compile("[_-]+");
        string = pattern.matcher(string).replaceAll("");
        return string;
    }

    public static String cleanProteinSequence(String string) {
        return NON_AA.matcher(string).replaceAll("");
    }

    public static boolean isProteinSequence(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AA.matcher(string);
        return matcher.find();
    }

    public static boolean isAmbiguosProtein(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        if (AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AMBIGUOUS_AA.matcher(string);
        return matcher.find();
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list, int n) throws IOException {
        SequenceUtil.writeFastaKeepTheStream(outputStream, list, n);
        outputStream.close();
    }

    public static void writeFastaKeepTheStream(OutputStream outputStream, List<FastaSequence> list, int n) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(">" + fastaSequence.getId() + "\n");
            bufferedWriter.write(fastaSequence.getFormatedSequence(n));
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
        outputStreamWriter.flush();
    }

    public static List<FastaSequence> readFasta(InputStream inputStream) throws IOException {
        ArrayList<FastaSequence> arrayList = new ArrayList<FastaSequence>();
        FastaReader fastaReader = new FastaReader(inputStream);
        while (fastaReader.hasNext()) {
            arrayList.add(fastaReader.next());
        }
        inputStream.close();
        return arrayList;
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(fastaSequence.getOnelineFasta());
        }
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    public static final List<FastaSequence> readJpredFile(InputStream inputStream) throws IOException, FileNotFoundException, NullPointerException {
        return SequenceUtil.readFasta(inputStream);
    }

    public static Map<String, Score> readIUPred(File file) throws IOException, UnknownFileFormatException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Map<String, Score> map = SequenceUtil.readIUPred(fileInputStream, IUPredResult.getType(file));
        ((InputStream)fileInputStream).close();
        return map;
    }

    private static Map<String, Score> readIUPred(InputStream inputStream, IUPredResult iUPredResult) throws IOException, UnknownFileFormatException {
        Score score = null;
        HashMap<String, Score> hashMap = new HashMap<String, Score>();
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("#");
        while (scanner.hasNext()) {
            Object object;
            String string = scanner.next();
            Scanner scanner2 = new Scanner(string);
            String string2 = scanner2.nextLine().trim();
            if (IUPredResult.Glob == iUPredResult) {
                object = SequenceUtil.parseIUPredDomains(scanner2);
                score = new Score(iUPredResult, (TreeSet<Range>)object);
            } else {
                object = SequenceUtil.parseIUPredScores(scanner2);
                score = new Score(iUPredResult, (float[])object);
            }
            scanner2.close();
            hashMap.put(string2, score);
        }
        scanner.close();
        return hashMap;
    }

    private static TreeSet<Range> parseIUPredDomains(Scanner scanner) {
        String string = "Number of globular domains:";
        String string2 = "globular domain";
        TreeSet<Range> treeSet = new TreeSet<Range>();
        String string3 = scanner.nextLine().trim();
        assert (string3.startsWith(string));
        int n = Integer.parseInt(string3 = string3.substring(string.length()).trim());
        if (n == 0) {
            return treeSet;
        }
        for (int i = 0; i < n; ++i) {
            assert (scanner.hasNextLine());
            string3 = scanner.nextLine();
            assert (string3.trim().startsWith(string2));
            string3 = string3.substring(string3.indexOf(".") + 1).trim();
            Range range = new Range(string3.split("-"));
            treeSet.add(range);
        }
        return treeSet;
    }

    private static float[] parseIUPredScores(Scanner scanner) throws UnknownFileFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine().trim();
            String[] stringArray = string.split("\\s+");
            arrayList.add(stringArray[2]);
        }
        return SequenceUtil.convertToNumber(arrayList.toArray(new String[arrayList.size()]));
    }

    public static Map<String, Score> readJRonn(File file) throws IOException, UnknownFileFormatException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Map<String, Score> map = SequenceUtil.readJRonn(fileInputStream);
        ((InputStream)fileInputStream).close();
        return map;
    }

    public static Map<String, Score> readJRonn(InputStream inputStream) throws IOException, UnknownFileFormatException {
        String string;
        HashMap<String, Score> hashMap = new HashMap<String, Score>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"), 16000);
        String string2 = "";
        do {
            if ((string = bufferedReader.readLine()) == null || string.isEmpty() || !string.startsWith(">")) continue;
            string2 = string.trim().substring(1);
            string = bufferedReader.readLine();
            String string3 = string.replace("\t", "");
            string = bufferedReader.readLine();
            String[] stringArray = string.split("\t");
            float[] fArray = SequenceUtil.convertToNumber(stringArray);
            if (fArray.length != string3.length()) {
                throw new UnknownFileFormatException("File does not look like Jronn horizontally formatted output file!\nJronn file must be in the following format:\n>sequence_name\n M\tV\tS\n0.43\t0.22\t0.65\nWhere first line is the sequence name,\nsecond line is the tab delimited sequence,\nthird line contains tab delimited disorder prediction values.\nNo lines are allowed between these three. Additionally, the number of  sequence residues must be equal to the number of the disorder values.");
            }
            hashMap.put(string2, new Score(DisorderMethod.JRonn, fArray));
        } while (string != null);
        bufferedReader.close();
        return hashMap;
    }

    private static float[] convertToNumber(String[] stringArray) throws UnknownFileFormatException {
        float[] fArray = new float[stringArray.length];
        try {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownFileFormatException(JRONN_WRONG_FORMAT_MESSAGE, numberFormatException.getCause());
        }
        return fArray;
    }

    public static final void closeSilently(Logger logger, Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
    }

    public static HashMap<String, Set<Score>> readDisembl(InputStream inputStream) throws IOException, UnknownFileFormatException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter(">");
        if (!scanner.hasNext()) {
            throw new UnknownFileFormatException("In Disembl score format each sequence score is expected to start from the line: >Sequence name  No such line was found!");
        }
        HashMap<String, Set<Score>> hashMap = new HashMap<String, Set<Score>>();
        int n = 0;
        while (scanner.hasNext()) {
            ++n;
            String string = scanner.next();
            Scanner scanner2 = new Scanner(string);
            if (!scanner2.hasNextLine()) {
                throw new RuntimeException("The input looks like an incomplete disembl file - cannot parse!");
            }
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            ArrayList<Float> arrayList3 = new ArrayList<Float>();
            String string2 = scanner2.nextLine().trim();
            TreeSet<Range> treeSet = SequenceUtil.parseRanges(DisemblResult.COILS, scanner2.nextLine());
            TreeSet<Range> treeSet2 = SequenceUtil.parseRanges(DisemblResult.REM465, scanner2.nextLine());
            TreeSet<Range> treeSet3 = SequenceUtil.parseRanges(DisemblResult.HOTLOOPS, scanner2.nextLine());
            String string3 = scanner2.nextLine();
            assert (string3.startsWith("# RESIDUE COILS REM465 HOTLOOPS")) : ">Sequence_name must follow column title: # RESIDUE COILS REM465 HOTLOOPS!";
            while (scanner2.hasNext()) {
                stringBuffer.append(scanner2.next());
                arrayList.add(Float.valueOf(scanner2.nextFloat()));
                arrayList2.add(Float.valueOf(scanner2.nextFloat()));
                arrayList3.add(Float.valueOf(scanner2.nextFloat()));
            }
            HashSet<Score> hashSet = new HashSet<Score>();
            hashSet.add(new Score(DisemblResult.COILS, arrayList, treeSet));
            hashSet.add(new Score(DisemblResult.REM465, arrayList2, treeSet2));
            hashSet.add(new Score(DisemblResult.HOTLOOPS, arrayList3, treeSet3));
            hashMap.put(string2, hashSet);
            scanner2.close();
        }
        scanner.close();
        inputStream.close();
        return hashMap;
    }

    private static TreeSet<Range> parseRanges(Enum enum_, String string) {
        TreeSet<Range> treeSet = new TreeSet<Range>();
        Scanner scanner = new Scanner(string);
        assert (scanner.hasNext());
        String string2 = scanner.next();
        assert ("#".equals(string2));
        String string3 = scanner.next();
        assert (enum_.toString().equalsIgnoreCase(string3)) : "Unknown result type: " + enum_.toString();
        scanner.useDelimiter(",");
        while (scanner.hasNext()) {
            String string4 = scanner.next();
            if (Util.isEmpty(string4)) continue;
            treeSet.add(new Range(string4.split("-")));
        }
        return treeSet;
    }

    public static HashMap<String, Set<Score>> readGlobPlot(InputStream inputStream) throws IOException, UnknownFileFormatException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter(">");
        if (!scanner.hasNext()) {
            throw new UnknownFileFormatException("In GlobPlot score format each sequence score is expected to start from the line: >Sequence name  No such line was found!");
        }
        HashMap<String, Set<Score>> hashMap = new HashMap<String, Set<Score>>();
        int n = 0;
        while (scanner.hasNext()) {
            ++n;
            String string = scanner.next();
            Scanner scanner2 = new Scanner(string);
            if (!scanner2.hasNextLine()) {
                throw new RuntimeException("The input looks like an incomplete GlobPlot file - cannot parse!");
            }
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            ArrayList<Float> arrayList3 = new ArrayList<Float>();
            String string2 = scanner2.nextLine().trim();
            TreeSet<Range> treeSet = SequenceUtil.parseRanges(GlobProtResult.GlobDoms, scanner2.nextLine());
            TreeSet<Range> treeSet2 = SequenceUtil.parseRanges(GlobProtResult.Disorder, scanner2.nextLine());
            String string3 = scanner2.nextLine();
            assert (string3.startsWith("# RESIDUE\tDYDX")) : ">Sequence_name must follow column title: # RESIDUE DYDX RAW SMOOTHED!";
            while (scanner2.hasNext()) {
                stringBuffer.append(scanner2.next());
                arrayList.add(Float.valueOf(scanner2.nextFloat()));
                arrayList2.add(Float.valueOf(scanner2.nextFloat()));
                arrayList3.add(Float.valueOf(scanner2.nextFloat()));
            }
            TreeSet<Score> treeSet3 = new TreeSet<Score>();
            treeSet3.add(new Score(GlobProtResult.Disorder, treeSet2));
            treeSet3.add(new Score(GlobProtResult.GlobDoms, treeSet));
            treeSet3.add(new Score(GlobProtResult.Dydx, arrayList));
            treeSet3.add(new Score(GlobProtResult.RawScore, arrayList2));
            treeSet3.add(new Score(GlobProtResult.SmoothedScore, arrayList3));
            hashMap.put(string2, treeSet3);
            scanner2.close();
        }
        scanner.close();
        inputStream.close();
        return hashMap;
    }

    public static HashSet<Score> readAAConResults(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream with results must be provided");
        }
        HashSet<Score> hashSet = new HashSet<Score>();
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("#");
        while (scanner.hasNext()) {
            String string = scanner.next();
            int n = string.indexOf(" ");
            assert (n > 0) : "Space is expected as delimited between method name and values!";
            String string2 = string.substring(0, n);
            ConservationMethod conservationMethod = ConservationMethod.getMethod(string2);
            assert (conservationMethod != null) : "Method " + string2 + " is not recognized! ";
            Scanner scanner2 = new Scanner(string.substring(n));
            ArrayList<Float> arrayList = new ArrayList<Float>();
            while (scanner2.hasNextDouble()) {
                Double d = scanner2.nextDouble();
                arrayList.add(Float.valueOf(d.floatValue()));
            }
            hashSet.add(new Score(conservationMethod, arrayList));
        }
        return hashSet;
    }

    public static List<FastaSequence> openInputStream(String string) throws IOException, UnknownFileFormatException {
        FileInputStream fileInputStream = new FileInputStream(string);
        FileInputStream fileInputStream2 = new FileInputStream(string);
        List<FastaSequence> list = null;
        if (ClustalAlignmentUtil.isValidClustalFile(fileInputStream)) {
            Alignment alignment = ClustalAlignmentUtil.readClustalFile(fileInputStream2);
            list = alignment.getSequences();
        } else {
            list = SequenceUtil.readFasta(fileInputStream2);
        }
        return list;
    }

    public static void writeClustal(OutputStream outputStream, List<FastaSequence> list, char c) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        AlignmentMetadata alignmentMetadata = new AlignmentMetadata(Program.CLUSTAL, c);
        ClustalAlignmentUtil.writeClustalAlignment(bufferedWriter, new Alignment(list, alignmentMetadata));
    }
}

