/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class JpredAlignment
extends Alignment {
    private JpredAlignment() {
    }

    public JpredAlignment(List<FastaSequence> list, Program program, char c) {
        this.sequences = list;
        this.metadata = new AlignmentMetadata(Program.Jpred, c);
    }

    public JpredAlignment(List<FastaSequence> list, AlignmentMetadata alignmentMetadata) {
        this.sequences = list;
        this.metadata = alignmentMetadata;
    }

    private List<FastaSequence> getRealSeqs() {
        ArrayList<FastaSequence> arrayList = new ArrayList<FastaSequence>();
        for (FastaSequence fastaSequence : this.sequences) {
            if (fastaSequence.getId().equals("jnetpred") || fastaSequence.getId().equals("JNETCONF") || fastaSequence.getId().equals("JNETSOL25") || fastaSequence.getId().equals("JNETSOL5") || fastaSequence.getId().equals("JNETSOL0") || fastaSequence.getId().equals("JNETHMM") || fastaSequence.getId().equals("JNETHMM") || fastaSequence.getId().equals("JNETSOL0") || fastaSequence.getId().equals("JNETHMM")) continue;
            arrayList.add(fastaSequence);
        }
        return arrayList;
    }

    public List<FastaSequence> getJpredSequences() {
        ArrayList<FastaSequence> arrayList = new ArrayList<FastaSequence>();
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("jnetpred") && !fastaSequence.getId().equals("JNETCONF") && !fastaSequence.getId().equals("JNETSOL25") && !fastaSequence.getId().equals("JNETSOL5") && !fastaSequence.getId().equals("JNETSOL0") && !fastaSequence.getId().equals("JNETHMM") && !fastaSequence.getId().equals("JNETHMM") && !fastaSequence.getId().equals("JNETSOL0") && !fastaSequence.getId().equals("JNETSOL0") && !fastaSequence.getId().equals("QUERY")) continue;
            arrayList.add(fastaSequence);
        }
        return arrayList;
    }

    public String getJpredPrediction() {
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("jnetpred")) continue;
            return fastaSequence.getSequence();
        }
        return new String("");
    }

    public String getJpredSOL25() {
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("JNETSOL25")) continue;
            return fastaSequence.getSequence();
        }
        return new String("");
    }

    public String getJpredSOL5() {
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("JNETSOL5")) continue;
            return fastaSequence.getSequence();
        }
        return new String("");
    }

    public String getJpredSOL0() {
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("JNETSOL0")) continue;
            return fastaSequence.getSequence();
        }
        return new String("");
    }

    public String getJpredJNETCONF() {
        for (FastaSequence fastaSequence : this.sequences) {
            if (!fastaSequence.getId().equals("JNETCONF")) continue;
            return fastaSequence.getSequence();
        }
        return new String("");
    }

    @Override
    public List<FastaSequence> getSequences() {
        return this.getRealSeqs();
    }

    @Override
    public int getSize() {
        return this.getRealSeqs().size();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof JpredAlignment)) {
            return false;
        }
        JpredAlignment jpredAlignment = (JpredAlignment)object;
        if (this.getSize() != jpredAlignment.getSize()) {
            return false;
        }
        if (!this.getMetadata().equals(jpredAlignment.getMetadata())) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (FastaSequence fastaSequence : this.getSequences()) {
            ++n;
            for (FastaSequence fastaSequence2 : jpredAlignment.getSequences()) {
                if (!fastaSequence.equals(fastaSequence2)) continue;
                ++n2;
            }
            if (n == n2) continue;
            return false;
        }
        return true;
    }
}

