/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import java.net.URL;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;

public final class Services
extends Enum<Services> {
    public static final /* enum */ Services MafftWS = new Services();
    public static final /* enum */ Services MuscleWS = new Services();
    public static final /* enum */ Services ClustalWS = new Services();
    public static final /* enum */ Services ClustalOWS = new Services();
    public static final /* enum */ Services TcoffeeWS = new Services();
    public static final /* enum */ Services ProbconsWS = new Services();
    public static final /* enum */ Services AAConWS = new Services();
    public static final /* enum */ Services JronnWS = new Services();
    public static final /* enum */ Services DisemblWS = new Services();
    public static final /* enum */ Services GlobPlotWS = new Services();
    public static final /* enum */ Services IUPredWS = new Services();
    public static final String AACON_INFO;
    public static final String CLUSTAL_INFO;
    public static final String CLUSTAL_OMEGA_INFO;
    public static final String DISEMBL_INFO;
    public static final String GLOBPLOT_INFO;
    public static final String IUPRED_INFO;
    public static final String TCOFFEE_INFO;
    public static final String MUSCLE_INFO;
    public static final String PROBCONS_INFO;
    public static final String JRONN_INFO;
    public static final String MAFFT_INFO;
    private static final /* synthetic */ Services[] $VALUES;

    public static Services[] values() {
        return (Services[])$VALUES.clone();
    }

    public static Services valueOf(String string) {
        return Enum.valueOf(Services.class, string);
    }

    public static Services getService(String string) {
        string = string.trim().toLowerCase();
        for (Services services : Services.values()) {
            if (!services.toString().equalsIgnoreCase(string)) continue;
            return services;
        }
        return null;
    }

    Service getService(URL uRL, String string) {
        QName qName = new QName(string, this.toString());
        return Service.create((URL)uRL, (QName)qName);
    }

    public static String toString(Set<Services> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        String string = "";
        String string2 = ", ";
        for (Services services : set) {
            string = string + services.toString() + string2;
        }
        string = string.substring(0, string.length() - string2.length());
        return string;
    }

    Class<? extends JABAService> getServiceType() {
        switch (this) {
            case AAConWS: 
            case JronnWS: 
            case DisemblWS: 
            case GlobPlotWS: 
            case IUPredWS: {
                return SequenceAnnotation.class;
            }
            case ClustalWS: 
            case ClustalOWS: 
            case MafftWS: 
            case MuscleWS: 
            case ProbconsWS: 
            case TcoffeeWS: {
                return MsaWS.class;
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happened!");
    }

    JABAService getInterface(Service service) {
        assert (service != null);
        QName qName = new QName(service.getServiceName().getNamespaceURI(), this.toString() + "Port");
        return (JABAService)service.getPort(qName, this.getServiceType());
    }

    public String getServiceInfo() {
        switch (this) {
            case AAConWS: {
                return AACON_INFO;
            }
            case ClustalOWS: {
                return CLUSTAL_OMEGA_INFO;
            }
            case ClustalWS: {
                return CLUSTAL_INFO;
            }
            case DisemblWS: {
                return DISEMBL_INFO;
            }
            case GlobPlotWS: {
                return GLOBPLOT_INFO;
            }
            case IUPredWS: {
                return IUPRED_INFO;
            }
            case JronnWS: {
                return JRONN_INFO;
            }
            case MafftWS: {
                return MAFFT_INFO;
            }
            case MuscleWS: {
                return MUSCLE_INFO;
            }
            case ProbconsWS: {
                return PROBCONS_INFO;
            }
            case TcoffeeWS: {
                return TCOFFEE_INFO;
            }
        }
        throw new RuntimeException("Unrecognised Web Service Type " + (Object)((Object)this) + " - Should never happened!");
    }

    public static void main(String[] stringArray) {
        System.out.println(MUSCLE_INFO);
    }

    static {
        $VALUES = new Services[]{MafftWS, MuscleWS, ClustalWS, ClustalOWS, TcoffeeWS, ProbconsWS, AAConWS, JronnWS, DisemblWS, GlobPlotWS, IUPredWS};
        AACON_INFO = new ServiceInfo(AAConWS, "in preparation", "1.0", "http://www.compbio.dundee.ac.uk/aacon").toString();
        CLUSTAL_INFO = new ServiceInfo(ClustalWS, "Larkin MA, Blackshields G, Brown NP, Chenna R, McGettigan PA, McWilliam H, Valentin F, Wallace IM, Wilm A, Lopez R, Thompson JD, Gibson TJ, Higgins DG.\r\n(2007). Clustal W and Clustal X version 2.0. Bioinformatics, 23, 2947-2948. ", "2.0.12", "http://www.clustal.org/clustal2/").toString();
        CLUSTAL_OMEGA_INFO = new ServiceInfo(ClustalOWS, "Fast, scalable generation of high quality protein multiple sequence alignments using Clustal Omega\r\nFabian Sievers, Andreas Wilm, David Dineen, Toby J. Gibson, Kevin Karplus, Weizhong Li, Rodrigo Lopez, Hamish McWilliam, Michael Remmert, Johannes S\u00f6ding, Julie D. Thompson, Desmond G. Higgins", "1.0.2", "http://www.clustal.org/omega").toString();
        DISEMBL_INFO = new ServiceInfo(DisemblWS, "R. Linding, L.J. Jensen, F. Diella, P. Bork, T.J. Gibson and R.B. Russell\r\nProtein disorder prediction: implications for structural proteomics\r\nStructure Vol 11, Issue 11, 4 November 2003", "1.5", "http://dis.embl.de/").toString();
        GLOBPLOT_INFO = new ServiceInfo(GlobPlotWS, "Rune Linding, Robert B. Russell, Victor Neduva and Toby J. Gibson 'GlobPlot: exploring protein sequences for globularity and disorder.' Nucl. Acids Res. (2003) 31 (13): 3701-3708. doi: 10.1093/nar/gkg519\r\n", "2.3", "http://globplot.embl.de/").toString();
        IUPRED_INFO = new ServiceInfo(IUPredWS, "The Pairwise Energy Content Estimated from Amino Acid Composition Discriminates between Folded and Intrinsically Unstructured Proteins\r\nZsuzsanna Doszt\u00e1nyi, Veronika Csizm\u00f3k, P\u00e9ter Tompa and Istv\u00e1n Simon\r\nJ. Mol. Biol. (2005) 347, 827-839.", "1.0", "http://iupred.enzim.hu/").toString();
        TCOFFEE_INFO = new ServiceInfo(TcoffeeWS, "T-Coffee: A novel method for multiple sequence alignments  Notredame, Higgins, Heringa, JMB, 302 (205-217) 2000", "8.99", "http://tcoffee.crg.cat/apps/tcoffee/index.html").toString();
        MUSCLE_INFO = new ServiceInfo(MuscleWS, "Edgar, R.C. (2004) MUSCLE: multiple sequence alignment with high accuracy and high throughput.Nucleic Acids Res. 32(5):1792-1797.\r\ndoi:10.1093/nar/gkh340", "3.8.31", "http://www.drive5.com/muscle/").toString();
        PROBCONS_INFO = new ServiceInfo(ProbconsWS, "Do, C.B., Mahabhashyam, M.S.P., Brudno, M., and Batzoglou, S. 2005. PROBCONS: Probabilistic Consistency-based Multiple Sequence Alignment. Genome Research 15: 330-340. ", "1.12", "http://probcons.stanford.edu/").toString();
        JRONN_INFO = new ServiceInfo(JronnWS, "unpublished, original algorithm Yang,Z.R., Thomson,R., McMeil,P. and Esnouf,R.M. (2005) RONN: the bio-basis function neural network technique applied to the dectection of natively disordered regions in proteins Bioinformatics 21: 3369-3376\r\n", "1.0", "http://www.compbio.dundee.ac.uk/jabaws/").toString();
        MAFFT_INFO = new ServiceInfo(MafftWS, "Katoh, Toh 2010 (Bioinformatics 26:1899-1900)\r\nParallelization of the MAFFT multiple sequence alignment program. ", "6.8.57", "http://mafft.cbrc.jp/alignment/software/").toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ServiceInfo {
        Services service;
        String reference;
        String version;
        String moreinfo;
        static final String jabaws_version = "2.0";
        static final String line_delimiter = "\n";

        private ServiceInfo() {
        }

        private ServiceInfo(Services services, String string, String string2, String string3) {
            this.service = services;
            this.reference = string;
            this.version = string2;
            this.moreinfo = string3;
        }

        public String toString() {
            String string = "SERVICE: " + (Object)((Object)this.service) + " version " + this.version + line_delimiter;
            string = string + "JABAWS v. 2.0\n";
            string = string + "REFERENCES: " + this.reference + line_delimiter;
            string = string + "MORE INFORMATION: " + this.moreinfo + line_delimiter;
            return string;
        }
    }
}

