/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.msa.RegistryWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.util.FileUtil;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.client.Services;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class Jws2Client {
    private static final Logger log = Logger.getLogger(Jws2Client.class.getCanonicalName());

    public static boolean validURL(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    <T> Jws2Client(String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        boolean bl4;
        Services services;
        String string;
        boolean bl5;
        String string2 = CmdHelper.getHost(stringArray);
        if (string2 == null) {
            System.err.println("Host name is not provided!");
            Jws2Client.printUsage(1);
        }
        if (!Jws2Client.validURL(string2)) {
            System.err.println("Host name is not valid!");
            Jws2Client.printUsage(1);
        }
        if (bl5 = CmdHelper.listServices(stringArray)) {
            Jws2Client.listServices(string2);
            System.exit(0);
        }
        if ((string = CmdHelper.getServiceName(stringArray)) == null) {
            System.err.println("Service name is no provided!");
            Jws2Client.printUsage(1);
        }
        if ((services = Services.getService(string)) == null) {
            System.err.println("Service " + string + " is no recognized! Valid values are: " + Arrays.toString((Object[])Services.values()));
            Jws2Client.printUsage(1);
        }
        if (bl4 = CmdHelper.testService(stringArray)) {
            Jws2Client.testService(string2, services, new PrintWriter(System.out, true));
            System.exit(0);
        }
        File file = IOHelper.getFile(stringArray, "-i", true);
        File file2 = IOHelper.getFile(stringArray, "-o", false);
        File file3 = IOHelper.getFile(stringArray, "-f", true);
        String string3 = CmdHelper.getPresetName(stringArray);
        Metadata metadata = (Metadata)((Object)Jws2Client.connect(string2, services));
        Preset preset = null;
        if (string3 != null) {
            preset = MetadataHelper.getPreset(metadata, string3);
        }
        List list = null;
        if (file3 != null) {
            object = IOHelper.loadParameters(file3);
            list = MetadataHelper.processParameters(object, metadata.getRunnerOptions());
        }
        object = null;
        if (file != null) {
            Writer writer = null;
            writer = file2 != null ? IOHelper.getWriter(file2) : new PrintWriter(System.out, true);
            if (services.getServiceType() == SequenceAnnotation.class) {
                ScoreManager scoreManager = Jws2Client.analize(file, (SequenceAnnotation)metadata, preset, list);
                IOHelper.writeOut(writer, scoreManager);
            } else {
                object = Jws2Client.align(file, (MsaWS)metadata, preset, list);
                IOHelper.writeOut(writer, (Alignment)object);
            }
            writer.close();
        }
        if (bl3 = CmdHelper.listParameters(stringArray)) {
            System.out.println(MetadataHelper.getParametersList(metadata));
        }
        if (bl2 = CmdHelper.listPresets(stringArray)) {
            System.out.println(MetadataHelper.getPresetList(metadata));
        }
        if (bl = CmdHelper.listLimits(stringArray)) {
            System.out.println(MetadataHelper.getLimits(metadata));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)metadata)).close();
        log.fine("Disconnected successfully!");
    }

    public static void testService(String string, Services services, PrintWriter printWriter) throws ConnectException, WebServiceException {
        RegistryWS registryWS = Jws2Client.connectToRegistry(string);
        if (registryWS != null) {
            String string2 = registryWS.testService(services);
            printWriter.println("Service " + (Object)((Object)services) + " testing results: ");
            printWriter.println(string2);
            FileUtil.closeSilently((Closeable)((Object)registryWS));
        }
        printWriter.flush();
    }

    public static Set<Services> getServices(String string) throws WebServiceException, ConnectException {
        RegistryWS registryWS = Jws2Client.connectToRegistry(string);
        Set<Services> set = Collections.EMPTY_SET;
        if (registryWS != null) {
            set = registryWS.getSupportedServices();
            FileUtil.closeSilently((Closeable)((Object)registryWS));
        }
        return set;
    }

    private static void listServices(String string) throws WebServiceException, IOException {
        Set<Services> set = Jws2Client.getServices(string);
        if (!set.isEmpty()) {
            System.out.println("Supported services are: " + Services.toString(set));
        } else {
            System.out.println("Failed to connect to the registry! ");
        }
    }

    static <T> ScoreManager analize(List<FastaSequence> list, SequenceAnnotation<T> sequenceAnnotation, Preset<T> preset, List<Option<T>> list2) {
        ScoreManager scoreManager = null;
        try {
            String string = null;
            if (list2 != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list2 != null ? sequenceAnnotation.customAnalize(list, list2) : (preset != null ? sequenceAnnotation.presetAnalize(list, preset) : sequenceAnnotation.analize(list));
            System.out.println("\n\ncalling analise.........");
            Thread.sleep(1000L);
            scoreManager = sequenceAnnotation.getAnnotation(string);
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            System.err.println("Exception while waiting for results. Exception details are below:");
            interruptedException.printStackTrace();
        }
        catch (WrongParameterException wrongParameterException) {
            System.err.println("Exception while parsing the web method input parameters. Exception details are below:");
            wrongParameterException.printStackTrace();
        }
        return scoreManager;
    }

    static <T> ScoreManager analize(File file, SequenceAnnotation<T> sequenceAnnotation, Preset<T> preset, List<Option<T>> list) {
        List<FastaSequence> list2 = null;
        try {
            list2 = SequenceUtil.openInputStream(file.getAbsolutePath());
            assert (!list2.isEmpty()) : "Input is empty!";
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            System.err.println("Exception while attempting to read the input file Exception details are below:");
            System.out.println(unknownFileFormatException.getMessage());
            unknownFileFormatException.printStackTrace();
        }
        return Jws2Client.analize(list2, sequenceAnnotation, preset, list);
    }

    public static JABAService connect(String string, Services services) throws WebServiceException, ConnectException {
        Service service;
        URL uRL;
        block5: {
            uRL = null;
            log.log(Level.FINE, "Attempting to connect...");
            try {
                uRL = new URL(string + "/" + services.toString() + "?wsdl");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            service = null;
            try {
                service = services.getService(uRL, "http://msa.data.compbio/01/01/2010/");
            }
            catch (WebServiceException webServiceException) {
                System.out.println("Connecting to JABAWS version 2 service");
                if (!Jws2Client.isV2service(webServiceException)) break block5;
                service = services.getService(uRL, "http://msa.data.compbio/01/12/2010/");
            }
        }
        if (service == null) {
            throw new ConnectException("Could not connect to " + uRL + " the server is down?");
        }
        JABAService jABAService = services.getInterface(service);
        log.log(Level.INFO, "Connected successfully!");
        return jABAService;
    }

    static boolean isV2service(WebServiceException webServiceException) {
        String string = webServiceException.getMessage();
        int n = string.indexOf("not a valid service");
        return n > 0 && string.substring(n).contains("http://msa.data.compbio/01/12/2010/");
    }

    public static RegistryWS connectToRegistry(String string) throws WebServiceException, ConnectException {
        URL uRL = null;
        String string2 = "RegistryWS";
        log.log(Level.FINE, "Attempting to connect...");
        try {
            uRL = new URL(string + "/" + string2 + "?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        QName qName = new QName("http://msa.data.compbio/01/12/2010/", string2);
        Service service = Service.create(uRL, (QName)qName);
        if (service == null) {
            throw new ConnectException("Could not connect to " + uRL + " the server is down?");
        }
        QName qName2 = new QName(service.getServiceName().getNamespaceURI(), string2 + "Port");
        RegistryWS registryWS = (RegistryWS)service.getPort(qName2, RegistryWS.class);
        log.log(Level.INFO, "Connected to " + string2 + " successfully!");
        return registryWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Alignment align(File file, MsaWS<T> msaWS, Preset<T> preset, List<Option<T>> list) {
        FileInputStream fileInputStream = null;
        List<FastaSequence> list2 = null;
        Alignment alignment = null;
        try {
            fileInputStream = new FileInputStream(file);
            list2 = SequenceUtil.readFasta(fileInputStream);
            fileInputStream.close();
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? msaWS.customAlign(list2, list) : (preset != null ? msaWS.presetAlign(list2, preset) : msaWS.align(list2));
            System.out.println("\n\ncalling align.........");
            Thread.sleep(1000L);
            alignment = msaWS.getResult(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            wrongParameterException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return alignment;
    }

    static void printUsage(int n) {
        System.out.println("\r\nJABAWS2 client August 2011 http://www.compbio.dundee.ac.uk/jabaws \r\n \r\nUsage: <Class or Jar file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n-h=<host_context>  - a full URL to the JABAWS web server including context \r\n                     path e.g. http://10.31.1.159:8080/ws\r\n-s=<ServiceName>   - one of [MafftWS, MuscleWS, ClustalWS, ClustalOWS, TcoffeeWS, \r\n\t\t\t\t\t ProbconsWS, AAConWS, JronnWS, DisemblWS, GlobPlotWS, IUPredWS]\r\n                     <serviceName> is required for all ACTIONS but -list_services\r\n\r\nACTIONS: \r\n-list_services    - list available services\r\n-test             - test service \r\n-i=<inputFile>    - full path to fasta formatted sequence file, from which to align \r\n                    sequences\r\n-parameters       - lists parameters supported by web service\r\n-presets          - lists presets supported by web service\r\n-limits           - lists web services limits\r\n\r\nPlease note that if input file is specified other actions are ignored\r\n\r\nOPTIONS (only for use with -i action):\r\n-r=<presetName>   - name of the preset to use\r\n-o=<outputFile>   - full path to the file where to write an alignment\r\n-f=<PrmInputFile> - the name of the file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. Alignment is done with \r\neither preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n\r\n1) List all available services on the host \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -list_services\r\n\r\n2) Test Clustal web service \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\ninto the output.txt \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt, output results to \r\nthe console \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\nfrom input.txt and report  the scores to the console \r\n\r\nJws2Client -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\nWhere the content of prm.txt file is -m=LANDGRAF\r\nThe list of the supported parameters can be obtained as shown in the example 5. \r\n\r\nCitation: Peter V. Troshin, James B. Procter and Geoffrey J. Barton - \"Java \r\nBioinformatics Analysis Web Services for Multiple Sequence Alignment - \r\nJABAWS:MSA\" Bioinformatics 2011; doi: 10.1093/bioinformatics/btr304.\r\n");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            Jws2Client.printUsage(1);
        }
        if (stringArray.length < 2) {
            System.err.println("Host and service names are required!");
            Jws2Client.printUsage(1);
        }
        try {
            new Jws2Client(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

