/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.server.AAConWS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class AAConClient {
    private static final Logger log = Logger.getLogger(AAConClient.class.getCanonicalName());
    static final String QUALIFIED_SERVICE_NAME = "http://msa.data.compbio/01/12/2010/";
    static final String hostname = "http://www.compbio.dundee.ac.uk/aacon";
    static final String serviceName = "AAConWS";

    AAConClient(String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        File file = IOHelper.getFile(stringArray, "-i", true);
        File file2 = IOHelper.getFile(stringArray, "-o", false);
        File file3 = IOHelper.getFile(stringArray, "-f", true);
        String string = CmdHelper.getPresetName(stringArray);
        SequenceAnnotation<AAConWS> sequenceAnnotation = AAConClient.connect();
        Preset<AAConWS> preset = null;
        if (string != null) {
            preset = MetadataHelper.getPreset(sequenceAnnotation, string);
        }
        List<Option<AAConWS>> list = null;
        if (file3 != null) {
            object = IOHelper.loadParameters(file3);
            list = MetadataHelper.processParameters(object, sequenceAnnotation.getRunnerOptions());
        }
        object = null;
        if (file != null) {
            System.out.println("Calculating conservation...");
            object = AAConClient.analize(file, sequenceAnnotation, preset, list);
            Writer writer = null;
            writer = file2 != null ? IOHelper.getWriter(file2) : new PrintWriter(System.out, true);
            AAConClient.writeOut(writer, (ScoreManager)object);
        }
        if (bl3 = CmdHelper.listParameters(stringArray)) {
            System.out.println(MetadataHelper.getParametersList(sequenceAnnotation));
        }
        if (bl2 = CmdHelper.listPresets(stringArray)) {
            System.out.println(MetadataHelper.getPresetList(sequenceAnnotation));
        }
        if (bl = CmdHelper.listLimits(stringArray)) {
            System.out.println(MetadataHelper.getLimits(sequenceAnnotation));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)sequenceAnnotation)).close();
        log.fine("Disconnected successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(Writer writer, ScoreManager scoreManager) {
        try {
            scoreManager.writeOut(writer);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SequenceAnnotation<AAConWS> connect() throws WebServiceException {
        URL uRL = null;
        log.log(Level.FINE, "Attempting to connect...");
        try {
            uRL = new URL("http://www.compbio.dundee.ac.uk/aacon/AAConWS?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        QName qName = new QName(QUALIFIED_SERVICE_NAME, serviceName);
        Service service = Service.create((URL)uRL, (QName)qName);
        QName qName2 = new QName(QUALIFIED_SERVICE_NAME, "AAConWSPort");
        SequenceAnnotation sequenceAnnotation = (SequenceAnnotation)service.getPort(qName2, SequenceAnnotation.class);
        log.log(Level.FINE, "Connected successfully!");
        return sequenceAnnotation;
    }

    static ScoreManager analize(File file, SequenceAnnotation<AAConWS> sequenceAnnotation, Preset<AAConWS> preset, List<Option<AAConWS>> list) {
        List<FastaSequence> list2 = null;
        ScoreManager scoreManager = null;
        try {
            list2 = SequenceUtil.openInputStream(file.getAbsolutePath());
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? sequenceAnnotation.customAnalize(list2, list) : (preset != null ? sequenceAnnotation.presetAnalize(list2, preset) : sequenceAnnotation.analize(list2));
            Thread.sleep(1000L);
            scoreManager = sequenceAnnotation.getAnnotation(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            System.err.println("Exception while parsing the web method input parameters. Exception details are below:");
            wrongParameterException.printStackTrace();
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            System.err.println("Exception while attempting to read the input file Exception details are below:");
            System.out.println(unknownFileFormatException.getMessage());
            unknownFileFormatException.printStackTrace();
        }
        return scoreManager;
    }

    static void printUsage(int n) {
        System.out.println();
        System.out.println("Usage: <Class or Jar file name>  ACTION [OPTIONS] ");
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("-i=<inputFile> - full path to fasta or Clustal formatted alignment file ");
        System.out.println("-parameters - lists parameters supported by web service");
        System.out.println("-presets - lists presets supported by web service");
        System.out.println("-limits - lists web services limits");
        System.out.println("Please note that if input file is specified other actions are ignored");
        System.out.println();
        System.out.println("OPTIONS (only for use with -i action):");
        System.out.println("-r=<presetName> - name of the preset to use");
        System.out.println("-o=<outputFile> - full path to the file where to write the result");
        System.out.println("-f=<parameterInputFile> - the name of the file with the list of parameters to use.");
        System.out.println("Please note that -r and -f options cannot be used together. Conservation is calculated with either a preset or the parameters from the file, but not both!");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            AAConClient.printUsage(1);
        }
        if (stringArray.length < 1) {
            System.out.println("No options is specified! ");
            AAConClient.printUsage(1);
        }
        try {
            new AAConClient(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

