/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Preset<T> {
    @XmlTransient
    private static final String SPACE = " ";
    @XmlElement(required=true, nillable=false)
    String name;
    String description;
    @XmlElement(required=true, nillable=false)
    @XmlElementWrapper(name="optlist")
    List<String> option;

    public void setOptions(List<String> list) {
        this.option = list;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public List<String> getOptions() {
        return new ArrayList<String>(this.option);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Option<T>> getArguments(RunnerConfig<T> runnerConfig) throws WrongParameterException {
        ArrayList<Option<T>> arrayList = new ArrayList<Option<T>>();
        for (String string : this.option) {
            String string2 = this.getName(string = string.trim());
            Option<T> option = runnerConfig.getArgumentByOptionName(string2);
            if (option == null) continue;
            if (this.containValue(string)) {
                option.setDefaultValue(this.getValue(string));
            } else {
                option.setDefaultValue(string2);
            }
            arrayList.add(option);
        }
        return arrayList;
    }

    boolean containValue(String string) {
        return string.trim().contains(SPACE);
    }

    String getName(String string) {
        if (this.containValue(string = string.trim())) {
            return string.substring(0, string.indexOf(SPACE)).trim();
        }
        return string;
    }

    String getValue(String string) {
        assert (this.containValue(string));
        string = string.trim();
        return string.substring(string.indexOf(SPACE) + 1).trim();
    }

    public String toString() {
        String string = "Preset name: '" + this.name + "'" + SysPrefs.newlinechar;
        string = string + "Description: " + this.description + SysPrefs.newlinechar;
        string = string + "Options: " + SysPrefs.newlinechar;
        for (String string2 : this.option) {
            string = string + string2 + SysPrefs.newlinechar;
        }
        string = string + SysPrefs.newlinechar;
        return string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.option == null ? 0 : ((Object)this.option).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Preset preset = (Preset)object;
        if (this.description == null ? preset.description != null : !this.description.equals(preset.description)) {
            return false;
        }
        if (this.name == null ? preset.name != null : !this.name.equals(preset.name)) {
            return false;
        }
        return !(this.option == null ? preset.option != null : !((Object)this.option).equals(preset.option));
    }
}

