/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Limit;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.util.Util;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="limits")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LimitsManager<T> {
    String runnerClassName;
    List<Limit<T>> limit;

    public List<Limit<T>> getLimits() {
        return this.limit;
    }

    public String toString() {
        if (this.limit == null) {
            return "";
        }
        String string = "";
        for (Limit<T> limit : this.limit) {
            string = string + limit.toString();
        }
        return string;
    }

    public Limit<T> getLimitByName(String string) {
        if (this.limit == null) {
            return null;
        }
        if (Util.isEmpty(string)) {
            return this.getDefaultLimit();
        }
        for (Limit<T> limit : this.limit) {
            String string2 = limit.getPreset();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return limit;
        }
        return null;
    }

    public Limit<T> getDefaultLimit() {
        for (Limit<T> limit : this.limit) {
            if (!limit.isDefault) continue;
            return limit;
        }
        return null;
    }

    public void validate(PresetManager<T> presetManager) throws ValidationException {
        int n = 0;
        for (Limit<T> limit : this.limit) {
            if (!limit.isDefault) continue;
            ++n;
        }
        if (n == 0) {
            throw new ValidationException("Default limit is not set!");
        }
        if (n > 1) {
            throw new ValidationException("Default limit is set more than once!");
        }
        if (presetManager != null) {
            for (Limit<T> limit : this.limit) {
                Preset<T> preset;
                limit.validate();
                String string = limit.getPreset();
                if (string == null || string.equals("# LocalEngineExecutionLimit #") || (preset = presetManager.getPresetByName(string)) != null) continue;
                throw new ValidationException("Preset " + string + " is not found!");
            }
        }
    }
}

