/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChunkHolder {
    String chunk;
    long position;

    private ChunkHolder() {
    }

    public ChunkHolder(String string, long l) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("Position in a file could not be negative! Given value: " + l);
        }
        if (string == null) {
            throw new NullPointerException("Chunk must not be NULL!");
        }
        this.chunk = string;
        this.position = l;
    }

    public String getChunk() {
        return this.chunk;
    }

    public long getNextPosition() {
        return this.position;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        ChunkHolder chunkHolder = null;
        if (!(object instanceof ChunkHolder)) {
            chunkHolder = (ChunkHolder)object;
        }
        if (this.position != chunkHolder.position) {
            return false;
        }
        return this.chunk.equals(chunkHolder.chunk);
    }

    public String toString() {
        String string = "Position: " + this.position + "\n";
        string = string + "Chunk size: " + this.chunk.length() + "\n";
        string = string + "Chunk: " + this.chunk + "\n";
        return string;
    }

    public int hashCode() {
        return new Long(this.position + (long)this.chunk.hashCode()).intValue();
    }
}

