/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Range;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Score
implements Comparable<Score> {
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.UK);
    private final String method;
    private TreeSet<Range> ranges = new TreeSet();
    private ArrayList<Float> scores = new ArrayList(0);

    private Score() {
        this.method = "";
    }

    public Score(Enum<?> enum_, ArrayList<Float> arrayList) {
        this.method = enum_.toString();
        this.scores = new ArrayList<Float>(arrayList);
    }

    public Score(Enum<?> enum_, ArrayList<Float> arrayList, TreeSet<Range> treeSet) {
        this.method = enum_.toString();
        this.ranges = treeSet;
        this.scores = arrayList;
    }

    public Score(Enum<?> enum_, TreeSet<Range> treeSet) {
        this.method = enum_.toString();
        this.ranges = treeSet;
    }

    public Score(Enum<?> enum_, float[] fArray) {
        this.method = enum_.toString();
        this.scores = this.toList(fArray);
    }

    private ArrayList<Float> toList(float[] fArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (float f : fArray) {
            arrayList.add(new Float(f));
        }
        return arrayList;
    }

    public String getMethod() {
        return this.method;
    }

    public ArrayList<Float> getScores() {
        return this.scores;
    }

    public TreeSet<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(TreeSet<Range> treeSet) {
        this.ranges = treeSet;
    }

    public String toString() {
        return "Score [method=" + this.method + ", ranges=" + this.ranges + ", scores=" + this.scores + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 7 * n + (this.method == null ? 0 : this.method.hashCode());
        n = 7 * n + (this.ranges == null ? 0 : this.ranges.hashCode());
        n = 7 * n + (this.scores == null ? 0 : this.scores.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Score score = (Score)object;
        if (this.method == null ? score.method != null : !this.method.equals(score.method)) {
            return false;
        }
        if (this.ranges == null ? score.ranges != null : !this.ranges.equals(score.ranges)) {
            return false;
        }
        return !(this.scores == null ? score.scores != null : !this.scores.equals(score.scores));
    }

    public static void write(TreeSet<Score> treeSet, Writer writer) throws IOException {
        if (writer == null) {
            throw new NullPointerException("Writer must be provided!");
        }
        for (Score score : treeSet) {
            writer.write("#" + score.method + " ");
            int n = score.ranges.size();
            for (Range range : score.ranges) {
                writer.write(range.toString());
                if (--n == 0) continue;
                writer.write(", ");
            }
            for (Float f : score.scores) {
                writer.write(NUMBER_FORMAT.format(f) + " ");
            }
            writer.write("\n");
            writer.flush();
        }
        writer.flush();
    }

    @Override
    public int compareTo(Score score) {
        return this.method.compareTo(score.method);
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_FORMAT.setMaximumFractionDigits(3);
    }
}

