/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaSequence;
import compbio.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;

public class FastaReader
implements Iterator<FastaSequence> {
    private final Scanner input;

    public FastaReader(String string) throws FileNotFoundException {
        this.input = new Scanner(new File(string), "UTF8");
        this.input.useDelimiter("\\s*>");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (FastaReader.this.input != null) {
                    FastaReader.this.input.close();
                }
            }
        });
    }

    public FastaReader(InputStream inputStream) throws FileNotFoundException {
        this.input = new Scanner(inputStream);
        this.input.useDelimiter("\\s*>");
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public FastaSequence next() {
        return FastaReader.toFastaSequence(this.input.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.input.close();
    }

    private static FastaSequence toFastaSequence(String string) {
        assert (!Util.isEmpty(string)) : "Empty String where FASTA sequence is expected!";
        int n = string.indexOf("\n");
        if (n < 0) {
            throw new AssertionError((Object)("The FASTA sequence must contain the header information separated by the new line from the sequence. Given sequence does not appear to contain the header! Given data:\n " + string));
        }
        String string2 = string.substring(0, n);
        string2 = string2.replaceAll("\r", "");
        String string3 = string.substring(n);
        if (Util.isEmpty(string3)) {
            throw new AssertionError((Object)("Empty sequences are not allowed! Please make sure the  data is in the FASTA format! Given data:\n " + string));
        }
        return new FastaSequence(string2, string3);
    }
}

