/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.ui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.prefs.PreferencesPage;

public class GeneralPage
extends JPanel
implements PreferencesPage {
    private static final Icon _icon = new ImageIcon(Main.class.getResource("image/PrefsSystem.gif"));
    private JCheckBox chkUseToolbarText = new JCheckBox();
    private JRadioButton radioTextRight = new JRadioButton();
    private JRadioButton radioTextBelow = new JRadioButton();
    private JLabel lblToolbar = new JLabel();
    private GridBagLayout _layout = new GridBagLayout();
    private ButtonGroup _buttonGroup = new ButtonGroup();

    public GeneralPage() {
        try {
            this.jbInit();
            this._updateUseTextState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layout);
        this.chkUseToolbarText.setText("Display Text on Toolbar Buttons");
        this.chkUseToolbarText.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GeneralPage.this._updateUseTextState();
            }
        });
        this.radioTextRight.setText("Display Text to the Right of Icon");
        this.radioTextBelow.setText("Display Text Below Icon");
        this._buttonGroup.add(this.radioTextBelow);
        this._buttonGroup.add(this.radioTextRight);
        this.lblToolbar.setText("Toolbar Options");
        this.add((Component)this.lblToolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.radioTextBelow, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 5, 5), 0, 0));
        this.add((Component)this.radioTextRight, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 20, 5, 5), 0, 0));
        this.add((Component)this.chkUseToolbarText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
    }

    public Component getPage() {
        return this;
    }

    public Icon getIcon() {
        return _icon;
    }

    public String getName() {
        return "General Preferences";
    }

    public Map getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("useToolBarText", Boolean.toString(this.chkUseToolbarText.isSelected()));
        map.put("radioTextBelow", Boolean.toString(this.radioTextBelow.isSelected()));
        map.put("radioTextRight", Boolean.toString(this.radioTextRight.isSelected()));
        return map;
    }

    public void setProperties(Map map) {
        String value = (String)map.get("useToolBarText");
        this.chkUseToolbarText.setSelected(Boolean.valueOf(value));
        value = (String)map.get("radioTextBelow");
        this.radioTextBelow.setSelected(Boolean.valueOf(value));
        value = (String)map.get("radioTextRight");
        this.radioTextRight.setSelected(Boolean.valueOf(value));
    }

    public Object getKey() {
        return "general";
    }

    public void onEntry() {
    }

    public void onExit() {
    }

    private void _updateUseTextState() {
        Enumeration<AbstractButton> e = this._buttonGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            b.setEnabled(this.chkUseToolbarText.isSelected());
        }
    }
}

