/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.robsite.jswingreader.action.UpdatableAction;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.ChannelListModel;
import org.robsite.jswingreader.model.SimpleRSSParser;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.MainWindow;

public class AddRSSFeedAction
extends AbstractAction
implements UpdatableAction {
    private JList _listChannels;

    public AddRSSFeedAction(JList listChannels) {
        super("Add");
        this.putValue("MnemonicKey", new Integer(65));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 8));
        this.putValue("SmallIcon", new ImageIcon(Main.class.getResource("image/Add16.gif")));
        this.putValue("LongDescription", "Add");
        this._listChannels = listChannels;
    }

    public void actionPerformed(ActionEvent e) {
        String urlString;
        String message = "Enter URL for RSS Feed";
        MainWindow parent = Main.getMainWindow();
        String initialValue = "";
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = c.getContents(this);
        if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (s != null && s.toLowerCase().startsWith("http:")) {
                    initialValue = s;
                }
            }
            catch (IOException s) {
            }
            catch (UnsupportedFlavorException s) {
                // empty catch block
            }
        }
        if ((urlString = JOptionPane.showInputDialog(parent, message, initialValue)) != null && urlString.length() > 0) {
            try {
                Channel channel = SimpleRSSParser.parse(urlString);
                ChannelListModel model = (ChannelListModel)this._listChannels.getModel();
                model.addChannel(channel);
                this._listChannels.setSelectedValue(channel, true);
            }
            catch (MalformedURLException ex) {
                Main.getMainWindow().setStatusBarText("Unable to open URL: " + urlString);
            }
            catch (Exception ex) {
                String text = ex.toString();
                JOptionPane.showMessageDialog(Main.getMainWindow(), text, "JSwingReader Exception", 0);
            }
        }
    }

    public void update(Object o) {
    }
}

