/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.servlet.utils;

import java.io.BufferedReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpUtils;

public class DASQueryStringTranslator
extends HttpServletRequestWrapper {
    private String queryString = null;
    private Hashtable params = null;

    public DASQueryStringTranslator(HttpServletRequest req) {
        super(req);
    }

    public void setRequest(HttpServletRequest req) {
        super.setRequest((ServletRequest)req);
        this.queryString = null;
        this.params = null;
    }

    protected String getQueryStringTranslated() {
        if (this.queryString != null) {
            return this.queryString;
        }
        if (this.getMethod().equalsIgnoreCase("POST")) {
            try {
                BufferedReader br = new BufferedReader(this.getReader());
                this.queryString = br.readLine();
            }
            catch (Exception br) {}
        } else {
            this.queryString = this.getQueryString();
            if (this.queryString == null || this.queryString.length() == 0) {
                return null;
            }
            try {
                this.queryString = URLDecoder.decode(this.queryString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (this.queryString == null || this.queryString.length() == 0) {
            return null;
        }
        if (this.queryString.indexOf(59) >= 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.queryString.length()) {
                char c = this.queryString.charAt(i);
                if (c == ';') {
                    c = '&';
                }
                sb.append(c);
                ++i;
            }
            this.queryString = sb.toString();
        }
        return this.queryString;
    }

    protected Hashtable getParameters() {
        if (this.params == null) {
            String p = this.getQueryStringTranslated();
            this.params = p == null ? new Hashtable() : HttpUtils.parseQueryString((String)p);
        }
        return this.params;
    }

    public String getParameter(String name) {
        Hashtable params = this.getParameters();
        String[] vals = (String[])params.get(name);
        if (vals != null) {
            return vals[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        Hashtable params = this.getParameters();
        String[] vals = (String[])params.get(name);
        return vals;
    }

    public Enumeration getParameterNames() {
        Hashtable params = this.getParameters();
        return params.keys();
    }
}

