/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.dassources.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.biodas.jdas.dassources.utils.DasSpec;
import org.biodas.jdas.schema.sources.CAPABILITY;
import org.biodas.jdas.schema.sources.COORDINATES;
import org.biodas.jdas.schema.sources.PROP;
import org.biodas.jdas.schema.sources.SOURCE;
import org.biodas.jdas.schema.sources.VERSION;

public class SourcesFilter {
    static Logger logger = Logger.getLogger(SourcesFilter.class);

    public List<SOURCE> filterBy(List<SOURCE> sources, List<String> label, List<String> organisms, List<String> authorities, List<String> capabilities, List<String> validCapability, List<String> types, List<String> specs, List<String> versions, List<String> coordId, List<String> serverRootUrls, String active) {
        logger.debug((Object)"version 5 of filter");
        ArrayList<SOURCE> lst = new ArrayList<SOURCE>();
        int i = 0;
        while (i < sources.size()) {
            SOURCE source = sources.get(i);
            if (!this.hasLabel(source, label)) {
                logger.debug((Object)"fail on label");
            } else if (!this.hasOrganism(source, organisms)) {
                logger.debug((Object)"fail on org");
            } else if (!this.hasAuthority(source, authorities)) {
                logger.debug((Object)"fail on auth");
            } else if (!this.hasCapability(source, capabilities)) {
                logger.debug((Object)"fail on cap");
            } else if (!this.hasValidCapability(source, validCapability)) {
                logger.debug((Object)"fail on validCap");
            } else if (!this.hasType(source, types)) {
                logger.debug((Object)"fail on types");
            } else if (!this.isSpec(source, specs)) {
                logger.debug((Object)"fail on specs");
            } else if (!this.hasVersion(source, versions)) {
                logger.debug((Object)"fail on version");
            } else if (!this.hasCoordinateId(source, coordId)) {
                logger.debug((Object)"fail on coordid");
            } else if (!this.hasServerRootUrl(source, serverRootUrls)) {
                logger.debug((Object)"fail on serverroot");
            } else if (!this.active(source, active)) {
                logger.debug((Object)"fail on active");
            } else {
                logger.debug((Object)("adding source in filter " + source.getUri()));
                lst.add(source);
            }
            ++i;
        }
        return lst;
    }

    public boolean active(SOURCE source, String active) {
        if (active == null || active.equals("any")) {
            return true;
        }
        if (!active.equals("true") && !active.equals("false")) {
            return true;
        }
        boolean isActive = true;
        for (PROP prop : source.getVERSION().get(0).getPROP()) {
            if (!prop.getName().equals("inactive")) continue;
            isActive = false;
        }
        if (active.equals("true") && isActive) {
            return true;
        }
        return active.equals("false") && !isActive;
    }

    public boolean hasAuthority(SOURCE source, List<String> authorities) {
        if (authorities == null || authorities.size() == 0) {
            return true;
        }
        List<Object> coords = new ArrayList();
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            coords = version.getCOORDINATES();
            for (COORDINATES cOORDINATES : coords) {
                for (String auth : authorities) {
                    if (this.isAny(auth)) {
                        return true;
                    }
                    if (!auth.equalsIgnoreCase(cOORDINATES.getAuthority())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasCapability(SOURCE source, List<String> capabilities) {
        if (capabilities == null || capabilities.size() == 0) {
            return true;
        }
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            List<CAPABILITY> caps = version.getCAPABILITY();
            for (CAPABILITY cap : caps) {
                for (String capab : capabilities) {
                    if (this.isAny(capab)) {
                        return true;
                    }
                    String[] array = cap.getType().split(":");
                    if (!(array.length > 1 ? capab.equalsIgnoreCase(array[1]) : capab.equalsIgnoreCase(cap.getType()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasValidCapability(SOURCE source, List<String> capabilities) {
        if (capabilities == null || capabilities.size() == 0) {
            return true;
        }
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            List<PROP> props = version.getPROP();
            for (PROP prop : props) {
                if (!prop.getValue().equalsIgnoreCase("valid") && !prop.getValue().equalsIgnoreCase("probably_valid")) continue;
                for (String cap : capabilities) {
                    if (this.isAny(cap)) {
                        return true;
                    }
                    if (!prop.getName().equals(cap)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasLabel(SOURCE source, List<String> labels) {
        if (labels == null || labels.size() == 0) {
            return true;
        }
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            List<PROP> props = version.getPROP();
            for (PROP prop : props) {
                if (!prop.getName().equalsIgnoreCase("label")) continue;
                for (String label : labels) {
                    if (this.isAny(label)) {
                        return true;
                    }
                    if (!prop.getValue().equalsIgnoreCase(label)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasType(SOURCE source, List<String> types) {
        if (types == null || types.size() == 0) {
            return true;
        }
        List<COORDINATES> coords = null;
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            coords = version.getCOORDINATES();
            for (COORDINATES coord : coords) {
                for (String type : types) {
                    if (this.isAny(type)) {
                        return true;
                    }
                    if (!type.equalsIgnoreCase(coord.getSource())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasOrganism(SOURCE source, List<String> organisms) {
        if (organisms == null || organisms.size() == 0) {
            return true;
        }
        List<Object> coords = new ArrayList();
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            coords = version.getCOORDINATES();
            for (COORDINATES cOORDINATES : coords) {
                String[] chunks = cOORDINATES.getContent().split(",");
                if (chunks.length > 2) {
                    String coordOrganism = chunks[2];
                    logger.debug((Object)("organism=" + coordOrganism));
                    for (String org : organisms) {
                        if (this.isAny(org)) {
                            return true;
                        }
                        if (!coordOrganism.equals(org) && !cOORDINATES.getTaxid().equals(org)) continue;
                        return true;
                    }
                    continue;
                }
                if (chunks.length != 2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpec(SOURCE source, List<String> specs) {
        if (specs == null || specs.size() == 0) {
            return true;
        }
        for (String spec : specs) {
            if (this.isAny(spec)) {
                return true;
            }
            DasSpec regSpec = DasSpec.convertToRegistrySpecification(spec);
            List<VERSION> versions = source.getVERSION();
            for (VERSION versionA : versions) {
                for (PROP prop : versionA.getPROP()) {
                    String convertedValue;
                    String name = prop.getName();
                    String value = prop.getValue();
                    if (!name.equals("spec") || !(convertedValue = DasSpec.convertToRegistrySpecification(value).toString()).equals(regSpec.toString())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasVersion(SOURCE source, List<String> cVersions) {
        if (cVersions == null || cVersions.size() == 0) {
            return true;
        }
        List<VERSION> versions = source.getVERSION();
        for (VERSION version : versions) {
            List<COORDINATES> coords = null;
            coords = version.getCOORDINATES();
            for (COORDINATES coord : coords) {
                String coordVersion = coord.getVersion();
                for (String cversion : cVersions) {
                    if (this.isAny(cversion)) {
                        return true;
                    }
                    if (!cversion.equalsIgnoreCase(coordVersion)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasCoordinateId(SOURCE source, List<String> ids) {
        if (ids == null || ids.size() == 0) {
            return true;
        }
        logger.debug((Object)ids.toString());
        List<VERSION> version = source.getVERSION();
        for (VERSION v : version) {
            List<COORDINATES> coords = null;
            coords = v.getCOORDINATES();
            for (COORDINATES coord : coords) {
                String coordId = coord.getUri();
                logger.debug((Object)coordId);
                for (String id : ids) {
                    if (this.isAny(id)) {
                        return true;
                    }
                    if (!id.contains("/")) {
                        coordId = coordId.substring(coordId.lastIndexOf("/") + 1, coordId.length());
                        logger.debug((Object)("modified=" + coordId));
                    }
                    if (!coordId.equalsIgnoreCase(id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasServerRootUrl(SOURCE source, List<String> serverUrls) {
        if (serverUrls == null || serverUrls.size() == 0) {
            return true;
        }
        List<VERSION> versionAdapters = source.getVERSION();
        for (VERSION v : versionAdapters) {
            List<CAPABILITY> caps = v.getCAPABILITY();
            if (caps.size() <= 0) continue;
            for (String serverUrl : serverUrls) {
                if (this.isAny(serverUrl)) {
                    return true;
                }
                if (serverUrl == null) continue;
                if (!serverUrl.endsWith("/")) {
                    serverUrl = String.valueOf(serverUrl) + "/";
                }
                if (!caps.get(0).getQueryUri().startsWith(serverUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTitle(SOURCE source, List<String> title) {
        for (String nickname : title) {
            if (this.isAny(nickname)) {
                return true;
            }
            if (!source.getTitle().equals(nickname)) continue;
            return true;
        }
        return false;
    }

    private boolean isAny(String param) {
        return param == null || param.equals("") || param.equals("any");
    }
}

