/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.dassources.utils;

import java.util.List;
import org.apache.log4j.Logger;
import org.biodas.jdas.dassources.Capabilities;
import org.biodas.jdas.dassources.utils.PropInterogator;
import org.biodas.jdas.dassources.utils.VersionAdapter;
import org.biodas.jdas.exceptions.ValidationException;
import org.biodas.jdas.schema.sources.CAPABILITY;
import org.biodas.jdas.schema.sources.PROP;
import org.biodas.jdas.schema.sources.SOURCE;
import org.biodas.jdas.schema.sources.VERSION;

public class RegistrySourceAdapter {
    private SOURCE source;
    private Logger logger = Logger.getLogger(RegistrySourceAdapter.class);

    public RegistrySourceAdapter(SOURCE source) {
        this.source = source;
    }

    public String getOriginalDataSourceUri() throws ValidationException {
        VERSION version = this.source.getVERSION().get(0);
        VersionAdapter adapter = new VersionAdapter(version);
        return adapter.getOriginalDataSourceUri();
    }

    public String getServerUri() throws ValidationException {
        String dataSourceUri = this.getOriginalDataSourceUri();
        if (!dataSourceUri.contains("/")) {
            throw new ValidationException("source with uri=" + this.source.getUri() + " query_uri doesn't contain a /" + " query_uri=" + dataSourceUri);
        }
        return dataSourceUri.substring(0, dataSourceUri.lastIndexOf("/"));
    }

    public void setActive() {
        for (VERSION version : this.source.getVERSION()) {
            List<PROP> props = version.getPROP();
            for (PROP prop : props) {
                if (!prop.getName().equals("inactive")) continue;
                props.remove(prop);
            }
        }
    }

    public void setInActive() {
        for (VERSION version : this.source.getVERSION()) {
            List<PROP> props = version.getPROP();
            if (!"".equals(PropInterogator.getPropByName("inactive", props))) continue;
            PROP prop = new PROP();
            prop.setName("inactive");
            prop.setValue("0");
            props.add(prop);
        }
    }

    public boolean hasBigFileFormat() {
        for (VERSION version : this.source.getVERSION()) {
            for (CAPABILITY cap : version.getCAPABILITY()) {
                String type = cap.getType();
                System.out.println(cap);
                if (!Capabilities.isBigFileFormat(type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCapability(Capabilities capability) {
        for (VERSION version : this.source.getVERSION()) {
            for (CAPABILITY cap : version.getCAPABILITY()) {
                String type = cap.getType();
                System.out.println(cap.toString());
                if (!type.equalsIgnoreCase("das1:" + capability.name())) continue;
                return true;
            }
        }
        return false;
    }
}

