/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.dassources.utils;

import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biodas.jdas.dassources.utils.DasTimeFormat;
import org.biodas.jdas.dassources.utils.PropInterogator;
import org.biodas.jdas.schema.sources.CAPABILITY;
import org.biodas.jdas.schema.sources.COORDINATES;
import org.biodas.jdas.schema.sources.PROP;
import org.biodas.jdas.schema.sources.SOURCE;

public abstract class DasSourceComparator
implements Comparator {
    private final String name;
    private static final Map COMPS_BY_NAME;
    private static final int TWODAYS = 172800000;
    public static final Comparator BY_ID;
    public static final Comparator BY_TITLE;
    public static final Comparator BY_STATUS;
    public static final Comparator BY_REGISTER_DATE;
    public static final Comparator BY_LEASE_DATE;
    public static final Comparator BY_URL;
    public static final Comparator BY_ADMIN_EMAIL;
    public static final Comparator BY_DESCRIPTION;
    public static final Comparator BY_VALID_CAPABILITIES;
    public static final Comparator BY_CAPABILITIES;
    public static final Comparator BY_COORDINATE_SYSTEM;

    static {
        BY_ID = new DasSourceComparator("id"){

            @Override
            protected Comparable getField(SOURCE ds) {
                return ds.getVERSION().get(0).getUri();
            }
        };
        BY_TITLE = new DasSourceComparator("title"){

            @Override
            protected Comparable getField(SOURCE ds) {
                return ds.getTitle();
            }
        };
        BY_STATUS = new DasSourceComparator("status"){

            @Override
            protected Comparable getField(SOURCE ds) {
                Date now = new Date();
                List<PROP> props = ds.getVERSION().get(0).getPROP();
                String timeString = PropInterogator.getPropByName("leaseTime", props);
                Date date = null;
                try {
                    date = DasTimeFormat.fromDASString(timeString);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (date.getTime() < now.getTime() - 172800000L) {
                    return new Integer(0);
                }
                return new Integer(1);
            }
        };
        BY_REGISTER_DATE = new DasSourceComparator("registerdate"){

            @Override
            protected Comparable getField(SOURCE ds) {
                Date date = null;
                try {
                    date = DasTimeFormat.fromDASString(ds.getVERSION().get(0).getCreated());
                    return date;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return date;
                }
            }
        };
        BY_LEASE_DATE = new DasSourceComparator("leasedate"){

            @Override
            protected Comparable getField(SOURCE ds) {
                List<PROP> props = ds.getVERSION().get(0).getPROP();
                String timeString = PropInterogator.getPropByName("leaseTime", props);
                Date date = null;
                try {
                    date = DasTimeFormat.fromDASString(timeString);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                return date;
            }
        };
        BY_URL = new DasSourceComparator("url"){

            @Override
            protected Comparable getField(SOURCE ds) {
                return ds.getVERSION().get(0).getUri();
            }
        };
        BY_ADMIN_EMAIL = new DasSourceComparator("adminemail"){

            @Override
            protected Comparable getField(SOURCE ds) {
                return ds.getMAINTAINER().getEmail();
            }
        };
        BY_DESCRIPTION = new DasSourceComparator("description"){

            @Override
            protected Comparable getField(SOURCE ds) {
                return ds.getDescription();
            }
        };
        BY_VALID_CAPABILITIES = new DasSourceComparator("validcapabilities"){

            @Override
            protected Comparable getField(SOURCE ds) {
                List<PROP> props = ds.getVERSION().get(0).getPROP();
                List<String> caps = PropInterogator.getPropByValue("valid", props);
                return Integer.valueOf(caps == null ? 0 : caps.size());
            }
        };
        BY_CAPABILITIES = new DasSourceComparator("capabilities"){

            @Override
            protected Comparable getField(SOURCE ds) {
                List<CAPABILITY> caps = ds.getVERSION().get(0).getCAPABILITY();
                return Integer.valueOf(caps == null ? 0 : caps.size());
            }
        };
        BY_COORDINATE_SYSTEM = new DasSourceComparator("coordinatesystem"){

            @Override
            protected Comparable getField(SOURCE ds) {
                List<COORDINATES> dcss = ds.getVERSION().get(0).getCOORDINATES();
                return dcss.size() == 0 ? "" : dcss.get(0).getContent();
            }
        };
        COMPS_BY_NAME = new HashMap();
        COMPS_BY_NAME.put(BY_ID.toString(), BY_ID);
        COMPS_BY_NAME.put(BY_REGISTER_DATE.toString(), BY_REGISTER_DATE);
        COMPS_BY_NAME.put(BY_LEASE_DATE.toString(), BY_LEASE_DATE);
        COMPS_BY_NAME.put(BY_URL.toString(), BY_URL);
        COMPS_BY_NAME.put(BY_ADMIN_EMAIL.toString(), BY_ADMIN_EMAIL);
        COMPS_BY_NAME.put(BY_DESCRIPTION.toString(), BY_DESCRIPTION);
        COMPS_BY_NAME.put(BY_CAPABILITIES.toString(), BY_CAPABILITIES);
        COMPS_BY_NAME.put(BY_COORDINATE_SYSTEM.toString(), BY_COORDINATE_SYSTEM);
        COMPS_BY_NAME.put(BY_STATUS.toString(), BY_STATUS);
        COMPS_BY_NAME.put(BY_TITLE.toString(), BY_TITLE);
        COMPS_BY_NAME.put(BY_VALID_CAPABILITIES.toString(), BY_VALID_CAPABILITIES);
    }

    public DasSourceComparator(String str) {
        this.name = str;
    }

    public static Comparator fromString(String name) {
        if (COMPS_BY_NAME.containsKey(name)) {
            return (Comparator)COMPS_BY_NAME.get(name);
        }
        throw new IllegalArgumentException("Can't compare by key " + name);
    }

    protected abstract Comparable getField(SOURCE var1);

    public int compare(Object a, Object b) {
        SOURCE x = (SOURCE)a;
        SOURCE y = (SOURCE)b;
        return this.getField(x).compareTo(this.getField(y));
    }

    public String toString() {
        return this.name;
    }
}

