/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.dassources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biodas.jdas.dassources.NoSuchCapabilityException;

public enum Capabilities {
    SOURCES("sources"){

        @Override
        public String getCommandTestString(String testCode) {
            return "sources";
        }
    }
    ,
    STYLESHEET("stylesheet"){

        @Override
        public String getCommandTestString(String testCode) {
            return this.getName();
        }
    }
    ,
    FEATURES("features"){

        @Override
        public String getCommandTestString(String testCode) {
            return String.valueOf(this.getName()) + "?segment=" + testCode;
        }
    }
    ,
    TYPES("types"){

        @Override
        public String getCommandTestString(String testCode) {
            return this.getName();
        }
    }
    ,
    SEQUENCE("sequence"){

        @Override
        public String getCommandTestString(String testCode) {
            return String.valueOf(this.getName()) + "?segment=" + testCode;
        }
    }
    ,
    ENTRY_POINTS("entry_points"){

        @Override
        public String getCommandTestString(String testCode) {
            return this.getName();
        }
    }
    ,
    ALIGNMENT("alignment"){

        @Override
        public String getCommandTestString(String testCode) {
            return String.valueOf(this.getName()) + "?query=" + testCode;
        }
    }
    ,
    STRUCTURE("structure"){

        @Override
        public String getCommandTestString(String testCode) {
            return String.valueOf(this.getName()) + "?query=" + testCode;
        }
    }
    ,
    INTERACTION("interaction"){

        @Override
        public String getCommandTestString(String testCode) {
            return String.valueOf(this.getName()) + "?interactor=" + testCode;
        }
    }
    ,
    UNKNOWN_SEGMENT("unknown-segment", "unknown_segment"){

        @Override
        public String getCommandTestString(String testCode) {
            return "features?segment=invalidTestCode:1,1000";
        }
    }
    ,
    UNKNOWN_FEATURE("unknown-feature", "unknown_feature"){

        @Override
        public String getCommandTestString(String testCode) {
            return "features?feature_id=invalidTestCode";
        }
    }
    ,
    ERROR_SEGMENT("error-segment", "error_segment"){

        @Override
        public String getCommandTestString(String testCode) {
            return "features?segment=invalidTestCode:1,1000";
        }
    }
    ,
    MAXBINS("maxbins"){

        @Override
        public String getCommandTestString(String testCode) {
            return "features?segment=" + testCode + ";maxbins=1";
        }
    }
    ,
    CORS("cors"){

        @Override
        public String getCommandTestString(String testCode) {
            return "any valid request";
        }
    }
    ,
    FEATURE_BY_ID("feature-by-id", "feature_id"){

        @Override
        public String getCommandTestString(String testCode) {
            return "features?feature_id=";
        }
    }
    ,
    FORMAT("format"){

        @Override
        public String getCommandTestString(String testCode) {
            return "format";
        }
    }
    ,
    ADJACENT_FEATURE("adjacent-feature", "adjacent"){

        @Override
        public String getCommandTestString(String testCode) {
            return "adjacent";
        }
    }
    ,
    BIGFILE_BAM("bigfile-bam", "bigfile_bam"){

        @Override
        public String getCommandTestString(String testCode) {
            return "";
        }
    }
    ,
    BIGFILE_BIGBED("bigfile-bigbed", "bigfile_bigbed"){

        @Override
        public String getCommandTestString(String testCode) {
            return "";
        }
    }
    ,
    BIGFILE_BIGWIG("bigfile-bigwig", "bigfile_bigwig"){

        @Override
        public String getCommandTestString(String testCode) {
            return "";
        }
    };

    private String name;
    private String command;
    private static final Map<String, Capabilities> nameToValueMap;
    private static final ArrayList<Capabilities> bigFileFormats;
    private static final ArrayList<Capabilities> primaryCapabilities;

    static {
        nameToValueMap = new HashMap<String, Capabilities>();
        for (Capabilities value : EnumSet.allOf(Capabilities.class)) {
            nameToValueMap.put(value.getName(), value);
        }
        bigFileFormats = new ArrayList();
        primaryCapabilities = new ArrayList();
        bigFileFormats.add(BIGFILE_BAM);
        bigFileFormats.add(BIGFILE_BIGBED);
        bigFileFormats.add(BIGFILE_BIGWIG);
        primaryCapabilities.add(SEQUENCE);
        primaryCapabilities.add(FEATURES);
        primaryCapabilities.add(ALIGNMENT);
        primaryCapabilities.add(STRUCTURE);
        primaryCapabilities.add(INTERACTION);
        primaryCapabilities.add(BIGFILE_BAM);
        primaryCapabilities.add(BIGFILE_BIGBED);
        primaryCapabilities.add(BIGFILE_BIGWIG);
    }

    public static ArrayList<Capabilities> getPrimarycapabilities() {
        return primaryCapabilities;
    }

    public ArrayList<Capabilities> getBigFileFormats() {
        return bigFileFormats;
    }

    private Capabilities(String name) {
        this.name = name;
    }

    private Capabilities(String name, String command) {
        this.name = name;
        this.command = command;
    }

    public abstract String getCommandTestString(String var1);

    public String getName() {
        return this.name;
    }

    public String getCommand() {
        if (this.command != null) {
            return this.command;
        }
        return this.getName();
    }

    public static String[] getCommandStrings() {
        ArrayList<String> caps = new ArrayList<String>();
        for (Capabilities value : EnumSet.allOf(Capabilities.class)) {
            caps.add(value.getCommand());
        }
        return caps.toArray(new String[caps.size()]);
    }

    public static String[] getCapabilityStrings() {
        ArrayList<String> caps = new ArrayList<String>();
        for (Capabilities value : EnumSet.allOf(Capabilities.class)) {
            caps.add(value.getName());
        }
        return caps.toArray(new String[caps.size()]);
    }

    public static boolean exists(String capability) {
        return nameToValueMap.containsKey(capability);
    }

    public String toString() {
        return this.getCommand();
    }

    public static Capabilities[] capabilitiesFromStrings(List<String> list) {
        ArrayList<Capabilities> caps = new ArrayList<Capabilities>();
        int i = 0;
        while (i < list.size()) {
            if (nameToValueMap.containsKey(list.get(i))) {
                caps.add(nameToValueMap.get(list.get(i)));
            } else {
                System.err.println("Warning a capability not found for  String " + list.get(i));
            }
            ++i;
        }
        return caps.toArray(new Capabilities[caps.size()]);
    }

    public static List<Capabilities> capabilitiesListFromStrings(List<String> list) {
        ArrayList<Capabilities> caps = new ArrayList<Capabilities>();
        if (list == null) {
            System.out.println("Warning capabilities from Strings is passed no capabilities");
            return caps;
        }
        int i = 0;
        while (i < list.size()) {
            if (nameToValueMap.containsKey(list.get(i))) {
                caps.add(nameToValueMap.get(list.get(i)));
            } else {
                System.err.println("Warning a capability not found for  String " + list.get(i));
                try {
                    throw new NoSuchCapabilityException(list.get(i));
                }
                catch (NoSuchCapabilityException e) {
                    System.out.println("no such found capability " + e.getUnfoundCapability());
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return caps;
    }

    public static List<String> capabilitiesListFromStrings(String[] list) {
        ArrayList<String> caps = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            caps.add(list[i]);
            ++i;
        }
        return caps;
    }

    public static List<String> capabilitiesAsStrings(Collection<Capabilities> capabilities) {
        ArrayList<String> list = new ArrayList<String>();
        for (Capabilities cap : capabilities) {
            list.add(cap.getName());
        }
        return list;
    }

    public static List<String> containsSubSet(List<String> list, List<String> caps) {
        ArrayList<String> notValidButStated = new ArrayList<String>();
        for (String sub : list) {
            boolean found = false;
            for (String superS : caps) {
                if (!sub.equals(superS)) continue;
                found = true;
            }
            if (found) continue;
            notValidButStated.add(sub);
        }
        return notValidButStated;
    }

    public static void main(String[] args) {
        Capabilities[] capabilitiesArray = Capabilities.values();
        int n = capabilitiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities cap = capabilitiesArray[n2];
            System.out.println(cap.toString());
            ++n2;
        }
        if (SEQUENCE.equals(SEQUENCE.toString())) {
            System.out.println("is true");
        }
    }

    public static boolean allStatedAreValid(List<String> stated, List<String> valid) {
        List<String> notValidButStated = Capabilities.containsSubSet(stated, valid);
        return notValidButStated.size() == 0;
    }

    public static Map capabilitiesToMap(Capabilities[] caps) {
        HashMap<Capabilities, String> map = new HashMap<Capabilities, String>();
        Capabilities[] capabilitiesArray = caps;
        int n = caps.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities cap = capabilitiesArray[n2];
            map.put(cap, "");
            ++n2;
        }
        return map;
    }

    public static Capabilities getValue(String nameOfCapability) {
        return nameToValueMap.get(nameOfCapability);
    }

    public static boolean isBigFileFormat(String name) {
        for (Capabilities cap : bigFileFormats) {
            if (name.startsWith("das1:")) {
                name = name.substring(5, name.length());
            }
            if (!cap.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryCapability(String name) {
        for (Capabilities cap : primaryCapabilities) {
            if (!cap.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    /* synthetic */ Capabilities(String string, int n, String string2, Capabilities capabilities) {
        this(string2);
    }

    /* synthetic */ Capabilities(String string, int n, String string2, String string3, Capabilities capabilities) {
        this(string2, string3);
    }
}

