/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.TypesClient;
import org.biodas.jdas.client.adapters.types.DasTypesAdapter;
import org.biodas.jdas.client.threads.ClientMultipleSources;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.exceptions.ErrorInSource;
import org.biodas.jdas.schema.types.DASTYPES;

public class TypesClientMultipleSources
extends ClientMultipleSources {
    private static Logger logger = Logger.getLogger(TypesClientMultipleSources.class);

    public TypesClientMultipleSources() {
    }

    public TypesClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime) {
        super(poolSize, maxPoolSize, keepAliveTime);
    }

    public TypesClientMultipleSources(Observer observer) {
        super(observer);
    }

    public TypesClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime, Observer observer) {
        super(poolSize, maxPoolSize, keepAliveTime, observer);
    }

    public void fetchData(List<String> sources, final List<String> segments, final List<String> types, final Map<String, Map<List<String>, DASTYPES>> results, final Map<String, Map<List<String>, Exception>> errors) {
        final TypesClientMultipleSources self = this;
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TypesClient typesClient = new TypesClient(TypesClientMultipleSources.this.getConnPropsFor(source));
                        DasTypesAdapter adapter = typesClient.fetchData(source, segments, types);
                        if (results.get(source) == null) {
                            HashMap<List, DasTypesAdapter> response = new HashMap<List, DasTypesAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }

    public void fetchData(List<String> sources, final Map<String, DASTYPES> results, final Map<String, Exception> errors) {
        final TypesClientMultipleSources self = this;
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TypesClient typesClient = new TypesClient(TypesClientMultipleSources.this.getConnPropsFor(source));
                        DasTypesAdapter adapter = typesClient.fetchData(source);
                        results.put(source, adapter);
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        errors.put(source, e);
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }
}

