/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.FeaturesClient;
import org.biodas.jdas.client.adapters.features.DasGFFAdapter;
import org.biodas.jdas.client.threads.ClientMultipleSources;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.exceptions.ErrorInSource;

public class FeaturesClientMultipleSources
extends ClientMultipleSources {
    private static Logger logger = Logger.getLogger(FeaturesClientMultipleSources.class);

    public FeaturesClientMultipleSources() {
    }

    public FeaturesClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime) {
        super(poolSize, maxPoolSize, keepAliveTime);
    }

    public FeaturesClientMultipleSources(Observer observer) {
        super(observer);
    }

    public FeaturesClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime, Observer observer) {
        super(poolSize, maxPoolSize, keepAliveTime, observer);
    }

    public void fetchData(List<String> sources, List<String> segments, Map<String, Map<List<String>, DasGFFAdapter>> results, Map<String, Map<List<String>, Exception>> errors) {
        ArrayList<List<String>> ids = new ArrayList<List<String>>();
        ids.add(segments);
        this.fetchData(sources, ids, true, results, errors);
    }

    public void fetchData(List<String> sources, List<List<String>> segmentsets, boolean reiterate, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        int sp = 0;
        if (!reiterate && segmentsets.size() != sources.size()) {
            throw new Error("Mismatch between number of sources and number of sets of segments. Please set reiterate flag or provide a segment set for each source");
        }
        final FeaturesClientMultipleSources self = this;
        for (final String source : sources) {
            final List<String> segments = segmentsets.get(sp++);
            if (reiterate && sp == segmentsets.size()) {
                sp = 0;
            }
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient(FeaturesClientMultipleSources.this.getConnPropsFor(source));
                        DasGFFAdapter adapter = featuresClient.fetchData(source, segments);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }

    public void fetchDataWithTypes(List<String> sources, final List<String> segments, final List<String> types, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        final FeaturesClientMultipleSources self = this;
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient(FeaturesClientMultipleSources.this.getConnPropsFor(source));
                        DasGFFAdapter adapter = featuresClient.fetchDataWithTypes(source, segments, types);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }

    public void fetchDataWithFeatueIds(List<String> sources, final List<String> segments, final List<String> featureIds, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        final FeaturesClientMultipleSources self = this;
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient(FeaturesClientMultipleSources.this.getConnPropsFor(source));
                        DasGFFAdapter adapter = featuresClient.fetchDataWithFeatueIds(source, segments, featureIds);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }

    public void fetchData(List<String> sources, final List<String> segments, final List<String> types, final List<String> categories, final String categorize, final List<String> featureIds, final String maxbins, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        final FeaturesClientMultipleSources self = this;
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient(FeaturesClientMultipleSources.this.getConnPropsFor(source));
                        DasGFFAdapter adapter = featuresClient.fetchData(source, segments, types, categories, categorize, featureIds, maxbins);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                        self.changeAndNotify(source);
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                        self.changeAndNotify(new ErrorInSource(source, e));
                    }
                }
            });
        }
    }
}

