/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.ConnectionPropertyProviderI;
import org.biodas.jdas.client.threads.MultipleConnectionPropertyProviderI;
import org.biodas.jdas.client.threads.ThreadPoolExecutorJdas;

public abstract class ClientMultipleSources
extends Observable {
    private static Logger logger = Logger.getLogger(ClientMultipleSources.class);
    protected MultipleConnectionPropertyProviderI connProps = null;
    protected int poolSize;
    protected int maxPoolSize;
    protected long keepAliveTime;
    protected ThreadPoolExecutorJdas threadPool = null;
    protected final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    public MultipleConnectionPropertyProviderI getConnProps() {
        return this.connProps;
    }

    public void setConnProps(MultipleConnectionPropertyProviderI connProps) {
        this.connProps = connProps;
    }

    protected ConnectionPropertyProviderI getConnPropsFor(String source) {
        return this.connProps == null ? null : this.connProps.getConnectionPropertyProviderFor(source);
    }

    protected ClientMultipleSources() {
        this(5, 10, 5L, null);
    }

    protected ClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime) {
        this(poolSize, maxPoolSize, keepAliveTime, null);
    }

    protected ClientMultipleSources(Observer observer) {
        this(5, 10, 5L, observer);
    }

    protected ClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime, Observer observer) {
        this.poolSize = poolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.threadPool = new ThreadPoolExecutorJdas(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, this.queue);
        if (observer != null) {
            this.addObserver(observer);
        }
    }

    protected void runTask(Runnable task) {
        this.threadPool.execute(task);
    }

    public void shutDown() {
        this.threadPool.shutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPool.awaitTermination(timeout, unit);
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    public int getThreadCounting() {
        return this.threadPool.getThreadCounting();
    }

    public boolean hasAliveRunners() {
        return this.threadPool.hasAliveRunners();
    }

    protected void changeAndNotify(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    protected void changeAndNotify() {
        this.setChanged();
        this.notifyObservers();
    }
}

