/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.DasHeadersEnum;
import org.biodas.jdas.client.SourcesClientInterface;
import org.biodas.jdas.dassources.utils.DasSpec;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.exceptions.ValidationException;
import org.biodas.jdas.schema.sources.SOURCES;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SourcesClient
implements SourcesClientInterface {
    private static Logger logger = Logger.getLogger(SourcesClient.class);
    private SOURCES sources;
    RestTemplate restTemp = new RestTemplate();
    private HttpHeaders respHeaders;

    public HttpHeaders getRespHeaders() {
        return this.respHeaders;
    }

    public SOURCES getSources() {
        return this.sources;
    }

    @Override
    public SOURCES fetchData(String serverURL) throws ValidationException, DASClientException {
        ResponseEntity response;
        SOURCES dasSources = null;
        logger.debug((Object)("getting sources from url=" + serverURL));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        headers.set(DasHeadersEnum.X_DAS_VERSION.toString(), DasSpec.SPEC1_6E.toString());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            response = this.restTemp.exchange(serverURL, HttpMethod.GET, entity, SOURCES.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        this.respHeaders = response.getHeaders();
        this.printHeaders();
        dasSources = (SOURCES)response.getBody();
        return dasSources;
    }

    @Override
    public SOURCES fetchDataRegistry(String serverURL, String capability, String type, String authority, String version, String organism, String label) throws ValidationException, DASClientException {
        String url = String.valueOf(serverURL) + "/sources";
        String arguments = null;
        if (capability != null) {
            arguments = "capability=" + capability;
        }
        if (type != null) {
            String string = arguments = arguments == null ? "type=" + type : String.valueOf(arguments) + "&type=" + type;
        }
        if (authority != null) {
            String string = arguments = arguments == null ? "authority=" + authority : String.valueOf(arguments) + "&authority=" + authority;
        }
        if (version != null) {
            String string = arguments = arguments == null ? "version=" + version : String.valueOf(arguments) + "&version=" + version;
        }
        if (organism != null) {
            String string = arguments = arguments == null ? "organism=" + organism : String.valueOf(arguments) + "&organism=" + organism;
        }
        if (label != null) {
            String string = arguments = arguments == null ? "label=" + label : String.valueOf(arguments) + "&label=" + label;
        }
        if (arguments != null) {
            url = String.valueOf(url) + "?" + arguments;
        }
        return this.fetchData(url);
    }

    public SOURCES postSource(SOURCES sources, String user, String pass) throws DASClientException {
        return this.postSource(sources, user, pass, "http://www.dasregistry.org/das/sources/");
    }

    public SOURCES postSource(SOURCES sourcesToCreate, String user, String pass, String registrySourcesUrl) throws DASClientException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity entity = new HttpEntity((Object)sourcesToCreate, (MultiValueMap)headers);
        ResponseEntity responseBody = null;
        try {
            responseBody = this.restTemp.exchange(registrySourcesUrl, HttpMethod.POST, entity, SOURCES.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        logger.info((Object)responseBody.getStatusCode());
        if (!"201".equals(responseBody.getStatusCode().toString())) {
            throw new DASClientException("The response HTML code was not 201");
        }
        SOURCES sources = (SOURCES)responseBody.getBody();
        return sources;
    }

    public DasSpec getDasVersion() {
        HttpHeaders respHeaders = this.getRespHeaders();
        List version = null;
        if (respHeaders.containsKey((Object)DasHeadersEnum.X_DAS_VERSION.toString())) {
            version = respHeaders.get((Object)DasHeadersEnum.X_DAS_VERSION.toString());
            System.out.println((String)version.get(0));
            return DasSpec.convertToRegistrySpecification((String)version.get(0));
        }
        return DasSpec.SPEC1_53E;
    }

    private void printHeaders() {
        Set keyset = this.respHeaders.keySet();
        for (String key : keyset) {
            System.out.println("header key " + key + "=" + this.respHeaders.get((Object)key));
        }
    }
}

