/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.biodas.jdas.client.ConnectionPropertyProviderI;
import org.biodas.jdas.client.NoDtdJaxbParser;
import org.biodas.jdas.client.SequenceClientInterface;
import org.biodas.jdas.client.adapters.sequence.DasSequenceAdapter;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.schema.sequence.DASSEQUENCE;

public class SequenceClient
implements SequenceClientInterface {
    ConnectionPropertyProviderI connectionProps = null;

    public SequenceClient() {
    }

    public SequenceClient(ConnectionPropertyProviderI connProps) {
        this.connectionProps = connProps;
    }

    private DasSequenceAdapter fetchData(String serverURL, String arguments) throws DASClientException {
        try {
            if (!serverURL.endsWith("/")) {
                serverURL = String.valueOf(serverURL) + "/";
            }
            String url = String.valueOf(serverURL) + "sequence" + arguments;
            NoDtdJaxbParser parser = new NoDtdJaxbParser();
            return new DasSequenceAdapter((DASSEQUENCE)parser.parseXmlUrl(url, "org.biodas.jdas.schema.sequence", this.connectionProps));
        }
        catch (IOException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        catch (JAXBException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public DasSequenceAdapter fetchData(String serverURL, List<String> segments) throws DASClientException {
        String arguments = "";
        String segmentArguments = null;
        if (segments != null && segments.size() != 0) {
            segmentArguments = "";
            for (String segment : segments) {
                segmentArguments = String.valueOf(segmentArguments) + ";segment=" + segment;
            }
            segmentArguments = segmentArguments.substring(1);
        }
        if (segmentArguments != null) {
            arguments = String.valueOf(arguments) + "?" + segmentArguments;
        }
        return this.fetchData(serverURL, arguments);
    }
}

