/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Logger;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.schema.registrycoordinates.DASCOORDINATESYSTEM;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class RegistryCoordinatesCrudClient {
    private static Logger logger = Logger.getLogger(RegistryCoordinatesCrudClient.class);
    private final RestTemplate restTemp;
    private final UsernamePasswordCredentials credentials;

    public RegistryCoordinatesCrudClient(String username, String password) {
        HttpClientParams params = new HttpClientParams();
        params.setAuthenticationPreemptive(true);
        params.setConnectionManagerClass(MultiThreadedHttpConnectionManager.class);
        HttpClient httpClient = new HttpClient(params);
        CommonsClientHttpRequestFactory clientRequestFactory = new CommonsClientHttpRequestFactory(httpClient);
        this.restTemp = new RestTemplate((ClientHttpRequestFactory)clientRequestFactory);
        this.credentials = new UsernamePasswordCredentials(username, password);
        CommonsClientHttpRequestFactory factory = (CommonsClientHttpRequestFactory)this.restTemp.getRequestFactory();
        HttpClient client = factory.getHttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)this.credentials);
    }

    public DASCOORDINATESYSTEM postCoordinate(DASCOORDINATESYSTEM coord, String coordsUrl) throws DASClientException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity entity = new HttpEntity((Object)coord, (MultiValueMap)headers);
        ResponseEntity responseBody = null;
        try {
            responseBody = this.restTemp.exchange(coordsUrl, HttpMethod.POST, entity, DASCOORDINATESYSTEM.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        if (!"201".equals(responseBody.getStatusCode().toString())) {
            throw new DASClientException("The response HTML code was not 201");
        }
        DASCOORDINATESYSTEM coordinatesNew = (DASCOORDINATESYSTEM)responseBody.getBody();
        System.out.println(coordinatesNew);
        return coordinatesNew;
    }
}

