/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.ConnectionPropertyProviderI;
import org.biodas.jdas.client.FeaturesClientInterface;
import org.biodas.jdas.client.NoDtdJaxbParser;
import org.biodas.jdas.client.adapters.features.DasGFFAdapter;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.schema.features.DASGFF;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class FeaturesClient
implements FeaturesClientInterface {
    RestTemplate restTemp = new RestTemplate();
    private static Logger logger = Logger.getLogger(FeaturesClient.class);
    ConnectionPropertyProviderI connectionProps = null;

    public FeaturesClient() {
    }

    public FeaturesClient(ConnectionPropertyProviderI connProps) {
        this.connectionProps = connProps;
    }

    public DasGFFAdapter fetchData(String serverURL, String arguments) throws DASClientException {
        if (!serverURL.endsWith("/")) {
            serverURL = String.valueOf(serverURL) + "/";
        }
        String url = String.valueOf(serverURL) + "features" + arguments;
        logger.debug((Object)("url=" + url));
        NoDtdJaxbParser parser = new NoDtdJaxbParser();
        try {
            return new DasGFFAdapter((DASGFF)parser.parseXmlUrl(url, "org.biodas.jdas.schema.features", this.connectionProps));
        }
        catch (IOException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        catch (JAXBException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public DasGFFAdapter fetchData(String serverURL, List<String> segments) throws DASClientException {
        return this.fetchData(serverURL, segments, null, null, null, null, null);
    }

    @Override
    public DasGFFAdapter fetchDataWithTypes(String serverURL, List<String> segments, List<String> types) throws DASClientException {
        return this.fetchData(serverURL, segments, types, null, null, null, null);
    }

    @Override
    public DasGFFAdapter fetchDataWithFeatueIds(String serverURL, List<String> segments, List<String> featureIds) throws DASClientException {
        return this.fetchData(serverURL, segments, null, null, null, featureIds, null);
    }

    @Override
    public DasGFFAdapter fetchData(String serverURL, List<String> segments, List<String> types, List<String> categories, String categorize, List<String> featureIds, String maxbins) throws DASClientException {
        String segmentArguments = null;
        if (segments != null && segments.size() != 0) {
            segmentArguments = "";
            for (String segment : segments) {
                segmentArguments = String.valueOf(segmentArguments) + ";segment=" + segment;
            }
            segmentArguments = segmentArguments.substring(1);
        }
        String typeArguments = null;
        if (types != null && types.size() != 0) {
            typeArguments = "";
            for (String type : types) {
                typeArguments = String.valueOf(typeArguments) + ";type=" + type;
            }
            typeArguments = typeArguments.substring(1);
        }
        String categoryArguments = null;
        if (categories != null && categories.size() != 0) {
            categoryArguments = "";
            for (String category : categories) {
                categoryArguments = String.valueOf(categoryArguments) + ";category=" + category;
            }
            categoryArguments = categoryArguments.substring(1);
        }
        String featureIdArguments = null;
        if (featureIds != null && featureIds.size() != 0) {
            featureIdArguments = "";
            for (String featureId : featureIds) {
                featureIdArguments = String.valueOf(featureIdArguments) + ";feature_id=" + featureId;
            }
            featureIdArguments = featureIdArguments.substring(1);
        }
        String arguments = null;
        if (segmentArguments != null) {
            arguments = segmentArguments;
        }
        if (typeArguments != null) {
            String string = arguments = arguments == null ? typeArguments : String.valueOf(arguments) + ";" + typeArguments;
        }
        if (categoryArguments != null) {
            String string = arguments = arguments == null ? categoryArguments : String.valueOf(arguments) + ";" + categoryArguments;
        }
        if (featureIdArguments != null) {
            String string = arguments = arguments == null ? featureIdArguments : String.valueOf(arguments) + ";" + featureIdArguments;
        }
        if (categorize != null) {
            String string = arguments = arguments == null ? "categorize=" + categorize : String.valueOf(arguments) + ";categorize=" + categorize;
        }
        if (maxbins != null) {
            arguments = arguments == null ? "maxbins=" + maxbins : String.valueOf(arguments) + ";maxbins=" + maxbins;
        }
        arguments = arguments == null ? "" : "?" + arguments;
        return this.fetchData(serverURL, arguments);
    }

    @Override
    public DasGFFAdapter postFeatures(String url, DasGFFAdapter dasgff, String user, String pass) throws DASClientException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity entity = new HttpEntity((Object)dasgff, (MultiValueMap)headers);
        ResponseEntity responseBody = null;
        try {
            responseBody = this.restTemp.exchange(url, HttpMethod.POST, entity, DASGFF.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            throw new DASClientException(e.getMessage(), e.getCause());
        }
        logger.info((Object)responseBody.getStatusCode());
        if (!"201".equals(responseBody.getStatusCode().toString())) {
            throw new DASClientException("The response HTML code is not 201");
        }
        DasGFFAdapter featuresCreated = new DasGFFAdapter((DASGFF)responseBody.getBody());
        return new DasGFFAdapter(featuresCreated);
    }
}

