/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.FileNameExtensionFilter;
import fr.orsay.lri.varna.applications.VARNAPrinter;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionJPEGEncoding;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.VARNAEdits;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.views.VueAboutPanel;
import fr.orsay.lri.varna.views.VueAnnotation;
import fr.orsay.lri.varna.views.VueBPHeightIncrement;
import fr.orsay.lri.varna.views.VueBPList;
import fr.orsay.lri.varna.views.VueBPThickness;
import fr.orsay.lri.varna.views.VueBPType;
import fr.orsay.lri.varna.views.VueBaseValues;
import fr.orsay.lri.varna.views.VueBases;
import fr.orsay.lri.varna.views.VueBorder;
import fr.orsay.lri.varna.views.VueChemProbAnnotation;
import fr.orsay.lri.varna.views.VueColorMapStyle;
import fr.orsay.lri.varna.views.VueFont;
import fr.orsay.lri.varna.views.VueGlobalRescale;
import fr.orsay.lri.varna.views.VueGlobalRotation;
import fr.orsay.lri.varna.views.VueHighlightRegionEdit;
import fr.orsay.lri.varna.views.VueJPEG;
import fr.orsay.lri.varna.views.VueListeAnnotations;
import fr.orsay.lri.varna.views.VueLoadColorMapValues;
import fr.orsay.lri.varna.views.VueManualInput;
import fr.orsay.lri.varna.views.VueNumPeriod;
import fr.orsay.lri.varna.views.VueRNAList;
import fr.orsay.lri.varna.views.VueSpaceBetweenBases;
import fr.orsay.lri.varna.views.VueStyleBP;
import fr.orsay.lri.varna.views.VueZoom;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class VueUI {
    private VARNAPanel _vp;
    private File _fileChooserDirectory = null;
    private UndoableEditSupport _undoableEditSupport;
    FileNameExtensionFilter _varnaFilter = new FileNameExtensionFilter("VARNA Session File", "varna", "VARNA");
    FileNameExtensionFilter _bpseqFilter = new FileNameExtensionFilter("BPSeq (CRW) File", "bpseq", "BPSEQ");
    FileNameExtensionFilter _ctFilter = new FileNameExtensionFilter("Connect (MFold) File", "ct", "CT");
    FileNameExtensionFilter _dbnFilter = new FileNameExtensionFilter("Dot-bracket notation (Vienna) File", "dbn", "DBN", "faa", "FAA");
    FileNameExtensionFilter _jpgFilter = new FileNameExtensionFilter("JPEG Picture", "jpeg", "jpg", "JPG", "JPEG");
    FileNameExtensionFilter _pngFilter = new FileNameExtensionFilter("PNG Picture", "png", "PNG");
    FileNameExtensionFilter _epsFilter = new FileNameExtensionFilter("EPS File", "eps", "EPS");
    FileNameExtensionFilter _svgFilter = new FileNameExtensionFilter("SVG Picture", "svg", "SVG");
    FileNameExtensionFilter _xfigFilter = new FileNameExtensionFilter("XFig Diagram", "fig", "xfig", "FIG", "XFIG");

    public VueUI(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this._undoableEditSupport = new UndoableEditSupport(this._vp);
    }

    public void addUndoableEditListener(UndoManager undoManager) {
        this._undoableEditSupport.addUndoableEditListener(undoManager);
    }

    public void UIToggleColorMap() {
        if (this._vp.isModifiable()) {
            this._vp.setColorMapVisible(!this._vp.getColorMapVisible());
            this._vp.repaint();
        }
    }

    public Hashtable<Integer, Point2D.Double> backupAllCoords() {
        Hashtable<Integer, Point2D.Double> hashtable = new Hashtable<Integer, Point2D.Double>();
        for (int i = 0; i < this._vp.getRNA().getSize(); ++i) {
            hashtable.put(i, this._vp.getRNA().getCoords(i));
        }
        return hashtable;
    }

    public void UIToggleFlatExteriorLoop() {
        if (this._vp.isModifiable() && this._vp.getRNA().get_drawMode() == 2) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(2, this._vp, !this._vp.getFlatExteriorLoop()));
            this._vp.setFlatExteriorLoop(!this._vp.getFlatExteriorLoop());
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 2);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIRadiate() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(2, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 2);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIMOTIFView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(6, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 6);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UILine() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(4, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 4);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UICircular() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(1, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 1);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UINAView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(3, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 3);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIVARNAView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(5, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 5);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIReset() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(this._vp.getRNA().get_drawMode(), this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), this._vp.getRNA().get_drawMode());
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    private void savePath(JFileChooser jFileChooser) {
        this._fileChooserDirectory = jFileChooser.getCurrentDirectory();
    }

    private void loadPath(JFileChooser jFileChooser) {
        if (this._fileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(this._fileChooserDirectory);
        }
    }

    public void UIChooseRNAs(ArrayList<RNA> arrayList) {
        if (arrayList.size() > 5) {
            VueRNAList vueRNAList = new VueRNAList(arrayList);
            if (JOptionPane.showConfirmDialog(this._vp, vueRNAList, "Select imported sequence/structures", 2) == 0) {
                for (RNA rNA : vueRNAList.getSelectedRNAs()) {
                    try {
                        rNA.drawRNA(this._vp.getConfig());
                    }
                    catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                        exceptionNAViewAlgorithm.printStackTrace();
                    }
                    this._vp.showRNA(rNA);
                }
                this._vp.repaint();
            }
        } else {
            for (RNA rNA : arrayList) {
                try {
                    rNA.drawRNA(this._vp.getConfig());
                }
                catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                    exceptionNAViewAlgorithm.printStackTrace();
                }
                this._vp.showRNA(rNA);
            }
            this._vp.repaint();
        }
    }

    public void UIFile() throws ExceptionNonEqualLength {
        if (this._vp.isModifiable()) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle("Open...");
            this.loadPath(jFileChooser);
            if (jFileChooser.showOpenDialog(this._vp) == 0) {
                try {
                    this.savePath(jFileChooser);
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (!string.toLowerCase().endsWith(".varna")) {
                        ArrayList<RNA> arrayList = RNAFactory.loadSecStr(string);
                        if (arrayList.isEmpty()) {
                            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
                        }
                        this.UIChooseRNAs(arrayList);
                    } else {
                        FullBackup fullBackup = this._vp.loadSession(string);
                    }
                }
                catch (ExceptionExportFailed exceptionExportFailed) {
                    this._vp.errorDialog(exceptionExportFailed);
                }
                catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                    this._vp.errorDialog(exceptionPermissionDenied);
                }
                catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                    this._vp.errorDialog(exceptionLoadingFailed);
                }
                catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                    this._vp.errorDialog(exceptionFileFormatOrSyntax);
                }
                catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    this._vp.errorDialog(exceptionUnmatchedClosingParentheses);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this._vp.errorDialog(fileNotFoundException);
                }
            }
        }
    }

    public void UISetColorMapStyle() {
        VueColorMapStyle vueColorMapStyle = new VueColorMapStyle(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, vueColorMapStyle, "Choose color map style", 2) == 0) {
            this._vp.setColorMap(vueColorMapStyle.getColorMap());
        } else {
            vueColorMapStyle.cancelChanges();
        }
    }

    public void UILoadColorMapValues() {
        VueLoadColorMapValues vueLoadColorMapValues = new VueLoadColorMapValues(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, vueLoadColorMapValues, "Load base values", 2) == 0) {
            try {
                this._vp.setColorMapVisible(true);
                this._vp.readValues(vueLoadColorMapValues.getReader());
            }
            catch (IOException iOException) {
                this._vp.errorDialog(iOException);
            }
        }
    }

    public void UISetColorMapValues() {
        VueBaseValues vueBaseValues = new VueBaseValues(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, vueBaseValues, "Choose base values", 2) != 0) {
            vueBaseValues.cancelChanges();
        }
    }

    public void UIManualInput() throws ParseException, ExceptionNonEqualLength {
        VueManualInput vueManualInput;
        if (this._vp.isModifiable() && JOptionPane.showConfirmDialog(this._vp, (vueManualInput = new VueManualInput(this._vp)).getPanel(), "Input sequence/structure", 2) == 0) {
            if (this._vp.getRNA().getSize() == 0) {
                // empty if block
            }
            try {
                RNA rNA = new RNA();
                VARNAConfig vARNAConfig = new VARNAConfig();
                rNA.setRNA(vueManualInput.getTseq().getText(), vueManualInput.getTstr().getText());
                rNA.drawRNA(this._vp.getRNA().get_drawMode(), vARNAConfig);
                this._vp.drawRNAInterpolated(rNA);
                this._vp.repaint();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                exceptionFileFormatOrSyntax.printStackTrace();
            }
            catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                exceptionNAViewAlgorithm.printStackTrace();
            }
        }
    }

    public void UISetTitle() {
        String string;
        if (this._vp.isModifiable() && (string = JOptionPane.showInputDialog(this._vp, "Input title", this._vp.getTitle())) != null) {
            this._vp.setTitle(string);
            this._vp.repaint();
        }
    }

    public void UISetColorMapCaption() {
        String string;
        if (this._vp.isModifiable() && (string = JOptionPane.showInputDialog(this._vp, "Input new color map caption", this._vp.getColorMapCaption())) != null) {
            this._vp.setColorMapCaption(string);
            this._vp.repaint();
        }
    }

    public void UISetBaseCharacter() {
        if (this._vp.isModifiable()) {
            int n = this._vp.getNearestBase();
            if (this._vp.isComparisonMode()) {
                String string = JOptionPane.showInputDialog(this._vp, "Input base", ((ModeleBasesComparison)this._vp.getRNA().get_listeBases().get(n)).getBases());
                if (string != null) {
                    ModeleBasesComparison modeleBasesComparison = (ModeleBasesComparison)this._vp.getRNA().get_listeBases().get(n);
                    String string2 = modeleBasesComparison.getBase1() + "|" + modeleBasesComparison.getBase2();
                    modeleBasesComparison.setBase1(Character.valueOf(string.length() > 0 ? string.charAt(0) : (char)' '));
                    modeleBasesComparison.setBase2(Character.valueOf(string.length() > 1 ? string.charAt(1) : (char)' '));
                    this._vp.repaint();
                    this._vp.fireSequenceChanged(n, string2, string);
                }
            } else {
                String string = JOptionPane.showInputDialog(this._vp, "Input base", ((ModeleBaseNucleotide)this._vp.getRNA().get_listeBases().get(n)).getBase());
                if (string != null) {
                    ModeleBaseNucleotide modeleBaseNucleotide = (ModeleBaseNucleotide)this._vp.getRNA().get_listeBases().get(n);
                    String string3 = modeleBaseNucleotide.getBase();
                    modeleBaseNucleotide.setBase(string);
                    this._vp.repaint();
                    this._vp.fireSequenceChanged(n, string3, string);
                }
            }
        }
    }

    public void UIExport() throws ExceptionExportFailed, ExceptionPermissionDenied, ExceptionWritingForbidden, ExceptionJPEGEncoding {
        ArrayList<FileNameExtensionFilter> arrayList = new ArrayList<FileNameExtensionFilter>();
        arrayList.add(this._epsFilter);
        arrayList.add(this._svgFilter);
        arrayList.add(this._xfigFilter);
        arrayList.add(this._jpgFilter);
        arrayList.add(this._pngFilter);
        String string = this.UIChooseOutputFile(arrayList);
        if (string != null) {
            String string2 = string.substring(string.lastIndexOf(46)).toLowerCase();
            if (string2.equals(".eps")) {
                this._vp.getRNA().saveRNAEPS(string, this._vp.getConfig());
            } else if (string2.equals(".svg")) {
                this._vp.getRNA().saveRNASVG(string, this._vp.getConfig());
            } else if (string2.equals(".fig") || string2.equals("xfig")) {
                this._vp.getRNA().saveRNAXFIG(string, this._vp.getConfig());
            } else if (string2.equals(".png")) {
                this.saveToPNG(string);
            } else if (string2.equals("jpg") || string2.equals("jpeg")) {
                this.saveToJPEG(string);
            }
        }
    }

    public void UIExportJPEG() throws ExceptionJPEGEncoding, ExceptionExportFailed {
        String string = this.UIChooseOutputFile(this._jpgFilter);
        if (string != null) {
            this.saveToJPEG(string);
        }
    }

    public void UIPrint() {
        VARNAPrinter.printComponent(this._vp);
    }

    public void UIExportPNG() throws ExceptionExportFailed {
        String string = this.UIChooseOutputFile(this._pngFilter);
        if (string != null) {
            this.saveToPNG(string);
        }
    }

    public void UIExportXFIG() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String string = this.UIChooseOutputFile(this._xfigFilter);
        if (string != null) {
            this._vp.getRNA().saveRNAXFIG(string, this._vp.getConfig());
        }
    }

    public void UIExportEPS() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String string = this.UIChooseOutputFile(this._epsFilter);
        if (string != null) {
            this._vp.getRNA().saveRNAEPS(string, this._vp.getConfig());
        }
    }

    public void UIExportSVG() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String string = this.UIChooseOutputFile(this._svgFilter);
        if (string != null) {
            this._vp.getRNA().saveRNASVG(string, this._vp.getConfig());
        }
    }

    public void UISaveAsDBN() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String string = this._vp.getVARNAUI().UIChooseOutputFile(this._dbnFilter);
        if (string != null) {
            this._vp.getRNA().saveAsDBN(string, this._vp.getTitle());
        }
    }

    public void UISaveAsCT() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String string = this._vp.getVARNAUI().UIChooseOutputFile(this._ctFilter);
        if (string != null) {
            this._vp.getRNA().saveAsCT(string, this._vp.getTitle());
        }
    }

    public void UISaveAsBPSEQ() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String string = this._vp.getVARNAUI().UIChooseOutputFile(this._bpseqFilter);
        if (string != null) {
            this._vp.getRNA().saveAsBPSEQ(string, this._vp.getTitle());
        }
    }

    public void UISaveAs() throws ExceptionExportFailed, ExceptionPermissionDenied {
        ArrayList<FileNameExtensionFilter> arrayList = new ArrayList<FileNameExtensionFilter>();
        arrayList.add(this._bpseqFilter);
        arrayList.add(this._dbnFilter);
        arrayList.add(this._ctFilter);
        arrayList.add(this._varnaFilter);
        String string = this.UIChooseOutputFile(arrayList);
        if (string != null) {
            String string2 = string.substring(string.lastIndexOf(46)).toLowerCase();
            if (string2.endsWith("bpseq")) {
                this._vp.getRNA().saveAsBPSEQ(string, this._vp.getTitle());
            } else if (string2.endsWith("ct")) {
                this._vp.getRNA().saveAsCT(string, this._vp.getTitle());
            } else if (string2.endsWith("dbn") || string2.endsWith("faa")) {
                this._vp.getRNA().saveAsDBN(string, this._vp.getTitle());
            } else if (string2.endsWith("varna")) {
                this._vp.saveSession(string);
            }
        }
    }

    public String UIChooseOutputFile(FileNameExtensionFilter fileNameExtensionFilter) {
        ArrayList<FileNameExtensionFilter> arrayList = new ArrayList<FileNameExtensionFilter>();
        arrayList.add(fileNameExtensionFilter);
        return this.UIChooseOutputFile(arrayList);
    }

    public String UIChooseOutputFile(ArrayList<FileNameExtensionFilter> arrayList) {
        JFileChooser jFileChooser = new JFileChooser();
        this.loadPath(jFileChooser);
        String string = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            jFileChooser.addChoosableFileFilter(arrayList.get(i));
        }
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle("Save...");
        if (jFileChooser.showSaveDialog(this._vp) == 0) {
            this.savePath(jFileChooser);
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            String string2 = this._vp.getPopupMenu().get_controleurMenu().getExtension(jFileChooser.getSelectedFile());
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter instanceof FileNameExtensionFilter) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.addAll(Arrays.asList(((FileNameExtensionFilter)fileFilter).getExtensions()));
                if (!arrayList2.contains(string2)) {
                    string = string + "." + (String)arrayList2.get(0);
                }
            }
        }
        return string;
    }

    public void UISetBorder() {
        VueBorder vueBorder = new VueBorder(this._vp);
        Dimension dimension = this._vp.getBorderSize();
        this._vp.drawBBox(true);
        this._vp.drawBorder(true);
        this._vp.repaint();
        if (JOptionPane.showConfirmDialog(this._vp, vueBorder.getPanel(), "Set new border size", 2) != 0) {
            this._vp.setBorderSize(dimension);
        }
        this._vp.drawBorder(false);
        this._vp.drawBBox(false);
        this._vp.repaint();
    }

    public void UISetBackground() {
        Color color = JColorChooser.showDialog(this._vp, "Choose new background color", this._vp.getBackground());
        if (color != null) {
            this._vp.setBackground(color);
            this._vp.repaint();
        }
    }

    public void UIZoomIn() {
        double d = this._vp.getZoom();
        double d2 = this._vp.getZoomIncrement();
        Point point = this._vp.getTranslation();
        double d3 = Math.min(60.0, d * d2);
        double d4 = d3 / d;
        Point point2 = new Point((int)((double)point.x * d4), (int)((double)point.y * d4));
        this._vp.setZoom(d3);
        this._vp.setTranslation(point2);
        this._vp.checkTranslation();
        this._vp.repaint();
    }

    public void UIZoomOut() {
        double d = this._vp.getZoom();
        double d2 = this._vp.getZoomIncrement();
        Point point = this._vp.getTranslation();
        double d3 = Math.max(d / d2, 0.5);
        double d4 = d3 / d;
        Point point2 = new Point((int)((double)point.x * d4), (int)((double)point.y * d4));
        this._vp.setZoom(d3);
        this._vp.setTranslation(point2);
        this._vp.checkTranslation();
        this._vp.repaint();
    }

    public void UICustomZoom() {
        VueZoom vueZoom = new VueZoom(this._vp);
        double d = this._vp.getZoom();
        double d2 = this._vp.getZoomIncrement();
        this._vp.drawBBox(true);
        this._vp.repaint();
        if (JOptionPane.showConfirmDialog(this._vp, vueZoom.getPanel(), "Set zoom", 2) != 0) {
            this._vp.setZoom(d);
            this._vp.setZoomIncrement(d2);
        }
        this._vp.drawBBox(false);
        this._vp.repaint();
    }

    public void UIGlobalRescale() {
        if (this._vp.isModifiable() && this._vp.getRNA().get_listeBases().size() > 0) {
            VueGlobalRescale vueGlobalRescale = new VueGlobalRescale(this._vp);
            if (JOptionPane.showConfirmDialog(this._vp, vueGlobalRescale.getPanel(), "Rescales the whole RNA (No redraw)", 2) != 0) {
                this.UIGlobalRescale(1.0 / vueGlobalRescale.getScale());
            }
            this._vp.drawBBox(false);
            this._vp.repaint();
        }
    }

    public void UIGlobalRescale(double d) {
        if (this._vp.isModifiable() && this._vp.getRNA().get_listeBases().size() > 0) {
            this._vp.globalRescale(d);
            this._undoableEditSupport.postEdit(new VARNAEdits.RescaleRNAEdit(d, this._vp));
        }
    }

    public void UIGlobalRotation() {
        if (this._vp.isModifiable() && this._vp.getRNA().get_listeBases().size() > 0) {
            this._vp.drawBBox(true);
            this._vp.repaint();
            VueGlobalRotation vueGlobalRotation = new VueGlobalRotation(this._vp);
            if (JOptionPane.showConfirmDialog(this._vp, vueGlobalRotation.getPanel(), "Rotates the whole RNA", 2) != 0) {
                this.UIGlobalRotation(-vueGlobalRotation.getAngle());
            }
            this._vp.drawBBox(false);
            this._vp.repaint();
        }
    }

    public void UIGlobalRotation(double d) {
        if (this._vp.isModifiable() && this._vp.getRNA().get_listeBases().size() > 0) {
            this._vp.globalRotation(d);
            this._undoableEditSupport.postEdit(new VARNAEdits.RotateRNAEdit(d, this._vp));
        }
    }

    public void UISetBPStyle() {
        if (this._vp.getRNA().get_listeBases().size() > 0) {
            VueStyleBP vueStyleBP = new VueStyleBP(this._vp);
            VARNAConfig.BP_STYLE bP_STYLE = this._vp.getBPStyle();
            if (JOptionPane.showConfirmDialog(this._vp, vueStyleBP.getPanel(), "Set main base pair style", 2) != 0) {
                this._vp.setBPStyle(bP_STYLE);
                this._vp.repaint();
            }
        }
    }

    public void UISetTitleColor() {
        Color color;
        if (this._vp.isModifiable() && (color = JColorChooser.showDialog(this._vp, "Choose new title color", this._vp.getTitleColor())) != null) {
            this._vp.setTitleColor(color);
            this._vp.repaint();
        }
    }

    public void UISetBackboneColor() {
        Color color;
        if (this._vp.isModifiable() && (color = JColorChooser.showDialog(this._vp, "Choose new backbone color", this._vp.getBackboneColor())) != null) {
            this._vp.setBackboneColor(color);
            this._vp.repaint();
        }
    }

    public void UISetTitleFont() {
        VueFont vueFont;
        if (this._vp.isModifiable() && JOptionPane.showConfirmDialog(this._vp, (vueFont = new VueFont(this._vp)).getPanel(), "New Title font", 2) == 0) {
            this._vp.setTitleFont(vueFont.getFont());
            this._vp.repaint();
        }
    }

    public void UISetSpaceBetweenBases() {
        if (this._vp.isModifiable()) {
            VueSpaceBetweenBases vueSpaceBetweenBases = new VueSpaceBetweenBases(this._vp);
            Double d = this._vp.getSpaceBetweenBases();
            if (JOptionPane.showConfirmDialog(this._vp, vueSpaceBetweenBases.getPanel(), "Set the space between each base", 2) != 0) {
                this._vp.setSpaceBetweenBases(d);
                this._vp.drawRNA(this._vp.getRNA());
                this._vp.repaint();
            }
        }
    }

    public void UISetBPHeightIncrement() {
        if (this._vp.isModifiable()) {
            VueBPHeightIncrement vueBPHeightIncrement = new VueBPHeightIncrement(this._vp);
            Double d = this._vp.getBPHeightIncrement();
            if (JOptionPane.showConfirmDialog(this._vp, vueBPHeightIncrement.getPanel(), "Set the vertical increment in linear mode", 2) != 0) {
                this._vp.setBPHeightIncrement(d);
                this._vp.drawRNA(this._vp.getRNA());
                this._vp.repaint();
            }
        }
    }

    public void UISetNumPeriod() {
        if (this._vp.getRNA().get_listeBases().size() != 0) {
            int n = this._vp.getNumPeriod();
            VueNumPeriod vueNumPeriod = new VueNumPeriod(this._vp);
            if (JOptionPane.showConfirmDialog(this._vp, vueNumPeriod.getPanel(), "Set new numbering period", 2) != 0) {
                this._vp.setNumPeriod(n);
                this._vp.repaint();
            }
        }
    }

    public void UIEditBasePair() {
        ModeleBase modeleBase;
        if (this._vp.isModifiable() && (modeleBase = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1) {
            ModeleBP modeleBP = modeleBase.getStyleBP();
            ModeleBP.Edge edge = modeleBP.getEdgePartner5();
            ModeleBP.Edge edge2 = modeleBP.getEdgePartner3();
            ModeleBP.Stericity stericity = modeleBP.getStericity();
            VueBPType vueBPType = new VueBPType(this._vp, modeleBP);
            if (JOptionPane.showConfirmDialog(this._vp, vueBPType.getPanel(), "Set base pair L/W type", 2) != 0) {
                modeleBP.setEdge5(edge);
                modeleBP.setEdge3(edge2);
                modeleBP.setStericity(stericity);
                this._vp.repaint();
            }
        }
    }

    public void UIColorBasePair() {
        ModeleBP modeleBP;
        Color color;
        ModeleBase modeleBase;
        if (this._vp.isModifiable() && (modeleBase = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1 && (color = JColorChooser.showDialog(this._vp, "Choose custom base pair color", (modeleBP = modeleBase.getStyleBP()).getStyle().getColor(this._vp.getConfig()._bondColor))) != null) {
            modeleBP.getStyle().setCustomColor(color);
            this._vp.repaint();
        }
    }

    public void UIThicknessBasePair() {
        ModeleBase modeleBase;
        if (this._vp.isModifiable() && (modeleBase = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1) {
            ModeleBP modeleBP = modeleBase.getStyleBP();
            ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
            arrayList.add(modeleBP);
            VueBPThickness vueBPThickness = new VueBPThickness(this._vp, arrayList);
            if (JOptionPane.showConfirmDialog(this._vp, vueBPThickness.getPanel(), "Set base pair(s) thickness", 2) != 0) {
                vueBPThickness.restoreThicknesses();
                this._vp.repaint();
            }
        }
    }

    public void saveToPNG(String string) throws ExceptionExportFailed {
        VueJPEG vueJPEG = new VueJPEG(true, false);
        if (JOptionPane.showConfirmDialog(this._vp, vueJPEG.getPanel(), "Set resolution", 2) == 0) {
            Double d = (double)vueJPEG.getScaleSlider().getValue() / 100.0;
            BufferedImage bufferedImage = new BufferedImage((int)Math.round((double)this._vp.getWidth() * d), (int)Math.round((double)this._vp.getHeight() * d), 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToScale(d, d);
            graphics2D.setTransform(affineTransform);
            this._vp.paintComponent(graphics2D, !this._vp.getConfig()._drawBackground);
            graphics2D.dispose();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void saveToJPEG(String string) throws ExceptionJPEGEncoding, ExceptionExportFailed {
        VueJPEG vueJPEG = new VueJPEG(true, true);
        if (JOptionPane.showConfirmDialog(this._vp, vueJPEG.getPanel(), "Set resolution/quality", 2) == 0) {
            Double d = vueJPEG.getScaleSlider().getValue() == 0 ? Double.valueOf(0.01) : Double.valueOf((double)vueJPEG.getScaleSlider().getValue() / 100.0);
            BufferedImage bufferedImage = new BufferedImage((int)Math.round((double)this._vp.getWidth() * d), (int)Math.round((double)this._vp.getHeight() * d), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToScale(d, d);
            graphics2D.setTransform(affineTransform);
            this._vp.paintComponent(graphics2D);
            try {
                FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(new File(string));
                ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality((float)vueJPEG.getQualitySlider().getValue() / 100.0f);
                imageWriter.setOutput(fileImageOutputStream);
                IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
                imageWriter.write(null, iIOImage, imageWriteParam);
                fileImageOutputStream.close();
            }
            catch (IOException iOException) {
                throw new ExceptionExportFailed(iOException.getMessage(), string);
            }
        }
    }

    public void UIToggleShowNCBP() {
        if (this._vp.isModifiable()) {
            this._vp.setShowNonCanonicalBP(!this._vp.getShowNonCanonicalBP());
            this._vp.repaint();
        }
    }

    public void UIToggleColorSpecialBases() {
        this._vp.setColorNonStandardBases(!this._vp.getColorSpecialBases());
        this._vp.repaint();
    }

    public void UIToggleColorGapsBases() {
        this._vp.setColorGapsBases(!this._vp.getColorGapsBases());
        this._vp.repaint();
    }

    public void UIToggleShowNonPlanar() {
        if (this._vp.isModifiable()) {
            this._vp.setShowNonPlanarBP(!this._vp.getShowNonPlanarBP());
            this._vp.repaint();
        }
    }

    public void UIToggleShowWarnings() {
        this._vp.setShowWarnings(!this._vp.getShowWarnings());
        this._vp.repaint();
    }

    public void UIPickSpecialBasesColor() {
        Color color = JColorChooser.showDialog(this._vp, "Choose new special bases color", this._vp.getNonStandardBasesColor());
        if (color != null) {
            this._vp.setNonStandardBasesColor(color);
            this._vp.setColorNonStandardBases(true);
            this._vp.repaint();
        }
    }

    public void UIPickGapsBasesColor() {
        Color color = JColorChooser.showDialog(this._vp, "Choose new gaps bases color", this._vp.getGapsBasesColor());
        if (color != null) {
            this._vp.setGapsBasesColor(color);
            this._vp.setColorGapsBases(true);
            this._vp.repaint();
        }
    }

    public void UIBaseTypeColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 1);
        }
    }

    public void UIToggleModifiable() {
        this._vp.setModifiable(!this._vp.isModifiable());
    }

    public void UIBasePairTypeColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 3);
        }
    }

    public void UIBaseAllColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 2);
        }
    }

    public void UIAbout() {
        VueAboutPanel vueAboutPanel = new VueAboutPanel();
        JOptionPane.showMessageDialog(this._vp, vueAboutPanel, "About VARNA 3.9", -1);
        vueAboutPanel.gracefulStop();
    }

    public void UIAutoAnnotateHelices() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateHelices();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateStrandEnds() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateStrandEnds();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateInteriorLoops() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateInteriorLoops();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateTerminalLoops() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateTerminalLoops();
            this._vp.repaint();
        }
    }

    public void UIAnnotationRemoveFromAnnotation(TextAnnotation textAnnotation) {
        if (this._vp.isModifiable()) {
            this._vp.set_selectedAnnotation(null);
            this._vp.getListeAnnotations().remove(textAnnotation);
            this._vp.repaint();
        }
    }

    public void UIAnnotationEditFromAnnotation(TextAnnotation textAnnotation) {
        VueAnnotation vueAnnotation = textAnnotation.getType() == TextAnnotation.AnchorType.POSITION ? new VueAnnotation(this._vp, textAnnotation, false) : new VueAnnotation(this._vp, textAnnotation, true, false);
        vueAnnotation.show();
    }

    public void UIAnnotationAddFromStructure(TextAnnotation.AnchorType anchorType, ArrayList<Integer> arrayList) throws Exception {
        switch (anchorType) {
            case BASE: {
                TextAnnotation textAnnotation = new TextAnnotation("", this._vp.getRNA().get_listeBases().get(arrayList.get(0)));
                VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
                vueAnnotation.show();
                break;
            }
            case LOOP: {
                ArrayList<ModeleBase> arrayList2 = new ArrayList<ModeleBase>();
                for (Integer n : arrayList) {
                    arrayList2.add(this._vp.getRNA().get_listeBases().get(n));
                }
                TextAnnotation textAnnotation = new TextAnnotation("", arrayList2, anchorType);
                VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
                vueAnnotation.show();
                break;
            }
            case HELIX: {
                ArrayList<ModeleBase> arrayList3 = new ArrayList<ModeleBase>();
                for (Integer n : arrayList) {
                    arrayList3.add(this._vp.getRNA().get_listeBases().get(n));
                }
                TextAnnotation textAnnotation = new TextAnnotation("", arrayList3, anchorType);
                VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
                vueAnnotation.show();
                break;
            }
            default: {
                this._vp.errorDialog(new Exception("Unknown structure type"));
            }
        }
    }

    public void UIAnnotationEditFromStructure(TextAnnotation.AnchorType anchorType, ArrayList<Integer> arrayList) {
        if (this._vp.isModifiable()) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(arrayList.get(0));
            TextAnnotation textAnnotation = this._vp.getRNA().getAnnotation(anchorType, modeleBase);
            if (textAnnotation != null) {
                this.UIAnnotationEditFromAnnotation(textAnnotation);
            }
        }
    }

    public void UIAnnotationRemoveFromStructure(TextAnnotation.AnchorType anchorType, ArrayList<Integer> arrayList) {
        if (this._vp.isModifiable()) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(arrayList.get(0));
            TextAnnotation textAnnotation = this._vp.getRNA().getAnnotation(anchorType, modeleBase);
            if (textAnnotation != null) {
                this.UIAnnotationRemoveFromAnnotation(textAnnotation);
            }
        }
    }

    public void UIAnnotationsAddPosition(int n, int n2) {
        if (this._vp.isModifiable()) {
            Point2D.Double double_ = this._vp.panelToLogicPoint(new Point2D.Double(n, n2));
            VueAnnotation vueAnnotation = new VueAnnotation(this._vp, (int)double_.x, (int)double_.y);
            vueAnnotation.show();
        }
    }

    public void UIAnnotationsAddBase(int n, int n2) {
        ModeleBase modeleBase;
        if (this._vp.isModifiable() && (modeleBase = this._vp.getBaseAt(new Point2D.Double(n, n2))) != null) {
            this._vp.highlightSelectedBase(modeleBase);
            TextAnnotation textAnnotation = new TextAnnotation("", modeleBase);
            VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
            vueAnnotation.show();
        }
    }

    public void UIAnnotationsAddLoop(int n, int n2) {
        if (this._vp.isModifiable()) {
            try {
                ModeleBase modeleBase = this._vp.getBaseAt(new Point2D.Double(n, n2));
                if (modeleBase != null) {
                    Vector<Integer> vector = this._vp.getRNA().getLoopBases(modeleBase.getIndex());
                    ArrayList<ModeleBase> arrayList = this._vp.getRNA().getBasesAt(vector);
                    TextAnnotation textAnnotation = new TextAnnotation("", arrayList, TextAnnotation.AnchorType.LOOP);
                    this._vp.setSelection((Collection<? extends ModeleBase>)arrayList);
                    VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
                    vueAnnotation.show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ModeleBase> extractMaxContiguousPortion(ArrayList<ModeleBase> arrayList) {
        void var4_7;
        ModeleBase[] modeleBaseArray = new ModeleBase[this._vp.getRNA().getSize()];
        for (int i = 0; i < modeleBaseArray.length; ++i) {
            modeleBaseArray[i] = null;
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            ModeleBase serializable2;
            modeleBaseArray[serializable2.getIndex()] = serializable2 = object.next();
        }
        object = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < modeleBaseArray.length; ++i) {
            if (modeleBaseArray[i] != null) {
                var4_7.add(modeleBaseArray[i]);
                continue;
            }
            if (var4_7.size() > ((ArrayList)object).size()) {
                object = var4_7;
            }
            ArrayList arrayList3 = new ArrayList();
        }
        if (var4_7.size() > ((ArrayList)object).size()) {
            object = var4_7;
        }
        return object;
    }

    public void UIAnnotationsAddRegion(int n, int n2) {
        if (this._vp.isModifiable()) {
            Serializable serializable;
            ArrayList<ModeleBase> arrayList = this._vp.getSelection().getBases();
            if (arrayList.size() == 0) {
                serializable = this._vp.getBaseAt(new Point2D.Double(n, n2));
                arrayList.add((ModeleBase)serializable);
            }
            arrayList = this.extractMaxContiguousPortion(this.extractMaxContiguousPortion(arrayList));
            this._vp.setSelection((Collection<? extends ModeleBase>)arrayList);
            serializable = new HighlightRegionAnnotation(arrayList);
            this._vp.addHighlightRegion((HighlightRegionAnnotation)serializable);
            VueHighlightRegionEdit vueHighlightRegionEdit = new VueHighlightRegionEdit(this._vp, (HighlightRegionAnnotation)serializable);
            if (!vueHighlightRegionEdit.show()) {
                this._vp.removeHighlightRegion((HighlightRegionAnnotation)serializable);
            }
            this._vp.clearSelection();
        }
    }

    public void UIAnnotationsAddChemProb(int n, int n2) {
        if (this._vp.isModifiable() && this._vp.getRNA().getSize() > 1) {
            Serializable serializable;
            Point2D.Double double_ = this._vp.panelToLogicPoint(new Point2D.Double(n, n2));
            ModeleBase modeleBase = this._vp.getBaseAt(new Point2D.Double(n, n2));
            Serializable serializable2 = null;
            if (modeleBase.getIndex() - 1 >= 0) {
                serializable2 = this._vp.getRNA().getBaseAt(modeleBase.getIndex() - 1);
            }
            if (modeleBase.getIndex() + 1 < this._vp.getRNA().getSize()) {
                serializable = this._vp.getRNA().getBaseAt(modeleBase.getIndex() + 1);
                if (serializable2 == null) {
                    serializable2 = serializable;
                } else if (serializable2.getCoords().distance(double_) > ((ModeleBase)serializable).getCoords().distance(double_)) {
                    serializable2 = serializable;
                }
            }
            serializable = new ArrayList<ModeleBase>();
            ((ArrayList)serializable).add(modeleBase);
            ((ArrayList)serializable).add(serializable2);
            this._vp.setSelection((Collection<? extends ModeleBase>)((Object)serializable));
            ChemProbAnnotation chemProbAnnotation = new ChemProbAnnotation(modeleBase, (ModeleBase)serializable2);
            this._vp.getRNA().addChemProbAnnotation(chemProbAnnotation);
            VueChemProbAnnotation vueChemProbAnnotation = new VueChemProbAnnotation(this._vp, chemProbAnnotation);
            if (!vueChemProbAnnotation.show()) {
                this._vp.getRNA().removeChemProbAnnotation(chemProbAnnotation);
            }
            this._vp.clearSelection();
        }
    }

    public void UIAnnotationsAddHelix(int n, int n2) {
        if (this._vp.isModifiable()) {
            try {
                ModeleBase modeleBase = this._vp.getBaseAt(new Point2D.Double(n, n2));
                if (modeleBase != null) {
                    ArrayList<Integer> arrayList = this._vp.getRNA().findHelix(modeleBase.getIndex());
                    ArrayList<ModeleBase> arrayList2 = this._vp.getRNA().getBasesAt(arrayList);
                    TextAnnotation textAnnotation = new TextAnnotation("", arrayList2, TextAnnotation.AnchorType.HELIX);
                    this._vp.setSelection((Collection<? extends ModeleBase>)arrayList2);
                    VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, true);
                    vueAnnotation.show();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void UIToggleGaspinMode() {
        if (this._vp.isModifiable()) {
            this._vp.toggleDrawOutlineBases();
            this._vp.toggleFillBases();
            this._vp.repaint();
        }
    }

    public void UIAnnotationsAdd() {
        if (this._vp.isModifiable()) {
            VueAnnotation vueAnnotation = new VueAnnotation(this._vp);
            vueAnnotation.show();
        }
    }

    public void UIEditAllBasePairs() {
        if (this._vp.isModifiable()) {
            new VueBPList(this._vp);
        }
    }

    public void UIEditAllBases() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 2);
        }
    }

    public void UIAnnotationsRemove() {
        if (this._vp.isModifiable()) {
            new VueListeAnnotations(this._vp, 0);
        }
    }

    public void UIAnnotationsEdit() {
        if (this._vp.isModifiable()) {
            new VueListeAnnotations(this._vp, 1);
        }
    }

    public void UIAddBP(int n, int n2, ModeleBP modeleBP) {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().addBP(n, n2, modeleBP);
            this._undoableEditSupport.postEdit(new VARNAEdits.AddBPEdit(n, n2, modeleBP, this._vp));
            this._vp.repaint();
            HashSet<ModeleBP> hashSet = new HashSet<ModeleBP>();
            hashSet.add(modeleBP);
            this._vp.fireStructureChanged(new HashSet<ModeleBP>(this._vp.getRNA().getAllBPs()), hashSet, new HashSet<ModeleBP>());
        }
    }

    public void UIRemoveBP(ModeleBP modeleBP) {
        if (this._vp.isModifiable()) {
            this._undoableEditSupport.postEdit(new VARNAEdits.RemoveBPEdit(modeleBP.getIndex5(), modeleBP.getIndex3(), modeleBP, this._vp));
            this._vp.getRNA().removeBP(modeleBP);
            this._vp.repaint();
            HashSet<ModeleBP> hashSet = new HashSet<ModeleBP>();
            hashSet.add(modeleBP);
            this._vp.fireStructureChanged(new HashSet<ModeleBP>(this._vp.getRNA().getAllBPs()), new HashSet<ModeleBP>(), hashSet);
        }
    }

    public void UIShiftBaseCoord(ArrayList<Integer> arrayList, double d, double d2) {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> hashtable = new Hashtable<Integer, Point2D.Double>();
            for (int n : arrayList) {
                ModeleBase modeleBase = this._vp.getRNA().getBaseAt(n);
                Point2D.Double double_ = modeleBase.getCoords();
                hashtable.put(n, double_);
                this._vp.getRNA().setCoord(n, double_.x + d, double_.y + d2);
                this._vp.getRNA().setCenter(n, modeleBase.getCenter().x + d, modeleBase.getCenter().y + d2);
            }
            this._undoableEditSupport.postEdit(new VARNAEdits.BasesShiftEdit(arrayList, d, d2, this._vp));
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIShiftBaseCoord(ArrayList<Integer> arrayList, Point2D.Double double_) {
        this.UIShiftBaseCoord(arrayList, double_.x, double_.y);
    }

    public void UIMoveSingleBase(int n, double d, double d2) {
        if (this._vp.isModifiable()) {
            ModeleBase modeleBase = this._vp.getRNA().getBaseAt(n);
            Point2D.Double double_ = modeleBase.getCoords();
            Hashtable<Integer, Point2D.Double> hashtable = new Hashtable<Integer, Point2D.Double>();
            hashtable.put(n, double_);
            this._undoableEditSupport.postEdit(new VARNAEdits.SingleBaseMoveEdit(n, d, d2, this._vp));
            this._vp.getRNA().setCoord(n, d, d2);
            this._vp.repaint();
            this._vp.fireLayoutChanged(hashtable);
        }
    }

    public void UIMoveSingleBase(int n, Point2D.Double double_) {
        this.UIMoveSingleBase(n, double_.x, double_.y);
    }

    public void UISetBaseCenter(int n, double d, double d2) {
        this.UISetBaseCenter(n, new Point2D.Double(d, d2));
    }

    public void UISetBaseCenter(int n, Point2D.Double double_) {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().setCenter(n, double_);
        }
    }

    public void UIUndo() {
        this._vp.undo();
    }

    public void UIRedo() {
        this._vp.redo();
    }

    public void UIMoveHelixAtom(int n, Point2D.Double double_) {
        if (this._vp.isModifiable() && n >= 0 && n < this._vp.getRNA().get_listeBases().size()) {
            int n2 = this._vp.getRNA().get_listeBases().get(n).getElementStructure();
            Point point = this._vp.getRNA().getHelixInterval(n);
            Point point2 = this._vp.getRNA().getMultiLoop(point.x);
            int n3 = point2.x;
            if (n2 != -1) {
                if (n3 == 0) {
                    if (this.shouldFlip(n, double_)) {
                        this.UIFlipHelix(point);
                        this._undoableEditSupport.postEdit(new VARNAEdits.HelixFlipEdit(point, this._vp));
                    }
                } else {
                    this.UIRotateHelixAtom(n, double_);
                }
            }
            this._vp.fireLayoutChanged();
        }
    }

    private Point2D.Double project(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Point2D.Double double_4 = new Point2D.Double(double_3.x - double_.x, double_3.y - double_.y);
        double d = double_2.x * double_4.x + double_2.y * double_4.y;
        Point2D.Double double_5 = new Point2D.Double(d * double_2.x, d * double_2.y);
        Point2D.Double double_6 = new Point2D.Double(double_4.x - double_5.x, double_4.y - double_5.y);
        Point2D.Double double_7 = new Point2D.Double(double_5.x - double_6.x, double_5.y - double_6.y);
        Point2D.Double double_8 = new Point2D.Double(double_.x + double_7.x, double_.y + double_7.y);
        return double_8;
    }

    public void UIFlipHelix(Point point) {
        int n = point.x;
        int n2 = point.y;
        Point2D.Double double_ = this._vp.getRNA().getCoords(n);
        Point2D.Double double_2 = this._vp.getRNA().getCoords(n2);
        Point2D.Double double_3 = new Point2D.Double(double_2.x - double_.x, double_2.y - double_.y);
        double d = Math.sqrt(double_3.x * double_3.x + double_3.y * double_3.y);
        Point2D.Double double_4 = double_;
        Point2D.Double double_5 = new Point2D.Double(double_3.x / d, double_3.y / d);
        Hashtable<Integer, Point2D.Double> hashtable = new Hashtable<Integer, Point2D.Double>();
        for (int i = n + 1; i < n2; ++i) {
            Point2D.Double double_6 = this._vp.getRNA().getCoords(i);
            Point2D.Double double_7 = this.project(double_4, double_5, double_6);
            hashtable.put(i, double_7);
            this._vp.getRNA().setCoord(i, double_7);
            Point2D.Double double_8 = this._vp.getRNA().getCenter(i);
            this._vp.getVARNAUI().UISetBaseCenter(i, this.project(double_4, double_5, double_8));
        }
        this._vp.fireLayoutChanged(hashtable);
    }

    boolean shouldFlip(int n, Point2D.Double double_) {
        Point point = this._vp.getRNA().getHelixInterval(n);
        Point2D.Double double_2 = this._vp.getRNA().getCoords(point.x);
        Point2D.Double double_3 = this._vp.getRNA().getCoords(point.y);
        Point2D.Double double_4 = this._vp.getRNA().getCoords(point.x + 1);
        Point2D.Double double_5 = new Point2D.Double(double_3.y - double_2.y, -(double_3.x - double_2.x));
        Point2D.Double double_6 = new Point2D.Double(double_4.x - double_2.x, double_4.y - double_2.y);
        Point2D.Double double_7 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
        double d = double_5.x * double_6.x + double_5.y * double_6.y;
        double d2 = double_5.x * double_7.x + double_5.y * double_7.y;
        return d * d2 < 0.0;
    }

    public void UIRotateHelixAtom(int n, Point2D.Double double_) {
        double d;
        double d2;
        double d3;
        double d4;
        Point2D.Double double_2;
        Point2D.Double double_3;
        Point2D.Double double_4;
        Point2D.Double double_5;
        Point2D.Double double_6;
        Point2D.Double double_7;
        Point point = this._vp.getRNA().getHelixInterval(n);
        Point point2 = this._vp.getRNA().getMultiLoop(point.x);
        int n2 = point2.x;
        int n3 = point.x;
        int n4 = point.y;
        while (n2 <= point2.y) {
            int n5 = this._vp.getRNA().get_listeBases().get(n2).getElementStructure();
            if (n5 != -1 && n2 < point.x) {
                n3 = n2;
            }
            if (n5 != -1 && n2 > point.y && n4 == point.y) {
                n4 = n2;
            }
            if (n5 > n2 && n5 < point2.y) {
                n2 = this._vp.getRNA().get_listeBases().get(n2).getElementStructure();
                continue;
            }
            ++n2;
        }
        Point2D.Double double_8 = this._vp.getRNA().getCoords(n);
        boolean bl = this._vp.getRNA().testDirectionality(point2.x, point2.y, point.x);
        if (bl) {
            double_7 = this._vp.getRNA().getCoords(point2.y);
            double_6 = this._vp.getRNA().getCoords(point2.x);
            double_5 = this._vp.getRNA().getCoords(n3);
            double_4 = this._vp.getRNA().getCoords(n4);
            double_3 = this._vp.getRNA().getCoords(point.x);
            double_2 = this._vp.getRNA().getCoords(point.y);
        } else {
            double_7 = this._vp.getRNA().getCoords(point2.x);
            double_6 = this._vp.getRNA().getCoords(point2.y);
            double_5 = this._vp.getRNA().getCoords(n4);
            double_4 = this._vp.getRNA().getCoords(n3);
            double_3 = this._vp.getRNA().getCoords(point.y);
            double_2 = this._vp.getRNA().getCoords(point.x);
        }
        Point2D.Double double_9 = this._vp.getRNA().get_listeBases().get(point.x).getCenter();
        double d5 = (RNA.computeAngle(double_9, double_6) + RNA.computeAngle(double_9, double_7)) / 2.0;
        double d6 = RNA.computeAngle(double_9, double_3) - d5;
        double d7 = RNA.computeAngle(double_9, double_) - d5;
        double d8 = RNA.computeAngle(double_9, double_8) - d5;
        double d9 = RNA.computeAngle(double_9, double_2) - d5;
        double d10 = RNA.computeAngle(double_9, double_4) - d5;
        for (d4 = RNA.computeAngle(double_9, double_5) - d5; d4 < 0.0; d4 += Math.PI * 2) {
        }
        while (d6 < d4) {
            d6 += Math.PI * 2;
        }
        while (d7 < d6) {
            d7 += Math.PI * 2;
        }
        while (d8 < d6) {
            d8 += Math.PI * 2;
        }
        while (d9 < d8) {
            d9 += Math.PI * 2;
        }
        while (d10 < d9) {
            d10 += Math.PI * 2;
        }
        double d11 = this.normalizeAngle(d4 - d6 + 0.25);
        for (d3 = this.normalizeAngle(d10 - d9 - 0.25); d3 < d11; d3 += Math.PI * 2) {
        }
        for (d2 = this.normalizeAngle(d7 - d8); d2 < d11; d2 += Math.PI * 2) {
        }
        if (d2 > d3) {
            double d12 = d11 - (d2 - Math.PI * 2);
            d = d2 - d3;
            d2 = d12 < d ? d11 : d3;
        }
        d = RNA.correctHysteresis(d2 + d5 + (d6 + d9) / 2.0);
        d2 = d - (d5 + (d6 + d9) / 2.0);
        this._undoableEditSupport.postEdit(new VARNAEdits.HelixRotateEdit(d2, d5, d10, d4, point, point2, this._vp));
        this.UIRotateEverything(d2, d5, d10, d4, point, point2);
    }

    public void UIRotateEverything(double d, double d2, double d3, double d4, Point point, Point point2) {
        Hashtable<Integer, Point2D.Double> hashtable = new Hashtable<Integer, Point2D.Double>();
        this._vp.getRNA().rotateEverything(d, d2, d3, d4, point, point2, hashtable);
        this._vp.fireLayoutChanged(hashtable);
    }

    private double normalizeAngle(double d) {
        return this.normalizeAngle(d, 0.0);
    }

    private double normalizeAngle(double d, double d2) {
        while (d < d2) {
            d += Math.PI * 2;
        }
        while (d >= Math.PI * 2 - d2) {
            d -= Math.PI * 2;
        }
        return d;
    }
}

