/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.GradientEditorPanel;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VueColorMapStyle
extends JPanel
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private VARNAPanel _vp;
    private GradientEditorPanel _gp;
    private JComboBox _cb;
    private JTextField _code;
    private ModeleColorMap _backup;

    public VueColorMapStyle(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this.init();
    }

    private void init() {
        JLabel jLabel = new JLabel("Click gradient to add new color...");
        this._gp = new GradientEditorPanel(this._vp.getColorMap().clone());
        this._backup = this._vp.getColorMap();
        this._gp.setPreferredSize(new Dimension(300, 70));
        this._gp.addPropertyChangeListener(this);
        JPanel jPanel = new JPanel();
        JLabel jLabel2 = new JLabel("Param. code: ");
        this._code = new JTextField("");
        this._code.setFont(Font.decode("Monospaced-PLAIN-12"));
        this._code.setEditable(false);
        this._code.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VueColorMapStyle.this._code.setSelectionStart(0);
                VueColorMapStyle.this._code.setSelectionEnd(VueColorMapStyle.this._code.getText().length());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        ModeleColorMap.NamedColorMapTypes[] namedColorMapTypesArray = ModeleColorMap.NamedColorMapTypes.values();
        Arrays.sort(namedColorMapTypesArray, new Comparator<ModeleColorMap.NamedColorMapTypes>(){

            @Override
            public int compare(ModeleColorMap.NamedColorMapTypes namedColorMapTypes, ModeleColorMap.NamedColorMapTypes namedColorMapTypes2) {
                return namedColorMapTypes.getId().compareTo(namedColorMapTypes2.getId());
            }
        });
        Object[] objectArray = new Object[namedColorMapTypesArray.length + 1];
        int n = -1;
        for (int i = 0; i < namedColorMapTypesArray.length; ++i) {
            if (namedColorMapTypesArray[i].getColorMap().equals(this._vp.getColorMap())) {
                n = i;
            }
            objectArray[i] = namedColorMapTypesArray[i];
        }
        String string = new String("Custom...");
        objectArray[namedColorMapTypesArray.length] = string;
        this._cb = new JComboBox<Object>(objectArray);
        if (n != -1) {
            this._cb.setSelectedIndex(n);
            this._code.setText(namedColorMapTypesArray[n].getId());
        } else {
            this._cb.setSelectedItem(objectArray.length - 1);
            this._code.setText(this._gp.getColorMap().getParamEncoding());
        }
        this._cb.addItemListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jLabel2);
        jPanel.add(this._code);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this._cb);
        this.add(jLabel);
        this.add(this._gp);
        this.add(jPanel);
    }

    public void cancelChanges() {
        this._vp.setColorMap(this._backup);
    }

    public ModeleColorMap getColorMap() {
        return this._gp.getColorMap();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void refreshCode() {
        int n = -1;
        ModeleColorMap.NamedColorMapTypes namedColorMapTypes = null;
        for (int i = 0; i < this._cb.getItemCount() - 1; ++i) {
            ModeleColorMap.NamedColorMapTypes namedColorMapTypes2;
            Object e = this._cb.getItemAt(i);
            if (!(e instanceof ModeleColorMap.NamedColorMapTypes) || !(namedColorMapTypes2 = (ModeleColorMap.NamedColorMapTypes)((Object)e)).getColorMap().equals(this._gp.getColorMap())) continue;
            n = i;
            namedColorMapTypes = namedColorMapTypes2;
        }
        if (n != -1) {
            this._code.setText(namedColorMapTypes.getId());
            this._cb.setSelectedIndex(n);
        } else {
            this._code.setText(this._gp.getColorMap().getParamEncoding());
        }
        this._vp.setColorMap(this._gp.getColorMap());
        this._gp.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (itemEvent.getStateChange() == 1 && (object = itemEvent.getItem()) instanceof ModeleColorMap.NamedColorMapTypes) {
            ModeleColorMap.NamedColorMapTypes namedColorMapTypes = (ModeleColorMap.NamedColorMapTypes)((Object)object);
            this._gp.setColorMap(namedColorMapTypes.getColorMap().clone());
            this.refreshCode();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("PaletteChanged")) {
            this._cb.setSelectedIndex(this._cb.getItemCount() - 1);
            this.refreshCode();
        }
    }
}

