/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ActionEditor;
import fr.orsay.lri.varna.components.ActionRenderer;
import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class VueBPList
extends JPanel
implements TableModelListener,
ActionListener {
    private JTable table;
    private BPTableModel _tm;
    private VARNAPanel _vp;
    private ArrayList<ModeleBP> data;
    private ArrayList<Double> _backup;
    private ArrayList<Object> columns;

    public VueBPList(VARNAPanel vARNAPanel) {
        super(new GridLayout(1, 0));
        this._vp = vARNAPanel;
        this.init();
    }

    private void init() {
        Object[] objectArray = new Object[]{"Sec.Str.", "5' partner", "3' partner", "5' edge", "3' edge", "Orientation", "Remove"};
        this.columns = new ArrayList();
        for (int i = 0; i < objectArray.length; ++i) {
            this.columns.add(objectArray[i]);
        }
        this._backup = new ArrayList();
        this.data = new ArrayList();
        for (ModeleBP modeleBP : this._vp.getRNA().getAllBPs()) {
            this.data.add(modeleBP);
        }
        Collections.sort(this.data);
        this._tm = new BPTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultRenderer(Actions.class, new ActionRenderer());
        this.table.setDefaultEditor(ModeleBP.Edge.class, new DefaultCellEditor(new JComboBox<ModeleBP.Edge>(ModeleBP.Edge.values())));
        this.table.setDefaultEditor(ModeleBP.Stericity.class, new DefaultCellEditor(new JComboBox<ModeleBP.Stericity>(ModeleBP.Stericity.values())));
        this.table.setDefaultEditor(Actions.class, new ActionEditor(this));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.table.getModel().addTableModelListener(this);
        this.table.setRowHeight(25);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add(jScrollPane);
        this.setOpaque(true);
        this.doLayout();
        JOptionPane.showMessageDialog(this._vp, this, "Base pairs Edition", -1);
    }

    public void cancelChanges() {
        for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(i);
            modeleBase.setValue(this._backup.get(i));
        }
        this._vp.getRNA().rescaleColorMap(this._vp.getColorMap());
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.table.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = actionEvent.getActionCommand().split("-");
        int n = Integer.parseInt(stringArray[stringArray.length - 1]);
        if (stringArray[0].equals("Delete")) {
            ModeleBP modeleBP = this.data.get(n);
            this._vp.getVARNAUI().UIRemoveBP(modeleBP);
            this.data.remove(n);
            this._tm.fireTableRowsDeleted(n, n);
        }
    }

    private class BPTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private BPTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return VueBPList.this.columns.get(n).toString();
        }

        @Override
        public int getRowCount() {
            return VueBPList.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return VueBPList.this.columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ModeleBP modeleBP = (ModeleBP)VueBPList.this.data.get(n);
            if (n2 == 0) {
                return new Boolean(modeleBP.getPartner3().getElementStructure() == modeleBP.getPartner5().getIndex());
            }
            if (n2 == 1) {
                return new String("" + modeleBP.getPartner5().getBaseNumber() + "-" + modeleBP.getPartner5().getContent());
            }
            if (n2 == 2) {
                return new String("" + modeleBP.getPartner3().getBaseNumber() + "-" + modeleBP.getPartner3().getContent());
            }
            if (n2 == 3) {
                return modeleBP.getEdgePartner5();
            }
            if (n2 == 4) {
                return modeleBP.getEdgePartner3();
            }
            if (n2 == 5) {
                return modeleBP.getStericity();
            }
            if (n2 == 6) {
                return Actions.ACTION_DELETE;
            }
            return "N/A";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 3 || n2 == 4 || n2 == 5) {
                ModeleBP modeleBP = (ModeleBP)VueBPList.this.data.get(n);
                if (n2 == 3) {
                    modeleBP.setEdge5((ModeleBP.Edge)((Object)object));
                } else if (n2 == 4) {
                    modeleBP.setEdge3((ModeleBP.Edge)((Object)object));
                } else if (n2 == 5) {
                    modeleBP.setStericity((ModeleBP.Stericity)((Object)object));
                }
                this.fireTableCellUpdated(n, n2);
                VueBPList.this._vp.repaint();
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    public static enum Actions {
        ACTION_DELETE,
        ACTION_EDIT_STYLE;


        public String toString() {
            switch (this) {
                case ACTION_DELETE: {
                    return "Delete";
                }
                case ACTION_EDIT_STYLE: {
                    return "Edit Style";
                }
            }
            return "N/A";
        }
    }
}

