/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.GraphvizDrawableNodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2WrongTypeException;
import java.util.ArrayList;
import java.util.List;

public class RNANodeValue2
implements GraphvizDrawableNodeValue {
    private boolean singleNode = true;
    private RNANodeValue node;
    private List<RNANodeValue> nodes;

    public RNANodeValue2(boolean bl) {
        this.singleNode = bl;
        if (bl) {
            this.node = new RNANodeValue();
        } else {
            this.nodes = new ArrayList<RNANodeValue>();
        }
    }

    public RNANodeValue getNode() {
        if (this.singleNode) {
            return this.node;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public void setNode(RNANodeValue rNANodeValue) {
        if (!this.singleNode) {
            throw new RNANodeValue2WrongTypeException();
        }
        this.node = rNANodeValue;
    }

    public List<RNANodeValue> getNodes() {
        if (!this.singleNode) {
            return this.nodes;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public char[] computeSequence() {
        if (!this.singleNode) {
            int n = this.nodes.size();
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = this.nodes.get(i).getLeftNucleotide().charAt(0);
            }
            return cArray;
        }
        throw new RNANodeValue2WrongTypeException();
    }

    public void setNodes(List<RNANodeValue> list) {
        if (this.singleNode) {
            throw new RNANodeValue2WrongTypeException();
        }
        this.nodes = list;
    }

    public boolean isSingleNode() {
        return this.singleNode;
    }

    public String toString() {
        if (this.singleNode) {
            return this.node.toString();
        }
        String string = "";
        for (RNANodeValue rNANodeValue : this.nodes) {
            if (string != "") {
                string = string + " ";
            }
            string = string + rNANodeValue.toString();
        }
        return string;
    }

    @Override
    public String toGraphvizNodeName() {
        if (this.singleNode) {
            return this.node.toGraphvizNodeName();
        }
        String string = "";
        for (RNANodeValue rNANodeValue : this.nodes) {
            if (string != "") {
                string = string + " ";
            }
            string = string + rNANodeValue.toGraphvizNodeName();
        }
        return string;
    }
}

