/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAObservable;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.export.PSExport;
import fr.orsay.lri.varna.models.export.SVGExport;
import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import fr.orsay.lri.varna.models.export.XFIGExport;
import fr.orsay.lri.varna.models.naView.NAView;
import fr.orsay.lri.varna.models.rna.DrawRNATemplate;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBackbone;
import fr.orsay.lri.varna.models.rna.ModeleBackboneElement;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.StructureTemp;
import fr.orsay.lri.varna.models.rna.VARNASecDraw;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateCurveMethod;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateMethod;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import fr.orsay.lri.varna.utils.RNAMLParser;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RNA
extends InterfaceVARNAObservable
implements Serializable {
    private static final long serialVersionUID = 7541274455751497303L;
    public static final int DRAW_MODE_CIRCULAR = 1;
    public static final int DRAW_MODE_RADIATE = 2;
    public static final int DRAW_MODE_NAVIEW = 3;
    public static final int DRAW_MODE_LINEAR = 4;
    public static final int DRAW_MODE_VARNA_VIEW = 5;
    public static final int DRAW_MODE_MOTIFVIEW = 6;
    public static final int DRAW_MODE_TEMPLATE = 7;
    public static final int DEFAULT_DRAW_MODE = 2;
    public int BASE_RADIUS = 10;
    public static final double LOOP_DISTANCE = 40.0;
    public static final double BASE_PAIR_DISTANCE = 65.0;
    public static final double MULTILOOP_DISTANCE = 35.0;
    public static final double VIRTUAL_LOOP_RADIUS = 40.0;
    public double CHEM_PROB_DIST = 14.0;
    public double CHEM_PROB_BASE_LENGTH = 30.0;
    public double CHEM_PROB_ARROW_HEIGHT = 10.0;
    public double CHEM_PROB_ARROW_WIDTH = 5.0;
    public double CHEM_PROB_TRIANGLE_WIDTH = 2.5;
    public double CHEM_PROB_PIN_SEMIDIAG = 6.0;
    public double CHEM_PROB_DOT_RADIUS = 6.0;
    public static double CHEM_PROB_ARROW_THICKNESS = 2.0;
    public static ArrayList<String> NormalBases = new ArrayList();
    public GeneralPath _debugShape;
    private int _drawMode;
    private boolean _drawn;
    private String _name;
    private String _id;
    public double _bpHeightIncrement;
    private ArrayList<ModeleBase> _listeBases;
    StructureTemp _listStrands;
    private ArrayList<ModeleBP> _structureAux;
    private ArrayList<TextAnnotation> _listeAnnotations;
    private ArrayList<HighlightRegionAnnotation> _listeRegionHighlights;
    private ArrayList<ChemProbAnnotation> _chemProbAnnotations;
    private ModeleBackbone _backbone;
    public static String XML_ELEMENT_NAME = "RNA";
    public static String XML_VAR_BASE_SPACING_NAME = "spacing";
    public static String XML_VAR_DRAWN_NAME = "drawn";
    public static String XML_VAR_NAME_NAME = "name";
    public static String XML_VAR_DRAWN_MODE_NAME = "mode";
    public static String XML_VAR_ID_NAME = "id";
    public static String XML_VAR_BP_HEIGHT_NAME = "delta";
    public static String XML_VAR_BASES_NAME = "bases";
    public static String XML_VAR_BASEPAIRS_NAME = "BPs";
    public static String XML_VAR_ANNOTATIONS_NAME = "annotations";
    public static String XML_VAR_BACKBONE_NAME = "backbone";
    private transient ArrayList<InterfaceVARNAListener> _listeVARNAListener;
    public static double HYSTERESIS_EPSILON = 0.15;
    public static final double[] HYSTERESIS_ATTRACTORS = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, 3.9269908169872414, 4.71238898038469, 5.497787143782138};
    public static String DBNStrandSep = "&";
    private boolean _strandEndsAnnotated;

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_DRAWN_NAME, "CDATA", "" + this._drawn);
        attributesImpl.addAttribute("", "", XML_VAR_DRAWN_MODE_NAME, "CDATA", "" + this._drawMode);
        attributesImpl.addAttribute("", "", XML_VAR_ID_NAME, "CDATA", "" + this._id);
        attributesImpl.addAttribute("", "", XML_VAR_BP_HEIGHT_NAME, "CDATA", "" + this._bpHeightIncrement);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_NAME_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, "" + this._name);
        transformerHandler.endElement("", "", XML_VAR_NAME_NAME);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_BASES_NAME, attributesImpl);
        for (ModeleBase serializable : this._listeBases) {
            serializable.toXML(transformerHandler);
        }
        transformerHandler.endElement("", "", XML_VAR_BASES_NAME);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_BASEPAIRS_NAME, attributesImpl);
        for (ModeleBP modeleBP : this.getSecStrBPs()) {
            modeleBP.toXML(transformerHandler, true);
        }
        for (ModeleBP modeleBP : this._structureAux) {
            modeleBP.toXML(transformerHandler, false);
        }
        transformerHandler.endElement("", "", XML_VAR_BASEPAIRS_NAME);
        attributesImpl.clear();
        this.getBackbone().toXML(transformerHandler);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_ANNOTATIONS_NAME, attributesImpl);
        for (TextAnnotation textAnnotation : this._listeAnnotations) {
            textAnnotation.toXML(transformerHandler);
        }
        for (HighlightRegionAnnotation highlightRegionAnnotation : this._listeRegionHighlights) {
            highlightRegionAnnotation.toXML(transformerHandler);
        }
        for (ChemProbAnnotation chemProbAnnotation : this._chemProbAnnotations) {
            chemProbAnnotation.toXML(transformerHandler);
        }
        transformerHandler.endElement("", "", XML_VAR_ANNOTATIONS_NAME);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModeleBackbone getBackbone() {
        return this._backbone;
    }

    public void setBackbone(ModeleBackbone modeleBackbone) {
        this._backbone = modeleBackbone;
    }

    public RNA() {
        this("");
    }

    public RNA(String string) {
        NormalBases.add("a");
        NormalBases.add("c");
        NormalBases.add("g");
        NormalBases.add("u");
        NormalBases.add("t");
        this._debugShape = null;
        this._drawMode = 2;
        this._drawn = false;
        this._name = "";
        this._id = "";
        this._bpHeightIncrement = 0.65;
        this._listStrands = new StructureTemp();
        this._structureAux = new ArrayList();
        this._listeAnnotations = new ArrayList();
        this._listeRegionHighlights = new ArrayList();
        this._chemProbAnnotations = new ArrayList();
        this._backbone = new ModeleBackbone();
        this._listeVARNAListener = new ArrayList();
        this._strandEndsAnnotated = false;
        this._name = string;
        this._listeBases = new ArrayList();
        this._drawn = false;
        this.init();
    }

    public String toString() {
        if (this._name.equals("")) {
            return this.getStructDBN();
        }
        return this._name;
    }

    public RNA(RNA rNA) {
        NormalBases.add("a");
        NormalBases.add("c");
        NormalBases.add("g");
        NormalBases.add("u");
        NormalBases.add("t");
        this._debugShape = null;
        this._drawMode = 2;
        this._drawn = false;
        this._name = "";
        this._id = "";
        this._bpHeightIncrement = 0.65;
        this._listStrands = new StructureTemp();
        this._structureAux = new ArrayList();
        this._listeAnnotations = new ArrayList();
        this._listeRegionHighlights = new ArrayList();
        this._chemProbAnnotations = new ArrayList();
        this._backbone = new ModeleBackbone();
        this._listeVARNAListener = new ArrayList();
        this._strandEndsAnnotated = false;
        this._drawMode = rNA._drawMode;
        this._listeBases.addAll(rNA._listeBases);
        this._listeVARNAListener = rNA._listeVARNAListener;
        this._drawn = rNA._drawn;
        this.init();
    }

    public void init() {
    }

    public void saveRNADBN(String string, String string2) throws ExceptionWritingForbidden {
        try {
            FileWriter fileWriter = new FileWriter(string);
            if (!string2.equals("")) {
                fileWriter.write("> " + string2 + "\n");
            }
            fileWriter.write(this.getListeBasesToString());
            fileWriter.write(10);
            String string3 = "";
            for (int i = 0; i < this._listeBases.size(); ++i) {
                string3 = this._listeBases.get(i).getElementStructure() == -1 ? string3 + '.' : (this._listeBases.get(i).getElementStructure() > i ? string3 + '(' : string3 + ')');
            }
            fileWriter.write(string3);
            fileWriter.write(10);
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ExceptionWritingForbidden(iOException.getMessage());
        }
    }

    public Color getBaseInnerColor(int n, VARNAConfig vARNAConfig) {
        Color color = this._listeBases.get(n).getStyleBase().get_base_inner_color();
        String string = this._listeBases.get(n).getContent();
        if (vARNAConfig._drawColorMap) {
            color = vARNAConfig._cm.getColorForValue(this._listeBases.get(n).getValue());
        } else if (vARNAConfig._colorDashBases && string.contains("-")) {
            color = vARNAConfig._dashBasesColor;
        } else if (vARNAConfig._colorSpecialBases && !NormalBases.contains(string.toLowerCase())) {
            color = vARNAConfig._specialBasesColor;
        }
        return color;
    }

    public Color getBaseOuterColor(int n, VARNAConfig vARNAConfig) {
        Color color = this._listeBases.get(n).getStyleBase().get_base_outline_color();
        return color;
    }

    public Color getBaseNameColor(int n, VARNAConfig vARNAConfig) {
        Color color = this._listeBases.get(n).getStyleBase().get_base_name_color();
        return color;
    }

    public Color getBasePairColor(ModeleBP modeleBP, VARNAConfig vARNAConfig) {
        Color color = vARNAConfig._bondColor;
        if (vARNAConfig._useBaseColorsForBPs) {
            color = this._listeBases.get(modeleBP.getPartner5().getIndex()).getStyleBase().get_base_inner_color();
        }
        if (modeleBP != null) {
            color = modeleBP.getStyle().getColor(color);
        }
        return color;
    }

    public double getBasePairThickness(ModeleBP modeleBP, VARNAConfig vARNAConfig) {
        double d = modeleBP.getStyle().getThickness(vARNAConfig._bpThickness);
        return d;
    }

    private void drawSymbol(SecStrDrawingProducer secStrDrawingProducer, double d, double d2, double d3, double d4, double d5, boolean bl, ModeleBP.Edge edge, double d6) {
        Color color = secStrDrawingProducer.getCurrentColor();
        switch (edge) {
            case WC: {
                if (bl) {
                    secStrDrawingProducer.fillCircle(d, d2, d5 / 2.0, d6, color);
                    break;
                }
                secStrDrawingProducer.fillCircle(d, d2, d5 / 2.0, d6, Color.white);
                secStrDrawingProducer.setColor(color);
                secStrDrawingProducer.drawCircle(d, d2, d5 / 2.0, d6);
                break;
            }
            case HOOGSTEEN: {
                double[] dArray = new double[4];
                double[] dArray2 = new double[4];
                dArray[0] = d - d5 * d3 / 2.0 - d5 * d4 / 2.0;
                dArray2[0] = d2 - d5 * d4 / 2.0 + d5 * d3 / 2.0;
                dArray[1] = d + d5 * d3 / 2.0 - d5 * d4 / 2.0;
                dArray2[1] = d2 + d5 * d4 / 2.0 + d5 * d3 / 2.0;
                dArray[2] = d + d5 * d3 / 2.0 + d5 * d4 / 2.0;
                dArray2[2] = d2 + d5 * d4 / 2.0 - d5 * d3 / 2.0;
                dArray[3] = d - d5 * d3 / 2.0 + d5 * d4 / 2.0;
                dArray2[3] = d2 - d5 * d4 / 2.0 - d5 * d3 / 2.0;
                if (bl) {
                    secStrDrawingProducer.fillPolygon(dArray, dArray2, color);
                    break;
                }
                secStrDrawingProducer.fillPolygon(dArray, dArray2, Color.white);
                secStrDrawingProducer.setColor(color);
                secStrDrawingProducer.drawPolygon(dArray, dArray2, d6);
                break;
            }
            case SUGAR: {
                double d7 = d5 * d3 / 2.0;
                double d8 = d5 * d4 / 2.0;
                double d9 = d5 * d4 / 2.0;
                double d10 = -d5 * d3 / 2.0;
                double[] dArray = new double[3];
                double[] dArray3 = new double[3];
                dArray[0] = d - d7 + d9;
                dArray3[0] = d2 - d8 + d10;
                dArray[1] = d + d7 + d9;
                dArray3[1] = d2 + d8 + d10;
                dArray[2] = d - d9;
                dArray3[2] = d2 - d10;
                if (bl) {
                    secStrDrawingProducer.fillPolygon(dArray, dArray3, color);
                    break;
                }
                secStrDrawingProducer.fillPolygon(dArray, dArray3, Color.white);
                secStrDrawingProducer.setColor(color);
                secStrDrawingProducer.drawPolygon(dArray, dArray3, d6);
            }
        }
        secStrDrawingProducer.setColor(color);
    }

    private void drawBasePairArc(SecStrDrawingProducer secStrDrawingProducer, int n, int n2, Point2D.Double double_, Point2D.Double double_2, ModeleBP modeleBP, VARNAConfig vARNAConfig) {
        double d = n2 - n == 1 ? this._bpHeightIncrement * 2.0 : this._bpHeightIncrement * 1.0;
        double d2 = (int)Math.round(double_2.x - double_.x);
        if (vARNAConfig._mainBPStyle != VARNAConfig.BP_STYLE.LW) {
            secStrDrawingProducer.drawArc(double_, d2, d2 * d, 0.0, 180.0);
        } else {
            double d3 = this.getBasePairThickness(modeleBP, vARNAConfig);
            double d4 = (65.0 - (double)this.BASE_RADIUS) / 5.0;
            if (modeleBP.isCanonical()) {
                if (modeleBP.isCanonicalGC()) {
                    if (double_.x != double_2.x || double_.y != double_2.y) {
                        secStrDrawingProducer.drawArc(new Point2D.Double(double_.x + (double)this.BASE_RADIUS / 4.0, double_.y), d2 - (double)this.BASE_RADIUS / 2.0, d2 * d - (double)(this.BASE_RADIUS / 2), 0.0, 180.0);
                        secStrDrawingProducer.drawArc(new Point2D.Double(double_.x - (double)this.BASE_RADIUS / 4.0, double_.y), d2 + (double)this.BASE_RADIUS / 2.0, d2 * d + (double)(this.BASE_RADIUS / 2), 0.0, 180.0);
                    }
                } else if (!modeleBP.isWobbleUG()) {
                    double d5 = (double_2.x + double_.x) / 2.0;
                    double d6 = (double_2.y + double_.y) / 2.0;
                    secStrDrawingProducer.drawArc(double_, d2, d2 * d, 0.0, 180.0);
                    this.drawSymbol(secStrDrawingProducer, d5, d6 + d2 * d / 2.0, 1.0, 0.0, d4, modeleBP.isCIS(), modeleBP.getEdgePartner5(), d3);
                } else {
                    secStrDrawingProducer.drawArc(double_, d2, d2 * d, 0.0, 180.0);
                }
            } else {
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge2 = modeleBP.getEdgePartner3();
                double d7 = (double_2.x + double_.x) / 2.0;
                double d8 = (double_2.y + double_.y) / 2.0;
                secStrDrawingProducer.drawArc(double_, d2, d2 * d, 0.0, 180.0);
                if (edge == edge2) {
                    this.drawSymbol(secStrDrawingProducer, d7, d8 + d2 * d / 2.0, 1.0, 0.0, d4, modeleBP.isCIS(), modeleBP.getEdgePartner5(), d3);
                } else {
                    this.drawSymbol(secStrDrawingProducer, d7 - (double)this.BASE_RADIUS, d8 + d2 * d / 2.0, 1.0, 0.0, d4, modeleBP.isCIS(), edge, d3);
                    this.drawSymbol(secStrDrawingProducer, d7 + (double)this.BASE_RADIUS, d8 + d2 * d / 2.0, 1.0, 0.0, d4, modeleBP.isCIS(), edge2, d3);
                }
            }
        }
    }

    private void drawBasePair(SecStrDrawingProducer secStrDrawingProducer, Point2D.Double double_, Point2D.Double double_2, ModeleBP modeleBP, VARNAConfig vARNAConfig) {
        double d = double_2.x - double_.x;
        double d2 = double_2.y - double_.y;
        double d3 = Math.sqrt((double_2.x - double_.x) * (double_2.x - double_.x) + (double_2.y - double_.y) * (double_2.y - double_.y));
        double d4 = -(d2 /= d3);
        double d5 = d /= d3;
        double_ = new Point2D.Double(double_.x + (double)this.BASE_RADIUS * d, double_.y + (double)this.BASE_RADIUS * d2);
        double_2 = new Point2D.Double(double_2.x - (double)this.BASE_RADIUS * d, double_2.y - (double)this.BASE_RADIUS * d2);
        if (vARNAConfig._mainBPStyle == VARNAConfig.BP_STYLE.LW) {
            double d6 = this.getBasePairThickness(modeleBP, vARNAConfig);
            double d7 = (65.0 - (double)this.BASE_RADIUS) / 5.0;
            if (modeleBP.isCanonical()) {
                if (modeleBP.isCanonicalGC()) {
                    if (double_.x != double_2.x || double_.y != double_2.y) {
                        secStrDrawingProducer.drawLine(double_.x + (d4 *= (double)this.BASE_RADIUS / 4.0), double_.y + (d5 *= (double)this.BASE_RADIUS / 4.0), double_2.x + d4, double_2.y + d5, vARNAConfig._bpThickness);
                        secStrDrawingProducer.drawLine(double_.x - d4, double_.y - d5, double_2.x - d4, double_2.y - d5, vARNAConfig._bpThickness);
                    }
                } else if (modeleBP.isCanonicalAU()) {
                    secStrDrawingProducer.drawLine(double_.x, double_.y, double_2.x, double_2.y, vARNAConfig._bpThickness);
                } else if (modeleBP.isWobbleUG()) {
                    double d8 = (double_2.x + double_.x) / 2.0;
                    double d9 = (double_2.y + double_.y) / 2.0;
                    secStrDrawingProducer.drawLine(double_.x, double_.y, double_2.x, double_2.y, vARNAConfig._bpThickness);
                    this.drawSymbol(secStrDrawingProducer, d8, d9, d4, d5, d7, false, ModeleBP.Edge.WC, d6);
                } else {
                    double d10 = (double_2.x + double_.x) / 2.0;
                    double d11 = (double_2.y + double_.y) / 2.0;
                    secStrDrawingProducer.drawLine(double_.x, double_.y, double_2.x, double_2.y, vARNAConfig._bpThickness);
                    this.drawSymbol(secStrDrawingProducer, d10, d11, d4, d5, d7, modeleBP.isCIS(), modeleBP.getEdgePartner5(), d6);
                }
            } else {
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge2 = modeleBP.getEdgePartner3();
                double d12 = (double_2.x + double_.x) / 2.0;
                double d13 = (double_2.y + double_.y) / 2.0;
                secStrDrawingProducer.drawLine(double_.x, double_.y, double_2.x, double_2.y, vARNAConfig._bpThickness);
                if (edge == edge2) {
                    this.drawSymbol(secStrDrawingProducer, d12, d13, d4, d5, d7, modeleBP.isCIS(), edge, d6);
                } else {
                    double d14 = double_2.x - double_.x;
                    double d15 = double_2.y - double_.y;
                    this.drawSymbol(secStrDrawingProducer, d12 + (d14 /= 6.0), d13 + (d15 /= 6.0), d4, d5, d7, modeleBP.isCIS(), edge2, d6);
                    this.drawSymbol(secStrDrawingProducer, d12 - d14, d13 - d15, d4, d5, d7, modeleBP.isCIS(), edge, d6);
                }
            }
        } else if (vARNAConfig._mainBPStyle == VARNAConfig.BP_STYLE.RNAVIZ) {
            double d16 = (double_.x + double_2.x) / 2.0;
            double d17 = (double_.y + double_2.y) / 2.0;
            secStrDrawingProducer.fillCircle(d16, d17, 3.0 * vARNAConfig._bpThickness, vARNAConfig._bpThickness, secStrDrawingProducer.getCurrentColor());
        } else if (vARNAConfig._mainBPStyle == VARNAConfig.BP_STYLE.SIMPLE) {
            secStrDrawingProducer.drawLine(double_.x, double_.y, double_2.x, double_2.y, vARNAConfig._bpThickness);
        }
    }

    private void drawColorMap(VARNAConfig vARNAConfig, SecStrDrawingProducer secStrDrawingProducer) {
        double d = vARNAConfig._cm.getMinValue();
        double d2 = vARNAConfig._cm.getMaxValue();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        Rectangle2D.Double double_ = secStrDrawingProducer.getBoundingBox();
        double d6 = double_.getMaxX() - vARNAConfig._colorMapWidth - vARNAConfig._colorMapXOffset;
        double d7 = double_.getMinY() - vARNAConfig._colorMapHeight - (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        int n = 0;
        while ((double)n < vARNAConfig._colorMapWidth) {
            double d8 = (double)n / (vARNAConfig._colorMapWidth - 1.0);
            double d9 = d + (d2 - d) * d8;
            Color color = vARNAConfig._cm.getColorForValue(d9);
            int n2 = (int)(d6 + (double)n);
            int n3 = (int)d7;
            secStrDrawingProducer.fillRectangle(n2, n3, VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH, vARNAConfig._colorMapHeight, color);
            ++n;
        }
        secStrDrawingProducer.setColor(VARNAConfig.DEFAULT_COLOR_MAP_OUTLINE);
        secStrDrawingProducer.drawRectangle(d6, d7, vARNAConfig._colorMapWidth + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH - 1.0, vARNAConfig._colorMapHeight, d5);
        secStrDrawingProducer.setColor(VARNAConfig.DEFAULT_COLOR_MAP_FONT_COLOR);
        secStrDrawingProducer.setFont(secStrDrawingProducer.getCurrentFont(), (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.5);
        secStrDrawingProducer.drawText(d6, d7 + vARNAConfig._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, "" + vARNAConfig._cm.getMinValue());
        secStrDrawingProducer.drawText(d6 + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + vARNAConfig._colorMapWidth, d7 + vARNAConfig._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, "" + vARNAConfig._cm.getMaxValue());
        secStrDrawingProducer.drawText(d6 + ((double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + vARNAConfig._colorMapWidth) / 2.0, d7 - (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7, vARNAConfig._colorMapCaption);
    }

    private void renderRegionHighlights(SecStrDrawingProducer secStrDrawingProducer, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2) {
        for (HighlightRegionAnnotation highlightRegionAnnotation : this._listeRegionHighlights) {
            GeneralPath generalPath = highlightRegionAnnotation.getShape(doubleArray, doubleArray2, 1.0);
            secStrDrawingProducer.setColor(highlightRegionAnnotation.getFillColor());
            secStrDrawingProducer.fillPolygon(generalPath, highlightRegionAnnotation.getFillColor());
            secStrDrawingProducer.setColor(highlightRegionAnnotation.getOutlineColor());
            secStrDrawingProducer.drawPolygon(generalPath, 1.0);
        }
    }

    private void saveRNA(String string, VARNAConfig vARNAConfig, double d, SecStrDrawingProducer secStrDrawingProducer) throws ExceptionWritingForbidden {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        Object object;
        int n;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        int n2;
        secStrDrawingProducer.setScale(d);
        double d9 = 40.0;
        double d10 = Double.MAX_VALUE;
        double d11 = Double.MIN_VALUE;
        double d12 = Double.MAX_VALUE;
        double d13 = Double.MIN_VALUE;
        for (int i = 0; i < this._listeBases.size(); ++i) {
            d10 = Math.min(d10, this._listeBases.get(i).getCoords().getX() - (double)this.BASE_RADIUS - d9);
            d12 = Math.min(d12, -(this._listeBases.get(i).getCoords().getY() - (double)this.BASE_RADIUS - d9));
            d11 = Math.max(d11, this._listeBases.get(i).getCoords().getX() + (double)this.BASE_RADIUS + d9);
            d13 = Math.max(d13, -(this._listeBases.get(i).getCoords().getY() + (double)this.BASE_RADIUS + d9));
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] doubleArray2 = new Point2D.Double[this._listeBases.size()];
        for (n2 = 0; n2 < this._listeBases.size(); ++n2) {
            double d14 = this._listeBases.get(n2).getCoords().getX() - d10;
            double d15 = -(this._listeBases.get(n2).getCoords().getY() - d12);
            doubleArray[n2] = new Point2D.Double(d14, d15);
            serializable3 = this.getCenter(n2);
            if ((this.get_drawMode() == 3 || this.get_drawMode() == 2) && this._listeBases.get(n2).getElementStructure() != -1 && n2 < this._listeBases.size() - 1 && n2 > 1) {
                serializable2 = this.get_listeBases().get(n2 - 1);
                serializable = this.get_listeBases().get(n2 + 1);
                int n3 = ((ModeleBase)serializable2).getElementStructure();
                if (n3 == -1 ^ (n = ((ModeleBase)serializable).getElementStructure()) == -1) {
                    Point2D.Double double_ = ((ModeleBase)serializable2).getCoords();
                    Point2D.Double double_2 = ((ModeleBase)serializable).getCoords();
                    object = ((ModeleBase)serializable2).getCenter();
                    Point2D.Double double_3 = ((ModeleBase)serializable).getCenter();
                    ((Point2D.Double)serializable3).x = this._listeBases.get((int)n2).getCoords().x + (((Point2D.Double)object).x - double_.x) / ((Point2D)object).distance(double_) + (double_3.x - double_2.x) / double_3.distance(double_2);
                    ((Point2D.Double)serializable3).y = this._listeBases.get((int)n2).getCoords().y + (((Point2D.Double)object).y - double_.y) / ((Point2D)object).distance(double_) + (double_3.y - double_2.y) / double_3.distance(double_2);
                }
            }
            double d16 = ((Point2D.Double)serializable3).getX() - d10;
            double d17 = -(((Point2D.Double)serializable3).getY() - d12);
            doubleArray2[n2] = new Point2D.Double(d16, d17);
        }
        if (vARNAConfig._drawBackground) {
            secStrDrawingProducer.setBackgroundColor(vARNAConfig._backgroundColor);
        }
        this.renderRegionHighlights(secStrDrawingProducer, doubleArray, doubleArray2);
        for (n2 = 1; n2 < this._listeBases.size(); ++n2) {
            boolean bl;
            serializable3 = doubleArray[n2 - 1];
            serializable2 = doubleArray[n2];
            d8 = ((Point2D.Double)serializable3).x;
            d7 = ((Point2D.Double)serializable3).y;
            d6 = ((Point2D.Double)serializable2).x;
            d5 = ((Point2D.Double)serializable2).y;
            serializable = new Point2D.Double();
            double d18 = ((Point2D)((Object)serializable3)).distance((Point2D)((Object)serializable2));
            int n4 = this._listeBases.get(n2 - 1).getElementStructure();
            int n5 = this._listeBases.get(n2).getElementStructure();
            object = this._backbone.getTypeBefore(n2);
            boolean bl2 = bl = n4 == n2 && n5 == n2 - 1;
            if (!(d18 > 0.0) || object == ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE) continue;
            Color color = this._backbone.getColorBefore(n2, vARNAConfig._backboneColor);
            if (object == ModeleBackboneElement.BackboneType.MISSING_PART_TYPE) {
                color.brighter();
            }
            secStrDrawingProducer.setColor(color);
            ((Point2D.Double)serializable).x = (d6 - d8) / d18;
            ((Point2D.Double)serializable).y = (d5 - d7) / d18;
            if (bl && this.getDrawMode() != 4 && this.getDrawMode() != 1) {
                int n6 = 0;
                if (n2 + 1 < doubleArray.length) {
                    n6 = this.testDirectionality(n2 - 1, n2, n2 + 1) ? -1 : 1;
                } else if (n2 - 2 >= 0) {
                    n6 = this.testDirectionality(n2 - 2, n2 - 1, n2) ? -1 : 1;
                }
                Point2D.Double double_ = new Point2D.Double((((Point2D.Double)serializable3).x + ((Point2D.Double)serializable2).x) / 2.0, (((Point2D.Double)serializable3).y + ((Point2D.Double)serializable2).y) / 2.0);
                double d19 = 40.0 * d;
                Point2D.Double double_4 = new Point2D.Double(double_.x + d19 * (double)n6 * ((Point2D.Double)serializable).y, double_.y - d19 * (double)n6 * ((Point2D.Double)serializable).x);
                secStrDrawingProducer.drawLine(double_4.x - 5.0, double_4.y, double_4.x + 5.0, double_4.y, 2.0);
                secStrDrawingProducer.drawLine(double_4.x, double_4.y - 5.0, double_4.x, double_4.y + 5.0, 2.0);
                double d20 = double_4.distance((Point2D)((Object)serializable3));
                double d21 = 360.0 * Math.atan2((double)n6 * (((Point2D.Double)serializable3).x - double_4.x), (double)n6 * (((Point2D.Double)serializable3).y - double_4.y)) / (Math.PI * 2);
                double d22 = 360.0 * Math.atan2((double)n6 * (double_4.x - ((Point2D.Double)serializable2).x), (double)n6 * (double_4.y - ((Point2D.Double)serializable2).y)) / (Math.PI * 2);
                if (d21 < 0.0) {
                    d21 += 360.0;
                }
                if (d22 < 0.0) {
                    d22 += 360.0;
                }
                double d23 = d22 - d21;
                if ((double)n6 * (d22 - d21) < 0.0) {
                    d23 += (double)n6 * 360.0;
                }
                secStrDrawingProducer.drawArc(double_4, 2.0 * d20, 2.0 * d20, d21, d23);
                continue;
            }
            secStrDrawingProducer.drawLine(d8 + (double)this.BASE_RADIUS * ((Point2D.Double)serializable).x, d7 + (double)this.BASE_RADIUS * ((Point2D.Double)serializable).y, d6 - (double)this.BASE_RADIUS * ((Point2D.Double)serializable).x, d5 - (double)this.BASE_RADIUS * ((Point2D.Double)serializable).y, 1.0);
        }
        for (n2 = 0; n2 < this._listeBases.size(); ++n2) {
            if (this._listeBases.get(n2).getElementStructure() <= n2 || !((ModeleBP)(serializable3 = this._listeBases.get(n2).getStyleBP())).isCanonical() && !vARNAConfig._drawnNonCanonicalBP) continue;
            serializable2 = this.getBasePairColor((ModeleBP)serializable3, vARNAConfig);
            secStrDrawingProducer.setColor((Color)serializable2);
            int n7 = this._listeBases.get(n2).getElementStructure();
            d8 = doubleArray[n2].x;
            d7 = doubleArray[n2].y;
            d6 = doubleArray[n7].x;
            d5 = doubleArray[n7].y;
            d4 = d6 - d8;
            d3 = d5 - d7;
            d2 = Math.sqrt(d4 * d4 + d3 * d3);
            d4 /= d2;
            d3 /= d2;
            if (this._drawMode == 1 || this._drawMode == 2 || this._drawMode == 3) {
                this.drawBasePair(secStrDrawingProducer, new Point2D.Double(d8, d7), new Point2D.Double(d6, d5), (ModeleBP)serializable3, vARNAConfig);
                continue;
            }
            if (this._drawMode != 4) continue;
            this.drawBasePairArc(secStrDrawingProducer, n2, n7, new Point2D.Double(d8, d7), new Point2D.Double(d6, d5), (ModeleBP)serializable3, vARNAConfig);
        }
        if (vARNAConfig._drawnNonPlanarBP) {
            for (n2 = 0; n2 < this._structureAux.size(); ++n2) {
                serializable3 = this._structureAux.get(n2);
                secStrDrawingProducer.setColor(this.getBasePairColor((ModeleBP)serializable3, vARNAConfig));
                int n8 = ((ModeleBP)serializable3).getPartner5().getIndex();
                int n9 = ((ModeleBP)serializable3).getPartner3().getIndex();
                if (!((ModeleBP)serializable3).isCanonical() && !vARNAConfig._drawnNonCanonicalBP) continue;
                d8 = doubleArray[n8].x;
                d7 = doubleArray[n8].y;
                d6 = doubleArray[n9].x;
                d5 = doubleArray[n9].y;
                d4 = d6 - d8;
                d3 = d5 - d7;
                d2 = Math.sqrt(d4 * d4 + d3 * d3);
                d4 /= d2;
                d3 /= d2;
                if (this._drawMode == 1 || this._drawMode == 2 || this._drawMode == 3) {
                    this.drawBasePair(secStrDrawingProducer, new Point2D.Double(d8, d7), new Point2D.Double(d6, d5), (ModeleBP)serializable3, vARNAConfig);
                    continue;
                }
                if (this._drawMode != 4) continue;
                this.drawBasePairArc(secStrDrawingProducer, n8, n9, new Point2D.Double(d8, d7), new Point2D.Double(d6, d5), (ModeleBP)serializable3, vARNAConfig);
            }
        }
        double d24 = 1.5 * (double)this.BASE_RADIUS;
        secStrDrawingProducer.setFont(18, d24);
        for (int i = 0; i < this._listeBases.size(); ++i) {
            d8 = doubleArray[i].x;
            d7 = doubleArray[i].y;
            if (this._listeBases.get(i) instanceof ModeleBasesComparison) {
                ModeleBasesComparison modeleBasesComparison = (ModeleBasesComparison)this._listeBases.get(i);
                if (vARNAConfig._fillBases) {
                    secStrDrawingProducer.fillRectangle(d8 - 1.5 * (double)this.BASE_RADIUS, d7 - (double)this.BASE_RADIUS, 3 * this.BASE_RADIUS, 2 * this.BASE_RADIUS, this.getBaseInnerColor(i, vARNAConfig));
                }
                if (vARNAConfig._drawOutlineBases) {
                    secStrDrawingProducer.setColor(this.getBaseOuterColor(i, vARNAConfig));
                    secStrDrawingProducer.drawRectangle(d8 - 1.5 * (double)this.BASE_RADIUS, d7 - (double)this.BASE_RADIUS, 3 * this.BASE_RADIUS, 2 * this.BASE_RADIUS, 1.0);
                    secStrDrawingProducer.drawLine(d8, d7 - (double)this.BASE_RADIUS, d8, d7 + (double)this.BASE_RADIUS, 1.0);
                }
                secStrDrawingProducer.setColor(this.getBaseNameColor(i, vARNAConfig));
                secStrDrawingProducer.drawText(d8 - 0.75 * (double)this.BASE_RADIUS, d7, "" + modeleBasesComparison.getBase1());
                secStrDrawingProducer.drawText(d8 + 0.75 * (double)this.BASE_RADIUS, d7, "" + modeleBasesComparison.getBase2());
                continue;
            }
            if (!(this._listeBases.get(i) instanceof ModeleBaseNucleotide)) continue;
            if (vARNAConfig._fillBases) {
                secStrDrawingProducer.fillCircle(d8, d7, this.BASE_RADIUS, 1.0, this.getBaseInnerColor(i, vARNAConfig));
            }
            if (vARNAConfig._drawOutlineBases) {
                secStrDrawingProducer.setColor(this.getBaseOuterColor(i, vARNAConfig));
                secStrDrawingProducer.drawCircle(d8, d7, this.BASE_RADIUS, 1.0);
            }
            secStrDrawingProducer.setColor(this.getBaseNameColor(i, vARNAConfig));
            secStrDrawingProducer.drawText(d8, d7, this._listeBases.get(i).getContent());
        }
        double d25 = 1.5 * (double)this.BASE_RADIUS;
        secStrDrawingProducer.setFont(18, d25);
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase;
            n = this._listeBases.get(i).getBaseNumber();
            if (n == -1) {
                n = i + 1;
            }
            if (!this.isNumberDrawn(modeleBase = this._listeBases.get(i), vARNAConfig._numPeriod)) continue;
            secStrDrawingProducer.setColor(modeleBase.getStyleBase().get_base_number_color());
            d8 = doubleArray[i].x;
            d7 = doubleArray[i].y;
            d6 = doubleArray2[i].x;
            d5 = doubleArray2[i].y;
            d4 = d6 - d8;
            d3 = d5 - d7;
            d2 = Math.sqrt(d4 * d4 + d3 * d3);
            secStrDrawingProducer.drawLine(d8 - 1.5 * (double)this.BASE_RADIUS * (d4 /= d2), d7 - 1.5 * (double)this.BASE_RADIUS * (d3 /= d2), d8 - 2.5 * (double)this.BASE_RADIUS * d4, d7 - 2.5 * (double)this.BASE_RADIUS * d3, 1.0);
            secStrDrawingProducer.drawText(d8 - (vARNAConfig._distNumbers + 1.0) * (double)this.BASE_RADIUS * d4, d7 - (vARNAConfig._distNumbers + 1.0) * (double)this.BASE_RADIUS * d3, modeleBase.getLabel());
        }
        this.renderAnnotations(secStrDrawingProducer, d10, d12, vARNAConfig);
        if (vARNAConfig._drawColorMap) {
            this.drawColorMap(vARNAConfig, secStrDrawingProducer);
        }
        Rectangle2D.Double double_ = secStrDrawingProducer.getBoundingBox();
        double d26 = 2.0 * (double)vARNAConfig._titleFont.getSize();
        secStrDrawingProducer.setColor(vARNAConfig._titleColor);
        secStrDrawingProducer.setFont(16, d26);
        double d27 = double_.y - d26 / 2.0;
        if (!this.getName().equals("")) {
            secStrDrawingProducer.drawText((d11 - d10) / 2.0, d27, this.getName());
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
            outputStreamWriter.write(secStrDrawingProducer.export());
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new ExceptionWritingForbidden(iOException.getMessage());
        }
    }

    Point2D.Double buildCaptionPosition(ModeleBase modeleBase, double d, VARNAConfig vARNAConfig) {
        double d2 = 2.0;
        if (this.isNumberDrawn(modeleBase, vARNAConfig._numPeriod)) {
            d2 += vARNAConfig._distNumbers + 1.0;
        }
        Point2D.Double double_ = modeleBase.getCenter();
        Point2D.Double double_2 = modeleBase.getCoords();
        double d3 = (double)this.BASE_RADIUS * d2 + d;
        return new Point2D.Double(double_.getX() + (double_2.getX() - double_.getX()) * ((double_2.distance(double_) + d3) / double_2.distance(double_)), double_.getY() + (double_2.getY() - double_.getY()) * ((double_2.distance(double_) + d3) / double_2.distance(double_)));
    }

    public double getBPHeightIncrement() {
        return this._bpHeightIncrement;
    }

    public void setBPHeightIncrement(double d) {
        this._bpHeightIncrement = d;
    }

    private void drawChemProbAnnotation(SecStrDrawingProducer secStrDrawingProducer, ChemProbAnnotation chemProbAnnotation, Point2D.Double double_, double d, double d2) {
        secStrDrawingProducer.setColor(chemProbAnnotation.getColor());
        Point2D.Double double_2 = chemProbAnnotation.getDirVector();
        Point2D.Double double_3 = chemProbAnnotation.getNormalVector();
        Point2D.Double double_4 = new Point2D.Double(double_.x + this.CHEM_PROB_DIST * double_2.x, double_.y + this.CHEM_PROB_DIST * double_2.y);
        Point2D.Double double_5 = new Point2D.Double(double_4.x + this.CHEM_PROB_BASE_LENGTH * chemProbAnnotation.getIntensity() * double_2.x, double_4.y + this.CHEM_PROB_BASE_LENGTH * chemProbAnnotation.getIntensity() * double_2.y);
        double d3 = CHEM_PROB_ARROW_THICKNESS * chemProbAnnotation.getIntensity();
        switch (chemProbAnnotation.getType()) {
            case ARROW: {
                Point2D.Double double_6 = new Point2D.Double(double_4.x + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_ARROW_WIDTH * double_3.x + this.CHEM_PROB_ARROW_HEIGHT * double_2.x), double_4.y + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_ARROW_WIDTH * double_3.y + this.CHEM_PROB_ARROW_HEIGHT * double_2.y));
                Point2D.Double double_7 = new Point2D.Double(double_4.x + chemProbAnnotation.getIntensity() * (-this.CHEM_PROB_ARROW_WIDTH * double_3.x + this.CHEM_PROB_ARROW_HEIGHT * double_2.x), double_4.y + chemProbAnnotation.getIntensity() * (-this.CHEM_PROB_ARROW_WIDTH * double_3.y + this.CHEM_PROB_ARROW_HEIGHT * double_2.y));
                secStrDrawingProducer.drawLine(double_4.x - d, d2 - double_4.y, double_5.x - d, d2 - double_5.y, d3);
                secStrDrawingProducer.drawLine(double_4.x - d, d2 - double_4.y, double_6.x - d, d2 - double_6.y, d3);
                secStrDrawingProducer.drawLine(double_4.x - d, d2 - double_4.y, double_7.x - d, d2 - double_7.y, d3);
                break;
            }
            case PIN: {
                Point2D.Double double_8 = new Point2D.Double(double_5.x - chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_2.x), double_5.y - chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_2.y));
                Point2D.Double double_9 = new Point2D.Double(double_5.x - chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_3.x), double_5.y - chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_3.y));
                Point2D.Double double_10 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_2.x), double_5.y + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_2.y));
                Point2D.Double double_11 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_PIN_SEMIDIAG * double_3.y));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(double_8.x - d), (float)(d2 - double_8.y));
                generalPath.lineTo((float)(double_9.x - d), (float)(d2 - double_9.y));
                generalPath.lineTo((float)(double_10.x - d), (float)(d2 - double_10.y));
                generalPath.lineTo((float)(double_11.x - d), (float)(d2 - double_11.y));
                generalPath.closePath();
                secStrDrawingProducer.fillPolygon(generalPath, chemProbAnnotation.getColor());
                secStrDrawingProducer.drawLine(double_4.x - d, d2 - double_4.y, double_5.x - d, d2 - double_5.y, d3);
                break;
            }
            case TRIANGLE: {
                Point2D.Double double_12 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_TRIANGLE_WIDTH * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * (this.CHEM_PROB_TRIANGLE_WIDTH * double_3.y));
                Point2D.Double double_13 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * (-this.CHEM_PROB_TRIANGLE_WIDTH * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * (-this.CHEM_PROB_TRIANGLE_WIDTH * double_3.y));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(double_4.x - d), (float)(d2 - double_4.y));
                generalPath.lineTo((float)(double_12.x - d), (float)(d2 - double_12.y));
                generalPath.lineTo((float)(double_13.x - d), (float)(d2 - double_13.y));
                generalPath.closePath();
                secStrDrawingProducer.fillPolygon(generalPath, chemProbAnnotation.getColor());
                break;
            }
            case DOT: {
                Double d4 = this.CHEM_PROB_DOT_RADIUS * chemProbAnnotation.getIntensity();
                Point2D.Double double_14 = new Point2D.Double(double_4.x + d4 * double_2.x - d, d2 - (double_4.y + d4 * double_2.y));
                secStrDrawingProducer.fillCircle(double_14.x, double_14.y, d4, d3, chemProbAnnotation.getColor());
            }
        }
    }

    private void renderAnnotations(SecStrDrawingProducer secStrDrawingProducer, double d, double d2, VARNAConfig vARNAConfig) {
        Point2D.Double double_;
        for (TextAnnotation serializable : this.getAnnotations()) {
            secStrDrawingProducer.setColor(serializable.getColor());
            secStrDrawingProducer.setFont(18, 2.0 * (double)serializable.getFont().getSize());
            double_ = serializable.getCenterPosition();
            if (serializable.getType() == TextAnnotation.AnchorType.BASE) {
                ModeleBase modeleBase = (ModeleBase)serializable.getAncrage();
                double d3 = Math.ceil(serializable.getFont().getSize());
                double_ = this.buildCaptionPosition(modeleBase, d3, vARNAConfig);
            }
            secStrDrawingProducer.drawText(double_.x - d, -(double_.y - d2), serializable.getTexte());
        }
        for (ChemProbAnnotation chemProbAnnotation : this.getChemProbAnnotations()) {
            double_ = chemProbAnnotation.getAnchorPosition();
            this.drawChemProbAnnotation(secStrDrawingProducer, chemProbAnnotation, double_, d, d2);
        }
    }

    public boolean isNumberDrawn(ModeleBase modeleBase, int n) {
        if (n <= 0) {
            return false;
        }
        return modeleBase.getIndex() == 0 || modeleBase.getBaseNumber() % n == 0 || modeleBase.getIndex() == this.get_listeBases().size() - 1;
    }

    public void saveRNAEPS(String string, VARNAConfig vARNAConfig) throws ExceptionWritingForbidden {
        PSExport pSExport = new PSExport();
        this.saveRNA(string, vARNAConfig, 0.4, pSExport);
    }

    public void saveRNAXFIG(String string, VARNAConfig vARNAConfig) throws ExceptionWritingForbidden {
        XFIGExport xFIGExport = new XFIGExport();
        this.saveRNA(string, vARNAConfig, 20.0, xFIGExport);
    }

    public void saveRNASVG(String string, VARNAConfig vARNAConfig) throws ExceptionWritingForbidden {
        SVGExport sVGExport = new SVGExport();
        this.saveRNA(string, vARNAConfig, 0.5, sVGExport);
    }

    public Rectangle2D.Double getBBox() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(10.0, 10.0, 10.0, 10.0);
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        for (int i = 0; i < this._listeBases.size(); ++i) {
            d = Math.min(this._listeBases.get(i).getCoords().getX() - (double)this.BASE_RADIUS, d);
            d2 = Math.min(this._listeBases.get(i).getCoords().getY() - (double)this.BASE_RADIUS, d2);
            d3 = Math.max(this._listeBases.get(i).getCoords().getX() + (double)this.BASE_RADIUS, d3);
            d4 = Math.max(this._listeBases.get(i).getCoords().getY() + (double)this.BASE_RADIUS, d4);
        }
        double_.x = d;
        double_.y = d2;
        double_.width = Math.max(d3 - d, 1.0);
        double_.height = Math.max(d4 - d2, 1.0);
        if (this._drawMode == 4) {
            double d5 = this._bpHeightIncrement * double_.width / 2.0;
            double_.height += d5;
            double_.y -= d5;
        }
        return double_;
    }

    public void setCoord(int n, Point2D.Double double_) {
        this.setCoord(n, double_.x, double_.y);
    }

    public void setCoord(int n, double d, double d2) {
        if (n < this._listeBases.size()) {
            this._listeBases.get(n).setCoords(new Point2D.Double(d, d2));
        }
    }

    public Point2D.Double getCoords(int n) {
        if (n < this._listeBases.size() && n >= 0) {
            return this._listeBases.get(n).getCoords();
        }
        return new Point2D.Double();
    }

    public String getBaseContent(int n) {
        if (n >= 0 && n < this._listeBases.size()) {
            return this._listeBases.get(n).getContent();
        }
        return "";
    }

    public int getBaseNumber(int n) {
        if (n >= 0 && n < this._listeBases.size()) {
            return this._listeBases.get(n).getBaseNumber();
        }
        return -1;
    }

    public Point2D.Double getCenter(int n) {
        if (n < this._listeBases.size()) {
            return this._listeBases.get(n).getCenter();
        }
        return new Point2D.Double();
    }

    public void setCenter(int n, double d, double d2) {
        this.setCenter(n, new Point2D.Double(d, d2));
    }

    public void setCenter(int n, Point2D.Double double_) {
        if (n < this._listeBases.size()) {
            this._listeBases.get(n).setCenter(double_);
        }
    }

    public void drawRNACircle(VARNAConfig vARNAConfig) {
        this._drawn = true;
        this._drawMode = 1;
        int n = (int)((double)(3 * (this._listeBases.size() + 1) * this.BASE_RADIUS) / (Math.PI * 2));
        for (int i = 0; i < this._listeBases.size(); ++i) {
            double d = -((double)(-(i + 1)) * 2.0 * Math.PI / (double)(this._listeBases.size() + 1) - 1.5707963267948966);
            this._listeBases.get(i).setCoords(new Point2D.Double((double)n * Math.cos(d) * vARNAConfig._spaceBetweenBases, (double)n * Math.sin(d) * vARNAConfig._spaceBetweenBases));
            this._listeBases.get(i).setCenter(new Point2D.Double(0.0, 0.0));
        }
    }

    public void drawRNAVARNAView(VARNAConfig vARNAConfig) {
        this._drawn = true;
        this._drawMode = 5;
        VARNASecDraw vARNASecDraw = new VARNASecDraw();
        vARNASecDraw.drawRNA(1.0, this);
    }

    public void drawRNALine(VARNAConfig vARNAConfig) {
        this._drawn = true;
        this._drawMode = 4;
        for (int i = 0; i < this.get_listeBases().size(); ++i) {
            this.get_listeBases().get(i).setCoords(new Point2D.Double((double)i * vARNAConfig._spaceBetweenBases * 20.0, 0.0));
            this.get_listeBases().get(i).setCenter(new Point2D.Double((double)i * vARNAConfig._spaceBetweenBases * 20.0, -10.0));
        }
    }

    public RNATemplateMapping drawRNATemplate(RNATemplate rNATemplate, VARNAConfig vARNAConfig) throws RNATemplateDrawingAlgorithmException {
        return this.drawRNATemplate(rNATemplate, vARNAConfig, DrawRNATemplateMethod.getDefault(), DrawRNATemplateCurveMethod.getDefault());
    }

    public RNATemplateMapping drawRNATemplate(RNATemplate rNATemplate, VARNAConfig vARNAConfig, DrawRNATemplateMethod drawRNATemplateMethod) throws RNATemplateDrawingAlgorithmException {
        return this.drawRNATemplate(rNATemplate, vARNAConfig, drawRNATemplateMethod, DrawRNATemplateCurveMethod.getDefault());
    }

    public RNATemplateMapping drawRNATemplate(RNATemplate rNATemplate, VARNAConfig vARNAConfig, DrawRNATemplateMethod drawRNATemplateMethod, DrawRNATemplateCurveMethod drawRNATemplateCurveMethod) throws RNATemplateDrawingAlgorithmException {
        this._drawn = true;
        this._drawMode = 7;
        DrawRNATemplate drawRNATemplate = new DrawRNATemplate(this);
        drawRNATemplate.drawRNATemplate(rNATemplate, vARNAConfig, drawRNATemplateMethod, drawRNATemplateCurveMethod);
        return drawRNATemplate.getMapping();
    }

    private static double objFun(int n, int n2, double d, double d2, double d3) {
        return (double)n * 2.0 * Math.asin(d2 / (2.0 * d)) + (double)n2 * 2.0 * Math.asin(d3 / (2.0 * d)) - Math.PI * 2;
    }

    public double determineRadius(int n, int n2, double d) {
        return RNA.determineRadius(n, n2, d, 65.0, 35.0);
    }

    public static double determineRadius(int n, int n2, double d, double d2, double d3) {
        double d4 = d2 / 2.0;
        double d5 = 3.0 * d3 + 1.0;
        double d6 = (d4 + d5) / 2.0;
        double d7 = 10000.0;
        double d8 = -1000.0;
        double d9 = 1000.0;
        double d10 = 1.0E-5;
        for (int i = 0; Math.abs(d7) > d10 && i < 10000; ++i) {
            d6 = (d4 + d5) / 2.0;
            d7 = RNA.objFun(n, n2, d6, d2, d3);
            d8 = RNA.objFun(n, n2, d5, d2, d3);
            d9 = RNA.objFun(n, n2, d4, d2, d3);
            if (d8 > 0.0) {
                d5 += d5 - d4;
                continue;
            }
            if (d7 <= 0.0 && d9 > 0.0) {
                d5 = d6;
                continue;
            }
            if (d7 >= 0.0 && d8 < 0.0) {
                d4 = d6;
                continue;
            }
            if (!(d9 < 0.0)) continue;
            d4 = Math.max(d4 - (d6 - d4), Math.max(d2 / 2.0, d3 / 2.0));
            d5 = d6;
        }
        return d6;
    }

    public void drawRNA(VARNAConfig vARNAConfig) throws ExceptionNAViewAlgorithm {
        this.drawRNA(2, vARNAConfig);
    }

    public void drawRNA(int n, VARNAConfig vARNAConfig) throws ExceptionNAViewAlgorithm {
        this._drawMode = n;
        switch (this.get_drawMode()) {
            case 2: {
                this.drawRNARadiate(vARNAConfig);
                break;
            }
            case 4: {
                this.drawRNALine(vARNAConfig);
                break;
            }
            case 1: {
                this.drawRNACircle(vARNAConfig);
                break;
            }
            case 3: {
                this.drawRNANAView(vARNAConfig);
                break;
            }
            case 5: {
                this.drawRNAVARNAView(vARNAConfig);
                break;
            }
        }
    }

    public int getDrawMode() {
        return this._drawMode;
    }

    public static double normalizeAngle(double d) {
        return RNA.normalizeAngle(d, 0.0);
    }

    public static double normalizeAngle(double d, double d2) {
        double d3;
        double d4 = d2 + Math.PI * 2;
        for (d3 = d; d3 < d2; d3 += Math.PI * 2) {
        }
        while (d3 >= d4) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public static double correctHysteresis(double d) {
        double d2 = RNA.normalizeAngle(d);
        for (int i = 0; i < HYSTERESIS_ATTRACTORS.length; ++i) {
            double d3 = HYSTERESIS_ATTRACTORS[i];
            if (!(Math.abs(RNA.normalizeAngle(d3 - d2, -Math.PI)) < HYSTERESIS_EPSILON)) continue;
            d2 = d3;
        }
        return d2;
    }

    private void distributeUnpaired(double d, double d2, double d3, double d4, Point2D.Double double_, Vector<Integer> vector) {
        double d5 = Math.abs(d * (d2 / (double)(vector.size() + 1)));
        double d6 = 0.0;
        Point2D.Double double_2 = new Point2D.Double(double_.x + d * Math.cos(d4 + d3), double_.y + d * Math.sin(d4 + d3));
        Point2D.Double double_3 = new Point2D.Double(double_.x + d * Math.cos(d4 + d3 + d2), double_.y + d * Math.sin(d4 + d3 + d2));
        double d7 = double_2.distance(double_3);
        Point2D.Double double_4 = new Point2D.Double((double_3.y - double_2.y) / d7, (-double_3.x + double_2.x) / d7);
        if (d5 < (double)(2 * this.BASE_RADIUS)) {
            d6 = Math.min(1.0, ((double)(2 * this.BASE_RADIUS) - d5) / 4.0) * this.computeRadius(d5, 2.29 * (double)(vector.size() + 1) * (double)this.BASE_RADIUS - d5);
        }
        ArrayList<Point2D.Double> arrayList = this.computeNewAngles(vector.size(), double_, double_4, d2, d4 + d3, d, d6);
        for (int i = 0; i < vector.size(); ++i) {
            int n = vector.get(i);
            this.setCoord(n, arrayList.get(i));
        }
    }

    private double computeRadius(double d, double d2) {
        double d3;
        double d4 = d3 = d;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = (d3 - d) * (d3 - d) / ((d3 + d) * (d3 + d));
        double d7 = Math.PI * (d3 + d) * (1.0 + d6 / 4.0 + d6 * d6 / 64.0 + d6 * d6 * d6 / 256.0 + 25.0 * d6 * d6 * d6 * d6 / 16384.0) / 2.0;
        double d8 = d3 + 1.0;
        while (Math.abs(d7 - d2) > 0.001 && d8 != d3) {
            d8 = d3;
            if (d7 < d2) {
                d4 = d3;
                d3 = d5 == Double.POSITIVE_INFINITY ? (d3 *= 2.0) : (d3 + d5) / 2.0;
            } else {
                d5 = d3;
                d3 = (d3 + d4) / 2.0;
            }
            d6 = (d3 - d) * (d3 - d) / ((d3 + d) * (d3 + d));
            d7 = Math.PI * (d3 + d) * (1.0 + d6 / 4.0 + d6 * d6 / 64.0 + d6 * d6 * d6 / 256.0 + 25.0 * d6 * d6 * d6 * d6 / 16384.0) / 2.0;
        }
        return d3;
    }

    public static double computeAngle(Point2D.Double double_, Point2D.Double double_2) {
        double d = double_.distance(double_2);
        double d2 = Math.asin((double_2.y - double_.y) / d);
        if (double_2.x - double_.x < 0.0) {
            d2 = Math.PI - d2;
        }
        return d2;
    }

    private Point2D.Double rotatePoint(Point2D.Double double_, Point2D.Double double_2, double d) {
        double d2 = double_2.distance(double_);
        double d3 = Math.asin((double_2.y - double_.y) / d2);
        if (double_2.x - double_.x < 0.0) {
            d3 = Math.PI - d3;
        }
        double d4 = double_.x + d2 * Math.cos(d3 + d);
        double d5 = double_.y + d2 * Math.sin(d3 + d);
        return new Point2D.Double(d4, d5);
    }

    private void rotateHelix(Point2D.Double double_, int n, int n2, double d) {
        for (int i = n; i <= n2; ++i) {
            Point2D.Double double_2 = this.getCoords(i);
            Point2D.Double double_3 = this.rotatePoint(double_, double_2, d);
            this.setCoord(i, double_3);
            if (i == n || i == n2) continue;
            Point2D.Double double_4 = this.get_listeBases().get(i).getCenter();
            Point2D.Double double_5 = this.rotatePoint(double_, double_4, d);
            this.setCenter(i, double_5);
        }
    }

    private void fixUnpairedPositions(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, Point2D.Double double_, Vector<Integer> vector, Vector<Integer> vector2) {
        if (bl) {
            double d7 = RNA.normalizeAngle(d2 - d);
            double d8 = RNA.normalizeAngle(d4 - d3);
            this.distributeUnpaired(d5, d7, d, d6, double_, vector);
            this.distributeUnpaired(d5, -d8, d4, d6, double_, vector2);
        } else {
            double d9 = RNA.normalizeAngle(d4 - d3);
            double d10 = RNA.normalizeAngle(d2 - d);
            this.distributeUnpaired(d5, -d9, d4, d6, double_, vector);
            this.distributeUnpaired(d5, d10, d, d6, double_, vector2);
        }
    }

    private static Point2D.Double getPoint(double d, double d2, Point2D.Double double_, Point2D.Double double_2, double d3, double d4, double d5) {
        return new Point2D.Double(double_.x + d3 * Math.cos(d) + d5 * d4 * Math.sin(d2) * double_2.x, double_.y + d3 * Math.sin(d) + d5 * d4 * Math.sin(d2) * double_2.y);
    }

    private ArrayList<Point2D.Double> computeNewAngles(int n, Point2D.Double double_, Point2D.Double double_2, double d, double d2, double d3, double d4) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        if (n > 0) {
            int n2;
            double d5;
            double d6;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            Point2D.Double double_3 = new Point2D.Double(double_.x + d3 * Math.cos(d2), double_.y + d3 * Math.sin(d2));
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = d < 0.0 ? -1.0 : 1.0;
            double d10 = 2.0 * (double)this.BASE_RADIUS;
            for (int i = 0; i < n; ++i) {
                double d11 = d7;
                d6 = 1.0;
                d5 = d2 + d * d7;
                d8 = Math.PI * d7;
                Point2D.Double double_4 = RNA.getPoint(d5, d8, double_, double_2, d3, d4, d9);
                for (int j = 0; Math.abs(double_4.distance(double_3) - d10) > 0.01 && j < 100; ++j) {
                    if (double_4.distance(double_3) > d10) {
                        d6 = d7;
                        d7 = (d7 + d11) / 2.0;
                    } else {
                        d11 = d7;
                        d7 = (d7 + d6) / 2.0;
                    }
                    d5 = d2 + d * d7;
                    d8 = Math.PI * d7;
                    double_4 = RNA.getPoint(d5, d8, double_, double_2, d3, d4, d9);
                }
                arrayList2.add(d7);
                double_3 = double_4;
            }
            double d12 = 1.0 / ((Double)arrayList2.get(arrayList2.size() - 1) + (Double)arrayList2.get(0));
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                arrayList2.set(n2, (Double)arrayList2.get(n2) * d12);
            }
            if (d4 > 0.0) {
                int n3;
                double_3 = RNA.getPoint(d2, 0.0, double_, double_2, d3, d4, d9);
                double d13 = 0.0;
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    d5 = (Double)arrayList2.get(n3);
                    double d14 = d2 + d * d5;
                    d8 = Math.PI * d5;
                    Point2D.Double double_5 = RNA.getPoint(d14, d8, double_, double_2, d3, d4, d9);
                    d13 += double_5.distance(double_3);
                    double_3 = double_5;
                }
                d10 = (d13 += RNA.getPoint(d2 + d, Math.PI, double_, double_2, d3, d4, d9).distance(double_3)) / (double)(n + 1);
                d7 = 0.0;
                arrayList2 = new ArrayList();
                double_3 = new Point2D.Double(double_.x + d3 * Math.cos(d2), double_.y + d3 * Math.sin(d2));
                for (n3 = 0; n3 < n; ++n3) {
                    d5 = d7;
                    double d15 = 1.5;
                    double d16 = d2 + d * d7;
                    d8 = Math.PI * d7;
                    Point2D.Double double_6 = RNA.getPoint(d16, d8, double_, double_2, d3, d4, d9);
                    for (int i = 0; Math.abs(double_6.distance(double_3) - d10) > 0.01 && i < 100; ++i) {
                        if (double_6.distance(double_3) > d10) {
                            d15 = d7;
                            d7 = (d7 + d5) / 2.0;
                        } else {
                            d5 = d7;
                            d7 = (d7 + d15) / 2.0;
                        }
                        d16 = d2 + d * d7;
                        d8 = Math.PI * d7;
                        double_6 = RNA.getPoint(d16, d8, double_, double_2, d3, d4, d9);
                    }
                    arrayList2.add(d7);
                    double_3 = double_6;
                }
                d12 = 1.0 / ((Double)arrayList2.get(arrayList2.size() - 1) + (Double)arrayList2.get(0));
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    arrayList2.set(n3, (Double)arrayList2.get(n3) * d12);
                }
            }
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                d6 = (Double)arrayList2.get(n2);
                d5 = d2 + d * d6;
                d8 = Math.PI * d6;
                arrayList.add(RNA.getPoint(d5, d8, double_, double_2, d3, d4, d9));
            }
        }
        return arrayList;
    }

    void drawLoop(int n, int n2, double d, double d2, double d3, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double[] dArray) {
        if (n > n2) {
            return;
        }
        if (this._listeBases.get(n).getElementStructure() == n2) {
            double d4 = 1.5707963267948966;
            doubleArray2[n] = new Point2D.Double(d, d2);
            doubleArray2[n2] = new Point2D.Double(d, d2);
            doubleArray[n].x = d + 65.0 * Math.cos(d3 - d4) / 2.0;
            doubleArray[n].y = d2 + 65.0 * Math.sin(d3 - d4) / 2.0;
            doubleArray[n2].x = d + 65.0 * Math.cos(d3 + d4) / 2.0;
            doubleArray[n2].y = d2 + 65.0 * Math.sin(d3 + d4) / 2.0;
            this.drawLoop(n + 1, n2 - 1, d + 40.0 * Math.cos(d3), d2 + 40.0 * Math.sin(d3), d3, doubleArray, doubleArray2, dArray);
        } else {
            double d5;
            double d6;
            double d7;
            int n3;
            int n4 = n;
            Vector<Integer> vector = new Vector<Integer>();
            Vector<Integer> vector2 = new Vector<Integer>();
            while (n4 <= n2) {
                n3 = this._listeBases.get(n4).getElementStructure();
                if (n3 > n4) {
                    vector.add(new Integer(n4));
                    vector.add(new Integer(n3));
                    vector2.add(new Integer(n4));
                    n4 = n3 + 1;
                    continue;
                }
                vector.add(new Integer(n4));
                ++n4;
            }
            int n5 = vector.size() + 2;
            int n6 = vector2.size() + 1;
            double d8 = 35.0 * (double)(n5 - n6) + 65.0 * (double)n6;
            if (n5 > 3) {
                d7 = RNA.determineRadius(n6, n5 - n6, d8 / (Math.PI * 2), 65.0, 35.0);
                d6 = -2.0 * Math.asin(35.0 / (2.0 * d7));
                d5 = -2.0 * Math.asin(65.0 / (2.0 * d7));
            } else {
                d7 = 35.0;
                d5 = -2.0 * Math.asin(65.0 / (2.0 * d7));
                d6 = (Math.PI * -2 - d5) / 2.0;
            }
            double d9 = Math.sqrt(Math.max(Math.pow(d7, 2.0) - Math.pow(32.5, 2.0), 0.0)) - 40.0;
            Point2D.Double double_ = new Point2D.Double(d + d9 * Math.cos(d3), d2 + d9 * Math.sin(d3));
            double d10 = d3 + Math.PI + 0.5 * d5 + 1.0 * d6;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Couple<Double, Double> couple = new Couple<Double, Double>(0.0, d10 - 1.0 * d6);
            ArrayList arrayList2 = new ArrayList();
            for (n4 = vector.size() - 1; n4 >= 0; --n4) {
                boolean bl;
                n3 = (Integer)vector.get(n4);
                doubleArray2[n3] = double_;
                boolean bl2 = this._listeBases.get(n3).getElementStructure() != -1;
                boolean bl3 = bl2 && this._listeBases.get(n3).getElementStructure() < n3;
                boolean bl4 = bl = bl2 && !bl3;
                if (bl3) {
                    d10 = RNA.correctHysteresis(d10 + d5 / 2.0) - d5 / 2.0;
                    couple.first = d10;
                    arrayList2.add(new Couple(arrayList, couple));
                    couple = new Couple<Double, Double>(-1.0, -1.0);
                    arrayList = new ArrayList();
                } else if (bl) {
                    couple.second = d10;
                } else {
                    arrayList.add(n3);
                }
                dArray[n3] = d10;
                if (bl3) {
                    d10 += d5;
                    continue;
                }
                d10 += d6;
            }
            couple.first = d3 - Math.PI - 0.5 * d5;
            arrayList2.add(new Couple(arrayList, couple));
            for (Couple couple2 : arrayList2) {
                double d11 = (Double)((Couple)couple2.second).first;
                double d12 = RNA.normalizeAngle((Double)((Couple)couple2.second).second, d11);
                for (int i = 0; i < ((ArrayList)couple2.first).size(); ++i) {
                    double d13 = (1.0 + (double)i) / (1.0 + (double)((ArrayList)couple2.first).size());
                    int n7 = (Integer)((ArrayList)couple2.first).get(i);
                    dArray[n7] = d11 + (1.0 - d13) * (d12 - d11);
                }
            }
            for (n4 = vector.size() - 1; n4 >= 0; --n4) {
                n3 = (Integer)vector.get(n4);
                doubleArray[n3].x = double_.x + d7 * Math.cos(dArray[n3]);
                doubleArray[n3].y = double_.y + d7 * Math.sin(dArray[n3]);
            }
            for (n4 = 0; n4 < vector2.size(); ++n4) {
                int n8 = (Integer)vector2.get(n4);
                int n9 = this._listeBases.get(n8).getElementStructure();
                double d14 = (dArray[n8] + dArray[n9]) / 2.0;
                this.drawLoop(n8 + 1, n9 - 1, 40.0 * Math.cos(d14) + (doubleArray[n8].x + doubleArray[n9].x) / 2.0, 40.0 * Math.sin(d14) + (doubleArray[n8].y + doubleArray[n9].y) / 2.0, d14, doubleArray, doubleArray2, dArray);
            }
        }
    }

    private Vector<Integer> getPreviousUnpaired(Point point) {
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        int n = point.y + 1;
        while (!bl) {
            if (n >= this.get_listeBases().size()) {
                bl = true;
            } else if (this.get_listeBases().get(n).getElementStructure() == -1) {
                vector.add(new Integer(n));
            } else {
                bl = true;
            }
            ++n;
        }
        return vector;
    }

    private Vector<Integer> getNextUnpaired(Point point) {
        boolean bl = false;
        int n = point.x - 1;
        Vector<Integer> vector = new Vector<Integer>();
        while (!bl) {
            if (n < 0) {
                bl = true;
            } else if (this.get_listeBases().get(n).getElementStructure() == -1) {
                vector.add(new Integer(n));
            } else {
                bl = true;
            }
            --n;
        }
        return vector;
    }

    public void rotateEverything(double d, double d2, double d3, double d4, Point point, Point point2, Hashtable<Integer, Point2D.Double> hashtable) {
        int n;
        int n2;
        double d5;
        double d6;
        boolean bl = this.testDirectionality(point2.x, point2.y, point.x);
        Point2D.Double double_ = this.get_listeBases().get(point.x).getCenter();
        for (int i = point.x; i <= point.y; ++i) {
            hashtable.put(i, this.getBaseAt(i).getCoords());
        }
        this.rotateHelix(double_, point.x, point.y, d);
        Point2D.Double double_2 = this.getCoords(point.x);
        Point2D.Double double_3 = this.getCoords(point.y);
        if (bl) {
            d6 = RNA.computeAngle(double_, double_3) - d2;
            d5 = RNA.computeAngle(double_, double_2) - d2;
        } else {
            d5 = RNA.computeAngle(double_, double_3) - d2;
            d6 = RNA.computeAngle(double_, double_2) - d2;
        }
        Vector<Integer> vector = this.getPreviousUnpaired(point);
        Vector<Integer> vector2 = this.getNextUnpaired(point);
        double d7 = double_.distance(double_2);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = vector.get(n2);
            hashtable.put(n, this.getCoords(n));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            n = vector2.get(n2);
            hashtable.put(n, this.getCoords(n));
        }
        this.fixUnpairedPositions(bl, d6, d3, d4, d5, d7, d2, double_, vector, vector2);
    }

    public void drawRNARadiate() {
        this.drawRNARadiate(-1.0, VARNAConfig.DEFAULT_SPACE_BETWEEN_BASES, true);
    }

    public void drawRNARadiate(VARNAConfig vARNAConfig) {
        this.drawRNARadiate(-1.0, vARNAConfig._spaceBetweenBases, vARNAConfig._flatExteriorLoop);
    }

    public void drawRNARadiate(double d, double d2, boolean bl) {
        int n;
        this._drawn = true;
        this._drawMode = 2;
        Point2D.Double[] doubleArray = new Point2D.Double[this._listeBases.size()];
        Point2D.Double[] doubleArray2 = new Point2D.Double[this._listeBases.size()];
        double[] dArray = new double[this._listeBases.size()];
        for (n = 0; n < this._listeBases.size(); ++n) {
            doubleArray[n] = new Point2D.Double(0.0, 0.0);
            doubleArray2[n] = new Point2D.Double(0.0, 0.0);
        }
        if (bl) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = -Math.sin(d += -0.5707963267948966);
            double d6 = Math.cos(d);
            for (n = 0; n < this._listeBases.size(); ++n) {
                doubleArray[n].x = d3;
                doubleArray[n].y = d4;
                doubleArray2[n].x = d3 + 65.0 * d6;
                doubleArray2[n].y = d4 - 65.0 * d5;
                int n2 = this._listeBases.get(n).getElementStructure();
                if (n2 > n) {
                    this.drawLoop(n, n2, d3 + 65.0 * d5 / 2.0, d4 + 65.0 * d6 / 2.0, d, doubleArray, doubleArray2, dArray);
                    doubleArray2[n].x = doubleArray[n].x + 65.0 * d6;
                    doubleArray2[n].y = d4 - 65.0 * d5;
                    n = n2;
                    d3 += 65.0 * d5;
                    doubleArray2[n].x = doubleArray[n].x + 65.0 * d6;
                    doubleArray2[n].y = (d4 += 65.0 * d6) - 65.0 * d5;
                }
                d3 += 35.0 * d5;
                d4 += 35.0 * d6;
            }
        } else {
            this.drawLoop(0, this._listeBases.size() - 1, 0.0, 0.0, d, doubleArray, doubleArray2, dArray);
        }
        for (n = 0; n < this._listeBases.size(); ++n) {
            this._listeBases.get(n).setCoords(new Point2D.Double(doubleArray[n].x * d2, doubleArray[n].y * d2));
            this._listeBases.get(n).setCenter(new Point2D.Double(doubleArray2[n].x * d2, doubleArray2[n].y * d2));
        }
    }

    public void drawRNANAView(VARNAConfig vARNAConfig) throws ExceptionNAViewAlgorithm {
        int n;
        this._drawMode = 3;
        this._drawn = true;
        ArrayList<Double> arrayList = new ArrayList<Double>(this._listeBases.size());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(this._listeBases.size());
        ArrayList<Short> arrayList3 = new ArrayList<Short>(this._listeBases.size());
        for (int i = 0; i < this._listeBases.size(); ++i) {
            arrayList3.add(Short.valueOf(String.valueOf(this._listeBases.get(i).getElementStructure())));
        }
        NAView nAView = new NAView();
        nAView.naview_xy_coordinates(arrayList3, arrayList, arrayList2);
        for (n = 0; n < this._listeBases.size(); ++n) {
            this._listeBases.get(n).setCoords(new Point2D.Double(arrayList.get(n) * 2.5 * vARNAConfig._spaceBetweenBases, arrayList2.get(n) * 2.5 * vARNAConfig._spaceBetweenBases));
        }
        for (n = 0; n < this._listeBases.size(); ++n) {
            Cloneable cloneable;
            int n2 = this._listeBases.get(n).getElementStructure();
            if (n2 != -1) {
                cloneable = this._listeBases.get(n).getCoords();
                Point2D.Double double_ = this._listeBases.get(n2).getCoords();
                this._listeBases.get(n).setCenter(new Point2D.Double((((Point2D.Double)cloneable).x + double_.x) / 2.0, (((Point2D.Double)cloneable).y + double_.y) / 2.0));
                continue;
            }
            cloneable = this.getLoopBases(n);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                int n3 = (Integer)((Vector)cloneable).elementAt(i);
                Point2D.Double double_ = this._listeBases.get(n3).getCoords();
                d += double_.x;
                d2 += double_.y;
            }
            this._listeBases.get(n).setCenter(new Point2D.Double(d / (double)((Vector)cloneable).size(), d2 / (double)((Vector)cloneable).size()));
        }
    }

    public ArrayList<ModeleBase> getAllPartners(int n) {
        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
        ModeleBase modeleBase = this.getBaseAt(n);
        int n2 = modeleBase.getElementStructure();
        if (n2 != -1) {
            arrayList.add(this.getBaseAt(n2));
        }
        ArrayList<ModeleBP> arrayList2 = this.getAuxBPs(n);
        for (ModeleBP modeleBP : arrayList2) {
            arrayList.add(modeleBP.getPartner(modeleBase));
        }
        return arrayList;
    }

    public int get_drawMode() {
        return this._drawMode;
    }

    public void setDrawMode(int n) {
        this._drawMode = n;
    }

    public Set<Integer> getSeparatorPositions(String string) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = string.indexOf(DBNStrandSep);
        while (n >= 0) {
            hashSet.add(n);
            n = string.indexOf(DBNStrandSep, n + 1);
        }
        return hashSet;
    }

    public void setRNA(String string, String string2) throws ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses {
        int n;
        ArrayList<String> arrayList = RNA.explodeSequence(string);
        Set<Integer> set = this.getSeparatorPositions(string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        String string3 = "";
        for (n = 0; n < arrayList.size(); ++n) {
            if (set.contains(n) && arrayList.get(n).equals(DBNStrandSep)) {
                hashSet.add(arrayList2.size() - 1);
                continue;
            }
            arrayList2.add(arrayList.get(n));
            string3 = n < string2.length() ? string3 + string2.charAt(n) : string3 + '.';
        }
        for (n = arrayList.size(); n < string2.length(); ++n) {
            arrayList2.add(" ");
            string3 = string3 + string2.charAt(n);
        }
        this.setRNA(arrayList2, string3);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this._backbone.addElement(new ModeleBackboneElement(n2, ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE));
        }
    }

    public void setRNA(String string) {
        ArrayList<String> arrayList = RNA.explodeSequence(string);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        try {
            this.setRNA(arrayList, nArray);
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.printStackTrace();
        }
    }

    public void setRNA(String string, int[] nArray) throws ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses {
        this.setRNA(RNA.explodeSequence(string), nArray);
    }

    public void setRNA(String[] stringArray, int[] nArray) throws ExceptionFileFormatOrSyntax {
        this.setRNA(stringArray, nArray, 1);
    }

    public void setRNA(List<String> list, int[] nArray) throws ExceptionFileFormatOrSyntax {
        this.setRNA(list.toArray(new String[list.size()]), nArray, 1);
    }

    public void setRNA(List<String> list, int[] nArray, int n) throws ExceptionFileFormatOrSyntax {
        this.setRNA(list.toArray(new String[list.size()]), nArray, n);
    }

    public void setRNA(String[] stringArray, int[] nArray, int n) throws ExceptionFileFormatOrSyntax {
        this.clearAnnotations();
        this._listeBases = new ArrayList();
        if (stringArray.length != nArray.length) {
            int n2;
            String[] stringArray2;
            this.warningEmition("Sequence length " + stringArray.length + " differs from that of secondary structure " + nArray.length + ". \nAdapting sequence length ...");
            if (stringArray.length < nArray.length) {
                stringArray2 = new String[nArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray2[n2] = stringArray[n2];
                }
                for (n2 = stringArray.length; n2 < stringArray2.length; ++n2) {
                    stringArray2[n2] = "";
                }
                stringArray = stringArray2;
            } else {
                stringArray2 = new String[nArray.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    stringArray2[n2] = stringArray[n2];
                }
                stringArray = stringArray2;
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this._listeBases.add(new ModeleBaseNucleotide(stringArray[i], i, n + i));
        }
        this.applyStruct(nArray);
    }

    public void setRNA(String string, String string2, ArrayList<Integer> arrayList) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        int n;
        this.clearAnnotations();
        this._listeBases = new ArrayList();
        int[] nArray = this.parseStruct(string2);
        int n2 = string2.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            ModeleBase modeleBase;
            if (string.charAt(n3) != string.charAt(n3 + 1)) {
                ModeleBasesComparison modeleBasesComparison = new ModeleBasesComparison(string.charAt(n3), string.charAt(n3 + 1), n);
                modeleBasesComparison.set_appartenance(arrayList.get(n));
                modeleBasesComparison.setBaseNumber(n + 1);
                modeleBase = modeleBasesComparison;
            } else {
                modeleBase = new ModeleBaseNucleotide("" + string.charAt(n3), n, n + 1);
            }
            this._listeBases.add(modeleBase);
            n3 += 2;
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != -1) {
                this.addBPNow(n, nArray[n]);
            }
            n3 += 2;
        }
    }

    public void setRNA(List<String> list, String string) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        this.clearAnnotations();
        int[] nArray = RNAFactory.parseSecStr(string);
        this.setRNA(list, nArray);
    }

    public static ArrayList<String> explodeSequence(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                boolean bl = false;
                String string2 = "";
                ++i;
                while (!bl & i < string.length()) {
                    if (string.charAt(i) != '}') {
                        string2 = string2 + string.charAt(i);
                        ++i;
                        continue;
                    }
                    bl = true;
                }
                arrayList.add(string2);
                continue;
            }
            arrayList.add("" + string.charAt(i));
        }
        return arrayList;
    }

    public int[] parseStruct(String string) throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        int[] nArray = new int[string.length()];
        int n = -1;
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                stack.push(new Integer(i));
                continue;
            }
            if (c == '.' || c == '-' || c == ':') {
                nArray[i] = -1;
                continue;
            }
            if (c == ')') {
                int n2;
                if (stack.size() == 0) {
                    throw new ExceptionUnmatchedClosingParentheses(i + 1);
                }
                nArray[i] = n2 = ((Integer)stack.pop()).intValue();
                nArray[n2] = i;
                continue;
            }
            if (n != -1) break;
            n = i;
            break;
        }
        if (n != -1) {
            // empty if block
        }
        if (stack.size() != 0) {
            throw new ExceptionUnmatchedClosingParentheses((Integer)stack.pop() + 1);
        }
        return nArray;
    }

    public Point getHelixInterval(int n) {
        if (n < 0 || n >= this._listeBases.size()) {
            return new Point(n, n);
        }
        int n2 = this._listeBases.get(n).getElementStructure();
        if (n2 != -1) {
            int n3 = n;
            int n4 = n;
            if (n2 > n) {
                n4 = n2;
            } else {
                n3 = n2;
            }
            boolean bl = false;
            while (!bl) {
                if (n3 < 0 || n4 >= this._listeBases.size()) {
                    bl = true;
                    continue;
                }
                if (this._listeBases.get(n3).getElementStructure() == n4) {
                    --n3;
                    ++n4;
                    continue;
                }
                bl = true;
            }
            return new Point(++n3, --n4);
        }
        return new Point(0, 0);
    }

    public ArrayList<Integer> getHelix(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n < 0 || n >= this._listeBases.size()) {
            return arrayList;
        }
        Point point = this.getHelixInterval(n);
        for (int i = point.x; i <= point.y; ++i) {
            arrayList.add(i);
            arrayList.add(this._listeBases.get(i).getElementStructure());
        }
        return arrayList;
    }

    public Point getMultiLoop(int n) {
        if (n < 0 || n >= this._listeBases.size()) {
            return new Point(n, n);
        }
        Point point = this.getHelixInterval(n);
        int n2 = point.x - 1;
        int n3 = point.y + 1;
        boolean bl = false;
        while (!bl) {
            if (n2 < 0) {
                bl = true;
                n2 = 0;
                continue;
            }
            if (this._listeBases.get(n2).getElementStructure() == -1) {
                --n2;
                continue;
            }
            if (this._listeBases.get(n2).getElementStructure() < n2) {
                n2 = this._listeBases.get(n2).getElementStructure() - 1;
                continue;
            }
            bl = true;
        }
        bl = false;
        while (!bl) {
            if (n3 > this._listeBases.size() - 1) {
                bl = true;
                n3 = this._listeBases.size() - 1;
                continue;
            }
            if (this._listeBases.get(n3).getElementStructure() == -1) {
                ++n3;
                continue;
            }
            if (this._listeBases.get(n3).getElementStructure() > n3) {
                n3 = this._listeBases.get(n3).getElementStructure() + 1;
                continue;
            }
            bl = true;
        }
        return new Point(n2, n3);
    }

    public Vector<Integer> getLoopBases(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        if (n < 0 || n >= this._listeBases.size()) {
            return vector;
        }
        int n2 = n;
        vector.add(n);
        if (this._listeBases.get(n2).getElementStructure() <= n2) {
            n2 = (n2 + 1) % this._listeBases.size();
        } else {
            n2 = this._listeBases.get(n2).getElementStructure();
            vector.add(n2);
            n2 = (n2 + 1) % this._listeBases.size();
        }
        while (n2 != n) {
            vector.add(n2);
            if (this._listeBases.get(n2).getElementStructure() == -1) {
                n2 = (n2 + 1) % this._listeBases.size();
                continue;
            }
            n2 = this._listeBases.get(n2).getElementStructure();
            vector.add(n2);
            n2 = (n2 + 1) % this._listeBases.size();
        }
        return vector;
    }

    public String getStructDBN() {
        String string = "";
        for (int i = 0; i < this._listeBases.size(); ++i) {
            int n = this._listeBases.get(i).getElementStructure();
            string = n == -1 ? string + "." : (i > n ? string + ")" : string + "(");
        }
        return this.addStrandSeparators(string);
    }

    private ArrayList<ModeleBP> getNonCrossingSubset(ArrayList<ArrayList<ModeleBP>> arrayList) {
        ArrayList<ModeleBP> arrayList2 = new ArrayList<ModeleBP>();
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<ModeleBP> arrayList3 = arrayList.get(i);
            if (!arrayList3.isEmpty()) {
                ModeleBP modeleBP = arrayList3.get(0);
                boolean bl = true;
                if (!stack.empty()) {
                    int n = (Integer)stack.peek();
                    if (modeleBP.getIndex3() >= n) {
                        bl = false;
                    }
                }
                if (bl) {
                    arrayList3.remove(0);
                    arrayList2.add(modeleBP);
                    stack.add(modeleBP.getIndex3());
                }
            }
            if (stack.empty() || i != (Integer)stack.peek()) continue;
            stack.pop();
        }
        return arrayList2;
    }

    public ArrayList<int[]> paginateStructure() {
        int n;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<ModeleBP> arrayList2 = this.getAllBPs();
        ModeleBP[] modeleBPArray = new ModeleBP[arrayList2.size()];
        arrayList2.toArray(modeleBPArray);
        Arrays.sort(modeleBPArray, new Comparator<ModeleBP>(){

            @Override
            public int compare(ModeleBP modeleBP, ModeleBP modeleBP2) {
                if (modeleBP.getIndex5() != modeleBP2.getIndex5()) {
                    return modeleBP.getIndex5() - modeleBP2.getIndex5();
                }
                return modeleBP.getIndex3() - modeleBP2.getIndex3();
            }
        });
        ArrayList<ArrayList<ModeleBP>> arrayList3 = new ArrayList<ArrayList<ModeleBP>>();
        for (n = 0; n < this.getSize(); ++n) {
            arrayList3.add(new ArrayList());
        }
        for (n = 0; n < modeleBPArray.length; ++n) {
            ((ArrayList)arrayList3.get(modeleBPArray[n].getIndex5())).add(modeleBPArray[n]);
        }
        while (!arrayList2.isEmpty()) {
            int n2;
            ArrayList<ModeleBP> arrayList4 = this.getNonCrossingSubset(arrayList3);
            int[] nArray = new int[this.getSize()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = -1;
            }
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                ModeleBP modeleBP = arrayList4.get(n2);
                nArray[modeleBP.getIndex3()] = modeleBP.getIndex5();
                nArray[modeleBP.getIndex5()] = modeleBP.getIndex3();
            }
            arrayList2.removeAll(arrayList4);
            arrayList.add(nArray);
        }
        return arrayList;
    }

    private void showBasic(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(nArray[i] + ",");
        }
        System.out.println();
    }

    public int[] getStrandShifts() {
        int[] nArray = new int[this.getSize()];
        int n = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this._backbone.getTypeBefore(i) == ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE) {
                // empty if block
            }
            nArray[i] = ++n;
        }
        return nArray;
    }

    public String addStrandSeparators(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + string.charAt(i);
            if (this._backbone.getTypeAfter(i) != ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE) continue;
            string2 = string2 + DBNStrandSep;
        }
        return string2;
    }

    public String getStructDBN(boolean bl) {
        String string = this.getStructDBN();
        if (bl) {
            int n;
            ArrayList<int[]> arrayList = this.paginateStructure();
            char[] cArray = new char[this.getSize()];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 46;
            }
            char[] cArray2 = new char[]{'(', '[', '{', '<', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N'};
            char[] cArray3 = new char[]{')', ']', '}', '>', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n'};
            for (n = 0; n < Math.min(arrayList.size(), cArray2.length); ++n) {
                int[] nArray = arrayList.get(n);
                for (int i = 0; i < cArray.length; ++i) {
                    if (nArray[i] == -1 || nArray[i] <= i || cArray[i] != '.' || cArray[nArray[i]] != '.') continue;
                    cArray[i] = cArray2[n];
                    cArray[nArray[i]] = cArray3[n];
                }
            }
            string = "";
            for (n = 0; n < cArray.length; ++n) {
                string = string + cArray[n];
            }
        }
        return this.addStrandSeparators(string);
    }

    public String getStructDBN(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = nArray[i] == -1 ? string + "." : (nArray[i] > i ? string + "(" : string + ")");
        }
        return this.addStrandSeparators(string);
    }

    public String getSeq() {
        String string = "";
        for (int i = 0; i < this._listeBases.size(); ++i) {
            string = string + this._listeBases.get(i).getContent();
        }
        return this.addStrandSeparators(string);
    }

    public String getStructBPSEQ() {
        String string = "";
        int[] nArray = this.getNonOverlappingStruct();
        for (int i = 0; i < this._listeBases.size(); ++i) {
            string = string + (i + 1) + " " + ((ModeleBaseNucleotide)this._listeBases.get(i)).getContent() + " " + (nArray[i] + 1) + "\n";
        }
        return string;
    }

    public int[] getNonCrossingStruct() {
        int[] nArray = new int[this._listeBases.size()];
        for (int i = 0; i < this._listeBases.size(); ++i) {
            nArray[i] = this._listeBases.get(i).getElementStructure();
        }
        return nArray;
    }

    public int[] getNonOverlappingStruct() {
        int[] nArray = this.getNonCrossingStruct();
        for (int i = 0; i < this._structureAux.size(); ++i) {
            ModeleBP modeleBP = this._structureAux.get(i);
            ModeleBase modeleBase = modeleBP.getPartner5();
            ModeleBase modeleBase2 = modeleBP.getPartner3();
            int n = modeleBase.getIndex();
            int n2 = modeleBase2.getIndex();
            if (nArray[n2] != -1 || nArray[n] != -1) continue;
            nArray[n2] = n;
            nArray[n] = n2;
        }
        return nArray;
    }

    public String getStructCT() {
        String string = "";
        for (int i = 0; i < this._listeBases.size(); ++i) {
            string = string + (i + 1) + " " + this._listeBases.get(i).getContent() + " " + i + " " + (i + 2) + " " + (this._listeBases.get(i).getElementStructure() + 1) + " " + (i + 1) + "\n";
        }
        return string;
    }

    public void saveAsBPSEQ(String string, String string2) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("# " + string2 + "\n");
            fileWriter.write(this.getStructBPSEQ() + "\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ExceptionExportFailed(iOException.getMessage(), string);
        }
    }

    public void saveAsCT(String string, String string2) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("" + this._listeBases.size() + " " + string2 + "\n");
            fileWriter.write(this.getStructCT() + "\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ExceptionExportFailed(iOException.getMessage(), string);
        }
    }

    public void saveAsDBN(String string, String string2) throws ExceptionExportFailed, ExceptionPermissionDenied {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("> " + string2 + "\n");
            fileWriter.write(this.getListeBasesToString() + "\n");
            fileWriter.write(this.getStructDBN() + "\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ExceptionExportFailed(iOException.getMessage(), string);
        }
    }

    public String getListeBasesToString() {
        String string = new String();
        for (int i = 0; i < this._listeBases.size(); ++i) {
            string = string + ((ModeleBaseNucleotide)this._listeBases.get(i)).getContent();
        }
        return this.addStrandSeparators(string);
    }

    public void applyBPs(ArrayList<ModeleBP> arrayList) {
        ArrayList<ModeleBP> arrayList2 = new ArrayList<ModeleBP>();
        ArrayList<ModeleBP> arrayList3 = new ArrayList<ModeleBP>();
        RNAMLParser.planarize(arrayList, arrayList2, arrayList3, this.getSize());
        for (ModeleBP modeleBP : arrayList2) {
            this.addBPnow(modeleBP.getPartner5().getIndex(), modeleBP.getPartner3().getIndex(), modeleBP);
        }
        for (ModeleBP modeleBP : arrayList3) {
            this.addBPAux(modeleBP.getPartner5().getIndex(), modeleBP.getPartner3().getIndex(), modeleBP);
        }
    }

    public void set_listeBases(ArrayList<ModeleBase> arrayList) {
        this._listeBases = arrayList;
    }

    @Override
    public void addVARNAListener(InterfaceVARNAListener interfaceVARNAListener) {
        this._listeVARNAListener.add(interfaceVARNAListener);
    }

    public void warningEmition(String string) {
        for (int i = 0; i < this._listeVARNAListener.size(); ++i) {
            this._listeVARNAListener.get(i).onWarningEmitted(string);
        }
    }

    public void applyStyleOnBases(ArrayList<Integer> arrayList, ModelBaseStyle modelBaseStyle) {
        for (int i = 1; i < arrayList.size(); ++i) {
            this._listeBases.get(arrayList.get(i)).setStyleBase(modelBaseStyle);
        }
    }

    private int[] correctReciprocity(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) {
                if (i == nArray[nArray[i]]) {
                    nArray2[i] = nArray[i];
                    continue;
                }
                nArray[nArray[i]] = i;
                continue;
            }
            nArray2[i] = -1;
        }
        return nArray2;
    }

    private void applyStruct(int[] nArray) throws ExceptionFileFormatOrSyntax {
        nArray = this.correctReciprocity(nArray);
        int[] nArray2 = RNAMLParser.planarize(nArray);
        this._structureAux.clear();
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] <= i) continue;
            if (nArray2[i] > i) {
                this.addBPNow(i, nArray2[i]);
                continue;
            }
            if (nArray2[i] == nArray[i]) continue;
            this.addBPAux(i, nArray[i]);
        }
    }

    public ArrayList<ModeleBase> get_listeBases() {
        return this._listeBases;
    }

    public int getSize() {
        return this._listeBases.size();
    }

    public ArrayList<Integer> findAll() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.get_listeBases().size(); ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public ArrayList<Integer> findBulge(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.get_listeBases().get(n).getElementStructure() == -1) {
            int n2;
            int n3 = n;
            boolean bl = false;
            while (n3 < this.get_listeBases().size() && !bl) {
                n2 = this.get_listeBases().get(n3).getElementStructure();
                if (n2 == -1) {
                    arrayList.add(n3);
                    ++n3;
                    continue;
                }
                bl = true;
            }
            n3 = n - 1;
            bl = false;
            while (n3 >= 0 && !bl) {
                n2 = this.get_listeBases().get(n3).getElementStructure();
                if (n2 == -1) {
                    arrayList.add(n3);
                    --n3;
                    continue;
                }
                bl = true;
            }
        }
        return arrayList;
    }

    public ArrayList<Integer> findStem(int n) {
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = n;
        do {
            arrayList.add(n3);
        } while ((n3 = (n2 = this.get_listeBases().get(n3).getElementStructure()) == -1 ? (n3 + 1) % this.getSize() : (n2 < n3 && n <= n3 && n2 <= n ? n2 : (n3 + 1) % this.getSize())) != n);
        return arrayList;
    }

    public int getHelixCountOnLoop(int n) {
        int n2 = 0;
        if (n < 0 || n >= this.get_listeBases().size()) {
            return n2;
        }
        int n3 = n;
        int n4 = this.get_listeBases().get(n3).getElementStructure();
        boolean bl = false;
        if (n4 != -1 && n4 < n3) {
            n = n3 = n4 + 1;
        }
        do {
            if ((n4 = this.get_listeBases().get(n3).getElementStructure()) != -1 && !bl) {
                n3 = n4;
                bl = true;
                ++n2;
                continue;
            }
            n3 = (n3 + 1) % this.get_listeBases().size();
            bl = false;
        } while (n3 != n);
        return n2;
    }

    public ArrayList<Integer> findLoop(int n) {
        return this.findLoopForward(n);
    }

    public ArrayList<Integer> findLoopForward(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n < 0 || n >= this.get_listeBases().size()) {
            return arrayList;
        }
        int n2 = n;
        int n3 = this.get_listeBases().get(n2).getElementStructure();
        boolean bl = false;
        if (n3 != -1) {
            n = n2 = Math.min(n2, n3) + 1;
        }
        do {
            arrayList.add(n2);
            n3 = this.get_listeBases().get(n2).getElementStructure();
            if (n3 != -1 && !bl) {
                n2 = n3;
                bl = true;
                continue;
            }
            n2 = (n2 + 1) % this.get_listeBases().size();
            bl = false;
        } while (n2 != n);
        return arrayList;
    }

    public ArrayList<Integer> findPair(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.get_listeBases().get(n).getElementStructure();
        if (n2 != -1) {
            arrayList.add(Math.min(n, n2));
            arrayList.add(Math.max(n, n2));
        }
        return arrayList;
    }

    public ArrayList<Integer> findLoopBackward(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n < 0 || n >= this.get_listeBases().size()) {
            return arrayList;
        }
        int n2 = n;
        int n3 = this.get_listeBases().get(n2).getElementStructure();
        boolean bl = false;
        if (n3 != -1) {
            n = n2 = Math.min(n2, n3) - 1;
        }
        if (n2 < 0) {
            return arrayList;
        }
        do {
            arrayList.add(n2);
            n3 = this.get_listeBases().get(n2).getElementStructure();
            if (n3 != -1 && !bl) {
                n2 = n3;
                bl = true;
                continue;
            }
            n2 = (n2 + this.get_listeBases().size() - 1) % this.get_listeBases().size();
            bl = false;
        } while (n2 != n);
        return arrayList;
    }

    public ArrayList<Integer> findHelix(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.get_listeBases().get(n).getElementStructure() != -1) {
            arrayList.add(n);
            arrayList.add(this.get_listeBases().get(n).getElementStructure());
            int n2 = 1;
            int n3 = this.get_listeBases().get(n).getElementStructure();
            while (n + n2 < this.get_listeBases().size() && this.get_listeBases().get(n + n2).getElementStructure() != -1 && this.get_listeBases().get(n + n2).getElementStructure() == n3 - 1) {
                arrayList.add(n + n2);
                arrayList.add(this.get_listeBases().get(n + n2).getElementStructure());
                n3 = this.get_listeBases().get(n + n2).getElementStructure();
                ++n2;
            }
            n2 = -1;
            n3 = this.get_listeBases().get(n).getElementStructure();
            while (n + n2 >= 0 && this.get_listeBases().get(n + n2).getElementStructure() != -1 && this.get_listeBases().get(n + n2).getElementStructure() == n3 + 1) {
                arrayList.add(n + n2);
                arrayList.add(this.get_listeBases().get(n + n2).getElementStructure());
                n3 = this.get_listeBases().get(n + n2).getElementStructure();
                --n2;
            }
        }
        return arrayList;
    }

    public ArrayList<Integer> find3Prime(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        while (n >= 0 && !bl) {
            bl = this.get_listeBases().get(n).getElementStructure() != -1;
            --n;
        }
        ++n;
        if (bl) {
            ++n;
        }
        for (int i = n; i < this.get_listeBases().size(); ++i) {
            arrayList.add(i);
            if (this.get_listeBases().get(i).getElementStructure() == -1) continue;
            return new ArrayList<Integer>();
        }
        return arrayList;
    }

    public ArrayList<Integer> find5Prime(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i <= n; ++i) {
            arrayList.add(i);
            if (this.get_listeBases().get(i).getElementStructure() == -1) continue;
            return new ArrayList<Integer>();
        }
        return arrayList;
    }

    public static Double angle(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Double d = Math.atan2(double_.y - double_2.y, double_.x - double_2.x);
        Double d2 = Math.atan2(double_3.y - double_2.y, double_3.x - double_2.x);
        Double d3 = d2 - d;
        while (d3 < 0.0 || d3 > Math.PI * 2) {
            if (d3 < 0.0) {
                d3 = d3 + Math.PI * 2;
                continue;
            }
            if (!(d3 > Math.PI * 2)) continue;
            d3 = d3 - Math.PI * 2;
        }
        return d3;
    }

    public ArrayList<Integer> findNonPairedBaseGroup(Integer n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = n;
        boolean bl = true;
        boolean bl2 = true;
        while (n2 < this.get_listeBases().size() && bl) {
            if (this.get_listeBases().get(n2).getElementStructure() == -1) {
                arrayList.add(n2);
                ++n2;
                continue;
            }
            bl = false;
        }
        n2 = n - 1;
        while (n2 >= 0 && bl2) {
            if (this.get_listeBases().get(n2).getElementStructure() == -1) {
                arrayList.add(n2);
                --n2;
                continue;
            }
            bl2 = false;
        }
        return arrayList;
    }

    public ArrayList<ModeleBP> getStructureAux() {
        return this._structureAux;
    }

    public int getIndexFromBaseNumber(int n) {
        for (int i = 0; i < this._listeBases.size(); ++i) {
            if (this._listeBases.get(i).getBaseNumber() != n) continue;
            return i;
        }
        return -1;
    }

    public void addBPToStructureUsingNumbers(int n, int n2) {
        int n3 = this.getIndexFromBaseNumber(n);
        int n4 = this.getIndexFromBaseNumber(n2);
        this.addBP(n3, n4);
    }

    public void addBPToStructureUsingNumbers(int n, int n2, ModeleBP modeleBP) {
        this.addBP(this.getIndexFromBaseNumber(n), this.getIndexFromBaseNumber(n2), modeleBP);
    }

    public void addBP(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        ModeleBase modeleBase = this._listeBases.get(n3);
        ModeleBase modeleBase2 = this._listeBases.get(n4);
        ModeleBP modeleBP = new ModeleBP(modeleBase, modeleBase2);
        this.addBP(n3, n4, modeleBP);
    }

    public void addBP(int n, int n2, ModeleBP modeleBP) {
        int n3;
        int n4 = n2;
        int n5 = n;
        if (n4 < n5) {
            n3 = n4;
            n4 = n5;
            n5 = n3;
        }
        if (n5 != -1) {
            for (n3 = n5; n3 <= n4; ++n3) {
                ModeleBase modeleBase = this._listeBases.get(n3);
                int n6 = modeleBase.getElementStructure();
                if (n6 == -1 || n6 > n5 && n6 < n4) continue;
                this.addBPAux(n5, n4, modeleBP);
                return;
            }
            this.addBPnow(n5, n4, modeleBP);
        }
    }

    public void removeBP(ModeleBP modeleBP) {
        if (this._structureAux.contains(modeleBP)) {
            this._structureAux.remove(modeleBP);
        } else {
            ModeleBase modeleBase = modeleBP.getPartner5();
            ModeleBase modeleBase2 = modeleBP.getPartner3();
            int n = modeleBase.getIndex();
            int n2 = modeleBase2.getIndex();
            if (modeleBase.getElementStructure() == modeleBase2.getIndex() && modeleBase2.getElementStructure() == modeleBase.getIndex()) {
                modeleBase.removeElementStructure();
                modeleBase2.removeElementStructure();
            }
        }
    }

    private void addBPNow(int n, int n2) {
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        ModeleBase modeleBase = this._listeBases.get(n);
        ModeleBase modeleBase2 = this._listeBases.get(n2);
        ModeleBP modeleBP = new ModeleBP(modeleBase, modeleBase2);
        this.addBPnow(n, n2, modeleBP);
    }

    private void addBPnow(int n, int n2, ModeleBP modeleBP) {
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        ModeleBase modeleBase = this._listeBases.get(n);
        ModeleBase modeleBase2 = this._listeBases.get(n2);
        modeleBP.setPartner5(modeleBase);
        modeleBP.setPartner3(modeleBase2);
        modeleBase.setElementStructure(n2, modeleBP);
        modeleBase2.setElementStructure(n, modeleBP);
    }

    public void addBPAux(int n, int n2) {
        ModeleBase modeleBase = this._listeBases.get(n);
        ModeleBase modeleBase2 = this._listeBases.get(n2);
        ModeleBP modeleBP = new ModeleBP(modeleBase, modeleBase2);
        this.addBPAux(n, n2, modeleBP);
    }

    public void addBPAux(int n, int n2, ModeleBP modeleBP) {
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        ModeleBase modeleBase = this._listeBases.get(n);
        ModeleBase modeleBase2 = this._listeBases.get(n2);
        modeleBP.setPartner5(modeleBase);
        modeleBP.setPartner3(modeleBase2);
        this._structureAux.add(modeleBP);
    }

    public ArrayList<ModeleBP> getBPsAt(int n) {
        ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
        if (this._listeBases.get(n).getElementStructure() != -1) {
            arrayList.add(this._listeBases.get(n).getStyleBP());
        }
        for (int i = 0; i < this._structureAux.size(); ++i) {
            ModeleBP modeleBP = this._structureAux.get(i);
            if (modeleBP.getPartner5().getIndex() != n && modeleBP.getPartner3().getIndex() != n) continue;
            arrayList.add(modeleBP);
        }
        return arrayList;
    }

    public ModeleBP getBPStyle(int n, int n2) {
        int n3;
        ModeleBP modeleBP = null;
        if (n > n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        if (this._listeBases.get(n).getElementStructure() == n2) {
            modeleBP = this._listeBases.get(n).getStyleBP();
        }
        for (n3 = 0; n3 < this._structureAux.size(); ++n3) {
            ModeleBP modeleBP2 = this._structureAux.get(n3);
            if (modeleBP2.getPartner5().getIndex() != n || modeleBP2.getPartner3().getIndex() != n2) continue;
            modeleBP = modeleBP2;
        }
        return modeleBP;
    }

    public ArrayList<ModeleBP> getSecStrBPs() {
        ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
        for (int i = 0; i < this.getSize(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            int n = modeleBase.getElementStructure();
            if (n == -1 || n <= i) continue;
            arrayList.add(modeleBase.getStyleBP());
        }
        return arrayList;
    }

    public ArrayList<ModeleBP> getAuxBPs() {
        ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
        for (ModeleBP modeleBP : this._structureAux) {
            arrayList.add(modeleBP);
        }
        return arrayList;
    }

    public ArrayList<ModeleBP> getAllBPs() {
        ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
        arrayList.addAll(this.getSecStrBPs());
        arrayList.addAll(this.getAuxBPs());
        return arrayList;
    }

    public ArrayList<ModeleBP> getAuxBPs(int n) {
        ArrayList<ModeleBP> arrayList = new ArrayList<ModeleBP>();
        for (ModeleBP modeleBP : this._structureAux) {
            if (modeleBP.getPartner5().getIndex() != n && modeleBP.getPartner3().getIndex() != n) continue;
            arrayList.add(modeleBP);
        }
        return arrayList;
    }

    public void setBaseInnerColor(Color color) {
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            modeleBase.getStyleBase().setBaseInnerColor(color);
        }
    }

    public void setBaseNumbersColor(Color color) {
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            modeleBase.getStyleBase().setBaseNumberColor(color);
        }
    }

    public void setBaseNameColor(Color color) {
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            modeleBase.getStyleBase().setBaseNameColor(color);
        }
    }

    public void setBaseOutlineColor(Color color) {
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            modeleBase.getStyleBase().setBaseOutlineColor(color);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public ArrayList<TextAnnotation> getAnnotations() {
        return this._listeAnnotations;
    }

    public boolean removeAnnotation(TextAnnotation textAnnotation) {
        return this._listeAnnotations.remove(textAnnotation);
    }

    public void addAnnotation(TextAnnotation textAnnotation) {
        this._listeAnnotations.add(textAnnotation);
    }

    public void removeAnnotation(String string) {
        ArrayList<TextAnnotation> arrayList = new ArrayList<TextAnnotation>();
        for (TextAnnotation textAnnotation : this._listeAnnotations) {
            if (!textAnnotation.getTexte().contains(string)) continue;
            arrayList.add(textAnnotation);
        }
        for (TextAnnotation textAnnotation : arrayList) {
            this._listeAnnotations.remove(textAnnotation);
        }
    }

    public void clearAnnotations() {
        this._listeAnnotations.clear();
    }

    public void autoAnnotateStrandEnds() {
        if (!this._strandEndsAnnotated) {
            int n = this._listeBases.size();
            boolean bl = false;
            this.addAnnotation(new TextAnnotation("5'", this._listeBases.get(0)));
            for (int i = 0; i < this._listeBases.size() - 1; ++i) {
                int n2 = this._listeBases.get(i).getBaseNumber();
                int n3 = this._listeBases.get(i + 1).getBaseNumber();
                if (n3 - n2 == 1) continue;
                this.addAnnotation(new TextAnnotation("3'", this._listeBases.get(i)));
                this.addAnnotation(new TextAnnotation("5'", this._listeBases.get(i + 1)));
                if (i + 1 != this._listeBases.size() - 1) continue;
                bl = true;
            }
            if (!bl) {
                this.addAnnotation(new TextAnnotation("3'", this._listeBases.get(n - 1)));
            }
            this._strandEndsAnnotated = true;
        } else {
            this.removeAnnotation("3'");
            this.removeAnnotation("5'");
            this._strandEndsAnnotated = false;
        }
    }

    public void autoAnnotateHelices() {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        int n = 1;
        while (!stack.empty()) {
            int n2 = (Integer)stack.pop();
            if (n2 >= this._listeBases.size()) continue;
            ModeleBase modeleBase = this._listeBases.get(n2);
            int n3 = modeleBase.getElementStructure();
            if (n3 == -1) {
                stack.push(n2 + 1);
                continue;
            }
            if (n3 <= n2) continue;
            ModeleBase modeleBase2 = this._listeBases.get(n3);
            stack.push(n3 + 1);
            ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
            int n4 = 1;
            while (modeleBase.getElementStructure() == modeleBase2.getIndex()) {
                arrayList.add(modeleBase);
                arrayList.add(modeleBase2);
                modeleBase = this._listeBases.get(n2 + n4);
                modeleBase2 = this._listeBases.get(n3 - n4);
                ++n4;
            }
            try {
                this.addAnnotation(new TextAnnotation("H" + n++, arrayList, TextAnnotation.AnchorType.HELIX));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            stack.push(n2 + n4);
        }
    }

    public void autoAnnotateTerminalLoops() {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        int n = 1;
        while (!stack.empty()) {
            int n2 = (Integer)stack.pop();
            if (n2 >= this._listeBases.size()) continue;
            ModeleBase modeleBase = this._listeBases.get(n2);
            int n3 = modeleBase.getElementStructure();
            if (n3 == -1) {
                int n4 = 1;
                ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
                while (n2 + n4 < this.getSize() && modeleBase.getElementStructure() == -1) {
                    arrayList.add(modeleBase);
                    modeleBase = this._listeBases.get(n2 + n4);
                    ++n4;
                }
                if (modeleBase.getElementStructure() == -1) continue;
                if (modeleBase.getElementStructure() == n2 - 1) {
                    try {
                        arrayList.add(this._listeBases.get(n2 - 1));
                        arrayList.add(this._listeBases.get(n2 + n4 - 1));
                        this.addAnnotation(new TextAnnotation("T" + n++, arrayList, TextAnnotation.AnchorType.LOOP));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                stack.push(n2 + n4 - 1);
                continue;
            }
            if (n3 <= n2) continue;
            stack.push(n3 + 1);
            stack.push(n2 + 1);
        }
    }

    public void autoAnnotateInteriorLoops() {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        int n = 1;
        while (!stack.empty()) {
            int n2 = (Integer)stack.pop();
            if (n2 >= this._listeBases.size()) continue;
            ModeleBase modeleBase = this._listeBases.get(n2);
            int n3 = modeleBase.getElementStructure();
            if (n3 == -1) {
                int n4 = n2 + 1;
                ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
                boolean bl = true;
                while (n4 < this.getSize() && (modeleBase.getElementStructure() >= n2 || modeleBase.getElementStructure() == -1)) {
                    arrayList.add(modeleBase);
                    modeleBase = this._listeBases.get(n4);
                    if (modeleBase.getElementStructure() == -1 || modeleBase.getElementStructure() < n4) {
                        ++n4;
                        continue;
                    }
                    stack.push(n4);
                    bl = false;
                    n4 = modeleBase.getElementStructure();
                }
                if (modeleBase.getElementStructure() == -1 || modeleBase.getElementStructure() != n2 - 1 || bl) continue;
                try {
                    arrayList.add(this._listeBases.get(n2 - 1));
                    arrayList.add(this._listeBases.get(n4 - 1));
                    this.addAnnotation(new TextAnnotation("I" + n++, arrayList, TextAnnotation.AnchorType.LOOP));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                stack.push(n4 - 1);
                continue;
            }
            if (n3 <= n2) continue;
            stack.push(n2 + 1);
        }
    }

    public TextAnnotation getAnnotation(TextAnnotation.AnchorType anchorType, ModeleBase modeleBase) {
        TextAnnotation textAnnotation = null;
        for (TextAnnotation textAnnotation2 : this._listeAnnotations) {
            if (textAnnotation2.getType() != anchorType) continue;
            switch (anchorType) {
                case BASE: {
                    if (modeleBase != (ModeleBase)textAnnotation2.getAncrage()) break;
                    return textAnnotation2;
                }
                case HELIX: 
                case LOOP: {
                    ArrayList arrayList = (ArrayList)textAnnotation2.getAncrage();
                    if (!arrayList.contains(modeleBase)) break;
                    return textAnnotation2;
                }
            }
        }
        return textAnnotation;
    }

    public void addChemProbAnnotation(ChemProbAnnotation chemProbAnnotation) {
        System.err.println(chemProbAnnotation.isOut());
        this._chemProbAnnotations.add(chemProbAnnotation);
    }

    public ArrayList<ChemProbAnnotation> getChemProbAnnotations() {
        return this._chemProbAnnotations;
    }

    public void setColorMapValues(Double[] doubleArray, ModeleColorMap modeleColorMap) {
        this.setColorMapValues(doubleArray, modeleColorMap, false);
    }

    public void adaptColorMapToValues(ModeleColorMap modeleColorMap) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < Math.min(this._listeBases.size(), this._listeBases.size()); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            d2 = Math.max(d2, modeleBase.getValue());
            d = Math.min(d, modeleBase.getValue());
        }
        modeleColorMap.rescale(d, d2);
    }

    public void readValues(Reader reader, ModeleColorMap modeleColorMap) {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.eolIsSignificant(true);
            ArrayList arrayList = new ArrayList();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                switch (n) {
                    case -2: {
                        arrayList2.add(streamTokenizer.nval);
                        break;
                    }
                    case 10: {
                        if (arrayList2.size() <= 0) break;
                        arrayList.add(arrayList2);
                        arrayList2 = new ArrayList();
                    }
                }
                n = streamTokenizer.nextToken();
            }
            if (arrayList2.size() > 0) {
                arrayList.add(arrayList2);
            }
            Double[] doubleArray = new Double[arrayList.size()];
            for (int i = 0; i < Math.min(arrayList.size(), this.getSize()); ++i) {
                ArrayList arrayList3 = (ArrayList)arrayList.get(i);
                doubleArray[i] = (Double)arrayList3.get(arrayList3.size() - 1);
            }
            this.setColorMapValues(doubleArray, modeleColorMap, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setColorMapValues(Double[] doubleArray, ModeleColorMap modeleColorMap, boolean bl) {
        if (doubleArray.length > 0) {
            for (int i = 0; i < Math.min(doubleArray.length, this._listeBases.size()); ++i) {
                ModeleBase modeleBase = this._listeBases.get(i);
                modeleBase.setValue(doubleArray[i]);
            }
            if (bl) {
                this.adaptColorMapToValues(modeleColorMap);
            }
        }
    }

    public Double[] getColorMapValues() {
        Double[] doubleArray = new Double[this._listeBases.size()];
        for (int i = 0; i < this._listeBases.size(); ++i) {
            doubleArray[i] = this._listeBases.get(i).getValue();
        }
        return doubleArray;
    }

    public void rescaleColorMap(ModeleColorMap modeleColorMap) {
        Double d = Double.MIN_VALUE;
        Double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this._listeBases.size(); ++i) {
            Double d3 = this._listeBases.get(i).getValue();
            d = Math.max(d, d3);
            d2 = Math.min(d2, d3);
        }
        modeleColorMap.rescale(d2, d);
    }

    public void addBase(ModeleBase modeleBase) {
        this._listeBases.add(modeleBase);
    }

    public void setSequence(String string) {
        this.setSequence(RNA.explodeSequence(string));
    }

    public void setSequence(List<String> list) {
        int n = 0;
        int n2 = 0;
        while (n < list.size() && n2 < this._listeBases.size()) {
            ModeleBase modeleBase = this._listeBases.get(n2);
            if (modeleBase instanceof ModeleBaseNucleotide) {
                ((ModeleBaseNucleotide)modeleBase).setBase(list.get(n));
                ++n;
                ++n2;
                continue;
            }
            if (modeleBase instanceof ModeleBasesComparison) {
                ((ModeleBasesComparison)modeleBase).setBase1(Character.valueOf(list.get(n).length() > 0 ? list.get(n).charAt(0) : (char)' '));
                ((ModeleBasesComparison)modeleBase).setBase2(Character.valueOf(list.get(n + 1).length() > 0 ? list.get(n + 1).charAt(0) : (char)' '));
                n += 2;
                ++n2;
                continue;
            }
            ++n2;
        }
        for (n = this._listeBases.size(); n < list.size(); ++n) {
            this._listeBases.add(new ModeleBaseNucleotide(list.get(n), n));
        }
    }

    public void eraseSequence() {
        int n = 0;
        while (n < this._listeBases.size()) {
            ModeleBase modeleBase = this._listeBases.get(n);
            if (modeleBase instanceof ModeleBaseNucleotide) {
                ((ModeleBaseNucleotide)modeleBase).setBase("");
                ++n;
                continue;
            }
            if (modeleBase instanceof ModeleBasesComparison) {
                ((ModeleBasesComparison)modeleBase).setBase1(Character.valueOf(' '));
                ((ModeleBasesComparison)modeleBase).setBase2(Character.valueOf(' '));
                ++n;
                continue;
            }
            ++n;
        }
    }

    public RNA clone() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return (RNA)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot clone class [" + this.getClass().getName() + "] via serialization: " + exception.toString());
        }
    }

    public ModeleBase getBaseAt(int n) {
        return this._listeBases.get(n);
    }

    public ArrayList<ModeleBase> getBasesAt(Collection<? extends Integer> collection) {
        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
        Iterator<? extends Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            arrayList.add(this.getBaseAt(n));
        }
        return arrayList;
    }

    public ArrayList<ModeleBase> getBasesBetween(int n, int n2) {
        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
        int n3 = Math.min(n, n2);
        n2 = Math.max(n, n2);
        for (int i = n = n3; i <= n2; ++i) {
            arrayList.add(this.getBaseAt(i));
        }
        return arrayList;
    }

    public void addHighlightRegion(HighlightRegionAnnotation highlightRegionAnnotation) {
        this._listeRegionHighlights.add(highlightRegionAnnotation);
    }

    public void removeHighlightRegion(HighlightRegionAnnotation highlightRegionAnnotation) {
        this._listeRegionHighlights.remove(highlightRegionAnnotation);
    }

    public void removeChemProbAnnotation(ChemProbAnnotation chemProbAnnotation) {
        this._chemProbAnnotations.remove(chemProbAnnotation);
    }

    public void clearChemProbAnnotations() {
        this._chemProbAnnotations.clear();
    }

    public void addHighlightRegion(int n, int n2, Color color, Color color2, double d) {
        this._listeRegionHighlights.add(new HighlightRegionAnnotation(this.getBasesBetween(n, n2), color, color2, d));
    }

    public void addHighlightRegion(int n, int n2) {
        this._listeRegionHighlights.add(new HighlightRegionAnnotation(this.getBasesBetween(n, n2)));
    }

    public ArrayList<HighlightRegionAnnotation> getHighlightRegion() {
        return this._listeRegionHighlights;
    }

    public void globalRotation(Double d) {
        if (this._listeBases.size() > 0) {
            Double d2 = d * Math.PI / 180.0;
            Double d3 = this._listeBases.get((int)0).getCoords().x;
            Double d4 = this._listeBases.get((int)0).getCoords().y;
            Double d5 = this._listeBases.get((int)0).getCoords().x;
            Double d6 = this._listeBases.get((int)0).getCoords().y;
            for (int i = 0; i < this._listeBases.size(); ++i) {
                if (this._listeBases.get(i).getCoords().getX() < d5) {
                    d5 = this._listeBases.get(i).getCoords().getX();
                }
                if (this._listeBases.get(i).getCoords().getY() < d6) {
                    d6 = this._listeBases.get(i).getCoords().getY();
                }
                if (this._listeBases.get(i).getCoords().getX() > d3) {
                    d3 = this._listeBases.get(i).getCoords().getX();
                }
                if (!(this._listeBases.get(i).getCoords().getX() > d4)) continue;
                d4 = this._listeBases.get(i).getCoords().getY();
            }
            Point2D.Double double_ = new Point2D.Double((d3 - d5) / 2.0, (d4 - d6) / 2.0);
            for (int i = 0; i < this._listeBases.size(); ++i) {
                Double d7 = Math.cos(d2) * (this._listeBases.get(i).getCenter().getX() - double_.x) - Math.sin(d2) * (this._listeBases.get(i).getCenter().getY() - double_.y) + double_.x;
                Double d8 = Math.sin(d2) * (this._listeBases.get(i).getCenter().getX() - double_.x) + Math.cos(d2) * (this._listeBases.get(i).getCenter().getY() - double_.y) + double_.y;
                this._listeBases.get(i).setCenter(new Point2D.Double(d7, d8));
                d7 = Math.cos(d2) * (this._listeBases.get(i).getCoords().getX() - double_.x) - Math.sin(d2) * (this._listeBases.get(i).getCoords().getY() - double_.y) + double_.x;
                d8 = Math.sin(d2) * (this._listeBases.get(i).getCoords().getX() - double_.x) + Math.cos(d2) * (this._listeBases.get(i).getCoords().getY() - double_.y) + double_.y;
                this._listeBases.get(i).setCoords(new Point2D.Double(d7, d8));
            }
        }
    }

    public boolean testDirectionality(int n, int n2, int n3) {
        Point2D.Double double_ = this.getCoords(n);
        Point2D.Double double_2 = this.getCoords(n2);
        Point2D.Double double_3 = this.getCoords(n3);
        return RNA.testDirectionality(double_, double_2, double_3);
    }

    public static boolean testDirectionality(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        double d = (double_2.x - double_.x) * (double_3.y - double_2.y) - (double_2.y - double_.y) * (double_3.x - double_2.x);
        return d < 0.0;
    }

    public double getOrientation() {
        double d = Double.MIN_VALUE;
        double d2 = 0.0;
        for (int i = 0; i < this._listeBases.size(); ++i) {
            ModeleBase modeleBase = this._listeBases.get(i);
            for (int j = i + 1; j < this._listeBases.size(); ++j) {
                Point2D.Double double_;
                ModeleBase modeleBase2 = this._listeBases.get(j);
                Point2D.Double double_2 = modeleBase._coords.toPoint2D();
                double d3 = double_2.distance(double_ = modeleBase2._coords.toPoint2D());
                if (!(d3 > d)) continue;
                d = d3;
                d2 = RNA.computeAngle(double_2, double_);
            }
        }
        return d2;
    }

    public boolean hasVirtualLoops() {
        boolean bl = false;
        for (int i = 0; i < this._listeBases.size(); ++i) {
            int n = this._listeBases.get(i).getElementStructure();
            if (n != i + 1) continue;
            bl = true;
        }
        return this._drawMode != 4 && this._drawMode != 1 && bl;
    }

    public String getHTMLDescription() {
        String string = "<table>";
        string = string + "<tr><td><b>Name:</b></td><td>" + this._name + "</td></tr>";
        string = string + "<tr><td><b>Length:</b></td><td>" + this.getSize() + " nts</td></tr>";
        string = string + "<tr><td><b>Base-pairs:</b></td><td>" + this.getAllBPs().size() + " </td></tr>";
        return string + "</table>";
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public static ArrayList<Integer> getGapPositions(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != ':') continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public RNA restrictTo(String string) {
        return this.restrictTo(RNA.getGapPositions(string));
    }

    public RNA restrictTo(ArrayList<Integer> arrayList) {
        RNA rNA = new RNA();
        String string = this.getSeq();
        String string2 = "";
        HashSet<Integer> hashSet = new HashSet<Integer>(arrayList);
        int[] nArray = new int[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = n++;
            if (hashSet.contains(i)) continue;
            string2 = string2 + string.charAt(i);
        }
        rNA.setRNA(string2);
        for (ModeleBP modeleBP : this.getAllBPs()) {
            if (!hashSet.contains(modeleBP.getIndex5()) && !hashSet.contains(modeleBP.getIndex3())) continue;
            int n2 = nArray[modeleBP.getIndex5()];
            int n3 = nArray[modeleBP.getIndex3()];
            ModeleBP modeleBP2 = new ModeleBP(rNA.getBaseAt(n2), rNA.getBaseAt(n3), modeleBP.getEdgePartner5(), modeleBP.getEdgePartner3(), modeleBP.getStericity());
            rNA.addBP(n2, n3, modeleBP2);
        }
        return rNA;
    }

    public void rescale(double d) {
        for (ModeleBase modeleBase : this._listeBases) {
            modeleBase._coords.x *= d;
            modeleBase._coords.y *= d;
            modeleBase._center.x *= d;
            modeleBase._center.y *= d;
        }
    }

    ArrayList<ModeleBase> getListeBases() {
        return this._listeBases;
    }
}

