/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.MappingException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class Mapping
implements Serializable {
    private static final long serialVersionUID = -3031358968555310380L;
    public static final int UNKNOWN = -1;
    Hashtable<Integer, Integer> _mapping = new Hashtable();
    Hashtable<Integer, Integer> _invMapping = new Hashtable();

    public void addCouple(int n, int n2) throws MappingException {
        if (this._mapping.containsKey(n) || this._invMapping.containsKey(n2)) {
            throw new MappingException(1);
        }
        this._mapping.put(new Integer(n), new Integer(n2));
        this._invMapping.put(new Integer(n2), new Integer(n));
    }

    public int getPartner(int n) {
        if (!this._mapping.containsKey(n)) {
            return -1;
        }
        return this._mapping.get(n);
    }

    public int getAncestor(int n) {
        if (!this._invMapping.containsKey(n)) {
            return -1;
        }
        return this._invMapping.get(n);
    }

    public int[] getSourceElems() {
        int[] nArray = new int[this._mapping.size()];
        Enumeration<Integer> enumeration = this._mapping.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2;
            nArray[n] = n2 = enumeration.nextElement().intValue();
            ++n;
        }
        return nArray;
    }

    public int[] getTargetElems() {
        int[] nArray = new int[this._invMapping.size()];
        Enumeration<Integer> enumeration = this._invMapping.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2;
            nArray[n] = n2 = enumeration.nextElement().intValue();
            ++n;
        }
        return nArray;
    }

    public static Mapping readMappingFromAlignment(String string, String string2) throws MappingException {
        Mapping mapping = new Mapping();
        if (string.length() != string2.length()) {
            throw new MappingException(2);
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (c != '-' && c != ':' && c2 != '-' && c2 != ':') {
                mapping.addCouple(n, n2);
            }
            if (c != '-' && c != ':') {
                ++n2;
            }
            if (c2 == '-' || c2 == ':') continue;
            ++n;
        }
        return mapping;
    }

    public static Mapping DefaultMapping(int n, int n2) {
        Mapping mapping = new Mapping();
        try {
            for (int i = 0; i < Math.min(n, n2); ++i) {
                mapping.addCouple(i, i);
            }
        }
        catch (MappingException mappingException) {
            mappingException.printStackTrace();
        }
        return mapping;
    }

    public static Mapping DefaultOutermostMapping(int n, int n2) {
        Mapping mapping = new Mapping();
        try {
            int n3 = Math.min(n, n2);
            int n4 = 0;
            int n5 = 0;
            boolean bl = true;
            while (n4 <= n3 - 1 - n5) {
                if (bl) {
                    mapping.addCouple(n4, n4);
                    ++n4;
                } else {
                    mapping.addCouple(n - 1 - n5, n2 - 1 - n5);
                    ++n5;
                }
                bl = !bl;
            }
        }
        catch (MappingException mappingException) {
            mappingException.printStackTrace();
        }
        return mapping;
    }

    public String toString() {
        Object object;
        Object object2;
        Enumeration<Integer> enumeration = this._mapping.keys();
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = this._mapping.get(object2);
            n = Math.max(n, (Integer)object2);
            n2 = Math.max(n2, (Integer)object);
            string = string + "(" + object2 + "," + object + ")";
        }
        n3 = Math.max(n3, Math.max(n, n2));
        object2 = "";
        object = "";
        enumeration = this._mapping.keys();
        int n4 = n;
        int n5 = n2;
        while (enumeration.hasMoreElements()) {
            Integer n6 = enumeration.nextElement();
            Integer n7 = this._mapping.get(n6);
            while (n6 < n4) {
                object2 = 'x' + (String)object2;
                object = '-' + (String)object;
                --n4;
            }
            while (n7 < n5) {
                object2 = '-' + (String)object2;
                object = 'x' + (String)object;
                --n5;
            }
            object2 = '|' + (String)object2;
            object = '|' + (String)object;
            --n4;
            --n5;
        }
        return string + "\n" + (String)object2 + "\n" + (String)object;
    }
}

