/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.VueVARNAGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class SwingGraphics
implements VueVARNAGraphics {
    private BasicStroke _dashedStroke;
    private BasicStroke _plainStroke;
    Graphics2D _g2d;
    private boolean _debug = false;

    public SwingGraphics(Graphics2D graphics2D) {
        this._g2d = graphics2D;
        float[] fArray = new float[]{5.0f, 5.0f};
        this._dashedStroke = new BasicStroke(1.0f, 1, 1, 3.0f, fArray, 0.0f);
        this._plainStroke = new BasicStroke(1.0f, 1, 1, 3.0f);
    }

    @Override
    public Dimension getStringDimension(String string) {
        FontMetrics fontMetrics = this._g2d.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this._g2d);
        return new Dimension((int)rectangle2D.getWidth(), fontMetrics.getAscent() - fontMetrics.getDescent());
    }

    @Override
    public void drawStringCentered(String string, double d, double d2) {
        Dimension dimension = this.getStringDimension(string);
        d -= (double)dimension.width / 2.0;
        d2 += (double)dimension.height / 2.0;
        if (this._debug) {
            Stroke stroke = this._g2d.getStroke();
            this._g2d.setStroke(this._plainStroke);
            this._g2d.draw(new Rectangle2D.Double(d, d2 - (double)dimension.height, dimension.width, dimension.height));
            this._g2d.setStroke(stroke);
        }
        this._g2d.drawString(string, (float)d, (float)d2);
    }

    @Override
    public void draw(GeneralPath generalPath) {
        this._g2d.draw(generalPath);
    }

    @Override
    public void drawArc(double d, double d2, double d3, double d4, double d5, double d6) {
        this._g2d.drawArc((int)(d - d3 / 2.0), (int)(d2 - d4 / 2.0), (int)d3, (int)d4, (int)d5, (int)d6);
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4) {
        this._g2d.drawLine((int)d, (int)d2, (int)d3, (int)d4);
    }

    @Override
    public void drawCircle(double d, double d2, double d3) {
        this._g2d.draw(new Ellipse2D.Double(d, d2, d3, d3));
    }

    @Override
    public void drawRect(double d, double d2, double d3, double d4) {
        this._g2d.drawRect((int)d, (int)d2, (int)d3, (int)d4);
    }

    @Override
    public void drawRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this._g2d.drawRoundRect((int)d, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6);
    }

    public void drawString(String string, double d, double d2) {
        this._g2d.drawString(string, (float)d, (float)d2);
    }

    @Override
    public void fill(GeneralPath generalPath) {
        this._g2d.fill(generalPath);
    }

    @Override
    public void fillCircle(double d, double d2, double d3) {
        this._g2d.fill(new Ellipse2D.Double(d, d2, d3, d3));
    }

    @Override
    public void fillRect(double d, double d2, double d3, double d4) {
        this._g2d.fill(new Rectangle2D.Double(d, d2, d3, d4));
    }

    @Override
    public void fillRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
        this._g2d.fillRoundRect((int)d, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6);
    }

    @Override
    public Color getColor() {
        return this._g2d.getColor();
    }

    @Override
    public void setColor(Color color) {
        this._g2d.setColor(color);
    }

    @Override
    public void setSelectionStroke() {
        this._g2d.setStroke(this._dashedStroke);
    }

    @Override
    public void setFont(Font font) {
        this._g2d.setFont(font);
    }

    @Override
    public void setPlainStroke() {
        this._g2d.setStroke(this._plainStroke);
    }

    private BasicStroke deriveStroke(BasicStroke basicStroke, double d) {
        return new BasicStroke((float)d, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    @Override
    public void setStrokeThickness(double d) {
        boolean bl = this._g2d.getStroke() == this._dashedStroke;
        this._plainStroke = this.deriveStroke(this._plainStroke, d);
        if (bl) {
            this._g2d.setStroke(this._dashedStroke);
        } else {
            this._g2d.setStroke(this._plainStroke);
        }
    }
}

