/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HighlightRegionAnnotation
implements Serializable {
    private static final long serialVersionUID = 7087014168028684775L;
    public static final Color DEFAULT_OUTLINE_COLOR = Color.decode("#6ed86e");
    public static final Color DEFAULT_FILL_COLOR = Color.decode("#bcffdd");
    public static final double DEFAULT_RADIUS = 16.0;
    private Color _outlineColor = DEFAULT_OUTLINE_COLOR;
    private Color _fillColor = DEFAULT_FILL_COLOR;
    private double _radius = 16.0;
    private ArrayList<ModeleBase> _bases;
    public static String XML_ELEMENT_NAME = "region";
    public static String XML_VAR_OUTLINE_NAME = "outline";
    public static String XML_VAR_FILL_NAME = "fill";
    public static String XML_VAR_RADIUS_NAME = "radius";
    public static final int NUM_STEPS_ROUNDED_CORNERS = 10;

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_OUTLINE_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._outlineColor));
        attributesImpl.addAttribute("", "", XML_VAR_FILL_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._fillColor));
        attributesImpl.addAttribute("", "", XML_VAR_RADIUS_NAME, "CDATA", "" + this._radius);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        XMLUtils.toXML(transformerHandler, this._bases);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public HighlightRegionAnnotation(RNA rNA, int n, int n2) {
        this(rNA.getBasesBetween(n, n2));
    }

    public HighlightRegionAnnotation() {
        this(new ArrayList<ModeleBase>());
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> arrayList) {
        this(arrayList, DEFAULT_FILL_COLOR, DEFAULT_OUTLINE_COLOR, 16.0);
    }

    public HighlightRegionAnnotation(ArrayList<ModeleBase> arrayList, Color color, Color color2, double d) {
        this._bases = arrayList;
        this._fillColor = color;
        this._outlineColor = color2;
        this._radius = d;
    }

    public HighlightRegionAnnotation clone() {
        return new HighlightRegionAnnotation(this._bases, this._fillColor, this._outlineColor, this._radius);
    }

    public int getMinIndex() {
        int n = Integer.MAX_VALUE;
        for (ModeleBase modeleBase : this._bases) {
            n = Math.min(n, modeleBase.getIndex());
        }
        return n;
    }

    public int getMaxIndex() {
        int n = Integer.MIN_VALUE;
        for (ModeleBase modeleBase : this._bases) {
            n = Math.max(n, modeleBase.getIndex());
        }
        return n;
    }

    public void setOutlineColor(Color color) {
        this._outlineColor = color;
    }

    public ArrayList<ModeleBase> getBases() {
        return this._bases;
    }

    public void setBases(ArrayList<ModeleBase> arrayList) {
        this._bases = arrayList;
    }

    public void setFillColor(Color color) {
        this._fillColor = color;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public Color getOutlineColor() {
        return this._outlineColor;
    }

    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double d) {
        this._radius = d;
    }

    public GeneralPath getShape(Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double d) {
        Point2D.Double double_;
        Point2D.Double double_2;
        double d2;
        int n;
        Point2D.Double double_3;
        Point2D.Double double_4;
        Point2D.Double double_5;
        Point2D.Double double_6;
        int n2;
        GeneralPath generalPath = new GeneralPath();
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        boolean bl = true;
        if (this.getBases().size() >= 2) {
            n2 = this.getBases().get(0).getIndex();
            double_6 = doubleArray[n2];
            double_5 = doubleArray[n2 + 1];
            double_4 = doubleArray2[n2];
            bl = RNA.testDirectionality(double_6, double_4, double_5);
        }
        if (this.getBases().size() > 0) {
            n2 = this.getBases().get(0).getIndex();
            double_6 = doubleArray[n2];
            double_5 = doubleArray2[n2];
            double d3 = double_6.distance(double_5);
            double_3 = new Point2D.Double((double_5.x - double_6.x) / d3, (double_5.y - double_6.y) / d3);
            for (n = 1; n <= 10; ++n) {
                d2 = (double)n * Math.PI / 11.0;
                if (bl) {
                    d2 += Math.PI;
                }
                double_2 = new Point2D.Double(Math.cos(d2) * double_3.x + Math.sin(d2) * double_3.y, -Math.sin(d2) * double_3.x + Math.cos(d2) * double_3.y);
                double_ = new Point2D.Double(double_6.x + d * this.getRadius() * double_2.x, double_6.y + d * this.getRadius() * double_2.y);
                linkedList.addLast(double_);
            }
        }
        for (n2 = 0; n2 < this.getBases().size(); ++n2) {
            double d4;
            int n3 = this.getBases().get(n2).getIndex();
            if (n3 <= 0 || n3 >= doubleArray.length - 1) continue;
            int n4 = n3 - 1;
            int n5 = n3 + 1;
            Point2D.Double double_7 = doubleArray[n4];
            double_3 = doubleArray[n3];
            Point2D.Double double_8 = doubleArray[n5];
            d2 = double_8.distance(double_3);
            double_2 = new Point2D.Double((double_8.x - double_3.x) / d2, (double_8.y - double_3.y) / d2);
            double_ = new Point2D.Double(double_2.y, -double_2.x);
            double d5 = double_3.distance(double_7);
            Point2D.Double double_9 = new Point2D.Double((double_3.x - double_7.x) / d5, (double_3.y - double_7.y) / d5);
            Point2D.Double double_10 = new Point2D.Double(double_9.y, -double_9.x);
            double d6 = new Point2D.Double(double_10.x - double_.x, double_10.y - double_.y).distance(new Point2D.Double(0.0, 0.0)) / 2.0;
            Point2D.Double double_11 = new Point2D.Double((double_.x + double_10.x) / 2.0, (double_.y + double_10.y) / 2.0);
            double d7 = double_11.distance(new Point2D.Double(0.0, 0.0));
            double_11.x /= d7;
            double_11.y /= d7;
            double d8 = d4 = d7 + d6 * d6 / d7;
            double d9 = d4;
            Point2D.Double double_12 = new Point2D.Double(double_3.x + d8 * d * this.getRadius() * double_11.x, double_3.y + d8 * d * this.getRadius() * double_11.y);
            Point2D.Double double_13 = new Point2D.Double(double_3.x - d9 * d * this.getRadius() * double_11.x, double_3.y - d9 * d * this.getRadius() * double_11.y);
            if (linkedList.size() > 0) {
                Point2D.Double double_14 = (Point2D.Double)linkedList.getLast();
                Point2D.Double double_15 = (Point2D.Double)linkedList.getFirst();
                if (double_12.distance(double_14) + double_13.distance(double_15) < double_12.distance(double_15) + double_13.distance(double_14)) {
                    linkedList.addLast(double_12);
                    linkedList.addFirst(double_13);
                    continue;
                }
                linkedList.addFirst(double_12);
                linkedList.addLast(double_13);
                continue;
            }
            linkedList.addLast(double_12);
            linkedList.addFirst(double_13);
        }
        if (this.getBases().size() >= 2) {
            n2 = this.getBases().get(this.getBases().size() - 1).getIndex();
            double_6 = doubleArray[n2];
            double_5 = doubleArray[n2 - 1];
            double_4 = doubleArray2[n2];
            bl = RNA.testDirectionality(double_6, double_5, double_4);
        }
        if (this.getBases().size() > 0) {
            n2 = this.getBases().get(this.getBases().size() - 1).getIndex();
            double_6 = doubleArray[n2];
            double_5 = doubleArray2[n2];
            double d10 = double_6.distance(double_5);
            double_3 = new Point2D.Double((double_5.x - double_6.x) / d10, (double_5.y - double_6.y) / d10);
            for (n = 1; n <= 10; ++n) {
                d2 = (double)n * Math.PI / 11.0;
                if (!bl) {
                    d2 += Math.PI;
                }
                double_2 = new Point2D.Double(Math.cos(d2) * double_3.x + Math.sin(d2) * double_3.y, -Math.sin(d2) * double_3.x + Math.cos(d2) * double_3.y);
                double_ = new Point2D.Double(double_6.x + d * this.getRadius() * double_2.x, double_6.y + d * this.getRadius() * double_2.y);
                linkedList.addLast(double_);
            }
        }
        if (linkedList.size() > 0) {
            Point2D.Double double_16 = (Point2D.Double)linkedList.get(0);
            generalPath.moveTo((float)double_16.x, (float)double_16.y);
            for (int i = 1; i < linkedList.size(); ++i) {
                double_16 = (Point2D.Double)linkedList.get(i);
                generalPath.lineTo((float)double_16.x, (float)double_16.y);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    public static HighlightRegionAnnotation parseHighlightRegionAnnotation(String string, VARNAPanel vARNAPanel) {
        try {
            String[] stringArray = string.split(":");
            String[] stringArray2 = stringArray[0].split("-");
            int n = Integer.parseInt(stringArray2[0]);
            int n2 = Integer.parseInt(stringArray2[1]);
            int n3 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
            int n4 = vARNAPanel.getRNA().getIndexFromBaseNumber(n2);
            Color color = DEFAULT_FILL_COLOR;
            Color color2 = DEFAULT_OUTLINE_COLOR;
            double d = 16.0;
            ArrayList<ModeleBase> arrayList = vARNAPanel.getRNA().getBasesBetween(n3, n4);
            try {
                String[] stringArray3 = stringArray[1].split(",");
                for (int i = 0; i < stringArray3.length; ++i) {
                    try {
                        String[] stringArray4 = stringArray3[i].split("=");
                        String string2 = stringArray4[0].toLowerCase();
                        String string3 = stringArray4[1];
                        if (string2.equals("fill")) {
                            color = VARNAConfigLoader.getSafeColor(string3, color);
                            continue;
                        }
                        if (string2.equals("outline")) {
                            color2 = VARNAConfigLoader.getSafeColor(string3, color2);
                            continue;
                        }
                        if (!string2.equals("radius")) continue;
                        d = Double.parseDouble(string3);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new HighlightRegionAnnotation(arrayList, color, color2, d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        String string = "Highlighted region " + this.getMinIndex() + "-" + this.getMaxIndex();
        return string;
    }
}

