/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionJPEGEncoding;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.views.VueBPThickness;
import fr.orsay.lri.varna.views.VueMenu;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

public class ControleurMenu
implements InterfaceVARNAListener,
ActionListener {
    private VARNAPanel _vp;
    private VueMenu _vm;
    private String _type;
    private String _color;
    private Object _source;

    public ControleurMenu(VARNAPanel vARNAPanel, VueMenu vueMenu) {
        this._vp = vARNAPanel;
        this._vm = vueMenu;
        this._vp.getRNA().addVARNAListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = actionEvent.getActionCommand().split(",");
        this._source = actionEvent.getSource();
        this._type = stringArray[0];
        this._color = stringArray.length > 1 ? stringArray[1] : "";
        if (!(this.optionRedraw() || this.optionExport() || this.optionImport() || this.optionRNADisplay() || this.optionTitle() || this.optionColorMap() || this.optionView() || this.optionBase() || this.optionBasePair() || this.optionLoop() || this.option3prime() || this.option5prime() || this.optionHelix() || this.optionStem() || this.optionBulge() || this.optionAnnotation() || this.optionEditRNA())) {
            this._vp.errorDialog(new Exception("Uknown action command '" + this._type + "'"));
        }
    }

    private boolean optionEditRNA() {
        if (this._type.equals("editallbps")) {
            this._vp.getVARNAUI().UIEditAllBasePairs();
        } else if (this._type.equals("editallbases")) {
            this._vp.getVARNAUI().UIEditAllBases();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionAnnotation() {
        if (!this._type.contains("annotation")) {
            return false;
        }
        if (this._type.equals("annotationsaddPosition")) {
            this._vp.getVARNAUI().UIAnnotationsAddPosition(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsaddBase")) {
            this._vp.getVARNAUI().UIAnnotationsAddBase(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsaddLoop")) {
            this._vp.getVARNAUI().UIAnnotationsAddLoop(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsaddChemProb")) {
            this._vp.getVARNAUI().UIAnnotationsAddChemProb(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsaddRegion")) {
            this._vp.getVARNAUI().UIAnnotationsAddRegion(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsaddHelix")) {
            this._vp.getVARNAUI().UIAnnotationsAddHelix(this._vp.getPopup().getSpawnPoint().x, this._vp.getPopup().getSpawnPoint().y);
        } else if (this._type.equals("annotationsautohelices")) {
            this._vp.getVARNAUI().UIAutoAnnotateHelices();
        } else if (this._type.equals("annotationsautointerior")) {
            this._vp.getVARNAUI().UIAutoAnnotateInteriorLoops();
        } else if (this._type.equals("annotationsautoterminal")) {
            this._vp.getVARNAUI().UIAutoAnnotateTerminalLoops();
        } else if (this._type.equals("annotationsautohelices")) {
            this._vp.getVARNAUI().UIAutoAnnotateHelices();
        } else if (this._type.equals("annotationsremove")) {
            this._vp.getVARNAUI().UIAnnotationsRemove();
        } else if (this._type.equals("annotationsautoextremites")) {
            this._vp.getVARNAUI().UIAutoAnnotateStrandEnds();
        } else if (this._type.equals("annotationsedit")) {
            this._vp.getVARNAUI().UIAnnotationsEdit();
        } else if (this._type.equals("Selectionannotationremove")) {
            this._vp.getVARNAUI().UIAnnotationRemoveFromAnnotation(this._vp.get_selectedAnnotation());
        } else if (this._type.equals("Selectionannotationedit")) {
            this._vp.getVARNAUI().UIAnnotationEditFromAnnotation(this._vp.get_selectedAnnotation());
        } else if (this._type.endsWith("annotationadd") || this._type.contains("annotationremove") || this._type.contains("annotationedit")) {
            try {
                TextAnnotation.AnchorType anchorType = this.trouverAncrage();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                switch (anchorType) {
                    case BASE: {
                        arrayList.add(this._vp.getNearestBase());
                    }
                    case LOOP: {
                        if (this._type.startsWith("loop1")) {
                            arrayList = this._vp.getRNA().findLoopForward(this._vp.getNearestBase());
                            break;
                        }
                        if (this._type.startsWith("loop2")) {
                            arrayList = this._vp.getRNA().findLoopBackward(this._vp.getNearestBase());
                            break;
                        }
                        arrayList = this._vp.getRNA().findLoop(this._vp.getNearestBase());
                        break;
                    }
                    case HELIX: {
                        arrayList = this._vp.getRNA().findHelix(this._vp.getNearestBase());
                    }
                }
                if (this._type.endsWith("annotationadd")) {
                    this._vp.getVARNAUI().UIAnnotationAddFromStructure(anchorType, arrayList);
                } else if (this._type.contains("annotationremove")) {
                    this._vp.getVARNAUI().UIAnnotationRemoveFromStructure(this.trouverAncrage(), arrayList);
                } else if (this._type.contains("annotationedit")) {
                    this._vp.getVARNAUI().UIAnnotationEditFromStructure(this.trouverAncrage(), arrayList);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return false;
        }
        return true;
    }

    private TextAnnotation.AnchorType trouverAncrage() {
        if (this._type.contains("loop")) {
            return TextAnnotation.AnchorType.LOOP;
        }
        if (this._type.contains("helix")) {
            return TextAnnotation.AnchorType.HELIX;
        }
        if (this._type.contains("base")) {
            return TextAnnotation.AnchorType.BASE;
        }
        this.errorDialog(new Exception("probleme d'identification de l'ancrage"));
        return TextAnnotation.AnchorType.POSITION;
    }

    private boolean option5prime() {
        return this.colorBases();
    }

    private boolean option3prime() {
        return this.colorBases();
    }

    private boolean optionBulge() {
        return this.colorBases();
    }

    private boolean optionStem() {
        return this.colorBases();
    }

    private boolean optionHelix() {
        return this.colorBases();
    }

    private boolean colorBases() {
        ArrayList<Object> arrayList = new ArrayList();
        String string = "Choose new " + this._type;
        if (this._color.equals("InnerColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " inner color", VARNAConfig.BASE_INNER_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i)).getStyleBase().setBaseInnerColor(color);
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("OutlineColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " outline color", VARNAConfig.BASE_OUTLINE_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i)).getStyleBase().setBaseOutlineColor(color);
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("NameColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " name color", VARNAConfig.BASE_NAME_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i)).getStyleBase().setBaseNameColor(color);
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("NumberColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " number color", VARNAConfig.BASE_NUMBER_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i)).getStyleBase().setBaseNumberColor(color);
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("BPColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " base-pair color", VARNAConfig.BASE_NUMBER_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    for (ModeleBP modeleBP : this._vp.getRNA().getBPsAt((Integer)arrayList.get(i))) {
                        if (modeleBP == null) continue;
                        modeleBP.getStyle().setCustomColor(color);
                    }
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("BPColor")) {
            Color color = JColorChooser.showDialog(this._vp, string = string + " base-pair color", VARNAConfig.BASE_NUMBER_COLOR_DEFAULT);
            if (color != null) {
                arrayList = this.listSwitchType(this._type);
                for (int i = 0; i < arrayList.size(); ++i) {
                    ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i));
                    if (modeleBase.getElementStructure() == -1) continue;
                    modeleBase.getStyleBP().getStyle().setCustomColor(color);
                }
                this._vp.repaint();
            }
        } else if (this._color.equals("BPThickness")) {
            arrayList = this.listSwitchType(this._type);
            ArrayList<ModeleBP> arrayList2 = new ArrayList<ModeleBP>();
            for (int i = 0; i < arrayList.size(); ++i) {
                ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get((Integer)arrayList.get(i));
                if (modeleBase.getElementStructure() == -1) continue;
                arrayList2.add(modeleBase.getStyleBP());
            }
            VueBPThickness vueBPThickness = new VueBPThickness(this._vp, arrayList2);
            if (JOptionPane.showConfirmDialog(this._vp, vueBPThickness.getPanel(), "Set base pair(s) thickness", 2) != 0) {
                vueBPThickness.restoreThicknesses();
                this._vp.repaint();
            }
        } else {
            return false;
        }
        return true;
    }

    private ArrayList<Integer> listSwitchType(String string) {
        if (string.equals("helix")) {
            return this._vp.getRNA().findHelix(this._vp.getNearestBase());
        }
        if (string.equals("current")) {
            return this._vp.getSelectionIndices();
        }
        if (string.equals("allBases")) {
            return this._vp.getRNA().findAll();
        }
        if (string.equals("loop1")) {
            return this._vp.getRNA().findLoopForward(this._vp.getNearestBase());
        }
        if (string.equals("loop2")) {
            return this._vp.getRNA().findLoopBackward(this._vp.getNearestBase());
        }
        if (string.equals("stem")) {
            return this._vp.getRNA().findStem(this._vp.getNearestBase());
        }
        if (string.equals("base")) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(this._vp.getNearestBase());
            return arrayList;
        }
        if (string.equals("basepair") || string.equals("bpcolor") || string.equals("bp")) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = this._vp.getNearestBase();
            arrayList.add(n);
            ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(n);
            int n2 = modeleBase.getElementStructure();
            if (modeleBase.getElementStructure() != -1) {
                arrayList.add(n);
                arrayList.add(n2);
            }
            return arrayList;
        }
        if (string.equals("5'")) {
            return this._vp.getRNA().findNonPairedBaseGroup(this._vp.getNearestBase());
        }
        if (string.equals("3'")) {
            return this._vp.getRNA().findNonPairedBaseGroup(this._vp.getNearestBase());
        }
        if (string.equals("bulge")) {
            return this._vp.getRNA().findNonPairedBaseGroup(this._vp.getNearestBase());
        }
        if (string.equals("all")) {
            return this._vp.getRNA().findAll();
        }
        return new ArrayList<Integer>();
    }

    private boolean optionLoop() {
        return this.colorBases();
    }

    private boolean optionBase() {
        if (this._type.equals("baseChar")) {
            this._vp.getVARNAUI().UISetBaseCharacter();
            return true;
        }
        return this.colorBases();
    }

    private boolean optionBasePair() {
        if (this._type.equals("basepair")) {
            this._vp.getVARNAUI().UIEditBasePair();
            return true;
        }
        if (this._type.equals("bpcolor")) {
            this._vp.getVARNAUI().UIColorBasePair();
            return true;
        }
        if (this._type.equals("thickness")) {
            this._vp.getVARNAUI().UIThicknessBasePair();
            return true;
        }
        return false;
    }

    private boolean optionView() {
        if (this._type.equals("background")) {
            this._vp.getVARNAUI().UISetBackground();
        } else if (this._type.equals("shownc")) {
            this._vp.getVARNAUI().UIToggleShowNCBP();
        } else if (this._type.equals("shownp")) {
            this._vp.getVARNAUI().UIToggleShowNonPlanar();
        } else if (this._type.equals("spaceBetweenBases")) {
            this._vp.getVARNAUI().UISetSpaceBetweenBases();
        } else if (this._type.equals("bpheightincrement")) {
            this._vp.getVARNAUI().UISetBPHeightIncrement();
        } else if (this._type.equals("borderSize")) {
            this._vp.getVARNAUI().UISetBorder();
        } else if (this._type.startsWith("zoom")) {
            if (this._type.equals("zoom")) {
                this._vp.getVARNAUI().UICustomZoom();
            } else {
                String string = this._type.substring("zoom".length());
                double d = Integer.parseInt(string);
                this._vp.setZoom(new Double(d /= 100.0));
                this._vp.repaint();
            }
        } else if (this._type.equals("rotation")) {
            this._vp.getVARNAUI().UIGlobalRotation();
        } else if (this._type.equals("rescale")) {
            this._vp.getVARNAUI().UIGlobalRescale();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionTitle() {
        if (this._type.equals("titleDisplay")) {
            this._vp.getVARNAUI().UISetTitleFont();
        } else if (this._type.equals("setTitle")) {
            this._vp.getVARNAUI().UISetTitle();
        } else if (this._type.equals("titleColor")) {
            this._vp.getVARNAUI().UISetTitleColor();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionColorMap() {
        if (this._type.equals("toggleshowcolormap")) {
            this._vp.getVARNAUI().UIToggleColorMap();
        } else if (this._type.equals("colormapcaption")) {
            this._vp.getVARNAUI().UISetColorMapCaption();
        } else if (this._type.equals("colormapstyle")) {
            this._vp.getVARNAUI().UISetColorMapStyle();
        } else if (this._type.equals("colormaploadvalues")) {
            this._vp.getVARNAUI().UILoadColorMapValues();
        } else if (this._type.equals("colormapvalues")) {
            this._vp.getVARNAUI().UISetColorMapValues();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionRNADisplay() {
        if (this._type.equals("gaspin")) {
            this._vp.getVARNAUI().UIToggleGaspinMode();
        } else if (this._type.equals("backbone")) {
            this._vp.getVARNAUI().UISetBackboneColor();
        } else if (this._type.equals("bonds")) {
            Color color = JColorChooser.showDialog(this._vp, "Choose new bonds color", this._vp.getBackground());
            if (color != null) {
                this._vp.setDefaultBPColor(color);
                this._vp.repaint();
            }
        } else if (this._type.equals("basecolorforBP")) {
            if (this._source != null && this._source instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this._source;
                this._vp.setUseBaseColorsForBPs(jCheckBoxMenuItem.getState());
                this._vp.repaint();
            }
        } else if (this._type.equals("bpstyle")) {
            this._vp.getVARNAUI().UISetBPStyle();
        } else if (this._type.equals("specialbasecolored")) {
            this._vp.getVARNAUI().UIToggleColorSpecialBases();
        } else if (this._type.equals("showwarnings")) {
            this._vp.getVARNAUI().UIToggleShowWarnings();
        } else if (this._type.equals("dashbasecolored")) {
            this._vp.getVARNAUI().UIToggleColorGapsBases();
        } else if (this._type.equals("numPeriod")) {
            this._vp.getVARNAUI().UISetNumPeriod();
        } else if (this._type.equals("eachKind")) {
            if (this._vp.getRNA().get_listeBases() != null) {
                this._vp.getVARNAUI().UIBaseTypeColor();
            } else {
                this._vp.emitWarning("No base");
            }
        } else if (this._type.equals("eachCouple")) {
            if (this._vp.getRNA().get_listeBases() != null && this._vp.getRNA().get_listeBases().size() != 0) {
                this._vp.getVARNAUI().UIBasePairTypeColor();
            } else {
                this._vp.emitWarning("No base");
            }
        } else if (this._type.equals("eachBase")) {
            if (this._vp.getRNA().get_listeBases() != null && this._vp.getRNA().get_listeBases().size() != 0) {
                this._vp.getVARNAUI().UIBaseAllColor();
            } else {
                this._vp.emitWarning("No base");
            }
        } else if (this._type.equals("specialBasesColor")) {
            this._vp.getVARNAUI().UIPickSpecialBasesColor();
        } else if (this._type.equals("dashBasesColor")) {
            this._vp.getVARNAUI().UIPickGapsBasesColor();
        } else {
            return this.colorBases();
        }
        return true;
    }

    private boolean optionImport() {
        if (this._type.equals("userInput")) {
            try {
                this._vp.getVARNAUI().UIManualInput();
            }
            catch (ParseException parseException) {
                this.errorDialog(parseException);
            }
            catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                this.errorDialog(exceptionNonEqualLength);
            }
        } else if (this._type.equals("file")) {
            try {
                this._vp.getVARNAUI().UIFile();
            }
            catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                this.errorDialog(exceptionNonEqualLength);
            }
        } else if (this._type.equals("print")) {
            this._vp.getVARNAUI().UIPrint();
        } else if (this._type.equals("about")) {
            this._vp.getVARNAUI().UIAbout();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionRedraw() {
        if (this._type.equals("reset")) {
            this._vp.getVARNAUI().UIReset();
        } else if (this._type.equals("circular")) {
            this._vp.getVARNAUI().UICircular();
        } else if (this._type.equals("radiate")) {
            this._vp.getVARNAUI().UIRadiate();
        } else if (this._type.equals("naview")) {
            this._vp.getVARNAUI().UINAView();
        } else if (this._type.equals("varnaview")) {
            this._vp.getVARNAUI().UIVARNAView();
        } else if (this._type.equals("motifview")) {
            this._vp.getVARNAUI().UIMOTIFView();
        } else if (this._type.equals("line")) {
            this._vp.getVARNAUI().UILine();
        } else if (this._type.equals("flat")) {
            this._vp.getVARNAUI().UIToggleFlatExteriorLoop();
        } else {
            return false;
        }
        return true;
    }

    private boolean optionExport() {
        if (this._type.equals("saveas")) {
            try {
                this._vp.getVARNAUI().UISaveAs();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
            catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                this.errorDialog(exceptionPermissionDenied);
            }
        } else if (this._type.equals("dbn")) {
            try {
                this._vp.getVARNAUI().UISaveAsDBN();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
            catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                this.errorDialog(exceptionPermissionDenied);
            }
        } else if (this._type.equals("bpseq")) {
            try {
                this._vp.getVARNAUI().UISaveAsBPSEQ();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
            catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                this.errorDialog(exceptionPermissionDenied);
            }
        } else if (this._type.equals("ct")) {
            try {
                this._vp.getVARNAUI().UISaveAsCT();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
            catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                this.errorDialog(exceptionPermissionDenied);
            }
        } else if (this._type.equals("eps")) {
            try {
                this._vp.getVARNAUI().UIExportEPS();
            }
            catch (ExceptionWritingForbidden exceptionWritingForbidden) {
                this.errorDialog(exceptionWritingForbidden);
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
        } else if (this._type.equals("xfig")) {
            try {
                this._vp.getVARNAUI().UIExportXFIG();
            }
            catch (ExceptionWritingForbidden exceptionWritingForbidden) {
                this.errorDialog(exceptionWritingForbidden);
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
        } else if (this._type.equals("svg")) {
            try {
                this._vp.getVARNAUI().UIExportSVG();
            }
            catch (ExceptionWritingForbidden exceptionWritingForbidden) {
                this.errorDialog(exceptionWritingForbidden);
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
        } else if (this._type.equals("jpeg")) {
            try {
                this._vp.getVARNAUI().UIExportJPEG();
            }
            catch (ExceptionJPEGEncoding exceptionJPEGEncoding) {
                this.errorDialog(exceptionJPEGEncoding);
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
        } else if (this._type.equals("png")) {
            try {
                this._vp.getVARNAUI().UIExportPNG();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                this.errorDialog(exceptionExportFailed);
            }
        } else {
            return false;
        }
        return true;
    }

    public String getExtension(File file) {
        String string = file.getName();
        return this.getExtension(string);
    }

    public String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public void errorDialog(Exception exception) {
        if (this._vp.isErrorsOn()) {
            JOptionPane.showMessageDialog(this._vp, exception.getMessage(), "VARNA Error", 0);
        }
    }

    @Override
    public void onStructureRedrawn() {
    }

    @Override
    public void onWarningEmitted(String string) {
        if (this._vp.isErrorsOn()) {
            JOptionPane.showMessageDialog(this._vp, string, "VARNA Warning", 0);
        }
    }

    public void onLoad(String string) {
    }

    public void onLoaded() {
    }

    @Override
    public void onUINewStructure(VARNAConfig vARNAConfig, RNA rNA) {
    }

    @Override
    public void onZoomLevelChanged() {
    }

    @Override
    public void onTranslationChanged() {
    }
}

