/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ReorderableJList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    static DataFlavor localObjectFlavor;
    static DataFlavor[] supportedFlavors;
    DragSource dragSource;
    DropTarget dropTarget;
    int dropTargetIndex;
    int draggedIndex = -1;

    public ReorderableJList() {
        this.setCellRenderer(new ReorderableListCellRenderer());
        this.setModel(new DefaultListModel());
        this.dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        int n = this.locationToIndex(point);
        if (n == -1) {
            return;
        }
        Object e = this.getModel().getElementAt(n);
        RJLTransferable rJLTransferable = new RJLTransferable(e);
        this.draggedIndex = n;
        this.dragSource.startDrag(dragGestureEvent, Cursor.getDefaultCursor(), rJLTransferable, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dropTargetIndex = -1;
        this.draggedIndex = -1;
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.getSource() != this.dropTarget) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(3);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        if (dropTargetDragEvent.getSource() != this.dropTarget) {
            dropTargetDragEvent.rejectDrag();
        }
        Point point = dropTargetDragEvent.getLocation();
        this.dropTargetIndex = n = this.locationToIndex(point);
        if (this.dropTargetIndex != -1) {
            Rectangle rectangle = this.getCellBounds(this.dropTargetIndex, this.dropTargetIndex);
            if (point.y > rectangle.y + rectangle.height / 2) {
                ++this.dropTargetIndex;
            }
        }
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.getSource() != this.dropTarget) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Point point = dropTargetDropEvent.getLocation();
        int n = this.locationToIndex(point);
        if (n != -1) {
            Rectangle rectangle = this.getCellBounds(n, n);
            if (point.y > rectangle.y + rectangle.height / 2) {
                ++n;
            }
        }
        boolean bl = false;
        try {
            if (n == -1 || n == this.draggedIndex || n == this.draggedIndex + 1) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(2);
            Object object = dropTargetDropEvent.getTransferable().getTransferData(localObjectFlavor);
            boolean bl2 = this.draggedIndex < n;
            DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
            defaultListModel.remove(this.draggedIndex);
            defaultListModel.add(bl2 ? n - 1 : n, object);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dropTargetDropEvent.dropComplete(bl);
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    private class RJLTransferable
    implements Transferable {
        Object object;

        public RJLTransferable(Object object) {
            this.object = object;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(localObjectFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }

    private class ReorderableListCellRenderer
    extends DefaultListCellRenderer {
        boolean isTargetCell;
        boolean isLastItem;

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.isTargetCell = n == ReorderableJList.this.dropTargetIndex;
            this.isLastItem = n == jList.getModel().getSize() - 1 && ReorderableJList.this.dropTargetIndex == jList.getModel().getSize();
            boolean bl3 = bl;
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl3, bl2);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isTargetCell) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.getSize().width, 0);
            }
            if (this.isLastItem) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
            }
        }
    }
}

