/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.FileNameExtensionFilter;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditorPanelUI;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionXMLGeneration;
import fr.orsay.lri.varna.models.templates.Benchmark;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateCurveMethod;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateMethod;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.undo.UndoManager;

public class TemplateEditor
extends JFrame
implements KeyListener,
ActionListener,
DropTargetListener {
    private TemplatePanel _sk;
    private VARNAPanel _vp;
    private File currentFilePath = null;
    private JButton saveButton;
    private JScrollPane jp;
    private UndoManager manager;
    private JButton flipButton;
    private JComboBox ellipseMethodList;
    private JComboBox applyMethodList;
    private static final long serialVersionUID = -5942729520783690050L;

    public TemplateEditor() {
        this.init();
        this.clearCurrentFilePath();
    }

    public JScrollPane getJp() {
        return this.jp;
    }

    private void init() {
        try {
            this._vp = new VARNAPanel(" ", ".");
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            exceptionNonEqualLength.printStackTrace();
        }
        this._vp.setNumPeriod(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        JToolBar jToolBar = new JToolBar();
        JToolBar jToolBar2 = new JToolBar();
        JButton jButton = new JButton("New", UIManager.getIcon("FileView.fileIcon"));
        jButton.setActionCommand("new");
        jButton.addActionListener(this);
        jButton.addKeyListener(this);
        JButton jButton2 = new JButton("Open...", UIManager.getIcon("FileView.directoryIcon"));
        jButton2.setActionCommand("open");
        jButton2.addActionListener(this);
        jButton2.addKeyListener(this);
        this.saveButton = new JButton("Save", UIManager.getIcon("FileView.floppyDriveIcon"));
        this.saveButton.setActionCommand("save");
        this.saveButton.addActionListener(this);
        this.saveButton.addKeyListener(this);
        this.saveButton.setEnabled(false);
        JButton jButton3 = new JButton("Save As...", UIManager.getIcon("FileView.floppyDriveIcon"));
        jButton3.setActionCommand("save as");
        jButton3.addActionListener(this);
        jButton3.addKeyListener(this);
        JButton jButton4 = new JButton("Undo");
        jButton4.setActionCommand("undo");
        jButton4.addActionListener(this);
        jButton4.addKeyListener(this);
        JButton jButton5 = new JButton("Redo");
        jButton5.setActionCommand("redo");
        jButton5.addActionListener(this);
        jButton5.addKeyListener(this);
        JButton jButton6 = new JButton("Benchmark");
        jButton6.setActionCommand("benchmark");
        jButton6.addActionListener(this);
        jButton6.addKeyListener(this);
        DrawRNATemplateMethod[] drawRNATemplateMethodArray = DrawRNATemplateMethod.values();
        this.applyMethodList = new JComboBox<DrawRNATemplateMethod>(drawRNATemplateMethodArray);
        this.applyMethodList.setSelectedItem((Object)DrawRNATemplateMethod.getDefault());
        DrawRNATemplateCurveMethod[] drawRNATemplateCurveMethodArray = DrawRNATemplateCurveMethod.values();
        this.ellipseMethodList = new JComboBox<DrawRNATemplateCurveMethod>(drawRNATemplateCurveMethodArray);
        this.ellipseMethodList.setSelectedItem((Object)DrawRNATemplateCurveMethod.getDefault());
        JButton jButton7 = new JButton("Apply");
        jButton7.setActionCommand("apply");
        jButton7.addActionListener(this);
        jButton7.addKeyListener(this);
        JButton jButton8 = new JButton("Retrieve Templates");
        jButton8.setActionCommand("retrieve");
        jButton8.addActionListener(this);
        this.flipButton = new JButton("Flip helix");
        this.flipButton.setActionCommand("flip");
        this.flipButton.addActionListener(this);
        this.flipButton.addKeyListener(this);
        this.flipButton.setEnabled(false);
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        jToolBar.add(this.saveButton);
        jToolBar.add(jButton3);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(jButton6);
        jToolBar.addKeyListener(this);
        jToolBar2.setLayout(new FlowLayout(0));
        jToolBar2.add(new JLabel("Single-Stranded "));
        jToolBar2.add(this.ellipseMethodList);
        jToolBar2.addSeparator();
        jToolBar2.add(new JLabel("Layout "));
        jToolBar2.add(this.applyMethodList);
        jToolBar2.addSeparator();
        jToolBar2.add(jButton7);
        jToolBar2.addSeparator();
        jToolBar2.add(jButton8);
        jToolBar2.doLayout();
        JToolBar jToolBar3 = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        jToolBar3.setOrientation(1);
        JToggleButton jToggleButton = new JToggleButton("Select");
        jToggleButton.setActionCommand("select");
        jToggleButton.addActionListener(this);
        jToggleButton.addKeyListener(this);
        JToggleButton jToggleButton2 = new JToggleButton("Helix");
        jToggleButton2.setActionCommand("helix");
        jToggleButton2.addActionListener(this);
        jToggleButton2.addKeyListener(this);
        jToggleButton2.setSelected(true);
        JToggleButton jToggleButton3 = new JToggleButton("Unpaired");
        jToggleButton3.setActionCommand("unpaired");
        jToggleButton3.addActionListener(this);
        jToggleButton3.addKeyListener(this);
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        jToolBar3.add(jButton4);
        jToolBar3.add(jButton5);
        jToolBar3.addSeparator();
        jToolBar3.add(new JLabel("Tools:"));
        jToolBar3.add(jToggleButton);
        jToolBar3.add(jToggleButton2);
        jToolBar3.add(jToggleButton3);
        jToolBar3.addSeparator();
        jToolBar3.add(this.flipButton);
        jToolBar.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this._sk = new TemplatePanel(this);
        this._sk.setPreferredSize(new Dimension(800, 600));
        this.manager = new UndoManager();
        this.manager.setLimit(2000);
        this._sk.addUndoableEditListener(this.manager);
        this._sk.addKeyListener(this);
        this.jp = new JScrollPane(this._sk, 22, 32);
        jPanel.add(this.jp);
        jPanel.add(this._vp);
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 1);
        jPanel2.setLayout(boxLayout);
        jToolBar.setAlignmentX(0.0f);
        jPanel2.add(jToolBar);
        jToolBar2.setAlignmentX(0.0f);
        jPanel2.add(jToolBar2);
        this.getContentPane().add((Component)jPanel2, "First");
        this.getContentPane().add((Component)jToolBar3, "West");
        this.getContentPane().add((Component)jPanel, "Center");
        this.addKeyListener(this);
        new DropTarget(this._vp, this);
        new DropTarget(this._sk, this);
        this.pack();
        this._sk.requestFocusInWindow();
    }

    private File getCurrentFilePath() {
        return this.currentFilePath;
    }

    private void setCurrentFilePath(File file) {
        this.currentFilePath = file;
        this.saveButton.setEnabled(true);
        this.setTitle("VARNA Template Editor: " + file);
    }

    private void clearCurrentFilePath() {
        this.currentFilePath = null;
        this.saveButton.setEnabled(false);
        this.setTitle("VARNA Template Editor: New file");
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = UIManager.getInstalledLookAndFeels();
            int n = 1;
            UIManager.LookAndFeelInfo lookAndFeelInfo = object[n % ((UIManager.LookAndFeelInfo[])object).length];
            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new TemplateEditor();
        ((Window)object).pack();
        ((Window)object).setVisible(true);
        ((JFrame)object).setDefaultCloseOperation(3);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        System.out.println(keyEvent);
        switch (keyEvent.getKeyCode()) {
            case 127: {
                GraphicalTemplateElement graphicalTemplateElement = this._sk.getSelected();
                this._sk.Unselect();
                this._sk.getTemplateUI().removeElementUI(graphicalTemplateElement);
                this._sk.repaint();
                break;
            }
            case 90: {
                if (!keyEvent.isControlDown()) break;
                this.undo();
                break;
            }
            case 89: {
                if (!keyEvent.isControlDown()) break;
                this.redo();
            }
        }
    }

    public void undo() {
        if (this.manager.canUndo()) {
            this.manager.undo();
        }
    }

    public void redo() {
        if (this.manager.canRedo()) {
            this.manager.redo();
        }
    }

    public void clearTemplate() {
        this._sk.clearTemplate();
        this.clearCurrentFilePath();
        this.manager.discardAllEdits();
    }

    public void loadTemplate(File file) {
        this._sk.loadFromXmlFile(file);
        this.setCurrentFilePath(file);
        this.manager.discardAllEdits();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        System.out.println(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        System.out.println(keyEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("undo")) {
            this.undo();
        } else if (actionEvent.getActionCommand().equals("redo")) {
            this.redo();
        } else if (actionEvent.getActionCommand().equals("flip")) {
            GraphicalTemplateElement graphicalTemplateElement = this._sk.getSelected();
            if (graphicalTemplateElement != null && graphicalTemplateElement instanceof Helix) {
                this._sk.getTemplateUI().flipHelixUI((Helix)graphicalTemplateElement);
            }
        } else if (actionEvent.getActionCommand().equals("select")) {
            this._sk.getTemplateUI().setSelectedTool(TemplateEditorPanelUI.Tool.SELECT);
        } else if (actionEvent.getActionCommand().equals("helix")) {
            this._sk.getTemplateUI().setSelectedTool(TemplateEditorPanelUI.Tool.CREATE_HELIX);
        } else if (actionEvent.getActionCommand().equals("retrieve")) {
            this.retrieveTemplates();
        } else if (actionEvent.getActionCommand().equals("unpaired")) {
            this._sk.getTemplateUI().setSelectedTool(TemplateEditorPanelUI.Tool.CREATE_UNPAIRED);
        } else if (actionEvent.getActionCommand().equals("apply")) {
            try {
                DrawRNATemplateMethod drawRNATemplateMethod = (DrawRNATemplateMethod)((Object)this.applyMethodList.getSelectedItem());
                DrawRNATemplateCurveMethod drawRNATemplateCurveMethod = (DrawRNATemplateCurveMethod)((Object)this.ellipseMethodList.getSelectedItem());
                RNATemplateMapping rNATemplateMapping = this._vp.getRNA().drawRNATemplate(this._sk.getTemplate(), this._vp.getConfig(), drawRNATemplateMethod, drawRNATemplateCurveMethod);
                for (int n : rNATemplateMapping.getSourceElemsAsSet()) {
                    RNATemplate.RNATemplateElement rNATemplateElement = rNATemplateMapping.getPartner(n);
                    Color color = this._sk.getElement(rNATemplateElement).getDominantColor();
                    this._vp.getRNA().getBaseAt(n).getStyleBase().setBaseInnerColor(color);
                }
                this._vp.repaint();
            }
            catch (RNATemplateDrawingAlgorithmException rNATemplateDrawingAlgorithmException) {
                rNATemplateDrawingAlgorithmException.printStackTrace();
                JOptionPane.showMessageDialog(this, rNATemplateDrawingAlgorithmException.getMessage(), "Template-based RNA drawing error", 0);
            }
        } else if (actionEvent.getActionCommand().equals("save")) {
            try {
                this._sk.getTemplate().toXMLFile(this.getCurrentFilePath());
                System.out.println("Template saved in " + this.getCurrentFilePath().toString());
            }
            catch (ExceptionXMLGeneration exceptionXMLGeneration) {
                exceptionXMLGeneration.printStackTrace();
            }
            catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
                exceptionInvalidRNATemplate.printStackTrace();
            }
        } else if (actionEvent.getActionCommand().equals("save as")) {
            JFileChooser jFileChooser = new JFileChooser();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("VARNA RNA template (.xml)", "xml");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            if (jFileChooser.showSaveDialog(this._sk) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                if (!string.toLowerCase().endsWith(".xml")) {
                    string = string + ".xml";
                }
                try {
                    this._sk.getTemplate().toXMLFile(new File(string));
                    System.out.println("Template saved in " + string);
                    this.setCurrentFilePath(new File(string));
                }
                catch (ExceptionXMLGeneration exceptionXMLGeneration) {
                    exceptionXMLGeneration.printStackTrace();
                }
                catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
                    exceptionInvalidRNATemplate.printStackTrace();
                }
            }
        } else if (actionEvent.getActionCommand().equals("new")) {
            this.clearTemplate();
        } else if (actionEvent.getActionCommand().equals("open")) {
            JFileChooser jFileChooser = new JFileChooser();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("VARNA RNA template (.xml)", "xml");
            jFileChooser.setFileFilter(fileNameExtensionFilter);
            if (jFileChooser.showOpenDialog(this._sk) == 0) {
                File file = jFileChooser.getSelectedFile();
                this.loadTemplate(file);
            }
        } else if (actionEvent.getActionCommand().equals("benchmark")) {
            new Benchmark(this._vp.getRNA()).printAll();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(3);
                List list = (List)transferable.getTransferData(dataFlavorArray[i]);
                for (int j = 0; j < list.size(); ++j) {
                    String string;
                    JPanel jPanel;
                    Object e = list.get(j);
                    if (!(dropTargetDropEvent.getSource() instanceof DropTarget)) continue;
                    DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
                    Component component = dropTarget.getComponent();
                    if (component instanceof VARNAPanel) {
                        jPanel = (VARNAPanel)component;
                        string = e.toString();
                        ((VARNAPanel)jPanel).loadFile(string, true);
                        jPanel.repaint();
                        continue;
                    }
                    if (!(component instanceof TemplatePanel)) continue;
                    jPanel = (TemplatePanel)component;
                    string = e.toString();
                    ((TemplatePanel)jPanel).loadFromXmlFile(new File(string));
                    jPanel.repaint();
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public VARNAPanel getVarnaPanel() {
        return this._vp;
    }

    public void flipButtonEnable() {
        this.flipButton.setEnabled(true);
    }

    public void flipButtonDisable() {
        this.flipButton.setEnabled(false);
    }

    public void retrieveTemplates() {
        try {
            URL uRL = new URL("http://127.0.0.1/VARNA/templateShare/actions.php?action=retrieve&nbHelices=3&nbMultiLoops=1&length=50");
            URLConnection uRLConnection = uRL.openConnection();
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

