/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;

public class VARNAGUIModel
implements Comparable<VARNAGUIModel> {
    private Date _lastModified;
    private boolean _outOfSync = false;
    private RNA _r = null;
    private String _caption = "";
    private String _path = "";
    private String _folder = "";
    public static DataFlavor Flavor = new DataFlavor(VARNAGUIModel.class, "VARNA Object");

    public static Date lastModif(String string) {
        return new Date(new File(string).lastModified());
    }

    public VARNAGUIModel(String string, String string2) {
        this(string, string2, VARNAGUIModel.lastModif(string2));
    }

    public VARNAGUIModel(String string, String string2, Date date) {
        this._lastModified = date;
        this._outOfSync = false;
        this._folder = string;
        this._path = string2;
        String[] stringArray = string2.split(Pattern.quote(File.separator));
        if (stringArray.length > 0) {
            this._caption = stringArray[stringArray.length - 1];
        }
    }

    public boolean hasChanged() {
        return this._outOfSync;
    }

    public boolean checkForModifications() {
        if (!VARNAGUIModel.lastModif(this._path).equals(this._lastModified) && !this._outOfSync) {
            this._outOfSync = true;
            return true;
        }
        return false;
    }

    public RNA getRNA() {
        if (this._r == null) {
            try {
                this.createRNA();
            }
            catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                exceptionUnmatchedClosingParentheses.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                exceptionFileFormatOrSyntax.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (ExceptionExportFailed exceptionExportFailed) {
                exceptionExportFailed.printStackTrace();
            }
            catch (ExceptionPermissionDenied exceptionPermissionDenied) {
                exceptionPermissionDenied.printStackTrace();
            }
            catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                exceptionLoadingFailed.printStackTrace();
            }
        }
        return this._r;
    }

    private RNA createRNA() throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax, FileNotFoundException, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed {
        ArrayList<RNA> arrayList = RNAFactory.loadSecStr(this._path);
        if (arrayList.size() <= 0) {
            throw new ExceptionFileFormatOrSyntax("No valid RNA defined in this file.");
        }
        this._r = (RNA)arrayList.iterator().next();
        this._r.drawRNARadiate();
        return this._r;
    }

    public String toString() {
        return this._caption + (this._outOfSync ? "*" : "");
    }

    public String getID() {
        return this.getRNA().getID();
    }

    public String getCaption() {
        return this._caption;
    }

    public String getFolder() {
        return this._folder;
    }

    @Override
    public int compareTo(VARNAGUIModel vARNAGUIModel) {
        return this._caption.compareTo(vARNAGUIModel._caption);
    }
}

