/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurDemoTextField;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VARNAOnlineDemo
extends JApplet {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE = "CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA";
    private static final String DEFAULT_STRUCTURE = "..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..";
    private VARNAPanel _vp;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _structPanel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _struct = new JTextField();
    private JTextField _seq = new JTextField();
    private JLabel _structLabel = new JLabel(" Str:");
    private JLabel _seqLabel = new JLabel(" Seq:");
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private int _algoCode;

    public VARNAOnlineDemo() {
        try {
            this._vp = new VARNAPanel(this._seq.getText(), this._struct.getText());
            this._vp.setErrorsOn(false);
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            this._vp.errorDialog(exceptionNonEqualLength);
        }
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int n = 40;
        this.setBackground(this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        try {
            this._vp.getRNA().setRNA(this._seq.getText(), this._struct.getText());
            this._vp.setErrorsOn(false);
        }
        catch (Exception exception) {
            this._vp.errorDialog(exception);
        }
        Font font = Font.decode("MonoSpaced-PLAIN-12");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(n, 15));
        this._seq.setFont(font);
        this._seq.setText(this._vp.getRNA().getSeq());
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq, "Center");
        this._structLabel.setPreferredSize(new Dimension(n, 15));
        this._structLabel.setHorizontalTextPosition(2);
        this._struct.setFont(font);
        this._struct.setText(this._vp.getRNA().getStructDBN());
        this._structPanel.setLayout(new BorderLayout());
        this._structPanel.add((Component)this._structLabel, "West");
        this._structPanel.add((Component)this._struct, "Center");
        ControleurDemoTextField controleurDemoTextField = new ControleurDemoTextField(this);
        this._seq.addCaretListener(controleurDemoTextField);
        this._struct.addCaretListener(controleurDemoTextField);
        this._input.setLayout(new GridLayout(3, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._structPanel);
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._vp, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vp.getVARNAUI().UIRadiate();
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return stringArray;
    }

    @Override
    public void init() {
        this.retrieveParametersValues();
        this._vp.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String string, Color color) {
        Color color2;
        try {
            color2 = Color.decode(string);
        }
        catch (Exception exception) {
            try {
                color2 = Color.getColor(string, color);
            }
            catch (Exception exception2) {
                return color;
            }
        }
        return color2;
    }

    private String getParameterValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private void retrieveParametersValues() {
        this._error = Boolean.parseBoolean(this.getParameterValue(errorOpt, "false"));
        this._vp.setErrorsOn(this._error);
        this._backgroundColor = this.getSafeColor(this.getParameterValue("background", this._backgroundColor.toString()), this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        this._seq.setText(this.getParameterValue("sequenceDBN", ""));
        this._struct.setText(this.getParameterValue("structureDBN", ""));
        String string = this.getParameterValue("algorithm", "radiate");
        this._algoCode = string.equals("circular") ? 1 : (string.equals("naview") ? 3 : (string.equals("line") ? 4 : 2));
        if (this._seq.getText().equals("") && this._struct.getText().equals("")) {
            this._seq.setText(DEFAULT_SEQUENCE);
            this._struct.setText(DEFAULT_STRUCTURE);
        }
        try {
            this._vp.drawRNA(this._seq.getText(), this._struct.getText(), this._algoCode);
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            exceptionNonEqualLength.printStackTrace();
        }
    }

    public VARNAPanel get_varnaPanel() {
        return this._vp;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
    }

    public JTextField get_struct() {
        return this._struct;
    }

    public void set_struct(JTextField jTextField) {
        this._struct = jTextField;
    }

    public JTextField get_seq() {
        return this._seq;
    }

    public void set_seq(JTextField jTextField) {
        this._seq = jTextField;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel jLabel) {
        this._info = jLabel;
    }
}

