/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.NussinovDemo;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.interfaces.InterfaceVARNABasesListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class NussinovDesignDemo
extends JFrame
implements InterfaceVARNAListener,
InterfaceVARNABasesListener,
ItemListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String SEQUENCE_A = "AGGCACGUCU";
    private static final String SEQUENCE_B = "GAGUAGCCUC";
    private static final String SEQUENCE_C = "GCAUAGCUGC";
    private static final String SEQUENCE_INRIA = "CGAUUGCAUCGCAAGU";
    private static final String TARGET_STRUCTURE_1 = "(((((((..)))))))";
    private static final String TARGET_STRUCTURE_2 = "(((())))(((())))";
    private static final String TARGET_STRUCTURE_3 = "(.((.((..).)).))";
    private static final String TARGET_STRUCTURE_4 = "((((((())))(((())(()))))))";
    private static final String TARGET_STRUCTURE_5 = "(((())))(((())))(((())))(((())))(((())))(((())))";
    private static final String SEQUENCE_BIG = "AAAACAAAAACACCAUGGUGUUUUCACCCAAUUGGGUGAAAACAGAGAUCUCGAGAUCUCUGUUUUUGUUUU";
    private static final String DEFAULT_STRUCTURE = "..........";
    private VARNAPanel _vpMaster;
    private VARNAPanel _vpTarget;
    private InfoPanel _infos = new InfoPanel();
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _structPanel = new JPanel();
    private JLabel _actions = new JLabel();
    private JComboBox _struct = new JComboBox();
    private JLabel _seq1 = new JLabel();
    private JLabel _structLabel = new JLabel("Structure Secondaire Cible");
    private JLabel _seqLabel = new JLabel("Sequence d'ARN");
    private JButton _switchButton = new JButton("Reset");
    private Color _backgroundColor = Color.white;
    private Color _targetColor = new Color(200, 200, 250);
    private Color _okColor = new Color(100, 100, 250);
    private Color _koColor = new Color(250, 200, 200);
    private String _cache = "";
    ArrayList<String> _cacheStructs = new ArrayList();
    static final String[] _bases = new String[]{"A", "C", "G", "U"};
    static final String[] _basesComp = new String[]{"U", "G", "C", "A"};

    public static ModelBaseStyle createStyle(String string) {
        ModelBaseStyle modelBaseStyle = new ModelBaseStyle();
        try {
            modelBaseStyle.assignParameters(string);
        }
        catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
            exceptionModeleStyleBaseSyntaxError.printStackTrace();
        }
        catch (ExceptionParameterError exceptionParameterError) {
            exceptionParameterError.printStackTrace();
        }
        return modelBaseStyle;
    }

    public void applyTo(VARNAPanel vARNAPanel, ModelBaseStyle modelBaseStyle, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            ModeleBase modeleBase = vARNAPanel.getRNA().getBaseAt(nArray[i]);
            modeleBase.setStyleBase(modelBaseStyle);
            if (modeleBase.getElementStructure() == -1) continue;
            vARNAPanel.getRNA().getBaseAt(modeleBase.getElementStructure()).setStyleBase(modelBaseStyle);
        }
        vARNAPanel.repaint();
    }

    public NussinovDesignDemo() {
        try {
            this._vpMaster = new VARNAPanel(this.getSeq(), "");
            this._vpTarget = new VARNAPanel();
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            this._vpMaster.errorDialog(exceptionNonEqualLength);
        }
        this._vpMaster.setPreferredSize(new Dimension(600, 600));
        this._vpTarget.setPreferredSize(new Dimension(600, 600));
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int n = 250;
        Font font = Font.decode("MonoSpaced-BOLD-16");
        Font font2 = this._seqLabel.getFont().deriveFont(16.0f);
        this._seq1.setFont(font.deriveFont(25.0f));
        this.setBackground(this._backgroundColor);
        this._vpMaster.setBackground(this._backgroundColor);
        this._vpMaster.addVARNAListener(this);
        this._vpMaster.setTitle("Meilleur repliement - S\u00e9quence courante");
        this._vpTarget.setBackground(this._targetColor);
        this._vpTarget.setModifiable(false);
        this._vpTarget.setTitle("Repliement cible");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(n, 15));
        this._seqLabel.setFont(font2);
        this._structLabel.setFont(font2);
        String[] stringArray = new String[]{TARGET_STRUCTURE_1, TARGET_STRUCTURE_2, TARGET_STRUCTURE_3, TARGET_STRUCTURE_4, TARGET_STRUCTURE_5};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this._struct.setModel(defaultComboBoxModel);
        this._struct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(actionEvent.getActionCommand());
                NussinovDesignDemo.this.setTarget(((JComboBox)actionEvent.getSource()).getSelectedItem().toString());
            }
        });
        this._struct.setFont(font);
        this._struct.setEnabled(true);
        this._struct.setEditable(true);
        this._switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NussinovDesignDemo.this.setTarget(NussinovDesignDemo.this._struct.getSelectedItem().toString());
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq1, "Center");
        this._seqPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._structLabel.setPreferredSize(new Dimension(n, 15));
        this._structLabel.setHorizontalTextPosition(2);
        this._structPanel.setLayout(new BorderLayout());
        this._structPanel.add((Component)this._structLabel, "West");
        this._structPanel.add((Component)this._struct, "Center");
        this._input.setLayout(new GridLayout(0, 1));
        this._input.add(this._structPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._infos.setFont(font2);
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._actions, "South");
        this._tools.add((Component)jPanel, "East");
        this._tools.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this._switchButton, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setBorder(BorderFactory.createBevelBorder(0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this._seqPanel, "North");
        jPanel2.add((Component)this._infos, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this._vpMaster, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jSplitPane.add(this._vpTarget);
        jSplitPane.add(jPanel3);
        jSplitPane.doLayout();
        jSplitPane.setDividerSize(5);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vpMaster.getVARNAUI().UIRadiate();
        this._vpMaster.setTitleFontSize(26.0f);
        this._vpMaster.setTitleFontStyle(0);
        this._vpTarget.setTitleFontSize(26.0f);
        this._vpTarget.setTitleFontStyle(0);
        this._vpMaster.addVARNABasesListener(this);
        this.setTitle("Nuit des Chercheurs - INRIA AMIB - Design d'ARN");
        this.setTarget(stringArray[0]);
    }

    private synchronized void showSolution() {
        ArrayList<String> arrayList = this.getStructs();
        this._infos.setInfo(arrayList, this.count(this.getSeq()));
        if (arrayList.size() == 1 && arrayList.get(0).equals(this._struct.getSelectedItem().toString())) {
            this._vpMaster.setTitle("F\u00e9licitations !");
        } else {
            this._vpMaster.setTitle("Meilleur repliement - S\u00e9quence courante");
        }
    }

    public void setTarget(String string) {
        RNA rNA = new RNA();
        try {
            this._vpTarget.drawRNA(String.format("%" + string.length() + "s", ""), string);
            this.createDummySeq();
            this.showSolution();
            this.onStructureRedrawn();
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            exceptionNonEqualLength.printStackTrace();
        }
    }

    private void createDummySeq() {
        RNA rNA = this._vpTarget.getRNA();
        String string = new String();
        for (int i = 0; i < rNA.getSize(); ++i) {
            string = string + 'A';
        }
        try {
            RNA rNA2 = new RNA();
            rNA2.setRNA(string, rNA.getStructDBN());
            for (ModeleBP modeleBP : rNA.getAllBPs()) {
                rNA2.getBaseAt(modeleBP.getIndex5()).setContent("A");
                rNA2.getBaseAt(modeleBP.getIndex3()).setContent("U");
            }
            this._vpMaster.drawRNA(rNA2);
            this._vpMaster.repaint();
            this._seq1.setText(this._vpMaster.getRNA().getSeq());
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            exceptionUnmatchedClosingParentheses.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.printStackTrace();
        }
    }

    public String getSeq() {
        return ("" + this._seq1.getText()).toUpperCase();
    }

    private boolean canBasePairAll(char c, char c2) {
        return true;
    }

    private boolean canBasePairBasic(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        return c == 'A' && c2 == 'U';
    }

    private double basePairScoreBasic(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return 1.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'U' && c2 == 'A') {
            return 1.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePairNussinov(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        if (c == 'A' && c2 == 'U') {
            return true;
        }
        if (c == 'U' && c2 == 'G') {
            return true;
        }
        return c == 'G' && c2 == 'U';
    }

    private double basePairScoreNussinov(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return 3.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 3.0;
        }
        if (c == 'U' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'G' && c2 == 'U') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePairINRIA(char c, char c2) {
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        if (c == 'A' && c2 == 'U') {
            return true;
        }
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'A' && c2 == 'G') {
            return true;
        }
        if (c == 'G' && c2 == 'A') {
            return true;
        }
        if (c == 'U' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'U') {
            return true;
        }
        if (c == 'A' && c2 == 'A') {
            return true;
        }
        if (c == 'U' && c2 == 'U') {
            return true;
        }
        if (c == 'U' && c2 == 'G') {
            return true;
        }
        if (c == 'G' && c2 == 'U') {
            return true;
        }
        if (c == 'A' && c2 == 'C') {
            return true;
        }
        return c == 'C' && c2 == 'A';
    }

    private double basePairScoreINRIA(char c, char c2) {
        if (c == 'U' && c2 == 'A') {
            return 3.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 3.0;
        }
        if (c == 'G' && c2 == 'C') {
            return 3.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 3.0;
        }
        if (c == 'A' && c2 == 'G') {
            return 2.0;
        }
        if (c == 'G' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'C') {
            return 2.0;
        }
        if (c == 'C' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'A' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'G' && c2 == 'U') {
            return 1.0;
        }
        if (c == 'A' && c2 == 'C') {
            return 1.0;
        }
        if (c == 'C' && c2 == 'A') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePair(char c, char c2) {
        return this.canBasePairBasic(c, c2);
    }

    private double basePairScore(char c, char c2) {
        return this.basePairScoreBasic(c, c2);
    }

    public double[][] fillMatrix(String string) {
        int n = string.length();
        double[][] dArray = new double[n][n];
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < n - i + 1; ++j) {
                int n2 = j + i - 1;
                dArray[j][n2] = 0.0;
                if (j >= n2) continue;
                dArray[j][n2] = Math.max(dArray[j][n2], dArray[j + 1][n2]);
                for (int k = j + 1; k <= n2; ++k) {
                    if (!this.canBasePair(string.charAt(j), string.charAt(k))) continue;
                    double d = 0.0;
                    if (k > j + 1) {
                        d = dArray[j + 1][k - 1];
                    }
                    double d2 = 0.0;
                    if (k < n2) {
                        d2 = dArray[k + 1][n2];
                    }
                    dArray[j][n2] = Math.max(dArray[j][n2], this.basePairScore(string.charAt(j), string.charAt(k)) + d + d2);
                }
            }
        }
        return dArray;
    }

    public static ArrayList<Double> combine(double d, ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (double d2 : arrayList) {
            for (double d3 : arrayList2) {
                arrayList3.add(d + d2 + d3);
            }
        }
        return arrayList3;
    }

    public static ArrayList<Double> selectBests(ArrayList<Double> arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : arrayList) {
            d = Math.max(d2, d);
        }
        for (double d2 : arrayList) {
            if (d2 != d) continue;
            arrayList2.add(d2);
        }
        return arrayList2;
    }

    private ArrayList<String> backtrack(double[][] dArray, String string) {
        return this.backtrack(dArray, string, 0, string.length() - 1);
    }

    private ArrayList<String> backtrack(double[][] dArray, String string, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n < n2) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(-1);
            for (int i = n + 1; i <= n2; ++i) {
                arrayList2.add(i);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (n3 == -1) {
                    if (dArray[n][n2] != dArray[n + 1][n2]) continue;
                    for (String string2 : this.backtrack(dArray, string, n + 1, n2)) {
                        arrayList.add("." + string2);
                    }
                    continue;
                }
                if (!this.canBasePair(string.charAt(n), string.charAt(n3))) continue;
                double d = 0.0;
                if (n3 > n + 1) {
                    d = dArray[n + 1][n3 - 1];
                }
                double d2 = 0.0;
                if (n3 < n2) {
                    d2 = dArray[n3 + 1][n2];
                }
                if (dArray[n][n2] != this.basePairScore(string.charAt(n), string.charAt(n3)) + d + d2) continue;
                for (String string3 : this.backtrack(dArray, string, n + 1, n3 - 1)) {
                    for (String string4 : this.backtrack(dArray, string, n3 + 1, n2)) {
                        arrayList.add("(" + string3 + ")" + string4);
                    }
                }
            }
        } else if (n == n2) {
            arrayList.add(".");
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    public BigInteger count(String string) {
        int n = string.length();
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < n - i + 1; ++j) {
                int n2 = j + i - 1;
                bigIntegerArray[j][n2] = BigInteger.ZERO;
                if (j < n2) {
                    bigIntegerArray[j][n2] = bigIntegerArray[j][n2].add(bigIntegerArray[j + 1][n2]);
                    for (int k = j + 1; k <= n2; ++k) {
                        if (!this.canBasePair(string.charAt(j), string.charAt(k))) continue;
                        BigInteger bigInteger = BigInteger.ONE;
                        if (k > j + 1) {
                            bigInteger = bigIntegerArray[j + 1][k - 1];
                        }
                        BigInteger bigInteger2 = BigInteger.ONE;
                        if (k < n2) {
                            bigInteger2 = bigIntegerArray[k + 1][n2];
                        }
                        bigIntegerArray[j][n2] = bigIntegerArray[j][n2].add(bigInteger.multiply(bigInteger2));
                    }
                    continue;
                }
                bigIntegerArray[j][n2] = BigInteger.ONE;
            }
        }
        return bigIntegerArray[0][n - 1];
    }

    public ArrayList<String> getStructs() {
        String string = this.getSeq();
        if (!this._cache.equals(string = string.toUpperCase())) {
            double[][] dArray = this.fillMatrix(string);
            this._cacheStructs = this.backtrack(dArray, string);
            this._cache = string;
        }
        return this._cacheStructs;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vpMaster;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vpMaster = vARNAPanel;
    }

    public JLabel get_info() {
        return this._actions;
    }

    public void set_info(JLabel jLabel) {
        this._actions = jLabel;
    }

    public static void main(String[] stringArray) {
        NussinovDesignDemo nussinovDesignDemo = new NussinovDesignDemo();
        nussinovDesignDemo.setDefaultCloseOperation(3);
        nussinovDesignDemo.pack();
        nussinovDesignDemo.setVisible(true);
    }

    @Override
    public void onStructureRedrawn() {
        this._vpMaster.repaint();
    }

    @Override
    public void onWarningEmitted(String string) {
    }

    public void onLoad(String string) {
    }

    public void onLoaded() {
    }

    @Override
    public void onUINewStructure(VARNAConfig vARNAConfig, RNA rNA) {
    }

    @Override
    public void onBaseClicked(ModeleBase modeleBase, MouseEvent mouseEvent) {
        int n = -1;
        for (int i = 0; i < _bases.length; ++i) {
            if (!modeleBase.getContent().equalsIgnoreCase(_bases[i])) continue;
            n = i;
        }
        n = (n + 1) % _bases.length;
        modeleBase.setContent(_bases[n].toUpperCase());
        ArrayList<ModeleBase> arrayList = this._vpTarget.getRNA().getAllPartners(modeleBase.getIndex());
        if (arrayList.size() != 0) {
            ModeleBase modeleBase2 = this._vpMaster.getRNA().getBaseAt(arrayList.get(0).getIndex());
            modeleBase2.setContent(_basesComp[n].toUpperCase());
        }
        this._vpMaster.repaint();
        this._seq1.setText(this._vpMaster.getRNA().getSeq());
        new Temporizer(this._vpMaster.getRNA().getSeq()).start();
    }

    @Override
    public void onZoomLevelChanged() {
    }

    @Override
    public void onTranslationChanged() {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        System.out.println();
    }

    public class InfoPanel
    extends JPanel {
        ArrayList<String> _sols = new ArrayList();
        BigInteger _nbFolds = BigInteger.ZERO;
        JTextArea _text = new JTextArea("");
        JTextArea _subopts = new JTextArea("");
        JPanel _suboptBrowser = new JPanel();
        JPanel _suboptCount = new JPanel();
        int _selectedIndex = 0;
        JButton next = new JButton("Precedent");
        JButton previous = new JButton("Suivant");

        InfoPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.add((Component)this._suboptBrowser, "South");
            this.add((Component)this._suboptCount, "North");
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (InfoPanel.this._sols.size() > 0) {
                        InfoPanel.this.setSelectedIndex((InfoPanel.this._selectedIndex + 1) % InfoPanel.this._sols.size());
                    }
                }
            });
            this.previous.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (InfoPanel.this._sols.size() > 0) {
                        InfoPanel.this.setSelectedIndex((InfoPanel.this._selectedIndex + InfoPanel.this._sols.size() - 1) % InfoPanel.this._sols.size());
                    }
                }
            });
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            JLabel jLabel = new JLabel("#Repliements");
            NussinovDemo.formatLabel(jLabel);
            this._suboptCount.setLayout(new BorderLayout());
            this._suboptCount.add((Component)jLabel, "West");
            this._suboptCount.add((Component)this._text, "Center");
            JLabel jLabel2 = new JLabel("#Co-optimaux");
            NussinovDemo.formatLabel(jLabel2);
            JPanel jPanel = new JPanel();
            jPanel.add(this.previous);
            jPanel.add(this.next);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this._subopts, "West");
            jPanel2.add((Component)jPanel, "Center");
            this._suboptBrowser.setLayout(new BorderLayout());
            this._suboptBrowser.add((Component)jLabel2, "West");
            this._suboptBrowser.add((Component)jPanel2, "Center");
        }

        public void setSelectedIndex(int n) {
            this._selectedIndex = n;
            RNA rNA = new RNA();
            try {
                ModeleBase modeleBase;
                rNA.setRNA(NussinovDesignDemo.this.getSeq(), this._sols.get(n));
                RNA rNA2 = NussinovDesignDemo.this._vpTarget.getRNA();
                for (ModeleBase modeleBase2 : rNA.get_listeBases()) {
                    modeleBase = rNA2.getBaseAt(modeleBase2.getIndex());
                    if (modeleBase2.getElementStructure() != modeleBase.getElementStructure()) continue;
                    modeleBase2.getStyleBase().setBaseInnerColor(NussinovDesignDemo.this._okColor);
                    modeleBase2.getStyleBase().setBaseNameColor(Color.white);
                }
                for (ModeleBase modeleBase2 : rNA2.get_listeBases()) {
                    modeleBase = rNA.getBaseAt(modeleBase2.getIndex());
                    if (modeleBase2.getElementStructure() == modeleBase.getElementStructure()) {
                        modeleBase2.getStyleBase().setBaseInnerColor(NussinovDesignDemo.this._okColor);
                        continue;
                    }
                    modeleBase2.getStyleBase().setBaseInnerColor(Color.white);
                }
                rNA.drawRNARadiate(NussinovDesignDemo.this._vpMaster.getConfig());
                NussinovDesignDemo.this._vpMaster.showRNAInterpolated(rNA);
                NussinovDesignDemo.this._vpTarget.repaint();
            }
            catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                exceptionUnmatchedClosingParentheses.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                exceptionFileFormatOrSyntax.printStackTrace();
            }
            this.formatDescription();
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this._text != null) {
                this._text.setFont(font);
                this._text.setOpaque(false);
            }
            if (this._subopts != null) {
                this._subopts.setFont(font);
                this._subopts.setOpaque(false);
            }
        }

        public void setInfo(ArrayList<String> arrayList, BigInteger bigInteger) {
            this._sols = arrayList;
            this._nbFolds = bigInteger;
            this.formatDescription();
            this.setSelectedIndex(0);
        }

        private void formatDescription() {
            this._text.setText("" + this._nbFolds);
            this._subopts.setText("" + this._sols.size());
            this.next.setEnabled(this._sols.size() > 1);
            this.previous.setEnabled(this._sols.size() > 1);
        }
    }

    private class Temporizer
    extends Thread {
        String _seq;

        public Temporizer(String string) {
            this._seq = string;
        }

        @Override
        public void run() {
            try {
                Temporizer.sleep(1000L);
                if (NussinovDesignDemo.this._vpMaster.getRNA().getSeq().equalsIgnoreCase(this._seq)) {
                    NussinovDesignDemo.this.showSolution();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

