/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.FileNameExtensionFilter;
import fr.orsay.lri.varna.applications.VARNAPrinter;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionJPEGEncoding;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.VARNAEdits;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.views.VueAboutPanel;
import fr.orsay.lri.varna.views.VueAnnotation;
import fr.orsay.lri.varna.views.VueBPHeightIncrement;
import fr.orsay.lri.varna.views.VueBPList;
import fr.orsay.lri.varna.views.VueBPThickness;
import fr.orsay.lri.varna.views.VueBPType;
import fr.orsay.lri.varna.views.VueBaseValues;
import fr.orsay.lri.varna.views.VueBases;
import fr.orsay.lri.varna.views.VueBorder;
import fr.orsay.lri.varna.views.VueChemProbAnnotation;
import fr.orsay.lri.varna.views.VueColorMapStyle;
import fr.orsay.lri.varna.views.VueFont;
import fr.orsay.lri.varna.views.VueGlobalRotation;
import fr.orsay.lri.varna.views.VueHighlightRegionEdit;
import fr.orsay.lri.varna.views.VueJPEG;
import fr.orsay.lri.varna.views.VueListeAnnotations;
import fr.orsay.lri.varna.views.VueLoadColorMapValues;
import fr.orsay.lri.varna.views.VueManualInput;
import fr.orsay.lri.varna.views.VueNumPeriod;
import fr.orsay.lri.varna.views.VueSpaceBetweenBases;
import fr.orsay.lri.varna.views.VueStyleBP;
import fr.orsay.lri.varna.views.VueZoom;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VueUI {
    private VARNAPanel _vp;
    private File _fileChooserDirectory = null;
    private UndoableEditSupport _undoableEditSupport;
    FileNameExtensionFilter _varnaFilter = new FileNameExtensionFilter("VARNA Session File", "varna", "VARNA");
    FileNameExtensionFilter _bpseqFilter = new FileNameExtensionFilter("BPSeq (CRW) File", "bpseq", "BPSEQ");
    FileNameExtensionFilter _ctFilter = new FileNameExtensionFilter("Connect (MFold) File", "ct", "CT");
    FileNameExtensionFilter _dbnFilter = new FileNameExtensionFilter("Dot-bracket notation (Vienna) File", "dbn", "DBN", "faa", "FAA");
    FileNameExtensionFilter _jpgFilter = new FileNameExtensionFilter("JPEG Picture", "jpeg", "jpg", "JPG", "JPEG");
    FileNameExtensionFilter _pngFilter = new FileNameExtensionFilter("PNG Picture", "png", "PNG");
    FileNameExtensionFilter _epsFilter = new FileNameExtensionFilter("EPS File", "eps", "EPS");
    FileNameExtensionFilter _svgFilter = new FileNameExtensionFilter("SVG Picture", "svg", "SVG");
    FileNameExtensionFilter _xfigFilter = new FileNameExtensionFilter("XFig Diagram", "fig", "xfig", "FIG", "XFIG");

    public VueUI(VARNAPanel vp) {
        this._vp = vp;
        this._undoableEditSupport = new UndoableEditSupport(this._vp);
    }

    public void addUndoableEditListener(UndoManager manager) {
        this._undoableEditSupport.addUndoableEditListener(manager);
    }

    public void UIToggleColorMap() {
        if (this._vp.isModifiable()) {
            this._vp.setColorMapVisible(!this._vp.getColorMapVisible());
            this._vp.repaint();
        }
    }

    public Hashtable<Integer, Point2D.Double> backupAllCoords() {
        Hashtable<Integer, Point2D.Double> tmp = new Hashtable<Integer, Point2D.Double>();
        int i = 0;
        while (i < this._vp.getRNA().getSize()) {
            tmp.put(i, this._vp.getRNA().getCoords(i));
            ++i;
        }
        return tmp;
    }

    public void UIToggleFlatExteriorLoop() {
        if (this._vp.isModifiable() && this._vp.getRNA().get_drawMode() == 2) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(2, this._vp, !this._vp.getFlatExteriorLoop()));
            this._vp.setFlatExteriorLoop(!this._vp.getFlatExteriorLoop());
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 2);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UIRadiate() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(2, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 2);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UIMOTIFView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(6, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 6);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UILine() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(4, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 4);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UICircular() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(1, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 1);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UINAView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(3, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 3);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UIVARNAView() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(5, this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), 5);
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    public void UIReset() {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> bck = this.backupAllCoords();
            this._undoableEditSupport.postEdit(new VARNAEdits.RedrawEdit(this._vp.getRNA().get_drawMode(), this._vp));
            this._vp.reset();
            this._vp.drawRNA(this._vp.getRNA(), this._vp.getRNA().get_drawMode());
            this._vp.repaint();
            this._vp.fireLayoutChanged(bck);
        }
    }

    private void savePath(JFileChooser jfc) {
        this._fileChooserDirectory = jfc.getCurrentDirectory();
    }

    private void loadPath(JFileChooser jfc) {
        if (this._fileChooserDirectory != null) {
            jfc.setCurrentDirectory(this._fileChooserDirectory);
        }
    }

    public void UIFile() throws ExceptionNonEqualLength {
        if (this._vp.isModifiable()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            fc.setDialogTitle("Open...");
            this.loadPath(fc);
            if (fc.showOpenDialog(this._vp) == 0) {
                try {
                    this.savePath(fc);
                    String path = fc.getSelectedFile().getAbsolutePath();
                    if (!path.toLowerCase().endsWith(".varna")) {
                        Collection<RNA> rnas = RNAFactory.loadSecStr(path);
                        if (rnas.isEmpty()) {
                            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
                        }
                        RNA r = rnas.iterator().next();
                        this._vp.drawRNAInterpolated(r);
                        this._vp.fireUINewStructure();
                        this._vp.repaint();
                    } else {
                        FullBackup bck = this._vp.loadSession(path);
                        this._vp.fireUINewStructure();
                    }
                }
                catch (ExceptionExportFailed e1) {
                    this._vp.errorDialog(e1);
                }
                catch (ExceptionPermissionDenied e1) {
                    this._vp.errorDialog(e1);
                }
                catch (ExceptionLoadingFailed e1) {
                    this._vp.errorDialog(e1);
                }
                catch (ExceptionFileFormatOrSyntax e1) {
                    this._vp.errorDialog(e1);
                }
                catch (ExceptionUnmatchedClosingParentheses e1) {
                    this._vp.errorDialog(e1);
                }
                catch (FileNotFoundException e) {
                    this._vp.errorDialog(e);
                }
            }
        }
    }

    public void UISetColorMapStyle() {
        VueColorMapStyle cms = new VueColorMapStyle(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, cms, "Choose color map style", 2) == 0) {
            this._vp.setColorMap(cms.getColorMap());
        } else {
            cms.cancelChanges();
        }
    }

    public void UILoadColorMapValues() {
        VueLoadColorMapValues cms = new VueLoadColorMapValues(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, cms, "Load base values", 2) == 0) {
            try {
                this._vp.setColorMapVisible(true);
                this._vp.readValues(cms.getReader());
            }
            catch (IOException e) {
                this._vp.errorDialog(e);
            }
        }
    }

    public void UISetColorMapValues() {
        VueBaseValues cms = new VueBaseValues(this._vp);
        if (JOptionPane.showConfirmDialog(this._vp, cms, "Choose base values", 2) != 0) {
            cms.cancelChanges();
        }
    }

    public void UIManualInput() throws ParseException, ExceptionNonEqualLength {
        VueManualInput manualInput;
        if (this._vp.isModifiable() && JOptionPane.showConfirmDialog(this._vp, (manualInput = new VueManualInput(this._vp)).getPanel(), "Input sequence/structure", 2) == 0) {
            this._vp.getRNA().getSize();
            try {
                RNA r = new RNA();
                VARNAConfig cfg = new VARNAConfig();
                r.setRNA(manualInput.getTseq().getText(), manualInput.getTstr().getText());
                r.drawRNA(this._vp.getRNA().get_drawMode(), cfg);
                this._vp.drawRNAInterpolated(r);
                this._vp.fireUINewStructure();
                this._vp.repaint();
            }
            catch (ExceptionFileFormatOrSyntax e) {
                e.printStackTrace();
            }
            catch (ExceptionNAViewAlgorithm e) {
                e.printStackTrace();
            }
        }
    }

    public void UISetTitle() {
        String res;
        if (this._vp.isModifiable() && (res = JOptionPane.showInputDialog(this._vp, "Input title", this._vp.getTitle())) != null) {
            this._vp.setTitle(res);
            this._vp.repaint();
        }
    }

    public void UISetColorMapCaption() {
        String res;
        if (this._vp.isModifiable() && (res = JOptionPane.showInputDialog(this._vp, "Input new color map caption", this._vp.getColorMapCaption())) != null) {
            this._vp.setColorMapCaption(res);
            this._vp.repaint();
        }
    }

    public void UISetBaseCharacter() {
        if (this._vp.isModifiable()) {
            int i = this._vp.getNearestBase();
            if (this._vp.isComparisonMode()) {
                String res = JOptionPane.showInputDialog(this._vp, "Input base", ((ModeleBasesComparison)this._vp.getRNA().get_listeBases().get(i)).getBases());
                if (res != null) {
                    ModeleBasesComparison mb = (ModeleBasesComparison)this._vp.getRNA().get_listeBases().get(i);
                    String bck = mb.get_base1() + "|" + mb.get_base2();
                    mb.set_base1(Character.valueOf(res.length() > 0 ? res.charAt(0) : (char)' '));
                    mb.set_base2(Character.valueOf(res.length() > 1 ? res.charAt(1) : (char)' '));
                    this._vp.repaint();
                    this._vp.fireSequenceChanged(i, bck, res);
                }
            } else {
                String res = JOptionPane.showInputDialog(this._vp, "Input base", ((ModeleBaseNucleotide)this._vp.getRNA().get_listeBases().get(i)).get_c());
                if (res != null) {
                    ModeleBaseNucleotide mb = (ModeleBaseNucleotide)this._vp.getRNA().get_listeBases().get(i);
                    String bck = mb.get_c();
                    mb.set_c(res);
                    this._vp.repaint();
                    this._vp.fireSequenceChanged(i, bck, res);
                }
            }
        }
    }

    public void UIExport() throws ExceptionExportFailed, ExceptionPermissionDenied, ExceptionWritingForbidden, ExceptionJPEGEncoding {
        ArrayList<FileNameExtensionFilter> v = new ArrayList<FileNameExtensionFilter>();
        v.add(this._epsFilter);
        v.add(this._svgFilter);
        v.add(this._xfigFilter);
        v.add(this._jpgFilter);
        v.add(this._pngFilter);
        String dest = this.UIChooseOutputFile(v);
        if (dest != null) {
            String extLower = dest.substring(dest.lastIndexOf(46)).toLowerCase();
            if (extLower.equals(".eps")) {
                this._vp.getRNA().saveRNAEPS(dest, this._vp.getConfig());
            } else if (extLower.equals(".svg")) {
                this._vp.getRNA().saveRNASVG(dest, this._vp.getConfig());
            } else if (extLower.equals(".fig") || extLower.equals("xfig")) {
                this._vp.getRNA().saveRNAXFIG(dest, this._vp.getConfig());
            } else if (extLower.equals(".png")) {
                this.saveToPNG(dest);
            } else if (extLower.equals("jpg") || extLower.equals("jpeg")) {
                this.saveToJPEG(dest);
            }
        }
    }

    public void UIExportJPEG() throws ExceptionJPEGEncoding, ExceptionExportFailed {
        String dest = this.UIChooseOutputFile(this._jpgFilter);
        if (dest != null) {
            this.saveToJPEG(dest);
        }
    }

    public void UIPrint() {
        VARNAPrinter.printComponent(this._vp);
    }

    public void UIExportPNG() throws ExceptionExportFailed {
        String dest = this.UIChooseOutputFile(this._pngFilter);
        if (dest != null) {
            this.saveToPNG(dest);
        }
    }

    public void UIExportXFIG() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String dest = this.UIChooseOutputFile(this._xfigFilter);
        if (dest != null) {
            this._vp.getRNA().saveRNAXFIG(dest, this._vp.getConfig());
        }
    }

    public void UIExportEPS() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String dest = this.UIChooseOutputFile(this._epsFilter);
        if (dest != null) {
            this._vp.getRNA().saveRNAEPS(dest, this._vp.getConfig());
        }
    }

    public void UIExportSVG() throws ExceptionExportFailed, ExceptionWritingForbidden {
        String dest = this.UIChooseOutputFile(this._svgFilter);
        if (dest != null) {
            this._vp.getRNA().saveRNASVG(dest, this._vp.getConfig());
        }
    }

    public void UISaveAsDBN() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String name = this._vp.getVARNAUI().UIChooseOutputFile(this._dbnFilter);
        if (name != null) {
            this._vp.getRNA().saveAsDBN(name, this._vp.getTitle());
        }
    }

    public void UISaveAsCT() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String name = this._vp.getVARNAUI().UIChooseOutputFile(this._ctFilter);
        if (name != null) {
            this._vp.getRNA().saveAsCT(name, this._vp.getTitle());
        }
    }

    public void UISaveAsBPSEQ() throws ExceptionExportFailed, ExceptionPermissionDenied {
        String name = this._vp.getVARNAUI().UIChooseOutputFile(this._bpseqFilter);
        if (name != null) {
            this._vp.getRNA().saveAsBPSEQ(name, this._vp.getTitle());
        }
    }

    public void UISaveAs() throws ExceptionExportFailed, ExceptionPermissionDenied {
        ArrayList<FileNameExtensionFilter> v = new ArrayList<FileNameExtensionFilter>();
        v.add(this._bpseqFilter);
        v.add(this._dbnFilter);
        v.add(this._ctFilter);
        v.add(this._varnaFilter);
        String dest = this.UIChooseOutputFile(v);
        if (dest != null) {
            String extLower = dest.substring(dest.lastIndexOf(46)).toLowerCase();
            if (extLower.endsWith("bpseq")) {
                this._vp.getRNA().saveAsBPSEQ(dest, this._vp.getTitle());
            } else if (extLower.endsWith("ct")) {
                this._vp.getRNA().saveAsCT(dest, this._vp.getTitle());
            } else if (extLower.endsWith("dbn") || extLower.endsWith("faa")) {
                this._vp.getRNA().saveAsDBN(dest, this._vp.getTitle());
            } else if (extLower.endsWith("varna")) {
                this._vp.saveSession(dest);
            }
        }
    }

    public String UIChooseOutputFile(FileNameExtensionFilter filtre) {
        ArrayList<FileNameExtensionFilter> v = new ArrayList<FileNameExtensionFilter>();
        v.add(filtre);
        return this.UIChooseOutputFile(v);
    }

    public String UIChooseOutputFile(ArrayList<FileNameExtensionFilter> filtre) {
        JFileChooser fc = new JFileChooser();
        this.loadPath(fc);
        String absolutePath = null;
        int i = 0;
        while (i < filtre.size()) {
            fc.addChoosableFileFilter(filtre.get(i));
            ++i;
        }
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Save...");
        if (fc.showSaveDialog(this._vp) == 0) {
            this.savePath(fc);
            absolutePath = fc.getSelectedFile().getAbsolutePath();
            String extension = this._vp.getPopupMenu().get_controleurMenu().getExtension(fc.getSelectedFile());
            FileFilter f = fc.getFileFilter();
            if (f instanceof FileNameExtensionFilter) {
                ArrayList<String> listeExtension = new ArrayList<String>();
                listeExtension.addAll(Arrays.asList(((FileNameExtensionFilter)f).getExtensions()));
                if (!listeExtension.contains(extension)) {
                    absolutePath = String.valueOf(absolutePath) + "." + (String)listeExtension.get(0);
                }
            }
        }
        return absolutePath;
    }

    public void UISetBorder() {
        VueBorder border = new VueBorder(this._vp);
        Dimension oldBorder = this._vp.getBorderSize();
        this._vp.drawBBox(true);
        this._vp.drawBorder(true);
        this._vp.repaint();
        if (JOptionPane.showConfirmDialog(this._vp, border.getPanel(), "Set new border size", 2) != 0) {
            this._vp.setBorderSize(oldBorder);
        }
        this._vp.drawBorder(false);
        this._vp.drawBBox(false);
        this._vp.repaint();
    }

    public void UISetBackground() {
        Color c = JColorChooser.showDialog(this._vp, "Choose new background color", this._vp.getBackground());
        if (c != null) {
            this._vp.setBackground(c);
            this._vp.repaint();
        }
    }

    public void UIZoomIn() {
        double _actualZoom = this._vp.getZoom();
        double _actualAmount = this._vp.getZoomIncrement();
        Point _actualTranslation = this._vp.getTranslation();
        double newZoom = Math.min(60.0, _actualZoom * _actualAmount);
        double ratio = newZoom / _actualZoom;
        Point newTrans = new Point((int)((double)_actualTranslation.x * ratio), (int)((double)_actualTranslation.y * ratio));
        this._vp.setZoom(newZoom);
        this._vp.setTranslation(newTrans);
        this._vp.checkTranslation();
        System.out.println("Zoom in");
        this._vp.repaint();
    }

    public void UIZoomOut() {
        double _actualZoom = this._vp.getZoom();
        double _actualAmount = this._vp.getZoomIncrement();
        Point _actualTranslation = this._vp.getTranslation();
        double newZoom = Math.max(_actualZoom / _actualAmount, 0.5);
        double ratio = newZoom / _actualZoom;
        Point newTrans = new Point((int)((double)_actualTranslation.x * ratio), (int)((double)_actualTranslation.y * ratio));
        this._vp.setTranslation(newTrans);
        this._vp.setZoom(newZoom);
        this._vp.checkTranslation();
        this._vp.repaint();
    }

    public void UICustomZoom() {
        VueZoom zoom = new VueZoom(this._vp);
        double oldZoom = this._vp.getZoom();
        double oldZoomAmount = this._vp.getZoomIncrement();
        this._vp.drawBBox(true);
        this._vp.repaint();
        if (JOptionPane.showConfirmDialog(this._vp, zoom.getPanel(), "Set zoom", 2) != 0) {
            this._vp.setZoom(oldZoom);
            this._vp.setZoomIncrement(oldZoomAmount);
        }
        this._vp.drawBBox(false);
        this._vp.repaint();
    }

    public void UIGlobalRotation() {
        if (this._vp.getRNA().get_listeBases().size() > 0) {
            this._vp.drawBBox(true);
            this._vp.repaint();
            VueGlobalRotation rotation = new VueGlobalRotation(this._vp);
            if (JOptionPane.showConfirmDialog(this._vp, rotation.getPanel(), "Rotates the whole RNA", 2) != 0) {
                this.UIGlobalRotation(-rotation.getAngle());
            }
            this._vp.drawBBox(false);
            this._vp.repaint();
        }
    }

    public void UIGlobalRotation(double d) {
        if (this._vp.isModifiable() && this._vp.getRNA().get_listeBases().size() > 0) {
            this._vp.globalRotation(d);
            this._undoableEditSupport.postEdit(new VARNAEdits.RotateRNAEdit(d, this._vp));
        }
    }

    public void UISetBPStyle() {
        if (this._vp.getRNA().get_listeBases().size() > 0) {
            VueStyleBP bpstyle = new VueStyleBP(this._vp);
            VARNAConfig.BP_STYLE bck = this._vp.getBPStyle();
            if (JOptionPane.showConfirmDialog(this._vp, bpstyle.getPanel(), "Set main base pair style", 2) != 0) {
                this._vp.setBPStyle(bck);
                this._vp.repaint();
            }
        }
    }

    public void UISetTitleColor() {
        Color c;
        if (this._vp.isModifiable() && (c = JColorChooser.showDialog(this._vp, "Choose new title color", this._vp.getTitleColor())) != null) {
            this._vp.setTitleColor(c);
            this._vp.repaint();
        }
    }

    public void UISetBackboneColor() {
        Color c;
        if (this._vp.isModifiable() && (c = JColorChooser.showDialog(this._vp, "Choose new backbone color", this._vp.getBackboneColor())) != null) {
            this._vp.setBackboneColor(c);
            this._vp.repaint();
        }
    }

    public void UISetTitleFont() {
        VueFont font;
        if (this._vp.isModifiable() && JOptionPane.showConfirmDialog(this._vp, (font = new VueFont(this._vp)).getPanel(), "New Title font", 2) == 0) {
            this._vp.setTitleFont(font.getFont());
            this._vp.repaint();
        }
    }

    public void UISetSpaceBetweenBases() {
        if (this._vp.isModifiable()) {
            VueSpaceBetweenBases vsbb = new VueSpaceBetweenBases(this._vp);
            Double oldSpace = this._vp.getRNA().get_spaceBetweenBases();
            if (JOptionPane.showConfirmDialog(this._vp, vsbb.getPanel(), "Set the space between each base", 2) != 0) {
                this._vp.getRNA().set_spaceBetweenBases(oldSpace);
                this._vp.drawRNA(this._vp.getRNA());
                this._vp.repaint();
            }
        }
    }

    public void UISetBPHeightIncrement() {
        if (this._vp.isModifiable()) {
            VueBPHeightIncrement vsbb = new VueBPHeightIncrement(this._vp);
            Double oldSpace = this._vp.getBPHeightIncrement();
            if (JOptionPane.showConfirmDialog(this._vp, vsbb.getPanel(), "Set the vertical increment in linear mode", 2) != 0) {
                this._vp.setBPHeightIncrement(oldSpace);
                this._vp.drawRNA(this._vp.getRNA());
                this._vp.repaint();
            }
        }
    }

    public void UISetNumPeriod() {
        if (this._vp.getRNA().get_listeBases().size() != 0) {
            int oldNumPeriod = this._vp.getNumPeriod();
            VueNumPeriod vnp = new VueNumPeriod(this._vp);
            if (JOptionPane.showConfirmDialog(this._vp, vnp.getPanel(), "Set new numbering period", 2) != 0) {
                this._vp.setNumPeriod(oldNumPeriod);
                this._vp.repaint();
            }
        }
    }

    public void UIEditBasePair() {
        ModeleBase mb;
        if (this._vp.isModifiable() && (mb = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1) {
            ModeleBP msbp = mb.getStyleBP();
            ModeleBP.Edge bck5 = msbp.getEdgePartner5();
            ModeleBP.Edge bck3 = msbp.getEdgePartner3();
            ModeleBP.Stericity bcks = msbp.getStericity();
            VueBPType vbpt = new VueBPType(this._vp, msbp);
            if (JOptionPane.showConfirmDialog(this._vp, vbpt.getPanel(), "Set base pair L/W type", 2) != 0) {
                msbp.setEdge5(bck5);
                msbp.setEdge3(bck3);
                msbp.setStericity(bcks);
                this._vp.repaint();
            }
        }
    }

    public void UIColorBasePair() {
        ModeleBP msbp;
        Color c;
        ModeleBase mb;
        if (this._vp.isModifiable() && (mb = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1 && (c = JColorChooser.showDialog(this._vp, "Choose custom base pair color", (msbp = mb.getStyleBP()).getStyle().getColor(this._vp.getConfig()._bondColor))) != null) {
            msbp.getStyle().setCustomColor(c);
            this._vp.repaint();
        }
    }

    public void UIThicknessBasePair() {
        ModeleBase mb;
        if (this._vp.isModifiable() && (mb = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase())).getElementStructure() != -1) {
            ModeleBP msbp = mb.getStyleBP();
            ArrayList<ModeleBP> bases = new ArrayList<ModeleBP>();
            bases.add(msbp);
            VueBPThickness vbpt = new VueBPThickness(this._vp, bases);
            if (JOptionPane.showConfirmDialog(this._vp, vbpt.getPanel(), "Set base pair(s) thickness", 2) != 0) {
                vbpt.restoreThicknesses();
                this._vp.repaint();
            }
        }
    }

    public void saveToPNG(String filename) throws ExceptionExportFailed {
        VueJPEG jpeg = new VueJPEG(true, false);
        if (JOptionPane.showConfirmDialog(this._vp, jpeg.getPanel(), "Set resolution", 2) == 0) {
            Double scale = (double)jpeg.getScaleSlider().getValue() / 100.0;
            BufferedImage myImage = new BufferedImage((int)Math.round((double)this._vp.getWidth() * scale), (int)Math.round((double)this._vp.getHeight() * scale), 3);
            Graphics2D g2 = myImage.createGraphics();
            AffineTransform AF = new AffineTransform();
            AF.setToScale(scale, scale);
            g2.setTransform(AF);
            this._vp.paintComponent(g2, !this._vp.getConfig()._drawBackground);
            g2.dispose();
            try {
                ImageIO.write((RenderedImage)myImage, "PNG", new File(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveToJPEG(String filename) throws ExceptionJPEGEncoding, ExceptionExportFailed {
        VueJPEG jpeg = new VueJPEG(true, true);
        if (JOptionPane.showConfirmDialog(this._vp, jpeg.getPanel(), "Set resolution/quality", 2) == 0) {
            Double scale = jpeg.getScaleSlider().getValue() == 0 ? Double.valueOf(0.01) : Double.valueOf((double)jpeg.getScaleSlider().getValue() / 100.0);
            BufferedImage myImage = new BufferedImage((int)Math.round((double)this._vp.getWidth() * scale), (int)Math.round((double)this._vp.getHeight() * scale), 1);
            Graphics2D g2 = myImage.createGraphics();
            AffineTransform AF = new AffineTransform();
            AF.setToScale(scale, scale);
            g2.setTransform(AF);
            this._vp.paintComponent(g2);
            try {
                FileImageOutputStream out = new FileImageOutputStream(new File(filename));
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                ImageWriteParam params = writer.getDefaultWriteParam();
                params.setCompressionMode(2);
                params.setCompressionQuality((float)jpeg.getQualitySlider().getValue() / 100.0f);
                writer.setOutput(out);
                IIOImage myIIOImage = new IIOImage(myImage, null, null);
                writer.write(null, myIIOImage, params);
                out.close();
            }
            catch (IOException e) {
                throw new ExceptionExportFailed(e.getMessage(), filename);
            }
        }
    }

    public void UIToggleShowNCBP() {
        if (this._vp.isModifiable()) {
            this._vp.setShowNonCanonicalBP(!this._vp.getShowNonCanonicalBP());
            this._vp.repaint();
        }
    }

    public void UIToggleColorSpecialBases() {
        this._vp.setColorNonStandardBases(!this._vp.getColorSpecialBases());
        this._vp.repaint();
    }

    public void UIToggleColorGapsBases() {
        this._vp.setColorGapsBases(!this._vp.getColorGapsBases());
        this._vp.repaint();
    }

    public void UIToggleShowNonPlanar() {
        if (this._vp.isModifiable()) {
            this._vp.setShowNonPlanarBP(!this._vp.getShowNonPlanarBP());
            this._vp.repaint();
        }
    }

    public void UIToggleShowWarnings() {
        this._vp.setShowWarnings(!this._vp.getShowWarnings());
        this._vp.repaint();
    }

    public void UIPickSpecialBasesColor() {
        Color c = JColorChooser.showDialog(this._vp, "Choose new special bases color", this._vp.getNonStandardBasesColor());
        if (c != null) {
            this._vp.setNonStandardBasesColor(c);
            this._vp.setColorNonStandardBases(true);
            this._vp.repaint();
        }
    }

    public void UIPickGapsBasesColor() {
        Color c = JColorChooser.showDialog(this._vp, "Choose new gaps bases color", this._vp.getGapsBasesColor());
        if (c != null) {
            this._vp.setGapsBasesColor(c);
            this._vp.setColorGapsBases(true);
            this._vp.repaint();
        }
    }

    public void UIBaseTypeColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 1);
        }
    }

    public void UIToggleModifiable() {
        this._vp.setModifiable(!this._vp.isModifiable());
    }

    public void UIBasePairTypeColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 3);
        }
    }

    public void UIBaseAllColor() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 2);
        }
    }

    public void UIAbout() {
        VueAboutPanel about = new VueAboutPanel();
        JOptionPane.showMessageDialog(this._vp, about, "About VARNA 3.8", -1);
        about.gracefulStop();
    }

    public void UIAutoAnnotateHelices() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateHelices();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateStrandEnds() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateStrandEnds();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateInteriorLoops() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateInteriorLoops();
            this._vp.repaint();
        }
    }

    public void UIAutoAnnotateTerminalLoops() {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().autoAnnotateTerminalLoops();
            this._vp.repaint();
        }
    }

    public void UIAnnotationRemoveFromAnnotation(TextAnnotation textAnnotation) {
        if (this._vp.isModifiable()) {
            this._vp.set_selectedAnnotation(null);
            this._vp.getListeAnnotations().remove(textAnnotation);
            this._vp.repaint();
        }
    }

    public void UIAnnotationEditFromAnnotation(TextAnnotation textAnnotation) {
        VueAnnotation vue = textAnnotation.getType() == 0 ? new VueAnnotation(this._vp, textAnnotation, false) : new VueAnnotation(this._vp, textAnnotation, true, false);
        vue.show();
    }

    public void UIAnnotationAddFromStructure(int type, ArrayList<Integer> listeIndex) throws Exception {
        switch (type) {
            case 1: {
                TextAnnotation textAnnot = new TextAnnotation("", this._vp.getRNA().get_listeBases().get(listeIndex.get(0)));
                VueAnnotation vue = new VueAnnotation(this._vp, textAnnot, true);
                vue.show();
                break;
            }
            case 3: {
                ArrayList<ModeleBase> listeBase = new ArrayList<ModeleBase>();
                for (Integer i : listeIndex) {
                    listeBase.add(this._vp.getRNA().get_listeBases().get(i));
                }
                TextAnnotation textAnnot = new TextAnnotation("", listeBase, type);
                VueAnnotation vue = new VueAnnotation(this._vp, textAnnot, true);
                vue.show();
                break;
            }
            case 2: {
                ArrayList<ModeleBase> listeBase = new ArrayList<ModeleBase>();
                for (Integer i : listeIndex) {
                    listeBase.add(this._vp.getRNA().get_listeBases().get(i));
                }
                TextAnnotation textAnnot = new TextAnnotation("", listeBase, type);
                VueAnnotation vue = new VueAnnotation(this._vp, textAnnot, true);
                vue.show();
                break;
            }
            default: {
                this._vp.errorDialog(new Exception("Unknown structure type"));
            }
        }
    }

    public void UIAnnotationEditFromStructure(int type, ArrayList<Integer> listeIndex) {
        if (this._vp.isModifiable()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(listeIndex.get(0));
            TextAnnotation ta = this._vp.getRNA().getAnnotation(type, mb);
            if (ta != null) {
                this.UIAnnotationEditFromAnnotation(ta);
            }
        }
    }

    public void UIAnnotationRemoveFromStructure(int type, ArrayList<Integer> listeIndex) {
        if (this._vp.isModifiable()) {
            ModeleBase mb = this._vp.getRNA().get_listeBases().get(listeIndex.get(0));
            TextAnnotation ta = this._vp.getRNA().getAnnotation(type, mb);
            if (ta != null) {
                this.UIAnnotationRemoveFromAnnotation(ta);
            }
        }
    }

    public void UIAnnotationsAddPosition(int x, int y) {
        if (this._vp.isModifiable()) {
            Point2D.Double p = this._vp.panelToLogicPoint(new Point2D.Double(x, y));
            VueAnnotation annotationAdd = new VueAnnotation(this._vp, (int)p.x, (int)p.y);
            annotationAdd.show();
        }
    }

    public void UIAnnotationsAddBase(int x, int y) {
        ModeleBase mb;
        if (this._vp.isModifiable() && (mb = this._vp.getBaseAt(new Point2D.Double(x, y))) != null) {
            this._vp.highlightSelectedBase(mb);
            TextAnnotation textAnnot = new TextAnnotation("", mb);
            VueAnnotation annotationAdd = new VueAnnotation(this._vp, textAnnot, true);
            annotationAdd.show();
        }
    }

    public void UIAnnotationsAddLoop(int x, int y) {
        if (this._vp.isModifiable()) {
            try {
                ModeleBase mb = this._vp.getBaseAt(new Point2D.Double(x, y));
                if (mb != null) {
                    Vector<Integer> v = this._vp.getRNA().getLoopBases(mb.getIndex());
                    ArrayList<ModeleBase> mbs = this._vp.getRNA().getBasesAt(v);
                    TextAnnotation textAnnot = new TextAnnotation("", mbs, 3);
                    this._vp.setSelection((Collection<? extends ModeleBase>)mbs);
                    VueAnnotation annotationAdd = new VueAnnotation(this._vp, textAnnot, true);
                    annotationAdd.show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<ModeleBase> extractMaxContiguousPortion(ArrayList<ModeleBase> m) {
        ModeleBase[] tab = new ModeleBase[this._vp.getRNA().getSize()];
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        Iterator<ModeleBase> iterator = m.iterator();
        while (iterator.hasNext()) {
            ModeleBase mb;
            tab[mb.getIndex()] = mb = iterator.next();
        }
        ArrayList<ModeleBase> best = new ArrayList<ModeleBase>();
        ArrayList<ModeleBase> current = new ArrayList<ModeleBase>();
        int i2 = 0;
        while (i2 < tab.length) {
            if (tab[i2] != null) {
                current.add(tab[i2]);
            } else {
                if (current.size() > best.size()) {
                    best = current;
                }
                current = new ArrayList();
            }
            ++i2;
        }
        if (current.size() > best.size()) {
            best = current;
        }
        return best;
    }

    public void UIAnnotationsAddRegion(int x, int y) {
        if (this._vp.isModifiable()) {
            ArrayList<ModeleBase> mb = this._vp.getSelection().getBases();
            if (mb.size() == 0) {
                ModeleBase m = this._vp.getBaseAt(new Point2D.Double(x, y));
                mb.add(m);
            }
            mb = this.extractMaxContiguousPortion(this.extractMaxContiguousPortion(mb));
            this._vp.setSelection((Collection<? extends ModeleBase>)mb);
            HighlightRegionAnnotation regionAnnot = new HighlightRegionAnnotation(mb);
            this._vp.addHighlightRegion(regionAnnot);
            VueHighlightRegionEdit annotationAdd = new VueHighlightRegionEdit(this._vp, regionAnnot);
            if (!annotationAdd.show()) {
                this._vp.removeHighlightRegion(regionAnnot);
            }
            this._vp.clearSelection();
        }
    }

    public void UIAnnotationsAddChemProb(int x, int y) {
        if (this._vp.isModifiable() && this._vp.getRNA().getSize() > 1) {
            Point2D.Double p = this._vp.panelToLogicPoint(new Point2D.Double(x, y));
            ModeleBase m1 = this._vp.getBaseAt(new Point2D.Double(x, y));
            ModeleBase best = null;
            if (m1.getIndex() - 1 >= 0) {
                best = this._vp.getRNA().getBaseAt(m1.getIndex() - 1);
            }
            if (m1.getIndex() + 1 < this._vp.getRNA().getSize()) {
                ModeleBase m2 = this._vp.getRNA().getBaseAt(m1.getIndex() + 1);
                if (best == null) {
                    best = m2;
                } else if (best.getCoords().distance(p) > m2.getCoords().distance(p)) {
                    best = m2;
                }
            }
            ArrayList<ModeleBase> tab = new ArrayList<ModeleBase>();
            tab.add(m1);
            tab.add(best);
            this._vp.setSelection((Collection<? extends ModeleBase>)tab);
            ChemProbAnnotation regionAnnot = new ChemProbAnnotation(m1, best);
            this._vp.getRNA().addChemProbAnnotation(regionAnnot);
            VueChemProbAnnotation annotationAdd = new VueChemProbAnnotation(this._vp, regionAnnot);
            if (!annotationAdd.show()) {
                this._vp.getRNA().removeChemProbAnnotation(regionAnnot);
            }
            this._vp.clearSelection();
        }
    }

    public void UIAnnotationsAddHelix(int x, int y) {
        if (this._vp.isModifiable()) {
            try {
                ModeleBase mb = this._vp.getBaseAt(new Point2D.Double(x, y));
                if (mb != null) {
                    ArrayList<Integer> v = this._vp.getRNA().findHelix(mb.getIndex());
                    ArrayList<ModeleBase> mbs = this._vp.getRNA().getBasesAt(v);
                    TextAnnotation textAnnot = new TextAnnotation("", mbs, 2);
                    this._vp.setSelection((Collection<? extends ModeleBase>)mbs);
                    VueAnnotation annotationAdd = new VueAnnotation(this._vp, textAnnot, true);
                    annotationAdd.show();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void UIToggleGaspinMode() {
        if (this._vp.isModifiable()) {
            this._vp.toggleDrawOutlineBase();
            this._vp.toggleFillBase();
            this._vp.repaint();
        }
    }

    public void UIAnnotationsAdd() {
        if (this._vp.isModifiable()) {
            VueAnnotation annotationAdd = new VueAnnotation(this._vp);
            annotationAdd.show();
        }
    }

    public void UIEditAllBasePairs() {
        if (this._vp.isModifiable()) {
            new VueBPList(this._vp);
        }
    }

    public void UIEditAllBases() {
        if (this._vp.isModifiable()) {
            new VueBases(this._vp, 2);
        }
    }

    public void UIAnnotationsRemove() {
        if (this._vp.isModifiable()) {
            new VueListeAnnotations(this._vp, 0);
        }
    }

    public void UIAnnotationsEdit() {
        if (this._vp.isModifiable()) {
            new VueListeAnnotations(this._vp, 1);
        }
    }

    public void UIAddBP(int i, int j, ModeleBP ms) {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().addBPToStructure(i, j, ms);
            this._undoableEditSupport.postEdit(new VARNAEdits.AddBPEdit(i, j, ms, this._vp));
            this._vp.repaint();
            HashSet<ModeleBP> tmp = new HashSet<ModeleBP>();
            tmp.add(ms);
            this._vp.fireStructureChanged(new HashSet<ModeleBP>(this._vp.getRNA().getAllBPs()), tmp, new HashSet<ModeleBP>());
        }
    }

    public void UIRemoveBP(ModeleBP ms) {
        if (this._vp.isModifiable()) {
            this._undoableEditSupport.postEdit(new VARNAEdits.RemoveBPEdit(ms.getIndex5(), ms.getIndex3(), ms, this._vp));
            this._vp.getRNA().removeBP(ms);
            this._vp.repaint();
            HashSet<ModeleBP> tmp = new HashSet<ModeleBP>();
            tmp.add(ms);
            this._vp.fireStructureChanged(new HashSet<ModeleBP>(this._vp.getRNA().getAllBPs()), new HashSet<ModeleBP>(), tmp);
        }
    }

    public void UIShiftBaseCoord(ArrayList<Integer> indices, double dx, double dy) {
        if (this._vp.isModifiable()) {
            Hashtable<Integer, Point2D.Double> backupPos = new Hashtable<Integer, Point2D.Double>();
            for (int index : indices) {
                ModeleBase mb = this._vp.getRNA().getBaseAt(index);
                Point2D.Double d = mb.getCoords();
                backupPos.put(index, d);
                this._vp.getRNA().setCoord(index, d.x + dx, d.y + dy);
                this._vp.getRNA().setCenter(index, mb.getCenter().x + dx, mb.getCenter().y + dy);
            }
            this._undoableEditSupport.postEdit(new VARNAEdits.BasesShiftEdit(indices, dx, dy, this._vp));
            this._vp.repaint();
            this._vp.fireLayoutChanged(backupPos);
        }
    }

    public void UIShiftBaseCoord(ArrayList<Integer> indices, Point2D.Double dv) {
        this.UIShiftBaseCoord(indices, dv.x, dv.y);
    }

    public void UIMoveSingleBase(int index, double nx, double ny) {
        if (this._vp.isModifiable()) {
            ModeleBase mb = this._vp.getRNA().getBaseAt(index);
            Point2D.Double d = mb.getCoords();
            Hashtable<Integer, Point2D.Double> backupPos = new Hashtable<Integer, Point2D.Double>();
            backupPos.put(index, d);
            this._undoableEditSupport.postEdit(new VARNAEdits.SingleBaseMoveEdit(index, nx, ny, this._vp));
            this._vp.getRNA().setCoord(index, nx, ny);
            this._vp.repaint();
            this._vp.fireLayoutChanged(backupPos);
        }
    }

    public void UIMoveSingleBase(int index, Point2D.Double dv) {
        this.UIMoveSingleBase(index, dv.x, dv.y);
    }

    public void UISetBaseCenter(int index, double x, double y) {
        this.UISetBaseCenter(index, new Point2D.Double(x, y));
    }

    public void UISetBaseCenter(int index, Point2D.Double p) {
        if (this._vp.isModifiable()) {
            this._vp.getRNA().setCenter(index, p);
        }
    }

    public void UIUndo() {
        this._vp.undo();
    }

    public void UIRedo() {
        this._vp.redo();
    }

    public void UIMoveHelixAtom(int index, Point2D.Double newPos) {
        if (this._vp.isModifiable() && index >= 0 && index < this._vp.getRNA().get_listeBases().size()) {
            int indexTo = this._vp.getRNA().get_listeBases().get(index).getElementStructure();
            Point h = this._vp.getRNA().getHelixInterval(index);
            Point ml = this._vp.getRNA().getMultiLoop(h.x);
            int i = ml.x;
            if (indexTo != -1) {
                if (i == 0) {
                    if (this.shouldFlip(index, newPos)) {
                        this.UIFlipHelix(h);
                        this._undoableEditSupport.postEdit(new VARNAEdits.HelixFlipEdit(h, this._vp));
                    }
                } else {
                    this.UIRotateHelixAtom(index, newPos);
                }
            }
            this._vp.fireLayoutChanged();
        }
    }

    private Point2D.Double project(Point2D.Double O, Point2D.Double Ox, Point2D.Double C) {
        Point2D.Double OC = new Point2D.Double(C.x - O.x, C.y - O.y);
        double normOX = Ox.x * OC.x + Ox.y * OC.y;
        Point2D.Double OX = new Point2D.Double(normOX * Ox.x, normOX * Ox.y);
        Point2D.Double XC = new Point2D.Double(OC.x - OX.x, OC.y - OX.y);
        Point2D.Double OCP = new Point2D.Double(OX.x - XC.x, OX.y - XC.y);
        Point2D.Double CP = new Point2D.Double(O.x + OCP.x, O.y + OCP.y);
        return CP;
    }

    public void UIFlipHelix(Point h) {
        int hBeg = h.x;
        int hEnd = h.y;
        Point2D.Double A = this._vp.getRNA().getCoords(hBeg);
        Point2D.Double B = this._vp.getRNA().getCoords(hEnd);
        Point2D.Double AB = new Point2D.Double(B.x - A.x, B.y - A.y);
        double normAB = Math.sqrt(AB.x * AB.x + AB.y * AB.y);
        Point2D.Double O = A;
        Point2D.Double Ox = new Point2D.Double(AB.x / normAB, AB.y / normAB);
        Hashtable<Integer, Point2D.Double> old = new Hashtable<Integer, Point2D.Double>();
        int i = hBeg + 1;
        while (i < hEnd) {
            Point2D.Double P = this._vp.getRNA().getCoords(i);
            Point2D.Double nP = this.project(O, Ox, P);
            old.put(i, nP);
            this._vp.getRNA().setCoord(i, nP);
            Point2D.Double Center = this._vp.getRNA().getCenter(i);
            this._vp.getVARNAUI().UISetBaseCenter(i, this.project(O, Ox, Center));
            ++i;
        }
        this._vp.fireLayoutChanged(old);
    }

    boolean shouldFlip(int index, Point2D.Double P) {
        Point h = this._vp.getRNA().getHelixInterval(index);
        Point2D.Double A = this._vp.getRNA().getCoords(h.x);
        Point2D.Double B = this._vp.getRNA().getCoords(h.y);
        Point2D.Double C = this._vp.getRNA().getCoords(h.x + 1);
        Point2D.Double hAB = new Point2D.Double(B.y - A.y, -(B.x - A.x));
        Point2D.Double AC = new Point2D.Double(C.x - A.x, C.y - A.y);
        Point2D.Double AP = new Point2D.Double(P.x - A.x, P.y - A.y);
        double signC = hAB.x * AC.x + hAB.y * AC.y;
        double signP = hAB.x * AP.x + hAB.y * AP.y;
        return signC * signP < 0.0;
    }

    public void UIRotateHelixAtom(int index, Point2D.Double newPos) {
        Point2D.Double helixStop;
        Point2D.Double helixStart;
        Point2D.Double limitRight;
        Point2D.Double limitLeft;
        Point2D.Double limitLoopRight;
        Point2D.Double limitLoopLeft;
        Point h = this._vp.getRNA().getHelixInterval(index);
        Point ml = this._vp.getRNA().getMultiLoop(h.x);
        int i = ml.x;
        int prevIndex = h.x;
        int nextIndex = h.y;
        while (i <= ml.y) {
            int j = this._vp.getRNA().get_listeBases().get(i).getElementStructure();
            if (j != -1 && i < h.x) {
                prevIndex = i;
            }
            if (j != -1 && i > h.y && nextIndex == h.y) {
                nextIndex = i;
            }
            if (j > i && j < ml.y) {
                i = this._vp.getRNA().get_listeBases().get(i).getElementStructure();
                continue;
            }
            ++i;
        }
        Point2D.Double oldPos = this._vp.getRNA().getCoords(index);
        boolean isDirect = this._vp.getRNA().testDirectionality(ml.x, ml.y, h.x);
        if (isDirect) {
            limitLoopLeft = this._vp.getRNA().getCoords(ml.y);
            limitLoopRight = this._vp.getRNA().getCoords(ml.x);
            limitLeft = this._vp.getRNA().getCoords(prevIndex);
            limitRight = this._vp.getRNA().getCoords(nextIndex);
            helixStart = this._vp.getRNA().getCoords(h.x);
            helixStop = this._vp.getRNA().getCoords(h.y);
        } else {
            limitLoopLeft = this._vp.getRNA().getCoords(ml.x);
            limitLoopRight = this._vp.getRNA().getCoords(ml.y);
            limitLeft = this._vp.getRNA().getCoords(nextIndex);
            limitRight = this._vp.getRNA().getCoords(prevIndex);
            helixStart = this._vp.getRNA().getCoords(h.y);
            helixStop = this._vp.getRNA().getCoords(h.x);
        }
        Point2D.Double center = this._vp.getRNA().get_listeBases().get(h.x).getCenter();
        double base = (VueUI.computeAngle(center, limitLoopRight) + VueUI.computeAngle(center, limitLoopLeft)) / 2.0;
        double pLimR = VueUI.computeAngle(center, limitLeft) - base;
        double pHelR = VueUI.computeAngle(center, helixStart) - base;
        double pNew = VueUI.computeAngle(center, newPos) - base;
        double pOld = VueUI.computeAngle(center, oldPos) - base;
        double pHelL = VueUI.computeAngle(center, helixStop) - base;
        double pLimL = VueUI.computeAngle(center, limitRight) - base;
        while (pLimR < 0.0) {
            pLimR += Math.PI * 2;
        }
        while (pHelR < pLimR) {
            pHelR += Math.PI * 2;
        }
        while (pNew < pHelR) {
            pNew += Math.PI * 2;
        }
        while (pOld < pHelR) {
            pOld += Math.PI * 2;
        }
        while (pHelL < pOld) {
            pHelL += Math.PI * 2;
        }
        while (pLimL < pHelL) {
            pLimL += Math.PI * 2;
        }
        double minDelta = this.normalizeAngle(pLimR - pHelR + 0.25);
        double maxDelta = this.normalizeAngle(pLimL - pHelL - 0.25);
        while (maxDelta < minDelta) {
            maxDelta += Math.PI * 2;
        }
        double delta = this.normalizeAngle(pNew - pOld);
        while (delta < minDelta) {
            delta += Math.PI * 2;
        }
        if (delta > maxDelta) {
            double distanceMin = minDelta - (delta - Math.PI * 2);
            double distanceMax = delta - maxDelta;
            delta = distanceMin < distanceMax ? minDelta : maxDelta;
        }
        this._undoableEditSupport.postEdit(new VARNAEdits.HelixRotateEdit(delta, base, pLimL, pLimR, h, ml, this._vp));
        this.UIRotateEverything(delta, base, pLimL, pLimR, h, ml);
    }

    public void UIRotateEverything(double delta, double base, double pLimL, double pLimR, Point h, Point ml) {
        double newY;
        double newX;
        double newAngle;
        int k;
        double angleNext;
        double anglePrev;
        double pHelL;
        double pHelR;
        Hashtable<Integer, Point2D.Double> backupPos = new Hashtable<Integer, Point2D.Double>();
        boolean isDirect = this._vp.getRNA().testDirectionality(ml.x, ml.y, h.x);
        Point2D.Double center = this._vp.getRNA().get_listeBases().get(h.x).getCenter();
        int k2 = h.x;
        while (k2 <= h.y) {
            backupPos.put(k2, this._vp.getRNA().getBaseAt(k2).getCoords());
            ++k2;
        }
        this.rotateHelix(center, h.x, h.y, delta);
        boolean over = false;
        Point2D.Double helixStart = this._vp.getRNA().getCoords(h.x);
        Point2D.Double helixStop = this._vp.getRNA().getCoords(h.y);
        if (isDirect) {
            pHelR = VueUI.computeAngle(center, helixStop) - base;
            pHelL = VueUI.computeAngle(center, helixStart) - base;
        } else {
            pHelL = VueUI.computeAngle(center, helixStop) - base;
            pHelR = VueUI.computeAngle(center, helixStart) - base;
        }
        int i = h.x - 1;
        Vector<Integer> nextBases = new Vector<Integer>();
        while (!over) {
            if (i < 0) {
                over = true;
            } else if (this._vp.getRNA().get_listeBases().get(i).getElementStructure() == -1) {
                nextBases.add(new Integer(i));
            } else {
                over = true;
            }
            --i;
        }
        Vector<Integer> prevBases = new Vector<Integer>();
        over = false;
        i = h.y + 1;
        while (!over) {
            if (i >= this._vp.getRNA().get_listeBases().size()) {
                over = true;
            } else if (this._vp.getRNA().get_listeBases().get(i).getElementStructure() == -1) {
                prevBases.add(new Integer(i));
            } else {
                over = true;
            }
            ++i;
        }
        double radius = center.distance(helixStart);
        if (isDirect) {
            anglePrev = this.normalizeAngle(pLimL - pHelR);
            angleNext = this.normalizeAngle(pHelL - pLimR);
        } else {
            anglePrev = this.normalizeAngle(pHelL - pLimR);
            angleNext = this.normalizeAngle(pLimL - pHelR);
        }
        i = 0;
        while (i < prevBases.size()) {
            k = (Integer)prevBases.get(i);
            newAngle = isDirect ? base + pHelR + (double)(i + 1) * anglePrev / (double)(prevBases.size() + 1) : base + pHelL - (double)(i + 1) * anglePrev / (double)(prevBases.size() + 1);
            newX = center.x + radius * Math.cos(newAngle);
            newY = center.y + radius * Math.sin(newAngle);
            backupPos.put(k, this._vp.getRNA().getCoords(k));
            this._vp.getRNA().setCoord(k, newX, newY);
            ++i;
        }
        i = 0;
        while (i < nextBases.size()) {
            k = (Integer)nextBases.get(i);
            newAngle = isDirect ? base + pHelL - (double)(i + 1) * angleNext / (double)(nextBases.size() + 1) : base + pHelR + (double)(i + 1) * angleNext / (double)(nextBases.size() + 1);
            newX = center.x + radius * Math.cos(newAngle);
            newY = center.y + radius * Math.sin(newAngle);
            backupPos.put(k, this._vp.getRNA().getCoords(k));
            this._vp.getRNA().setCoord(k, newX, newY);
            ++i;
        }
        this._vp.fireLayoutChanged(backupPos);
    }

    private double normalizeAngle(double angle) {
        return this.normalizeAngle(angle, 0.0);
    }

    private double normalizeAngle(double angle, double base) {
        while (angle < base) {
            angle += Math.PI * 2;
        }
        while (angle >= Math.PI * 2 - base) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static double computeAngle(Point2D.Double center, Point2D.Double p) {
        double dist = center.distance(p);
        double angle = Math.asin((p.y - center.y) / dist);
        if (p.x - center.x < 0.0) {
            angle = Math.PI - angle;
        }
        return angle;
    }

    private void rotateHelix(Point2D.Double center, int i, int j, double angle) {
        int k = i;
        while (k <= j) {
            Point2D.Double oldp = this._vp.getRNA().getCoords(k);
            Point2D.Double newp = this.rotatePoint(center, oldp, angle);
            this._vp.getRNA().setCoord(k, newp);
            if (k != i && k != j) {
                Point2D.Double oldc = this._vp.getRNA().get_listeBases().get(k).getCenter();
                Point2D.Double newc = this.rotatePoint(center, oldc, angle);
                this.UISetBaseCenter(k, newc);
            }
            ++k;
        }
    }

    private Point2D.Double rotatePoint(Point2D.Double center, Point2D.Double p, double angle) {
        double dist = p.distance(center);
        double oldAngle = Math.asin((p.y - center.y) / dist);
        if (p.x - center.x < 0.0) {
            oldAngle = Math.PI - oldAngle;
        }
        double newX = center.x + dist * Math.cos(oldAngle + angle);
        double newY = center.y + dist * Math.sin(oldAngle + angle);
        return new Point2D.Double(newX, newY);
    }
}

